/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)memhelp.h      6.0 91/10/11";*/
/***    Memory Management PDD Interface definition
 *
 *      SCCSID = @(#)memhelp.inc    6.0 91/10/11
 *
 *
 *
 *
 *      DESCRIPTION
 *      MEMHELP$ PDD constants, types, and function prototypes
 *
 *      MODIFICATION HISTORY
 *      10/11/91    J-TS00  Created.
 */

// Memory management device driver name

#define     MEMHELP_PDD_NAME            "SCREEN$ "

// protect mode service routine definition

#define     CAT_MEMHELP                 0x03    // memhelp category
#define     FUNC_GET_PHYS_ADDR          0x7f    // get ROS font address
#define     FUNC_ALLOC_BUFF             0x7e    // allocate video buffer

// FUNC_GET_PHYS_ADDR

struct ParamGetPhys {
    ULONG  PhysAddr;                            // requested physical address
    USHORT PhysLen;                             // length
    SEL    VertSel;                             // allocated GDT
};

// FUNC_ALLOC_BUFF

struct ParamAllocBuff {
    USHORT BuffLen;                             // requested buffer length
    SEL    BuffSel;                             // allocated GDT
};

// VDD service routine definition

// Command definitions

#define     MEMHELP_CMD_REGISTERVDD     0       // register the entry of VDD
#define     MEMHELP_CMD_GETGLOBAL       1       // map private to global
#define     MEMHELP_CMD_FREEGLOBAL      2       // free mapped global

// Command parameter definitions

// MEMHELP_CMD_GETGLOBAL

struct MemHelpGetGlobalIn {
    ULONG   addr;                               // linear address to be mapped into global address
    ULONG   len;                                // memory length
};

struct MemHelpGetGlobalOut {
    ULONG   addr;                               // mapped global linear address
};

// MEMHELP_CMD_GETGLOBAL

struct MemHelpFreeGlobalIn {
    ULONG   addr;                               // global address to be freed
};
