/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)fntcalls   1.0 91/04/11";*/

/**********************  START OF SPECIFICATIONS  ***********************/
/*                                                                      */
/*  SOURCE FILE NAME:    FNTCALLS.H                                     */
/*                                                                      */
/*  DESCRIPTIVE NAME:    System Font Handler External Interface         */
/*                       Definition                                     */
/*                                                                      */
/*  COPYRIGHT:           na                                             */
/*                                                                      */
/*  STATUS:              na                                             */
/*                                                                      */
/*  FUNCTION:            This module contains external interface        */
/*                       definitions (function prototypes & data        */
/*                       structures.)                                   */
/*                                                                      */
/*  NOTES:               None                                           */
/*                                                                      */
/*  ENTRY POINTS:        None                                           */
/*                                                                      */
/*  EXTERNAL REFERENCES: None                                           */
/*                                                                      */
/*  CHANGE HISTORY:                                                     */
/*                      91/04/11    Initial coding (T.Sobue)            */
/*                                                                      */
/***********************  END OF SPECIFICATIONS  ************************/

/* FNTQUERY() */
typedef struct _FNTRESOURCE {
    USHORT  CodePage;
    USHORT  FontType0;
    USHORT  FontType1;
    USHORT  FontID;
    USHORT  Row;
    USHORT  Col;
    UCHAR   FileName[52];
} FNTRESOURCE;

typedef struct _FNTRESOURCES {
    USHORT      Length;
    FNTRESOURCE Resources[1];
} FNTRESOURCES;

/* FNTGETIMAGE() */
typedef struct _FNTBLOCK {
    USHORT  Length;
    USHORT  CodePage;
    USHORT  FontType0;
    USHORT  FontType1;
    USHORT  FontID;
    USHORT  Row;
    USHORT  Col;
} FNTBLOCK;

#define FNTGET_PUT_FONT     0x0001
#define FNTGET_PACKED       0x0002
#define FNTGET_FULL_BOX     0x0004

/* FNTINTTOREGEN(), FNTREGENTOINT() */
typedef struct _FNTCODES {
    USHORT  Count;
    USHORT  Codes[1];
} FNTCODES;

/* FNTCHGSOURCE(), FNTGETSOURCE() */
typedef struct _FNTBLOCK2 {
    USHORT  Length;
    USHORT  CodePage;
    USHORT  FontType0;
    USHORT  FontType1;
    USHORT  FontID;
} FNTBLOCK2;

#define FNT_SOURCE_DBCS     0x0000
#define FNT_SOURCE_BASE     0x0001
#define FNT_SOURCE_EXTRA    0x0002

/* FNTGETACTIVEBUFFER() */
typedef struct _SBCSFILEHEADER {
    USHORT  Length;
    USHORT  HeaderLength;
    USHORT  CodePage;
    USHORT  FontType0;
    USHORT  FontType1;
    USHORT  FontID;
    USHORT  Row;
    USHORT  Col;
    USHORT  FontOffset;
    USHORT  FontLength;
    USHORT  Count;
    USHORT  FirstCode;
    USHORT  LastCode;
    USHORT  Reserved[10];
} SBCSFILEHEADER;

typedef struct _FNTACTIVEBUFFER {
    USHORT  Length;
    SBCSFILEHEADER far *BaseHeader;
    UCHAR          far *BaseFont;
    SBCSFILEHEADER far *ExtraHeader;
    UCHAR          far *ExtraFont;
} FNTACTIVEBUFFER;

#define FNT_ACTIVE_CURRENT_SG   (-1)
#define FNT_ACTIVE_GET          (0)
#define FNT_ACTIVE_FREE         (-1)

/* FNTGETIMAGEADDR() */
typedef struct _FNTIMAGEADDR {
    USHORT     Length;
    UCHAR far *FontAddr;
} FNTIMAGEADDR;

/* FNTCHGSG() */
#define FNT_SCREEN_GROUP_NEW    0x0001
#define FNT_SCREEN_GROUP_OLD    0x0000


USHORT far pascal FNTQUERY( USHORT, FNTRESOURCES far * );
USHORT far pascal FNTGETIMAGE( FNTBLOCK far *, USHORT, USHORT, UCHAR far * );
USHORT far pascal FNTINTTOREGEN( FNTCODES far *, USHORT );
USHORT far pascal FNTREGENTOINT( FNTCODES far *, USHORT );
USHORT far pascal FNTCHGSOURCE( FNTBLOCK2 far *, USHORT );
USHORT far pascal FNTGETSOURCE( USHORT, FNTBLOCK2 far *, USHORT );
USHORT far pascal FNTSETMODE( USHORT );
USHORT far pascal FNTCHGCP( USHORT, USHORT );
USHORT far pascal FNTCHGSG( USHORT, USHORT );
USHORT far pascal FNTSETFONT( USHORT, USHORT, UCHAR far * );
USHORT far pascal FNTGETFONT( USHORT, USHORT, UCHAR far * );
USHORT far pascal FNTASYNCTHREAD( void );
USHORT far pascal FNTFMKICKCTL( USHORT );
USHORT far pascal FNTSETOPTION( USHORT );
USHORT far pascal FNTRSTUSECNT( void );
USHORT far pascal FNTPURGE( USHORT );
USHORT far pascal FNTFMKICKTHREAD( void );
USHORT far pascal FNTVDMHLP( UCHAR *, USHORT, USHORT );
USHORT far pascal FNTGETACTIVEBUFFER( FNTACTIVEBUFFER far * , USHORT , USHORT );
USHORT far pascal FNTGETIMAGEADDR( USHORT, FNTIMAGEADDR far * );
