/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = SVGADEFS.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  Contains SVGA definitions.
 *
 * FUNCTIONS
 *
 * NOTES        When included into VVID sources, #ifdef SVGA
 *              must be used before #include!
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define MAX_LOCKUNLOCKCMD       10
#define MAX_CLEANDATA           20

//c-begin

typedef struct _CLEANDATA
{
    USHORT  Command;
    USHORT  IndexPort;
    USHORT  DataPort;
    USHORT  Index;
    USHORT  ANDMask;
    USHORT  ORMask;
} CLEANDATA;

//c-end

#define SVGA_ID                 8
#define SVGA_OEM                9
#define SCREENDD_CATEGORY       0x80
#define SCREENDD_NAME           "SCREEN$"

//c-begin
typedef struct {
        USHORT AdapterType;
        USHORT ChipType;
        ULONG  Memory;
} OEMSVGAINFO;

typedef struct {
        ULONG  Length;                                  /*            */
        USHORT Manufacturer;
        ULONG  ManufacturerData;                        /*            */
} OEMINFO;

typedef struct {
        ULONG  Length;
        USHORT Bank;
        USHORT VideoModeType;
        USHORT ReadWriteMode;
} BANKINFO;                                             /*            */
//c-end

#define DEFAULT_ADAPTER       (-1)
#define VIDEO7_ADAPTER          1
#define TRIDENT_ADAPTER         2
#define TSENG_ADAPTER           3
#define WESTERNDIG_ADAPTER      4
#define ATI_ADAPTER             5
#define IBM_ADAPTER             6
#define CIRRUS_ADAPTER          7
#define S3_ADAPTER              8
#define CHIPS_ADAPTER           9                      /*            */
#define WEITEK_ADAPTER         10                      /*            */
 /* remember to update SVGA_LASTADAPTER when adding new adapter support */


#define SVGA_FIRSTADAPTER       VIDEO7_ADAPTER         /*            */
#define SVGA_LASTADAPTER        WEITEK_ADAPTER         /*            */

#define VIDEO7_HT205_CHIP       1
#define VIDEO7_HT208_CHIP       2
#define VIDEO7_HT209_CHIP       3

#define TRIDENT_8800_CHIP       1
#define TRIDENT_8900_CHIP       2

#define TSENG_ET3000_CHIP       1
#define TSENG_ET4000_CHIP       2

#define WESTERNDIG_PVGA1A_CHIP  1
#define WESTERNDIG_WD9000_CHIP  2
#define WESTERNDIG_WD9011_CHIP  3
#define WESTERNDIG_WD9030_CHIP  4

#define ATI_18800_CHIP          1
#define ATI_28800_CHIP          2

#define IBM_SVGA_CHIP           1

#define CIRRUS_5422_CHIP        1
#define CIRRUS_5424_CHIP        2
#define CIRRUS_5426_CHIP        3
#define CIRRUS_5428_CHIP        4           /*            */

#define S3_86C805_CHIP          1
#define S3_86C928_CHIP          2
#define S3_86C911_CHIP          3           /*            */

#define DIAMOND_MANUFACTURER    1           /*            */
#define NUMBER9_MANUFACTURER    3           /*            */
#define ARTIST_MANUFACTURER     4           /*            */
