/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************** Module Header ******************************\
*
* Module Name: PMAVIOP.H
*
* OS/2 Presentation Manager AVIO PRIVATE function declarations
*
*
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
#ifndef __IBMC__
   * The 32-bit version of this file (as placed into the IBMH directory)
   * excludes all non 32-bit material marked in this file as well
   * as any areas specifically marked with __IBMC__ conditional
   * sections - including this paragraph. The H2IBMH rexx command file
   * removes these sections.
#endif
* ===========================================================================
*
*/
/* NOINC */
#ifdef __IBMC__
   #pragma checkout( suspend )
      #ifndef __CHKHDR__
         #pragma checkout( suspend )
      #endif
   #pragma checkout( resume )
#endif
/* INC */

#define PMAVIOP_INCLUDED

#ifndef INCL_32         /* If neither INCL_32 or INCL_16 set already */
   #ifndef INCL_16      /* find out from compiler if 32-bit or not.  */
     #ifdef M_I386
        #define INCL_32 /* Compiling for 32-bit */
     #else
        #define INCL_16 /* Compiling for 16-bit */
     #endif
  #endif
#endif

/* NOINC */
#ifndef INCL_32
   #ifndef APIENTRY16
      #define APIENTRY16 APIENTRY
   #endif
#endif
/* INC */

/*************************** Shield Section ****************************
*
* Abstract: Data structures and constants used by the Shield Layer.
*           Interfaces provided by the Shield Layer.
*
* Created:  07-May-87
* Author:   Ron Murray  [ronm]
*
*
* This include file defines the data structures used by the Shield
* Layer module and documents their usage conventions.
*
*/

/************************ Conventions **********************************\
*
* Instances of VioPresentationSpace correspond to console windows.  Vio and
* Shield Layer modules cooperatively use them to maintain the state of the
* console's window.  That cooperation is mediated by a ram semaphore
* (fsemVioPSLock) which must be acquired before any drawing actions or
* presentation space modifications are attempted on behalf of the console.
*
* When the sempahore is acquired, the VioPS will be in a consistent state.
* It may become temporarily inconsistent while the semaphore is held,
* but it must again be consistent when the semaphore lock is released.  The
* WinSyncWithPS (defined below) is relevant here.
*
* When a new console is created, the Vio module allocates a shared global
* segment containing the VioPresentationSpace instance for that console.
*
* The initialization process is completed by the WinCreateConsole function
* (defined below) which defines pShieldGreData to reference a private data
* structure within the global segment.  That is done by reallocating the
* global segment to provide room for the private data.
*
* All drawing actions by Vio and the Shield Layer are accomplished by means
* of the CharRect, CharStr, ScrollRect, and UpdateCursor interfaces provided
* by the Graphics Engine API.
*
\***********************************************************************/


/*********************** Field Definitions *****************************\
*
* fsemVioPSLock -- A fast, safe ram semaphore used to control
* access to the presentation space by the Vio module and the Shield
* Layer thread.  This semaphore records the process/thread numbers
* for the owning thread.  That makes crash-recovery cleanups possible.
*
* selLVB -- A segment selector for the Logical Video Buffer.
* The LVB is assumed to begin at offset zero within that segment.  It is a
* two dimensional array of character cells laid out in memory in row-major
* order.
*
* selBVSCB -- A segment selector field filled in by BvsCalls.
* That segment contains per-session control information used by the
* BvsCalls module.
*
* rgfAVio -- A word of bit flags reserved for use by the AVio subsystem.
* Currently it's used to denote whether the PS is associated with a
* device context.
*
* CellByteSize -- The size in bytes of a logical video buffer cell.  For VIO
* presentation spaces this values must be 2.  This field is included for upward
* compatibility with AVIO presentation spaces where CellSize == 4.
*
* BufferRowCount -- The number of cell rows in the logical video buffer.
*
* BufferColumnCount -- The number of cell columns in the logical video buffer.
*
* WindowOriginRow -- A row index for the logical video buffer. This field
* together with the WindowOriginColumn field contain the indices of the LVB
* cell which is drawn in the bottom left corner of the console window's
* client area.  The origin for these coordinates is the bottom left corner
* of the LVB.  These fields are maintained by the Shield Layer thread as
* the console window is scrolled and resized.
*
* WindowOriginColumn -- A column index for the logical video buffer. See the
* description of WindowOriginRow.
*
* TextCursorRow -- The row coordinate for the flashing text cursor associated
* with this Vio console.  This coordinate defines the vertical position of the
* cursor relative to the logical video buffer.
*
* TextCursorColumn -- The column coordinate for the flashing text cursor.  This
* coordinate defines the position of the cursor relative to the logical video
* buffer.
*
* TextCursorStartLine -- The first scan line of a character cell image overlaid
* by the text cursor. Lines in the cell image are number from top to bottom
* starting at zero.
*
* TextCursorEndLine -- The last scan line of a character cell image overlaid by
* the text cursor.
*
* If the TextCursorStartLine and TextCursorEndLine fields are initially zero,
* WinCreateConsole function will set them to values which will place a line at
* the bottom the character cell.  The thickness of that line will match the
* system metric SM_CYBORDER.
*
* Non-zero values will be coerced into the half open interval
* [0.. CellImageHeight).
*
*
* TextCursorWidth -- The width of the text cursor in pixels.  If this field is
* initially zero WinCreateConsole will set it to match the width of a character
* cell. Non-zero values for CWidth will be coerced into the half open interval
* [ 0..CellWidth).
*
* TextCursorVisible -- The VIO module uses this field to define whether it
* wishes the cursor to be visible (non zero values) or invisible (zero).  Note
* that the cursor may not be visible even when this field is non-zero.  For
* example the window for this console may not have the input focus.
*
* After setting this field, Vio calls UpdateCursor (part of the Graphics
* Engine Interface) to bring the text cursor image into correspondence.
*
*
* CellImageHeight -- The height in pixels of a character cell image.  This
* field together with the CellImageWidth field define the DeviceCellSize.
*
* CellImageWidth -- The width in pixels of a character cell image.
*
* CodepageID -- A number identifying the code page from which character
*               images are to be copied.
*
* WindowHeight -- The height of the console window client rectangle in
*                 units of LVB cell images.
*
* WindowWidth -- The width of the console window client rectangle in units
*                of LVB cell images.
*
* The WindowHeight and WindowWidth fields are maintained by the Shield Layer
* thread for Vio presentation spaces and by WinDefAvioWindowProc for AVio
* presentation spaces.
*
* hConsoleDisplayContext -- A handle to the Own Display Context corresponding
* to this presentation space.
*
\***********************************************************************/


/******************* Public Data Type **********************************\
 *
 * VioPresentationSpace  -- Shared with the Vio module
 *
\***********************************************************************/
/*ifdef D1348*/
#define DBCSEvBufSiz 10
typedef struct _DBCSENVINFO { /* dbcsenvinfo */
    UCHAR  DBCSVector[DBCSEvBufSiz];    /* DBCS Vectors */
    USHORT cc;                          /* Country Code */
    USHORT cp;                          /* Code Page    */
} DBCSENVINFO;



typedef struct _VIOPSNLSEXT { /* viopsnlsext */
    DBCSENVINFO DBCSEvInfo[4];  /* For lcid 0 to 3 */
    ULONG       grid_color;     /* For Display.dll */
    ULONG       scrnattrflag;   /* lsb = 0 : screen intensity low */
                                /*       1 : screen intensity high */
} VIOPSNLSEXT;
typedef VIOPSNLSEXT FAR  *PVIOPSNLSEXT;
/*endif D1348*/

#ifdef INCL_32

typedef struct _VioPresentationSpace32 {  /* viops */

    FSRSEM  fsemVioPSLock;
/****************************************/
/*      what to do with these?          */
/****************************************/
/*  SEL     selLVB;                     */
/*  SEL     selBVSCB;                   */
    PVOID   pLVB;
    PVOID   pBVSCB;
    BOOL    rgfAVio;
    USHORT  CellByteSize;
    USHORT  BufferRowCount;
    USHORT  BufferColumnCount;

/* Window Origin coordinates can be negative for AVio presentation spaces.
 * For Vio presentation spaces the Shield Layer always coerces them to
 * non-negative values such that the client rectangle always lies completely
 * within the image of the logical video buffer.
 */
    short   WindowOriginRow;
    short   WindowOriginColumn;
    USHORT  TextCursorRow;
    USHORT  TextCursorColumn;
    USHORT  TextCursorStartLine;
    USHORT  TextCursorEndLine;
    USHORT  TextCursorWidth;
    BOOL    TextCursorVisible;
    USHORT  CellImageHeight;
    USHORT  CellImageWidth;
    USHORT  CodepageID;
    USHORT  WindowHeight;
    USHORT  WindowWidth;
    USHORT  Pad;
    HDC     hConsoleDisplayContext;

/* The following fields are used for private communication between
 * the shield thread and the display driver.
 *
 * NB: The order and positions of the fields RowOrgLatch..CursorWidth
 *     must parallel that of the fields WindowOriginRow..TextCursorWidth
 *     in the Vio presentation space.  The UpdateCursor code in the device
 *     driver depends on this being so.  See the AVioPS.inc file used
 *     by the driver.
 */
    HWND    hVioWindow;         /* Window handle for this Vio PS  */
    short   RowOrgLatch;        /* Window origin coordinates from */
    short   ColOrgLatch;        /* the last call to UpdateCursor  */
    short   CursorRow;          /* Cursor state as of the last    */
    short   CursorCol;          /* call to UpdateCursor           */
    short   CursorStartLine;
    short   CursorEndLine;
    BYTE    CursorWidth;
    char    PartialCellAdjust;  /* Adjustment for partial cells   */
    short   XLatch;             /* Pel coordinates of the cursor  */
    short   YLatch;             /* rectangle relative to the Vio  */
    short   WidthLatch;         /* window                         */
    short   HeightLatch;
    USHORT  CellHeightLatch;    /* To detect cell height changes. */
    BOOL    rgfShieldStates;    /* Shield States shared with the  */
                                /* device driver code.            */

    PVOID   pFontsLoaded[3];    /* define 32 bits of storage    */
    PVOID   pMapFontsLoaded[3]; /* for a FLAT pointer           */

    USHORT  FormatID;
    USHORT  Reserved;           /*
                                 * Japan needs to know FormatID and *
                                 * Reserved for the Display Device  *
                                 * Driver.                          */

    /*ifdef D1348*/
    PVIOPSNLSEXT lpNLSExt;
    /*endif D1348*/

} VioPresentationSpace32;
typedef VioPresentationSpace32 VIOPS32;
typedef VIOPS32 *PVIOPS32;

#else

typedef struct _VioPresentationSpace {  /* viops */

    FSRSEM  fsemVioPSLock;

    SEL     selLVB;
    SEL     selBVSCB;
    BOOL    rgfAVio;

    USHORT  CellByteSize;

    USHORT  BufferRowCount;
    USHORT  BufferColumnCount;

/* Window Origin coordinates can be negative for AVio presentation spaces.
 * For Vio presentation spaces the Shield Layer always coerces them to
 * non-negative values such that the client rectangle always lies completely
 * within the image of the logical video buffer.
 */
    SHORT   WindowOriginRow;
    SHORT   WindowOriginColumn;

    USHORT  TextCursorRow;
    USHORT  TextCursorColumn;
    USHORT  TextCursorStartLine;
    USHORT  TextCursorEndLine;
    USHORT  TextCursorWidth;
    BOOL    TextCursorVisible;

    USHORT  CellImageHeight;
    USHORT  CellImageWidth;

    USHORT  CodepageID;

    USHORT  WindowHeight;
    USHORT  WindowWidth;

    HDC     hConsoleDisplayContext;

/* The following fields are used for private communication between
 * the shield thread and the display driver.
 *
 * NB: The order and positions of the fields RowOrgLatch..CursorWidth
 *     must parallel that of the fields WindowOriginRow..TextCursorWidth
 *     in the Vio presentation space.  The UpdateCursor code in the device
 *     driver depends on this being so.  See the AVioPS.inc file used
 *     by the driver.
 */
    HWND    hVioWindow;         /* Window handle for this Vio PS  */

    SHORT   RowOrgLatch;        /* Window origin coordinates from */
    SHORT   ColOrgLatch;        /* the last call to UpdateCursor  */

    SHORT   CursorRow;          /* Cursor state as of the last    */
    SHORT   CursorCol;          /* call to UpdateCursor           */
    SHORT   CursorStartLine;
    SHORT   CursorEndLine;
    BYTE    CursorWidth;

    CHAR    PartialCellAdjust;  /* Adjustment for partial cells   */
                                /* on the bottom of the window.   */
    SHORT   XLatch;             /* Pel coordinates of the cursor  */
    SHORT   YLatch;             /* rectangle relative to the Vio  */
    SHORT   WidthLatch;         /* window                         */
    SHORT   HeightLatch;

    USHORT  CellHeightLatch;    /* To detect cell height changes. */

    BOOL    rgfShieldStates;    /* Shield States shared with the  */
                                /* device driver code.            */

    SEL     selFontsLoaded[3];  /* Selectors for fonts loaded into */
                                /* LCID 1..3.                      */

    USHORT NEAR *npMapFontsLoaded[3];
                                /* Offsets within the display driver's   */
                                /* global data segment of the code page  */
                                /* maps for fonts loaded into LCID 1..3. */
    USHORT  FormatID;
    USHORT  Reserved;           /*
                                 * Japan needs to know FormatID and *
                                 * Reserved for the Display Device  *
                                 * Driver.                          */
    /*ifdef D1348*/
    PVIOPSNLSEXT lpNLSExt;
    /*endif D1348*/

} VioPresentationSpace;


/* Standard typedefs
 */
typedef VioPresentationSpace VIOPS;
typedef VIOPS FAR *PVIOPS;
typedef VIOPS NEAR *NPVIOPS;
typedef PVIOPS FAR *PPVIOPS;

#endif


/* Compatible typedefs
 */
/* NOINC */
#define Sel_LogicalVideoBuffer  selLVB
#define Sel_BVSControlBlock     selBVSCB
#define selfontsloaded          selFontsLoaded
#define npmapfontsloaded        npMapFontsLoaded
#define PresentationSpaceLock   fsemVioPSLock
/* INC */
/* ASM
viops_PresentationSpaceLock     equ <viops_fsemVioPSLock>
viops_Sel_LogicalVideoBuffer    equ <viops_selLVB>
viops_Sel_BVSControlBlock       equ <viops_selBVSCB>
ifndef viops_selfontsloaded
viops_selfontsloaded            equ <viops_selFontsLoaded>
viops_npmapfontsloaded          equ <viops_npMapFontsLoaded>
endif
*/


/* Flag definitions for rgfAVio:
 */
#define fAssociated         0x0001


/* Flag definitions for rgfShieldStates.  These flags coordinate the
 * appearance of the text cursor between the shield thread and the display
 * driver.
 */
#define fCursorShowing      0x0001  /* Cursor is visible on the screen */
#define fHasTheFocus        0x0002  /* This window has the input focus */
#define fCursorIsOn         0x0004  /* 1 => On part of blink cycle     */


/* The flags below are used to implement WinSyncWithPS and the system
 * commands "Mark" and "Copy".
 *
 * Whenever the shield thread makes a call to the device driver via
 * GreCharRect, GreCharStr, GreScrollRect, or GreUpdateCursor, it
 * will turn on the fShieldCalling flag.
 *
 * When we want to restrict display changes to those initiated by the
 * shield thread, we turn on the fServeShieldOnly flag.  When we want
 * to defer all display changes, we turn on the fServeNobody flag.
 *
 * The routines which turn off the fServeShieldOnly and fServeNobody
 * flags must also repaint the client rect and update the text cursor.
 */
#define fShieldCalling      0x8000
#define fServeShieldOnly    0x4000
#define fServeNobody        0x2000


#define MaxVIORows  255         /* Limit value for BufferRowCount    */
#define MaxVIOCols  255         /* Limit value for BufferColumnCount */


/* WM_AbortShield is a private message used between the shield thread,
 * VioStub.exe, and the task manager.  It indicates that the Vio window
 * should be removed immediately when the child processes terminate.
 */
#define WM_AbortShield          (0x352)    /* WM_User+52 */

/* NOINC */
#define BufferCell      USHORT

#define RamSemaphore    ULONG
/* INC */

typedef RamSemaphore FAR *LPRamSemaphore;



/***********************************************************************\
 *
 *                   Structures and Interfaces
 *                              for
 *                     Drawing (A)Vio Images
 *
 * The Graphics Engine provides a set of interfaces for drawing Vio and
 * AVio images on the display screen.  [#define'd in PMDDIP.H]
 *
 * Four functions are provided:
 *
 *     ErrValue GreCharRect(hps, lpVioPS)
 *     HPS                       hps;        -- A micro PS for the console
 *     VioPresentationSpace FAR *lpVioPS;    -- The  VioPS for the console
 *     GridRectRef          FAR *lpRectDesc; -- The rectangle to draw
 *
 * GreCharRect draws a rectangle of characters taken from the logical video
 * buffer associated with the (A)Vio presentation space.
 *
 *     ErrValue GreCharStr(hps, lpVioPS, lpStrDesc)
 *     HPS                       hps;          -- A micro PS for the console
 *     VioPresentationSpace FAR *lpVioPS;      -- The  VioPS for the console
 *     GridStringRef        FAR *lpStringDesc; -- The string to draw
 *
 * GreCharStr draws a string of characters taken from the logical video
 * buffer.  The string is defined by a set of starting coordinates within
 * the LVB and an length.  The string may cross row boundaries.
 *
 *     ErrValue GreScrollRect(hps, lpVioPS, lpScrollDesc)
 *     HPS                       hps;          -- A micro ps for the console.
 *     VioPresentationSpace FAR *lpVioPS;      -- The (A)Vio PS for the console.
 *     ScrollRectRef        FAR *lpScrollDesc; -- The rectangle being scrolled.
 *
 * GreScrollRect scrolls a subrectangle of the LVB image.  Note that it does
 * not scroll the content of the logical video buffer.  That must be done
 * prior to calling GreScrollRect.
 *
 *     ErrValue GreUpdateCursor(hps, lpVioPS)
 *     HPS                       hps;        -- A micro ps for the console.
 *     VioPresentationSpace FAR *lpVioPS;    -- The (A)Vio PS for the console.
 *
 * GreUpdateCursor adjusts the position and characteristic of the text cursor
 * to match the control fields within the (A)Vio presentation space.
 *
\***********************************************************************/


/******************* Public Data Type **********************************\
 *
 * GridRectRef -- Defines an LVB rectangle for GreCharRect.
 *
\***********************************************************************/

typedef struct _GridRectRef { /* cellrect */

                    ULONG   StartRow;
                    ULONG   StartColumn;
                    ULONG   RectWidth;
                    ULONG   RectDepth;
               } GridRectRef;

typedef GridRectRef FAR * LPGridRectRef;


/******************* Public Data Type **********************************\
 *
 * GridStringRef -- Defines an LVB string for GreCharStr.
 *
\***********************************************************************/

typedef struct _GridStringRef { /* cellstr */

                    ULONG   StartRow;
                    ULONG   StartColumn;
                    ULONG   StringLength;
                } GridStringRef;

typedef GridStringRef FAR * LPGridStringRef;


/******************* Public Data Type **********************************\
 *
 * ScrollRectRef -- Defines a scrolling action for GreScrollRect.
 *
\***********************************************************************/

typedef struct _ScrollRectRef { /* cellscroll */

                    ULONG   StartRow;
                    ULONG   StartColumn;
                    ULONG   RectWidth;
                    ULONG   RectDepth;
                    LONG    HorzMovement;
                    LONG    VertMovement;

                    USHORT FAR *lpFillCell;
                } ScrollRectRef;

typedef ScrollRectRef FAR * LPScrollRectRef;



/******************* Public Data Type **********************************\
 *
 * KbdMouParameters -- Used to create a console
 *
\***********************************************************************/

typedef struct _KbdMouParameters {   /* kmparms */

            USHORT  KeyBuffSize;
            USHORT  MouBuffSize;
            USHORT  MouFilterMask;
        } KbdMouParameters;


/************************ Conventions **********************************\
 *
 * This structure is passed to WinCreateConsole (see below).  It defines the
 * sizes of the keyboard and mouse event queues to allocate for the console
 * and it supplies the initial cursor image and event filter to use with
 * the mouse.
 *
\***********************************************************************/

/*********************** Field Definitions *****************************\
 *
 * KeyBuffSize -- Maximum number of events to be retained in the keyboard
 * buffer.  Zero signifies that the default value (30) should be used.
 *
 * MouBuffSize -- Maximum number of events to be retained in the mouse buffer.
 * Zero signifies that the default value (30) should be used.
 *
 * MouFilterMask -- An initial value for the filter mask used to record or
 * discard mouse events
 *
\***********************************************************************/


/******************* Public Data Type **********************************\
 *
 * HCONSOLE -- Handle used to reference a Vio console.
 *
\***********************************************************************/

/* NOINC */
#define HCONSOLE SHANDLE
/* INC */



/******************* Public Data Type **********************************\
 *
 * hLogicalKBD -- A logical keyboard in the sense of OS|2.11
 *
\***********************************************************************/

/* NOINC */
#define HLogicalKbd USHORT
/* INC */

typedef HLogicalKbd FAR * LPHLogicalKbd;


/* Bit Definitions for the fsState field of the KBDKEYINFO
 * data structure:
 */
#define RightShiftDown    (0x0001)
#define LeftShiftDown     (0x0002)
#define CtrlKeyDown       (0x0004)
#define AltKeyDown        (0x0008)
#define ScrollLockOn      (0x0010)
#define NumLockOn         (0x0020)
#define CapsLockOn        (0x0040)
#define InsertOn          (0x0080)
#define LeftCtrlKeyDown   (0x0100)
#define LeftAltKeyDown    (0x0200)
#define RightCtrlKeyDown  (0x0400)
#define RightAltKeyDown   (0x0800)
#define ScrollLockKeyDown (0x1000)
#define NumLockKeyDown    (0x2000)
#define CapsLockKeyDown   (0x4000)
#define SysReqKeyDown     (0x8000)


/* NOINC */
/******************* Public Data Type **********************************\
 *
 * ErrVal -- The error condition returned by the interface functions.
 *
\***********************************************************************/

#define ErrVal int


/******************* Public Data Type **********************************\
 *
 * CODEPAGEID -- A Code Page ID in the sense of OS|2.11
 *
\***********************************************************************/

#define CODEPAGEID USHORT
/* INC */

typedef CODEPAGEID FAR *LPCODEPAGEID;


/* Bit definitions for the fsMask field of the KBDINFO
 * data structure:
 */
#define Shift_Return_On         0x0100
#define Two_Byte_Turnaround     0x0080
#define Set_Turnaround_Char     0x0040
#define Set_Interim_Char_Flags  0x0020
#define Set_Shift_State         0x0010
#define Ascii_Mode_On           0x0008
#define Binary_Mode_On          0x0004
#define Echo_Off                0x0002
#define Echo_On                 0x0001


/* NOINC */

#ifndef INCL_NOSHIELDPROCS

/************************ Public Functions *****************************\
 *
 * LockVioPS and UnlockVioPS -- These interfaces are provided as a
 * convenience for procuring and releasing PresentationSpaceLock's.
 *
\***********************************************************************/

extern ErrVal APIENTRY16    LockVioPS(VioPresentationSpace FAR *);
extern ErrVal APIENTRY16  UnlockVioPS(VioPresentationSpace FAR *);


/************************ Public Function ******************************\
 *
 * WinCreateConsole -- Create a console handle.
 *
\***********************************************************************/

ErrVal APIENTRY16  WinCreateConsole(USHORT,
                                    VioPresentationSpace FAR *,
                                    KbdMouParameters FAR *,
                                    HCONSOLE FAR *
                                   );


/************************ Public Function ******************************\
 *
 * WinDestroyConsole -- Dispose of a console handle.
 *
\***********************************************************************/

ErrVal APIENTRY16  WinDestroyConsole(USHORT);



/************************ Public Function ******************************\
 *
 * WinSyncWithPS -- Synchronize the window image with the PS.
 *
\***********************************************************************/

ErrVal APIENTRY16  WinSyncWithPS(HCONSOLE);




/************************ Public Function ******************************\
 *
 * WinConsoleReadKeyEvent -- Read an event from the keyboard queue.
 *
\***********************************************************************/

ErrVal APIENTRY16  WinConsoleReadKeyEvent(HCONSOLE, HLogicalKbd, BOOL, BOOL,
                                          KBDKEYINFO FAR *);



/************************ Public Function ******************************\
 *
 * WinConsoleFlushKeyEvents -- Empty the keyboard event queue.
 *
\***********************************************************************/

ErrVal APIENTRY16  WinConsoleFlushKeyEvents(HCONSOLE, HLogicalKbd);



/************************ Public Function ******************************\
 *
 * WinConsoleOpenKbd -- Create a logical keyboard.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleOpenKbd(HCONSOLE, LPHLogicalKbd);



/************************ Public Function ******************************\
 *
 * WinConsoleCloseKbd -- Destroy a logical keyboard.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleCloseKbd(HCONSOLE, HLogicalKbd);



/************************ Public Function ******************************\
 *
 * WinConsoleSetStatus -- Set the fbStatus of a logical keyboard.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleSetStatus(HCONSOLE, HLogicalKbd,
                                      PKBDINFO);



/************************ Public Function ******************************\
 *
 * WinConsoleGetStatus -- Retrieve the fbStatus of a logical keyboard.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleGetStatus(HCONSOLE, HLogicalKbd,
                                      PKBDINFO);



/************************ Public Function ******************************\
 *
 * WinConsoleSetCP -- Set the code page id for a logical keyboard.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleSetCP(HCONSOLE, HLogicalKbd, CODEPAGEID);



/************************ Public Function ******************************\
 *
 * WinConsoleGetCP -- Retrieve the code page id bound to a logical keyboard.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleGetCP(HCONSOLE, HLogicalKbd, LPCODEPAGEID);



/************************ Public Function ******************************\
 *
 * WinConsoleKbdXlate -- Translate scan codes to ascii codes.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleKbdXlate(HCONSOLE, HLogicalKbd, PKBDTRANS);



/************************ Public Function ******************************\
 *
 * WinConsoleSetCustXT -- Bind a custom translate table to a logical kbd.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleSetCustXT(HCONSOLE, HLogicalKbd, PUSHORT);



/************************ Public Function ******************************\
 *
 * WinConsoleGetFocus -- Direct incoming keystrokes to a particular
 *                       logical keyboard.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleGetFocus(HCONSOLE, HLogicalKbd);



/************************ Public Function ******************************\
 *
 * WinConsoleFreeFocus -- Release the binding made by WinConsoleGetFocus.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleFreeFocus(HCONSOLE, HLogicalKbd);



/************************ Public Function ******************************\
 *
 * WinConsoleQueuedPointerEvents -- Query the number of mouse events.
 *
\***********************************************************************/

ErrVal APIENTRY16  WinConsoleQueuedPointerEvents(HCONSOLE, PMOUQUEINFO);


/************************ Public Function ******************************\
 *
 * WinConsoleReadPointerEvent -- Read a mouse event from the queue.
 *
\***********************************************************************/

ErrVal APIENTRY16  WinConsoleReadPointerEvent(HCONSOLE, BOOL, BOOL,
                                              PMOUEVENTINFO);



/************************ Public Function ******************************\
 *
 * WinConsoleFlushPointerEvents -- Empty the mouse event queue.
 *
\***********************************************************************/

ErrVal APIENTRY16  WinConsoleFlushPointerEvents(HCONSOLE);



/************************ Public Function ******************************\
 *
 * WinConsoleGetPointerFilterMask -- Retrieve the mouse event filter mask
 *
\***********************************************************************/

ErrVal APIENTRY16  WinConsoleGetPointerFilterMask(HCONSOLE, USHORT FAR *);


/************************ Public Function ******************************\
 *
 * WinConsoleSetPointerFilterMask -- Defines the mouse event filter mask
 *
\***********************************************************************/

ErrVal APIENTRY16  WinConsoleSetPointerFilterMask(HCONSOLE, USHORT);


/************************ Public Function ******************************\
 *
 * WinConsoleGetPtrPos -- Retrieves the current mouse position.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleGetPtrPos(HCONSOLE, USHORT FAR *, USHORT FAR *);


/************************ Public Function ******************************\
 *
 * WinConsoleSetPtrPos -- Sets the mouse to a designated cell position.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleSetPtrPos(HCONSOLE, USHORT, USHORT);


/************************ Public Function ******************************\
 *
 * WinConsoleAttachMouseUser -- Increments mouse user count.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleAttachMouseUser(HCONSOLE);


/************************ Public Function ******************************\
 *
 * WinConsoleDetachMouseUser -- Decrements mouse user count.
 *
\***********************************************************************/

ErrVal APIENTRY16 WinConsoleDetachMouseUser(HCONSOLE);

/* NB: Mouse Events are only recorded when the mouse user count for
 *     the console is non-zero.
 */

#endif /* INCL_NOSHIELDPROCS */

/* INC */


/***************************Error Values *******************************
*
* Abstract: Error values returned by portions of the Shield Layer.
*
* Created:  14-May-87
* Author:   Ron Murray  [ronm]
*
*
* These are the error values returned by
* the components of the Shield Layer.
*
\***********************************************************************/


/* Error values returned by the Shield Layer
 * Dyn-Link API:
 */

#define SHIELD_API_ERROR_BASE                   (-32)

#define CE_NULL_PRESENTATION_SPACE              (-33)
#define CE_INVALID_PRESENTATION_SPACE           (-34)
#define CE_TOO_MANY_PS_ROWS                     (-35)
#define CE_TOO_MANY_PS_COLS                     (-36)
#define CE_CANT_CREATE_GLOBAL_HEAP              (-37)
#define CE_NULL_HCONSOLE_POINTER                (-38)
#define CE_OUT_OF_DGROUP_MEMORY                 (-39)
#define CE_CANT_CREATE_INSTANCEHEAP             (-40)
#define CE_OUT_OF_INSTANCE_MEMORY               (-41)
#define CE_INVALID_MOUSE_FILTER_MASK            (-42)

#define CE_CANT_REGISTER_WINDOW_CLASS           (-44)
#define CE_CANT_CREATE_STD_WINDOW               (-45)
#define CE_CANT_SUBCLASS_FRAME_PROC             (-46)

#define CE_CANT_DISCARD_KEY_BUFFER              (-48)
#define CE_CANT_DISCARD_MOU_BUFFER              (-49)
#define CE_CANT_DISCARD_CONSOLE_STATE           (-50)
#define CE_INVALID_CONSOLE_HANDLE               (-51)

#define CE_CANT_ALLOCATE_DC                     (-53)
#define CE_CANT_ALLOCATE_LVB                    (-54)
#define CE_PSPACE_INACCESSABLE                  (-55)
#define CE_CANT_DISCARD_INSTANCE_SEG            (-56)

#define CE_CANT_DISCARD_KBD_STATE               (-59)
#define CE_PS_NOT_LOCKED                        (-60)
#define CE_CONSOLE_DOES_NOT_HAVE_FOCUS          (-61)
#define CE_NOT_A_SIZE_MESSAGE                   (-62)
#define CE_CANT_LOAD_STRING_RESOURCES           (-63)
#define CE_NO_CELL_INFO                         (-64)
#define CE_CANT_MAP_WND_TO_DC                   (-65)
#define CE_CANT_MAP_DC_TO_LPVIOPS               (-66)
#define CE_TOO_MANY_MOUSE_DETACHES              (-67)
#define CE_SHIELD_ALREADY_INITIALED             (-68)
#define CE_NOT_ENOUGH_SHELL_HOOKS               (-69)
#define CE_CANT_SUBCLASS_TASK_MGR               (-70)
#define CE_CANT_LOAD_MARKING_CURSOR             (-71)
#define CE_SGID_NOT_ACTIVE                      (-72)
#define CE_CANT_DEALLOCATE_LVB                  (-73)
#define CE_CANT_DEALLOCATE_VIO_PS               (-74)
#define CE_INVALID_VIO_PS_ADDRESS               (-75)
#define CE_INVALID_LVB_SELECTOR                 (-76)
#define CE_CANT_ALLOCATE_TITLE_BUFFER           (-77)
#define CE_NOT_CALLED_FROM_SHELL_PID            (-78)
#define CE_SHIELD_NOT_INITIALED                 (-79)

/* Error values added for use by VDM-related portions of the Shield Layer:
 */

#define CE_UNKNOWN_PROG_TYPE                    (-80)
#define CE_DLL_LOAD_FAILURE                     (-81)
#define CE_DLL_PROC_FAILURE                     (-82)
#define CE_DLL_FREE_FAILURE                     (-83)

#define CE_VDM_HEAP_CREATE_FAILURE              (-84)
#define CE_VDM_HEAP_ALLOC_FAILURE               (-85)
#define CE_VDM_HEAP_FREE_FAILURE                (-86)
#define CE_VDM_VIDEO_VDD_NOT_FOUND              (-87)
#define CE_VDM_VIDEO_ACCESS_DENIED              (-88)
#define CE_VDM_KEYBOARD_VDD_NOT_FOUND           (-89)
#define CE_VDM_KEYBOARD_ACCESS_DENIED           (-90)
#define CE_VDM_MOUSE_VDD_NOT_FOUND              (-91)
#define CE_VDM_MOUSE_ACCESS_DENIED              (-92)
#define CE_VDM_TIMER_VDD_NOT_FOUND              (-93)
#define CE_VDM_TIMER_ACCESS_DENIED              (-94)
#define CE_VDM_STACK_ALLOCATION_FAILURE         (-95)
#define CE_VDM_THREAD_CREATION_FAILURE          (-96)


/* Error values returned by the Graphics Engine API for
 * Vio/AVio presentation spaces:
 */

#define GRAPHICSENGINEAPIERRORBASE              (-128)

#define GRE_INVALIDROWINDEX                     (-129)
#define GRE_INVALIDCOLUMNINDEX                  (-130)
#define GRE_NEGATIVEWIDTH                       (-131)
#define GRE_NEGATIVEDEPTH                       (-132)
#define GRE_NEGATIVELENGTH                      (-133)
#define GRE_CURSORSTATEFAILURE                  (-134)
#define GRE_OUTOFMEMORY                         (-135)


#define AVIO_PS_HANDLE_INDEX 1
#define CNT_LOADABLE_LCIDS   3

/* NOINC */
#ifdef __IBMC__
   #pragma checkout( suspend )
      #ifndef __CHKHDR__
         #pragma checkout( resume )
      #endif
   #pragma checkout( resume )
#endif
/* INC */

/**************************** end of file **********************************/
