/**************************************************************************
 *
 * SOURCE FILE NAME = DELDDK.CMD
 *
 * DESCRIPTIVE NAME = Delete the entire DDKx86 tree.
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1993-1995
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  This command file deletes the system DDKx86 INI entries
 *              and the DDK tree.
 *
 * Functions    Testexist
 *              Remind
 *              DelDir
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR     CHANGE DESCRIPTION
 *  --------  ----------  -----    --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx    xxxxxxx
 *  06/10/93  v2.00000jk           Created       Jagan Karuturi
 *  02/01/94  v2.00001jk  modified to delete EPFIS.INI keywords.  Jagan
 ****************************************************************************/

/*

   This command gets the path for the DDK from the user
   and deletes the entire tree using Rexx functions

*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call SysCls
escq=x2c('1B'); Cyan=escq'[1;36;40m'; White=escq'[0;37;40m'; Red=escq'[1;31;40m'
Yellow=escq'[1;33;40m'
Line= '---------------------------------------------------------------------'
/*
   Make sure that the user supplies the path to be deleted
   If not output help messages on to the screen.  Also check
   if the user enters the existing directory.  If the
   does not exist display error message.
*/

 parse upper arg Dir

 if Dir = '?' | Dir = ''
   then signal Remind
 Keep = Testexist(Dir)

  say Red
  say 'WARNING: If you made any changes to the previous version of the DDK,'
  say 'make sure that you SAVE the modified files. All the existing files'
  say 'in the specified directory and subdirectories will be deleted.'
  say
  say White
  say 'Do you want to continue ?'
  say 'Enter Y or y to continue, else N or n to exit out of this program:'

   do until wordpos(Ch, 'Y N') <> 0
     Ch=translate( SysGetKey('NOECHO'))
   end
   say Ch
   if Ch = 'N' then do
      say White
      exit 2
   end
   say White


/*
   Find out the bootdrive from the path and then delete the EPF* files
   from OS2/SYSTEM   directory
*/

 path = value('PATH',,'OS2ENVIRONMENT')

 if pos(':\OS2\SYSTEM', path) > 1 then
    Parse Upper var path . ":\OS2\SYSTEM" -1 bootdrive +1 .
 else bootdrive = 'C'
 bootpath= bootdrive':\os2\system'

call SysIni bootpath'\epfis.ini','EPFINST_IBM Developer Connection Device Driver Kit for OS/2_83G9641_', 'DELETE:'
call SysIni bootpath'\epfis.ini','EPFINST_IBM Device Driver Source Kit for OS/2_71G3703-01_', 'DELETE:'
call SysIni bootpath'\epfis.ini','EPFINST_IBM Device Driver Source Kit for OS/2_71G3703_', 'DELETE:'
call SysIni bootpath'\epfis.ini','EPFINST_IBM Device Driver Source Kit for OS/2_71G3703_5892', 'DELETE:'
call SysIni bootpath'\epfis.ini','EPFINST_OS/2 Device Driver Development Kit_0_0', 'DELETE:'


 call SysFileTree bootpath'\epfi*.*', files, 'FSO', '***+*'

  do i = 1 to files.0

          '@ATTRIB -r -h' files.i
  end


 drop files.i


 call SysFileTree bootpath'\epfi*.*', files, 'FO'

 if files.0 = 0
 then
    do
      say Red
      say 'The system DDK INI entries have already been removed - CONTINUE'
      say White
    end
 else
  do i = 1 to files.0

     if i=1
      then
            call SysFileDelete bootpath'\epficat.pkg'
            call SysFileDelete bootpath'\epfihcnf.cnf'
  end

/*
** If the directory exists then prompt the user again to make sure
** he wants to delete the DDK directory
*/

 say
 say 'You have selected to delete the' Cyan||Keep||White 'directory'

 do
   say Cyan
   Say 'Are you sure ? '
   do until wordpos(Ch, 'Y N') <> 0
     Ch=translate( SysGetKey('NOECHO'))
   end
   say Ch

   if Ch = 'N' then do

    say White
    exit 2
   end

   else
   say White
   say 'Please wait, deleting' Cyan||Keep||White 'directory...'
   say

   result = SysDestroyObject('<DDKFLD>')
   result = SysDestroyObject('<DDKI_FOLDER>')

   call deldir keep'\H'
   rc=SysRmDir(keep'\H')

   call deldir keep'\BOOK'
   rc=SysRmDir(keep'\BOOK')

   call deldir keep'\DBCSDD'
   rc=SysRmDir(keep'\DBCSDD')

   call deldir keep'\H386'
   rc=SysRmDir(keep'\h386')

   call deldir keep'\H_DBCS'
   rc=SysRmDir(keep'\H_DBCS')

   call deldir keep'\IBMH'
   rc=SysRmDir(keep'\IBMH')

   call deldir keep'\IBMC'
   rc=SysRmDir(keep'\IBMC')

   call deldir keep'\INC'
   rc=SysRmDir(keep'\INC')

   call deldir keep'\INC32'
   rc=SysRmDir(keep'\INC32')

   call deldir keep'\INC_DBCS'
   rc=SysRmDir(keep'\INC_DBCS')

   call deldir keep'\LIB'
   rc=SysRmDir(keep'\LIB')

   call deldir keep'\MASM60'
   rc=SysRmDir(keep'\MASM60')

   call deldir keep'\MISCTOOL'
   rc=SysRmDir(keep'\MISCTOOL')

   call deldir keep'\MMOS2'
   rc=SysRmDir(keep'\MMOS2')

   call deldir keep'\MRI'
   rc=SysRmDir(keep'\MRI')

   call deldir keep'\SETUP'
   rc=SysRmDir(keep'\SETUP')

   call deldir keep'\SRC'
   rc=SysRmDir(keep'\SRC')

   call deldir keep'\SRC_DBCS'
   rc=SysRmDir(keep'\SRC_DBCS')

   call deldir keep'\SVGAINST'
   rc=SysRmDir(keep'\SVGAINST')

   call deldir keep'\TESTCERT'
   rc=SysRmDir(keep'\TESTCERT')

   call deldir keep'\TESTTOOL'
   rc=SysRmDir(keep'\TESTTOOL')

   call deldir keep'\TOOLS'
   rc=SysRmDir(keep'\TOOLS')

   call deldir keep'\VIDEO'
   rc=SysRmDir(keep'\VIDEO')

   call SysFileDelete keep'\ddk.pkg'

   call SysFileDelete keep'\README.ddk'

   rc=SysRmDir(keep)

 end
 say white

exit

/*==============================================================*/
/* TESTEXIST PROCEDURE                                          */
/* This procedure checks if the given directory name exists     */
/*==============================================================*/

 Testexist:

  parse arg Dir
  Keep = Dir
  Home = directory()
  Test = directory(Dir)
  len = LENGTH(Dir)
  gen= RIGHT(LEFT(Dir,2),1)

  if len <=3 & gen == ':'
     then do
           say Yellow
           say  Dir 'is a drive, not a directory. Please enter a valid DDK directory.'
           say White
           exit
         end
  if Test = ''
    then do
            say Yellow
            say 'Directory' Dir 'does not exist.'
            say White
            exit
         end
  else
    call SysFileTree Test'\ddk.PKG', files, 'FO', '*****'
    if files.0 == 0
        then do
              say Yellow
              say 'Directory' Dir 'is not a DDK directory.'
              say White
              exit
         end

    else
            return Test

/*======================================================*/
/* REMIND PROCEDURE                                     */
/* This procedure reminds the user to enter the path    */
/*======================================================*/

 Remind:

  say
  say Yellow||Line
  say 'DELDDK  - Delete the complete ddkx86 tree'
  say Line
  say White
  say 'Syntax:   DELDDK directory_path'
  say
  say 'Example:  DELDDK D:\DDKx86'
  say
  say 'This command deletes all files in the specified ddkx86 directory'
  say 'and its subdirectories, all ddkx86 maintenance files from the desktop.'
  say Cyan
  say 'Make sure that you enter the correct directory name.'
  say Red
  say 'WARNING: If you made any changes to the previous version'
  say 'of the DDK, make sure that you SAVE the modified files.'
  say White
  exit 0

/*======================================================*/
/* DELDIR PROCEDURE                                     */
/* This procedure deletes all the files and directories */
/*======================================================*/

deldir: procedure
    parse arg dir .

    call SysFileTree dir'\*', files, 'FSO', '***+*'
    do i = 1 to files.0

       '@ATTRIB -r -h' files.i
    end

    drop files.i

    call SysFileTree dir'\*', files, 'FO'
    do i = 1 to files.0

   /*    say files.i          */
       call SysFileDelete files.i

    end

    drop files.

    call SysFileTree dir'\*', files, 'DO'

    do i = 1 to files.0

      say files.i
      call deldir files.i
      call SysRmDir files.i

    end

    return

/********************************************************************/
