/**************************************************************************
 *
 * SOURCE FILE NAME : COPYC60.CMD
 *
 * VERSION : V1.1
 *
 * DATE    : 01/12/94
 *
 * DESCRIPTION  This command file copies the MS C 6.0 headers, libraries
 *              and tools to a directory usable by many makefiles.
 *
 * Functions
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR     CHANGE DESCRIPTION
 *  --------  ----------  -----    --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx    xxxxxxx
 *  01/13/94  @V1.1ALEXH           Simplify the screen output
 *
 ****************************************************************************/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
call SysCls
parse upper arg c600 basename .


parse source . . command .

command = FILESPEC( 'Name', command )

i = POS( '.', command )

k_esc   = d2c(27)
k_bell  = d2c(7)
LWhite  = k_esc'[0;40;37m'
HWhite  = k_esc'[1;40;37m'
HGreen  = k_esc'[1;40;32m'
HYellow = k_esc'[1;40;33m'

if i <> 0 then

   command = substr( command, 1, i - 1 )


if c600 = '' then

   do

      say
      say 'Usage:' command 'C600PATH DDKPATH'
      say
      say '        Where:'
      say '               C600PATH is the path to the Microsoft C 6.0 directory.'
      say '               e.g. C:\C600'
      say
      say '               DDKPATH  is the path where the DDK has been installed.    '
      say '               e.g. D:\DDKx86'

      exit

   end

uncopy     = 0

headers.1  = 'ASSERT.H'
headers.2  = 'CONIO.H'
headers.3  = 'CTYPE.H'
headers.4  = 'DOS.H'
headers.5  = 'ERRNO.H'
headers.6  = 'FCNTL.H'
headers.7  = 'FLOAT.H'
headers.8  = 'IO.H'
headers.9  = 'LIMITS.H'
headers.10 = 'LOCALE.H'
headers.11 = 'MALLOC.H'
headers.12 = 'MATH.H'
headers.13 = 'MEMORY.H'
headers.14 = 'PROCESS.H'
headers.15 = 'SEARCH.H'
headers.16 = 'SETJMP.H'
headers.17 = 'SIGNAL.H'
headers.18 = 'STDARG.H'
headers.19 = 'STDDEF.H'
headers.20 = 'STDIO.H'
headers.21 = 'STDLIB.H'
headers.22 = 'STRING.H'
headers.23 = 'TIME.H'

headers.0  = 23


exes.1     = 'C1.ERR'
exes.2     = 'C1.EXE'
exes.3     = 'C1L.EXE'
exes.4     = 'C2.EXE'
exes.5     = 'C23.ERR'
exes.6     = 'C2L.EXE'
exes.7     = 'C3.EXE'
exes.8     = 'C3L.EXE'
exes.9     = 'CL.ERR'
exes.10    = 'CL.EXE'
exes.11    = 'CL.MSG'

exes.0     = 11


libs.1     = 'LLIBCDLL.LIB'
libs.2     = 'LLIBCMT.LIB'

libs.0     = 2


libchk.1   = 'SLIBC7P.LIB'
libchk.2   = 'SLIBCEP.LIB'
libchk.3   = 'SLIBCER.LIB'
libchk.4   = 'CLIBCEP.LIB'
libchk.5   = 'LLIBCER.LIB'
libchk.6   = 'LLIBCEP.LIB'
libchk.7   = 'CLIBCER.LIB'

libchk.0   = 7

/*------------------------------------------------------*/
/* Copy header files.                                   */
/*------------------------------------------------------*/
say HWhite
say 'Copying header files ...'LWhite

call SysFileTree basename'\H',dirs, 'DO'
if dirs.0 <> 0 then
do
 do i = 1 to headers.0

   '@COPY' c600'\INCLUDE\'headers.i basename'\H\'headers.i '/V > nul 2>&1'

   if rc = 0 then
      say c600'\INCLUDE\'headers.i
   else
      do
         uncopy = uncopy + 1
         uncopylist.uncopy = c600'\INCLUDE\'headers.i ' to ' basename'\H'
      end
 end
end


/*------------------------------------------------------*/
/* Copy header files for DBCS.                          */
/*------------------------------------------------------*/

call SysFileTree basename'\DBCSDD',dirs, 'DO'
if dirs.0 <> 0 then
do

 '@MD' basename'\DBCSDD\H > nul 2>&1'
  do i = 1 to headers.0

   '@COPY' c600'\INCLUDE\'headers.i basename'\DBCSDD\H\'headers.i '/V > nul 2>&1'

   if rc = 0 then
      say c600'\INCLUDE\'headers.i
   else
      do
         uncopy = uncopy + 1
         uncopylist.uncopy = c600'\INCLUDE\'headers.i ' to ' basename'\DBCSDD\H'
      end
  end
end

/*------------------------------------------------------*/
/* Copy exe files.                                      */
/*------------------------------------------------------*/
say HWhite
say 'Copying EXE files ...'LWhite

do i = 1 to exes.0

   '@COPY' c600'\BINP\'exes.i basename'\TOOLS\'exes.i '/V > nul 2>&1'

   if rc = 0 then
      say c600'\BINP\'exes.i
   else
      do
         uncopy = uncopy + 1
         uncopylist.uncopy = c600'\BINP\'exes.i
      end
end


/*------------------------------------------------------*/
/* Copy library files.                                  */
/*------------------------------------------------------*/
say HWhite
say 'Copying library files ...'LWhite

call SysFileTree basename'\LIB',dirs, 'DO'
if dirs.0 <> 0 then
do
do i = 1 to libs.0

   '@COPY' c600'\LIB\'libs.i basename'\LIB\'libs.i '/V > nul 2>&1'

   if rc = 0 then
      say c600'\LIB\'libs.i
   else
      do
         uncopy = uncopy + 1
         uncopylist.uncopy = c600'\LIB\'libs.i
      end
 end
end


/*------------------------------------------------------*/
/* Copy DBCS library files.                             */
/*------------------------------------------------------*/

call SysFileTree basename'\DBCSDD',dirs, 'DO'
if dirs.0 <> 0 then
do
 DBCS= 'Y'
 '@MD' basename'\DBCSDD\LIB > nul 2>&1'

 do i = 1 to libs.0

   '@COPY' c600'\LIB\'libs.i basename'\DBCSDD\LIB\'libs.i '/V > nul 2>&1'

   if rc = 0 then
      say c600'\LIB\'libs.i
   else
      do
         uncopy = uncopy + 1
         uncopylist.uncopy = c600'\LIB\'libs.i
      end
 end
end


/*------------------------------------------------------*/
/* Copy library files.                                  */
/*------------------------------------------------------*/
do i = 1 to libchk.0

   /*------------------------------------------------------------*/
   /* If the real mode or protect mode library file exist,       */
   /*    then copy it.                                           */
   /* else                                                       */
   /*    search for default library (w/o 'r' or 'p' at the       */
   /*    end of the file name) and copy it.                      */
   /*    e.g.  COPY <source>\LLIBCE.LIB <target>\LLIBCEP.LIB     */
   /*------------------------------------------------------------*/
   if stream( c600'\LIB\'libchk.i, 'Command', 'Query Exist' ) <> '' then
      do
         '@COPY' c600'\LIB\'libchk.i basename'\LIB\'libchk.i '/V > nul 2>&1'

         /*------------------------------------------------------*/
         /* If the library file is SLIBCEP.LIB                   */
         /*    then copy it to \DBCSDD\LIB directory also.    */
         /*------------------------------------------------------*/
         if DBCS = 'Y' then
            '@COPY' c600'\LIB\'libchk.i basename'\DBCSDD\LIB\'libchk.i '/V > nul 2>&1'

         say c600'\LIB\'libchk.i
      end
   else
      do
         position = pos( '.', libchk.i )
         filename = left( libchk.i, position - 2 )
         filename = filename'.LIB'

         if stream( c600'\LIB\'filename, 'Command', 'Query Exist' ) <> '' then
            do
               '@COPY' c600'\LIB\'filename basename'\LIB\'libchk.i '/V > nul 2>&1'

               /*------------------------------------------------------*/
               /* If the library file is SLIBCEP.LIB                   */
               /*    then copy it to \DBCSDD\LIB directory also.    */
               /*------------------------------------------------------*/
               if DBCS = 'Y' then
                  '@COPY' c600'\LIB\'filename basename'\DBCSDD\LIB\'libchk.i '/V > nul 2>&1'

               say c600'\LIB\'filename
            end
         else
            do
               uncopy = uncopy + 1
               uncopylist.uncopy = c600'\LIB\'libchk.i
            end
      end

   if rc <> 0 then
      do
         uncopy = uncopy + 1
         uncopylist.uncopy = c600'\LIB\'libchk.i
      end

end


/*------------------------------------------------------*/
/* Display a list of files that cannot be copy,         */
/* if uncopy not equal to zero.                         */
/*------------------------------------------------------*/
if uncopy <> 0 then
   do
      say k_bell HWhite
      say 'Unable to copy the following file(s) to target.'HYellow
      do i = 1 to uncopy
         say uncopylist.i
      end
      say HWhite
      say 'Please make sure that you have these files then run this command file again.'
      say LWhite
   end
else
   do
      say HGreen
      say '<<<  Copy completed  >>>'LWhite
   end


exit
