/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)time.h	6.1 90/11/16";*/
/***
*time.h - definitions/declarations for time routines
*
*
*Purpose:
*	This file has declarations of time routines and defines
*	the structure returned by the localtime and gmtime routines and
*	used by asctime.
*	[ANSI/System V]
*
****/

#ifndef	CALLTYPE
#define	CALLTYPE	_cdecl
#endif	/* CALLTYPE */


/* define the implementation defined time type */

#ifndef _TIME_T_DEFINED
typedef long time_t;		/* time value */
#define _TIME_T_DEFINED 	/* avoid multiple def's of time_t */
#endif

#ifndef _CLOCK_T_DEFINED
typedef long clock_t;
#define _CLOCK_T_DEFINED
#endif

#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef _TM_DEFINED
struct tm {
	int tm_sec;	/* seconds after the minute - [0,59] */
	int tm_min;	/* minutes after the hour - [0,59] */
	int tm_hour;	/* hours since midnight - [0,23] */
	int tm_mday;	/* day of the month - [1,31] */
	int tm_mon;	/* months since January - [0,11] */
	int tm_year;	/* years since 1900 */
	int tm_wday;	/* days since Sunday - [0,6] */
	int tm_yday;	/* days since January 1 - [0,365] */
	int tm_isdst;	/* daylight savings time flag */
	};
#define _TM_DEFINED
#endif

#define CLK_TCK 1000


/* extern declarations for the global variables used by the ctime family of
 * routines.
 */

extern int CALLTYPE daylight;	/* non-zero if daylight savings time is used */
extern long CALLTYPE timezone;	/* difference in seconds between GMT and local time */
extern char * CALLTYPE tzname[2]; /* standard/daylight savings time zone names */


/* function prototypes */

char * CALLTYPE asctime(const struct tm *);
char * CALLTYPE ctime(const time_t *);
clock_t CALLTYPE clock(void);
double CALLTYPE difftime(time_t, time_t);
struct tm * CALLTYPE gmtime(const time_t *);
struct tm * CALLTYPE localtime(const time_t *);
time_t CALLTYPE mktime(struct tm *);
size_t CALLTYPE strftime(char *, size_t, const char *, const struct tm *);
char * CALLTYPE _strdate(char *);
char * CALLTYPE _strtime(char *);
time_t CALLTYPE time(time_t *);
void CALLTYPE tzset(void);
