/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = SVGADEFS.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  Contains SVGA definitions.
 *
 * FUNCTIONS
 *
 * NOTES        When included into VVID sources, #ifdef SVGA
 *              must be used before #include!
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_DOSERRORS
#define MAX_LOCKUNLOCKCMD       40                              /*          */
#define MAX_CLEANDATA          200      /* Includes DACs */     /*@V3.0YEE01*/
#define MAX_SETBANK_CMD         25                              /*          */
#define MAX_GETBANK_CMD         20                              /*          */
#define MAX_MODESET_CMD         84                              /*          */


#define DEFAULT_ADAPTER       (-1)
#define UNKNOWN_ADAPTER         0
#define VIDEO7_ADAPTER          1       /* bugbug line up with cleanups! */
#define TRIDENT_ADAPTER         2
#define TSENG_ADAPTER           3
#define WESTERNDIG_ADAPTER      4
#define ATI_ADAPTER             5
#define IBM_ADAPTER             6
#define CIRRUS_ADAPTER          7
#define S3_ADAPTER              8
#define CHIPS_ADAPTER           9                      /*            */
#define WEITEK_ADAPTER          10                     /*            */
#define NUMBER9_ADAPTER         11                     /*            */
#define GENERIC_PCISVGA_ADAPTER 12                      //@senja
 /* remember to update SVGA_LASTADAPTER when adding new adapter support */

#define SVGA_FIRSTADAPTER       VIDEO7_ADAPTER         /*            */
#define SVGA_LASTADAPTER        GENERIC_PCISVGA_ADAPTER

/*            start */
#ifdef FAMILY2
  #define ORCHID_MC_ADAPTER     2       /*            */
  #define ORCHID_MC_ID          0x86    /*            */
#endif

/*
** DAC types
*/

#define VGA_DAC           0                                     /*          */
#define DEFAULT_DAC       VGA_DAC                               /*          */
#define HICOLOR_DAC       1      /* Unidentified */             /*          */
#define WINBOND_DAC       HICOLOR_DAC                           /*          */
#define BT485_DAC         2      /* Brooktree 485 */            /*          */
#define Weitek_BT485DAC   3      /* BT485 used by Weitek      */
#define SC15025_DAC       4      /* SC15025                   */
#define SierraDAC         SC15025_DAC /* Use more specific name! */
#define ATT490_DAC        5
#define ATTDAC            ATT490_DAC /* Use more specific name! */
#define MU9C1880_DAC      6      /* MU9C4870, MU9C1880, SS2410*/
#define MU9C4870_DAC      MU9C1880_DAC                          /*          */

#define TRUECOLOR_DAC     7                                     /*          */
#define IMSG173_DAC       8      /*These DACS identified, but not programmed*/
#define InmosDAC          IMSG173_DAC /* Use more specific name! */
#define CH8398_DAC        9
#define ChrontelDAC       CH8398_DAC /* Use more specific name! */
#define CIRRUS_DAC       10
#define ICS5341_DAC      11
#define ICS5342_DAC      ICS5341_DAC                            /*          */
#define SGS1702_DAC      12
#define SGSThomsonDAC16  SGS1702_DAC /* Use more specific name! */
#define SGS1703_DAC      13                                     /*          */
#define MU9C4910_DAC     14      /* MU9C4910 (blue byte first) */
                                 /*  note that the MU9C1880 is also true color, but */
                                 /*       it does not need to be identified because */
                                 /*       behaves like the others in its group      */
#define MusicDAC16RGB    MU9C4910_DAC /* Use more specific name! */
#define ATI68830_DAC     15      /* ATI 68830 & compatible              */
#define S3SDAC_DAC       16      /* S3 SDAC                             */
#define ATT498_DAC       17      /* AT&T 498 CLOCKDAC                   */
#define SGS1700_DAC      18      /* SGS 1700 DAC                        */
#define TLC34075_DAC     19      /* Texas Instruments TLC34075*/
#define ATI68875_DAC     TLC34075_DAC
#define BT476_DAC        20      /* Brooktree 476/478                   */
#define BT478_DAC        BT476_DAC
#define BT481_DAC        21      /* Brooktree 481/482                   */
#define BT482_DAC        BT481_DAC
#define ATI68860_DAC     22      /* ATI 68860/68880                     */
#define MU9CBUG_DAC      23
#define CH8391_DAC       24
#define W82C490_DAC      25
#define ATT491_DAC       26
#define ATT492_DAC       27
#define ATT493_DAC       28
#define ATT497_DAC       29
#define WD90C24_DAC      30
#define MU9C9910_DAC     31      /* (blue byte first) */
#define ATT409_DAC       32
#define TI3025_DAC       33      /* TI Viewpoint 3025 CLOCKDAC  @V3.0YEE01*/
#define MAX_DAC          34                                   /*@V3.0YEE01*/

#define VGADAC_NAME     "VGA_RGB"                             /*          */
#define HICOLOR_NAME    "HICOLOR_RGB"                         /*          */
#define BT485_NAME      "BT485_RGB"                           /*          */
#define VIPER_NAME      "BT485_RGB"
#define SC15025_NAME    "SC15025_RGB"
#define ATT490_NAME     "ATT20C490_RGB"                       /*          */
#define MU9C1880_NAME   "MU9C1880_BGR"
#define TRUECOLOR_NAME  "TRUECOLOR_RGB"                       /*          */
#define IMSG173_NAME    "IMSG173_RGB"
#define CH8398_NAME     "CH8398_RGB"
#define CIRRUS_NAME     "CIRRUS_RGB"
#define ICS5341_NAME    "ICS5341_RGB"
#define SGS1702_NAME    "SGS1702_RGB"
#define SGS1703_NAME    "SGS1703_RGB"                         /*          */
#define MU9C4910_NAME   "MU9C4910_RGB"                        /*            was BGR */
#define ATI68830_NAME   "ATI68830_RGB"                        /*          */
#define S3SDAC_NAME     "S3SDAC_RGB"                          /*          */
#define ATT498_NAME     "ATT20C498_RGB"                       /*          */
#define SGS1700_NAME    "SGS1700_RGB"                         /*          */
#define TLC34075_NAME   "TLC34075_RGB"                        /*          */
#define ATI68875_NAME   "ATI68875_RGB"                        /*          */
#define BT476_NAME      "BT476_RGB"                           /*          */
#define BT481_NAME      "BT481_RGB"                           /*          */
#define ATI68860_NAME   "ATI68860_RGB"                        /*          */
#define MU9CBUG_NAME    "MU9C1880BUG_BGR"                     /*          */
#define CH8391_NAME     "CH8391_RGB"                          /*          */
#define W82C490_NAME    "W82C490_RGB"                         /*          */
#define ATT491_NAME     "ATT20C491_RGB"                       /*          */
#define ATT492_NAME     "ATT20C492_RGB"                       /*          */
#define ATT493_NAME     "ATT20C493_RGB"                       /*          */
#define ATT497_NAME     "ATT20C497_RGB"                       /*          */
#define WD90C24_NAME    "WD90C24_RGB"                         /*          */
#define MU9C9910_NAME   "MU9C9910_RGB"                        /*          */
#define ATT409_NAME     "ATT20C409_RGB"                       /*          */
#define TI3025_NAME     "TVP3025_RGB" /* TI Viewpoint 3025 DAC  @V3.0YEE01*/

/* NOINC */
typedef struct _DACINFO {       /* dac */
  USHORT        DACFamily;
  USHORT        DACType;
} DACINFO;

/*
** flag values for fPortFlags in TRAPREGINFO              
*/
#define BYTE_IOPORT        0x001
#define WORD_IOPORT        0x002
#define DWORD_IOPORT       0x004
#define BYTE_MMIOPORT      0x008
#define WORD_MMIOPORT      0x010
#define DWORD_MMIOPORT     0x020
#define INDEXED            0x040
#define ACCEL              0x080
#define RESET_PORT         0x100
#define READ_ONLY          0x200
#define WRITE_ONLY         0x400
#define READ_WRITE         0x800

#define MASK_SIZE             32

typedef struct _TRAPREGINFO {   /* trp */
#ifdef DEVELOP
        ULONG   cb;                     /* size of the structure            */
#endif
        ULONG   ulAddressPort;          /* Address Port                     */
        ULONG   ulDataPort;             /* Data Port                        */
        USHORT  fPortFlags;             /* port type                        */
        USHORT  usIndex;                /* value in index port              */
        ULONG   ulIndexMask;            /* index mask                       */
        ULONG   ulDataMask;             /* data mask                        */
        ULONG   ulResetOneMask;         /*                                  */
        ULONG   ulResetZeroMask;         /*                                 */
        BYTE    abIndexList[MASK_SIZE]; /* bit mask of trapped indexed ports*/
        BYTE    abUpdateList[MASK_SIZE];/* bit mask of updated port indices */
        PVOID   aTrapRegData;           /* trap registers data area         */
} TRAPREGINFO;
typedef TRAPREGINFO FAR *PTRAPREGINFO;

typedef ULONG       MODEID;
typedef MODEID FAR *PMODEID;

                                        /*             definition of         */
                                        /* parameter packet of PMIREQUEST fx */
                                        /* PMIRequest_UpdateModeTrapData()   */
typedef struct _UPDATETRAPDATA {   /* upd */
   PTRAPREGINFO  asTrapInfo;
   MODEID        miModeId;
} UPDATETRAPDATA;
typedef UPDATETRAPDATA  *PUPDATETRAPDATA;

/* INC */

#define WEITEK_P9000_INCREMENT  0x0040 //Spacing between potential bases.
#define WEITEK_P9000_REGISTERS  0x0010 //Base address offset for registers.
#define WEITEK_P9000_VRAM       0x0020 //Base address offset for VRAM.
#define WEITEK_P9000_SYSCONFIG  0x0004 //Offset for config reg
#define WEITEK_P9000_INTERRUPT  0x0008 //Offset for interrupt reg
#define WEITEK_P9000_ENABLE     0x000c //Offset for interrupt enable reg
#define WEITEK_P9000_MEMCONFIG  0x0184 //Offset for memory config reg
#define WEITEK_P9000_REGLENGTH  0x2000 //Length for register addressability
/*            end   */

#define UNKNOWN_CHIP            0

#define VIDEO7_HT205_CHIP       1
#define VIDEO7_HT208_CHIP       2
#define VIDEO7_HT209_CHIP       3
#define MAX_VIDEO7_CHIP         VIDEO7_HT209_CHIP               /*          */

#define VIDEO7_HT205_NAME       "HT205"                         /*          */
#define VIDEO7_HT208_NAME       "HT208"                         /*          */
#define VIDEO7_HT209_NAME       "HT209"                         /*          */

#define TRIDENT_8800_CHIP       1
#define TRIDENT_8900_CHIP       2
#define MAX_TRIDENT_CHIP        TRIDENT_8900_CHIP               /*          */

#define TRIDENT_8800_NAME       "TR8800"                        /*          */
#define TRIDENT_8900_NAME       "TR8900"                        /*          */


#define TSENG_ET3000_CHIP       1
#define TSENG_ET4000_CHIP       2
#define TSENG_ET4000W32_CHIP    3    /* w32                             */
#define TSENG_ET4000W32I_CHIP   4    /* w32i (level a)                  */
#define TSENG_ET4000W32IB_CHIP  5    /* w32i level b                    */
#define TSENG_ET4000W32IC_CHIP  6    /* w32i level c                    */
#define TSENG_ET4000W32PA_CHIP  7    /* w32p level a                    */
#define TSENG_ET4000W32PB_CHIP  8    /* w32p level b                    */
#define TSENG_ET4000W32PC_CHIP  9    /* w32p level c                    */
#define TSENG_ET4000W32ID_CHIP 10    /* w32i level d                    */
#define TSENG_ET4000W32PD_CHIP 11    /* w32p level d                    */
#define TSENG_ET4000W32PX_CHIP 12    /* all others                      */
#define MAX_TSENG_CHIP         12

#define TSENG_ET3000_NAME       "ET3000"                        /*          */
#define TSENG_ET4000_NAME       "ET4000"                        /*          */
#define TSENG_ET4000W32_NAME    "ET4000W32"                     /*          */
#define TSENG_ET4000W32I_NAME   "ET4000W32IREVA"                /*          */
#define TSENG_ET4000W32IB_NAME  "ET4000W32IREVB"                /*          */
#define TSENG_ET4000W32IC_NAME  "ET4000W32IREVC"                /*          */
#define TSENG_ET4000W32PA_NAME  "ET4000W32PREVA"                /*          */
#define TSENG_ET4000W32PB_NAME  "ET4000W32PREVB"                /*          */
#define TSENG_ET4000W32PC_NAME  "ET4000W32PREVC"                /*          */
#define TSENG_ET4000W32ID_NAME  "ET4000W32IREVD"                /*          */
#define TSENG_ET4000W32PD_NAME  "ET4000W32PREVD"                /*          */
#define TSENG_ET4000W32PX_NAME  "ET4000W32PREVC_COMPATABLE"     /*          */

#define WESTERNDIG_PVGA1A_CHIP  1
#define WESTERNDIG_WD9000_CHIP  2 /* PVGA1B */
#define WESTERNDIG_WD9011_CHIP  3 /* PVGA1C */
#define WESTERNDIG_WD9030_CHIP  4 /* PVGA1D */
#define WESTERNDIG_WD9026_CHIP  5 /* PVGA1F */                  /*          */
#define WESTERNDIG_WD9027_CHIP  6                               /*          */
#define WESTERNDIG_WD9031_CHIP  7 /* PVGA1DW */                 /*          */
#define WESTERNDIG_WD9024_CHIP  8                               /*          */
#define WESTERNDIG_WD9033_CHIP  9 /* PVGA2DW */                 /*          */
#define MAX_WESTERNDIG_CHIP     WESTERNDIG_WD9033_CHIP          /*          */

#define WESTERNDIG_PVGA1A_NAME  "PVGA1A"                        /*          */
#define WESTERNDIG_WD9000_NAME  "PVGA1B"                        /*          */
#define WESTERNDIG_WD9011_NAME  "PVGA1C"                        /*          */
#define WESTERNDIG_WD9030_NAME  "PVGA1D"                        /*          */
#define WESTERNDIG_WD9026_NAME  "WD90C26"                       /*          */
#define WESTERNDIG_WD9027_NAME  "WD90C27"                       /*          */
#define WESTERNDIG_WD9031_NAME  "WD90C31"                       /*          */
#define WESTERNDIG_WD9024_NAME  "WD90C24"                       /*          */
#define WESTERNDIG_WD9033_NAME  "WD90C33"                       /*          */

#define ATI_18800_CHIP          1 /*VGAWONDER*/
#define ATI_28800_CHIP          2 /*VGAWONDER+/XL*/
#define ATI_38800_CHIP          3 /*MACH8/GraphicsUltra*/       /*          */
#define ATI_68800_CHIP          4 /*MACH32/GraphicsUltraPro*/   /*          */
#define ATI_88800_CHIP          5 /*MACH64*/                    /*          */
#define MAX_ATI_CHIP            ATI_88800_CHIP                  /*          */

#define ATI_18800_NAME          "ATI18800"                      /*          */
#define ATI_28800_NAME          "ATI28800"                      /*          */
#define ATI_38800_NAME          "ATI38800MACH8"                 /*          */
#define ATI_68800_NAME          "ATI68800MACH32"                /*          */
#define ATI_88800_NAME          "ATI88800MACH64"                /*          */

#define IBM_SVGA_CHIP           1
#define MAX_IBM_CHIP            IBM_SVGA_CHIP                   /*          */

#define IBM_SVGA_NAME           "IBMSVGA"                       /*          */

#define CIRRUS_5420_CHIP        1                               /*          */
#define CIRRUS_5422_CHIP        2
#define CIRRUS_5424_CHIP        3
#define CIRRUS_5426_CHIP        4
#define CIRRUS_5428_CHIP        5                               /*          */
#define CIRRUS_5429_CHIP        6                               /*          */
#define CIRRUS_543X_CHIP        7                               /*          */
#define CIRRUS_5434_CHIP        8                               /*          */
#define MAX_CIRRUS_CHIP         CIRRUS_5434_CHIP                /*          */

#define CIRRUS_5420_NAME        "GD5420"                        /*          */
#define CIRRUS_5422_NAME        "GD5422"                        /*          */
#define CIRRUS_5424_NAME        "GD5424"                        /*          */
#define CIRRUS_5426_NAME        "GD5426"                        /*          */
#define CIRRUS_5428_NAME        "GD5428"                        /*          */
#define CIRRUS_5429_NAME        "GD5429"                        /*          */
#define CIRRUS_543X_NAME        "GD543X"                        /*          */
#define CIRRUS_5434_NAME        "GD5434"                        /*          */

#define S3_86C805_CHIP          1           /* 801 or 805 */
#define S3_86C928_CHIP          2
#define S3_86C911_CHIP          3           /*            */
#define S3_86C864_CHIP          4                               /*          */
#define S3_86C964_CHIP          5                               /*          */
#define MAX_S3_CHIP             S3_86C964_CHIP                  /*          */

#define S3_86C805_NAME          "S386C80X"                      /*          */
#define S3_86C928_NAME          "S386C928"                      /*          */
#define S3_86C911_NAME          "S386C911"                      /*          */
#define S3_86C864_NAME          "S386C864"       /* VISION864 *//*          */
#define S3_86C964_NAME          "S386C964"       /* VISION964 *//*          */

#define CHIPS_FIRST_CHIP        1                /* bogus chip              */
#define MAX_CHIPS_CHIP          1                               /*          */

#define WEITEK_P9000_CHIP       1                               /*          */
#define WEITEK_W5186_CHIP       2                               /*          */
#define WEITEK_W5286_CHIP       3                               /*          */
#define WEITEK_P9100_CHIP       4                               /*          */
#define MAX_WEITEK_CHIP         WEITEK_P9100_CHIP               /*          */

#define WEITEK_P9000_NAME       "P9000"                         /*          */
#define WEITEK_W5186_NAME       "W5186"                         /*          */
#define WEITEK_W5286_NAME       "W5286"                         /*          */

/*
** OEM manufacturer defines.
*/

#define UNKNOWN_MANUFACTURER    0                               /*          */
#define DIAMOND_MANUFACTURER    1                               /*          */
#define ORCHID_MANUFACTURER     2                               /*          */
#define NUMBER9_MANUFACTURER    3                               /*          */
#define ARTIST_MANUFACTURER     4                               /*          */
#define LACUNA_MANUFACTURER     5                               /*          */
#define STB_MANUFACTURER        6                               /*          */
#define S3_MANUFACTURER         7                               /*          */
#define CIRRUS_MANUFACTURER     8
#define MIROCRYSTAL_MANUFACTURER   9                            /*          */
#define VIDEOLOGIC_MANUFACTURER    10                           /*          */
#define THINKPAD_MANUFACTURER    11                             /*@V3.0YEE02*/
#define MANUFACTURER_MAX        THINKPAD_MANUFACTURER           /*@V3.0YEE02*/
#define DEFAULT_MANUFACTURER    UNKNOWN_MANUFACTURER            /*          */
/* NOINC */
typedef struct _ADAPTERS {      /* adp */
  CHAR  *Name;
  CHAR  *Manufacturer;
  INT    ID;
}ADAPTERS;

typedef CHAR *CHIPNAMES;
typedef CHIPNAMES *PCHIPNAMES;

/*
 * define CHIPS_INCL to include the following definitions.
 */
#ifdef CHIPS_INCL
/*
** This table contains adapter ID's as not to depend on the changes to
** the ID's and their order. The ChipsetName table should be kept in sync
** with the Adapters table.
*/
ADAPTERS Adapters [SVGA_LASTADAPTER + 0x01] =          /*            */
{
  {"UNKNOWN","Unknown",                         UNKNOWN_ADAPTER},
  {"VIDEO7","Headland Technology, Inc.",        VIDEO7_ADAPTER},
  {"TRIDENT","Trident Microsystems, Inc.",      TRIDENT_ADAPTER},
  {"TSENG","Tseng Labs, Inc.",                  TSENG_ADAPTER},
  {"WESTERNDIGITAL","Western Digital Corporation",WESTERNDIG_ADAPTER},
  {"ATI","ATI Technologies Inc.",               ATI_ADAPTER},
  {"IBM","IBM Corporation",                     IBM_ADAPTER},
  {"CIRRUS","Cirrus Logic, Inc.",               CIRRUS_ADAPTER},
  {"S3","S3 Incorporated",                      S3_ADAPTER},
  {"CHIPS","Chips and Techologies",             CHIPS_ADAPTER},
  {"WEITEK","WEITEK Corporation",               WEITEK_ADAPTER},
  {"NUMBER9","Number Nine Corporation",         NUMBER9_ADAPTER},
  {"GENERICPCI","Unknown",                      GENERIC_PCISVGA_ADAPTER}
};
CHIPNAMES ppszUnknownChipNames [1] =
  {
    "UNKNOWN",
  };
CHIPNAMES ppszVideo7ChipNames [MAX_VIDEO7_CHIP] =               /*          */
  { /* Video 7==Headland Technology */                          /*          */
    VIDEO7_HT205_NAME,                                          /*          */
    VIDEO7_HT208_NAME,                                          /*          */
    VIDEO7_HT209_NAME,                                          /*          */
  };
CHIPNAMES ppszTridentChipNames [MAX_TRIDENT_CHIP] =             /*          */
  { /* Trident */                                               /*          */
    TRIDENT_8800_NAME,                                          /*          */
    TRIDENT_8900_NAME,                                          /*          */
  };
CHIPNAMES ppszTsengChipNames [MAX_TSENG_CHIP] =                 /*          */
  { /* Tseng */
    TSENG_ET3000_NAME,                                          /*          */
    TSENG_ET4000_NAME,
    TSENG_ET4000W32_NAME,
    TSENG_ET4000W32I_NAME,
    TSENG_ET4000W32IB_NAME,
    TSENG_ET4000W32IC_NAME,                                     /*          */
    TSENG_ET4000W32PA_NAME,                                     /*          */
    TSENG_ET4000W32PB_NAME,                                     /*          */
    TSENG_ET4000W32PC_NAME,                                     /*          */
    TSENG_ET4000W32ID_NAME,                                     /*          */
    TSENG_ET4000W32PD_NAME,                                     /*          */
    TSENG_ET4000W32PX_NAME,  /*JWK23*/
  };
CHIPNAMES ppszWDChipNames [MAX_WESTERNDIG_CHIP] =               /*          */
  { /* Western Digital */                                       /*          */
    WESTERNDIG_PVGA1A_NAME,                                     /*          */
    WESTERNDIG_WD9000_NAME,                                     /*          */
    WESTERNDIG_WD9011_NAME,                                     /*          */
    WESTERNDIG_WD9030_NAME,                                     /*          */
    WESTERNDIG_WD9026_NAME,                                     /*          */
    WESTERNDIG_WD9027_NAME,                                     /*          */
    WESTERNDIG_WD9031_NAME,                                     /*          */
    WESTERNDIG_WD9024_NAME,                                     /*          */
    WESTERNDIG_WD9033_NAME,                                     /*          */
  };
CHIPNAMES ppszATIChipNames [MAX_ATI_CHIP] =                     /*          */
  { /* ATI */                                                   /*          */
    ATI_18800_NAME,                                             /*          */
    ATI_28800_NAME,                                             /*          */
    ATI_38800_NAME,                                             /*          */
    ATI_68800_NAME,                                             /*          */
    ATI_88800_NAME,                                             /*          */
  };
CHIPNAMES ppszIBMChipNames [MAX_IBM_CHIP] =                     /*          */
  { /* IBM */                                                   /*          */
    IBM_SVGA_NAME,                                              /*          */
  };
CHIPNAMES ppszCirrusChipNames [MAX_CIRRUS_CHIP] =               /*          */
  { /* Cirrus Logic */                                          /*          */
    CIRRUS_5420_NAME,                                           /*          */
    CIRRUS_5422_NAME,
    CIRRUS_5424_NAME,
    CIRRUS_5426_NAME,
    CIRRUS_5428_NAME,                                           /*          */
    CIRRUS_5429_NAME,                                           /*          */
    CIRRUS_543X_NAME,                                           /*          */
    CIRRUS_5434_NAME,
  };
CHIPNAMES ppszS3ChipNames [MAX_S3_CHIP] =                       /*          */
  { /* S3 */                                                    /*          */
    S3_86C805_NAME,                                             /*          */
    S3_86C928_NAME,                                             /*          */
    S3_86C911_NAME,                                             /*          */
    S3_86C864_NAME,                                             /*          */
    S3_86C964_NAME,                                             /*          */
  };
CHIPNAMES ppszWeitekChipNames [MAX_WEITEK_CHIP] =               /*          */
  { /* Weitek */                                                /*          */
    WEITEK_P9000_NAME,                                          /*          */
    WEITEK_W5186_NAME,                                          /*          */
    WEITEK_W5286_NAME,                                          /*          */
  };
PCHIPNAMES ChipsetName [SVGA_LASTADAPTER + 0x01] =              /*          */
{
  ppszUnknownChipNames,                                         /*          */
  ppszVideo7ChipNames,                                          /*          */
  ppszTridentChipNames,                                         /*          */
  ppszTsengChipNames,                                           /*          */
  ppszWDChipNames,                                              /*          */
  ppszATIChipNames,                                             /*          */
  ppszIBMChipNames,                                             /*          */
  ppszCirrusChipNames,                                          /*          */
  ppszS3ChipNames,                                              /*          */
  ppszUnknownChipNames,                                         /*          */
  ppszWeitekChipNames,                                          /*          */
};
#endif
/* INC */

/*
** Mode flag values
** used in VIDEOMODEINFO
*/
#define MODE_FLAG_NOT_MONO      0x0001  /* Mono-compatible                  */
#define MODE_FLAG_GRAPHICS      0x0002  /* Text mode, Graphics              */
#define MODE_FLAG_NO_CLR_BRST   0x0004  /* Disable Color burst              */
#define MODE_FLAG_NATIVE        0x0008  /* Native (advanced function) mode  */
#define IGNORE_CLR_BRST         0x0010  /* Disable color burst doesn't make */
                                        /* sense for this mode              */
#define NOT_PLASMA              0x0020  /*            won't work on plasma  */
                                        /* display                          */
#define MODE_FLAG_VGA_ENTRY     0x0040  /* VGA mode, need clean up          */

/*
 * definitions of bus type
 */
#define ISA_BUS    0
#define VLB_BUS    1
#define PCI_BUS    2
#define EISA_BUS   3
#define PCMCIA_BUS 4
#define MCA_BUS    5

/*
* endian type
*/
#define LITTLE_ENDIAN  0
#define BIG_ENDIAN     1


/*
** VIDEOPMI.DLL prototypes.
*/
/* NOINC */
#define HVIDEO   PVOID
typedef HVIDEO  *PHVIDEO;

#ifndef APIENTRY
#define APIENTRY /* nothing */
#endif

#ifndef APIRET
#define APIRET ULONG
#endif

/*
** Structures passed as input and output parameters.
*/

typedef struct _VIDEOMODEINFO { /* vmi */
#ifdef DEVELOP
        ULONG   cb;                     /* size of the structure            */
#endif
        MODEID  miModeId;               /* used to make setmode request     */
        USHORT  usType;                 /* mode type bits                   */
        USHORT  usInt10ModeSet;         /* int 10 mode                      */
        USHORT  usXResolution;          /* horizontal pels                  */
        USHORT  usYResolution;          /* vertical scan lines              */
        ULONG   ulBufferAddress;        /* physical address of VRAM         */
        ULONG   ulApertureSize;         /* VRAM aperture                    */
        BYTE    bBitsPerPixel;          /* no of colors                     */
        BYTE    bBitPlanes;             /* number of planes                 */
        BYTE    bXCharSize;             /* font width                       */
        BYTE    bYCharSize;             /* font height                      */
        USHORT  usBytesPerScanLine;     /* logical line length in bytes     */
        USHORT  usTextRows;             /* text rows                        */
        ULONG   ulPageLength;           /* no of bytes to save a plane      */
        ULONG   ulSaveSize;             /* total bytes of VRAM to save      */
        /*
         * Monitor Info
         */
        BYTE    bVrtRefresh;
        BYTE    bHrtRefresh;
        BYTE    bVrtPolPos;
        BYTE    bHrtPolPos;
        USHORT  usScrnTop;
        USHORT  usScrnBottom;
        USHORT  usScrnLeft;
        USHORT  usScrnRight;

        CHAR    szColorFormat[8];       /* for true color or hi-color modes */
        CHAR    szColorWeight[8];       /* for true color or hi-color modes */

} VIDEOMODEINFO;
typedef VIDEOMODEINFO FAR *PVIDEOMODEINFO;

typedef struct _SVGARGB { /* rgb */
        BYTE    bR;
        BYTE    bG;
        BYTE    bB;
        BYTE    bUnused;
} SVGARGB;
typedef SVGARGB FAR *PSVGARGB;

typedef struct _CLUTDATA { /* clt */
        ULONG   ulRGBCount;             /* No of aRGB entries that follow   */
        ULONG   ulRGBStart;             /* Start index for RGB triplets     */
        SVGARGB aRGB[1];                /* One defined, ulRGBCount entries  */
} CLUTDATA;
typedef CLUTDATA FAR *PCLUTDATA;

typedef struct _PALETTEDATA { /* pal */
        ULONG   ulPalCount;             /* No of bPal.. entries that follow */
        ULONG   ulPalStart;             /* Start index for data             */
        BYTE    bPaletteData[1];        /* One defined, ulPalCount entries  */
} PALETTEDATA;
typedef PALETTEDATA FAR *PPALETTEDATA;

typedef struct _FONTDATA { /* font */
        ULONG   ulCharCount;            /* No of chars in font              */
        ULONG   ulFontHeight;           /* No of scanlines per character    */
        ULONG   ulFontWidth;            /* No of columns per character      */
        BYTE    bFontData[1];           /* ulCharCount*ulFontHeight entries */
} FONTDATA;
typedef FONTDATA FAR *PFONTDATA;

typedef BYTE FAR *PVRAMDATA;

typedef struct _CLEANDATA { /* clean */
    USHORT  Command;
    USHORT  IndexPort;
    USHORT  DataPort;
    USHORT  Index;
    USHORT  ANDMask;
    USHORT  ORMask;
} CLEANDATA;

typedef struct _BANKDATA { /* bank */
        MODEID  miBank;                 /*                                  */
        ULONG   ulBank;                 /*                                  */
} BANKDATA;
typedef BANKDATA FAR *PBANKDATA;

#define MAX_OEM_STRING  128
#define MAX_DAC_STRING  128
#define MAX_VERSION     128

typedef struct _ADAPTERINFO {   /* adi */
        ULONG       ulAdapterID;
        CHAR        szOEMString[MAX_OEM_STRING];    /* adapter info from Hardware section */
        CHAR        szDACString[MAX_DAC_STRING];    /* DAC info from Hardware section */
        CHAR        szRevision[MAX_VERSION];        /* whatever the revision  means   */
        ULONG       ulTotalMemory;
        ULONG       ulMMIOBaseAddress;
        ULONG       ulPIOBaseAddress;
        BYTE        bBusType;
        BYTE        bEndian;
        USHORT      usDeviceBusID;       /* has to be 2 bytes */
        USHORT      usVendorBusID;       /* has to be 2 bytes */
        USHORT      SlotID;              /* has to be 2 bytes */
} ADAPTERINFO, FAR *PADAPTERINFO;

/*
 * Adapter Instance definition. The structure will be passed in every
 * PMIREQUEST call.
 */
typedef struct _VIDEO_ADAPTER { /* va */
     HVIDEO          hvideo;
     ADAPTERINFO     Adapter;
     VIDEOMODEINFO   ModeInfo;
} VIDEO_ADAPTER, FAR *PVIDEO_ADAPTER;

/*
 * prototype for import functions in PMI file
 */
typedef ULONG   *PREGS;     //pointer to registers. Passed to imported PMI functions.
typedef APIRET (EXPENTRY FNIMPORTPMI)(PVIDEO_ADAPTER, PREGS);
typedef FNIMPORTPMI *PFNIMPORTPMI;

#ifdef INCL_16
   #define VIDEOAPI FAR     //this controls the calling convention.
#else                           // 32-bit code
   #define VIDEOAPI EXPENTRY       //C calling convention
#endif

/*
** prototype for VIDEOPMI request functions
*/
typedef APIRET (VIDEOAPI FNVIDEOPMIREQUEST)(PVIDEO_ADAPTER, ULONG, PVOID, PVOID);

typedef FNVIDEOPMIREQUEST     *PFNVIDEOPMIREQUEST;
                                         /* used to exchange data with vvid */
typedef struct _VDDDATA {    /* vdd */
        PFNVIDEOPMIREQUEST       npfnEntryPointAddress;
        HVIDEO                   hvideo;
} VDDDATA;
typedef VDDDATA *PVDDATA;
/* INC */
/*
** Save Restore constants
*/

#define STATEFLAG_REGISTERS     0x0001  /*                                  */
#define STATEFLAG_CLUT          0x0002  /*                                  */
#define STATEFLAG_VRAM          0x0004  /*                                  */
#define STATEFLAG_FONT          0x0008  /*                                  */

/* NOINC */
typedef struct _VIDEOSTATE { /* vst */
#ifdef DEVELOP
        ULONG     cb;                   /* size of the structure            */
#endif
        ULONG     fStateFlags;          /*                                  */
        MODEID    miState;              /*                                  */
        PVOID     pModeData;            /*                                  */
        ULONG     ulVRAMSaveSize;       /* No of bytes/page to save         */
        PVRAMDATA pVRAM;                /*                                  */
        PCLUTDATA pCLUT;                /*                                  */
        PFONTDATA pFont;                /*                                  */
} VIDEOSTATE;
typedef VIDEOSTATE FAR *PVIDEOSTATE;
/* INC */

/*
** Function request parameters supported.
*/

#define PMIREQUEST_SETMODE                 0
#define PMIREQUEST_LOCKREGISTERS           1
#define PMIREQUEST_UNLOCKREGISTERS         2
#define PMIREQUEST_CLEANUP                 3
#define PMIREQUEST_SAVESTATE               4
#define PMIREQUEST_RESTORESTATE            5
#define PMIREQUEST_GETBANK                 6
#define PMIREQUEST_SETBANK                 7
#define PMIREQUEST_GETCLUT                 8
#define PMIREQUEST_SETCLUT                 9
#define PMIREQUEST_GETPALETTE             10
#define PMIREQUEST_SETPALETTE             11
#define PMIREQUEST_GETFONT                12
#define PMIREQUEST_SETFONT                13
#define PMIREQUEST_TUNEDISPLAY            14        /*            */
#define PMIREQUEST_QUERYMAXMODEENTRIES    15
#define PMIREQUEST_QUERYMAXMODELISTSIZE   16
#define PMIREQUEST_QUERYMODEINFODATA      17
#define PMIREQUEST_QUERYMAXTRAPENTRIES    18
#define PMIREQUEST_QUERYTRAPLISTDATA      19
#define PMIREQUEST_QUERYMODEHRDWRLIST     20        /*            */
#define PMIREQUEST_LOADPMIFILE            21
#define PMIREQUEST_IDENTIFYADAPTER        22

#define PMIREQUEST_MAX (PMIREQUEST_IDENTIFYADAPTER + 1) /* last entry + 1 */

/* NOINC */

/*
 * define PMIDEF_INCL to include the following definitions.
 */
#ifdef PMIDEF_INCL

/*           
** Possible flags in ModeAtrributes field in PMI file
** the flags will be saved in ModeInfo.ulType
*/
#define  PMI_MODE_COLOUR          0x08        /* Bit 3 - 0 = mono, 1 = colour */
#define  PMI_MODE_GRAPHICS        0x10      /* Bit 4 - 0 = text, 1 = graphics */
#define  PMI_MODE_VGA_ENTRY       0x20/* vga entry, need clean up in set mode */
#define  PMI_MODE_IGNORE_CLR_BRST 0x40 /* won't work on B/W mode              */
#define  PMI_MODE_NOT_PLASMA      0x80 /* won't work on planar display        */

/*
 * PMI commands
 */
#define PMICMD_NONE             0xFF            //reserved
#define PMICMD_INB              0
#define PMICMD_OUTB             1
#define PMICMD_INW              2
#define PMICMD_OUTW             3
#define PMICMD_INDW             4
#define PMICMD_OUTDW            5
#define PMICMD_BINB             6
#define PMICMD_BOUTB            7
#define PMICMD_ABOUTW           8
#define PMICMD_ABOUTDW          9
#define PMICMD_RMWBN           10
#define PMICMD_RMWBI           11
#define PMICMD_RMWWN           12
#define PMICMD_REGOP           13
#define PMICMD_ASSIGN          14
/***************** for backward compatibility ***************/
#define PMICMD_WAIT            15
#define PMI_WAIT_CLEAR          0       /* Wait for CLEAR condition         */
/***************** for backward compatibility ***************/
#define PMICMD_WAITB           16
#define PMICMD_WAITW           17
#define PMICMD_WAITDW          18
#define PMICMD_READB           19               /*                     */
#define PMICMD_READW           20               /* Don't rearrange the */
#define PMICMD_READDW          21               /* order or put        */
#define PMICMD_WRITEB          22               /* anything in between */
#define PMICMD_WRITEW          23               /* for these MMIO      */
#define PMICMD_WRITEDW         24               /* commands            */
#define PMICMD_ROUTINE         25               /*                     */
#define PMICMD_LABEL           26
#define PMICMD_WHILE           27
#define PMICMD_ENDWHILE        28
#define PMICMD_IF              29
#define PMICMD_GOTO            30
#define PMICMD_STRCMP          31
#define PMICMD_MEMCMP          32
#define PMICMD_CALL            33
#define PMICMD_MAX             PMICMD_CALL  /* equals last entry   */


#define PMI_REGOP_ASSIGN          0     /* Rxxx  = <value>                  */
#define PMI_REGOP_AND             1     /* Rxxx &= <value>                  */
#define PMI_REGOP_OR              2     /* Rxxx |= <value>                  */
#define PMI_REGOP_XOR             3     /* Rxxx ^= <value>                  */
#define PMI_REGOP_PLUS            4     /* Rxxx += <value>                  */
#define PMI_REGOP_MINUS           5     /* Rxxx -= <value>                  */
#define PMI_REGOP_SHL             6     /* Rxxx <= <value>                  */
#define PMI_REGOP_SHR             7     /* Rxxx >= <value>                  */
#define PMI_REGOP_LESS            8     /* Rxx < Rxyy                       */
#define PMI_REGOP_LESS_EQUALS     9     /* Rxx <= Ryy                       */
#define PMI_REGOP_GREATER         10    /* Rxx > Rxyy                       */
#define PMI_REGOP_GREATER_EQUALS  11    /* Rxx >= Ryy                       */
#define PMI_REGOP_EQUALS          12    /* Rxx == Ryy                       */
#define PMI_REGOP_NOT_EQUALS      13    /* Rxx != Ryy                       */
#define PMI_REGOP_MAX  PMI_REGOP_NOT_EQUALS /* must equal last entry        */

/*
**      Type Definitions
**
**      Tokens are grouped, and must be kept that way.
**      There are dummy tokens, place holders, TOK_??_BEGIN and TOK_??_END
**      to make tests and expansion easier. Just be sure to keep token
**      info for a given section, within these bounds.
*/

typedef enum _PMITOKEN {        /* pt */
     TOK_SECT_BEGIN,
/***************** for backward compatibility ***************/
     TOK_ADAPTERTYPE,           /* Section Heading tokens */
     TOK_CHIPSET,
/***************** for backward compatibility ***************/
     TOK_PMIVERSION,           /* Section Heading tokens */
     TOK_COMMENT,
     TOK_MODEINFO,
     TOK_SETMODE,
     TOK_MONITORMODEINFO,
     TOK_TRAPREGS,
     TOK_UNLOCK,
     TOK_LOCK,
     TOK_CLEANUP,
     TOK_SETBANK,
     TOK_GETBANK,
     TOK_DECLARATIONS,
     TOK_COPYVRAM,
     TOK_TUNEDISPLAY,
     TOK_HARDWARE,
     TOK_IDENTIFYADAPTER,
     TOK_ISENGINEBUSY,
     TOK_ENABLECONTROLLER,
     TOK_DISABLECONTROLLER,
     TOK_SETMONITORTIMINGS,
     TOK_ROUTINE_DECLR,             /*            */
     TOK_INCLUDE,                   /* text include */
     TOK_INCLUDECODE,               /* DLL include  */
     TOK_SECT_END,

     TOK_MI_BEGIN,
     TOK_MODEATTRIBUTES,        /* ModeInfo Section tokens */
     TOK_INT10MODESET,          /*            int 10 mode */
     TOK_BYTESPERSCANLINE,
     TOK_TEXTROWS,              /* [ModeInfo] and [Hardware] tokens       */
     TOK_XRESOLUTION,           /* are PMI keyvariables. Do remember      */
     TOK_YRESOLUTION,           /* update the PMIKeyVarTable[] and        */
     TOK_XCHARSIZE,             /* PMI Keyvariable defines in header file */
     TOK_YCHARSIZE,
     TOK_BITSPERPIXEL,
     TOK_NUMBEROFPLANES,
     TOK_PAGELENGTH,
     TOK_SAVESIZE,
     TOK_BUFFERADDRESS,
     TOK_APERTURESIZE,
     TOK_COLORFORMAT,
     TOK_COLORWEIGHT,
     TOK_VERTICALREFRESH,
     TOK_HORIZONTALREFRESH,
     TOK_VPOLARITYPOSITIVE,
     TOK_HPOLARITYPOSITIVE,
     TOK_SCREENLEFTEDGE,
     TOK_SCREENRIGHTEDGE,
     TOK_SCREENTOPEDGE,
     TOK_SCREENBOTTOMEDGE,
/***************** for backward compatibility ***************/
     TOK_INTERLACEMODE,
/***************** for backward compatibility ***************/
     TOK_MI_END,

     TOK_HARDWARE_BEGIN,      /*            Hardware Section */
     TOK_BUSTYPE,
     TOK_OEMSTRING,
     TOK_DACSTRING,
     TOK_VERSION,
     TOK_TOTALMEMORY,
     TOK_MEMORYIOADDRESS,
     TOK_PORTIOADDRESS,
     TOK_ENDIAN,
     TOK_HARDWARE_END,

     TOK_TRAP_BEGIN,
     TOK_BYTE_IOPORT,             /*             trap registers type */
     TOK_WORD_IOPORT,
     TOK_DWORD_IOPORT,
     TOK_BYTE_MMIOPORT,
     TOK_WORD_MMIOPORT,
     TOK_DWORD_MMIOPORT,
     TOK_RESET,
     TOK_INDEX,
     TOK_INDEXMASK,
     TOK_DATAMASK,
     TOK_ACCEL,
     TOK_RO,
     TOK_WO,
     TOK_RW,
     TOK_TRAP_END,

     TOK_SM_BEGIN,
     TOK_INB,                /* Command Section tokens */
     TOK_OUTB,
     TOK_INW,
     TOK_INDW,
     TOK_OUTW,
     TOK_OUTDW,
     TOK_BINB,
     TOK_BOUTB,
     TOK_RMWBI,
     TOK_RMWBN,
     TOK_RMWWN,
     TOK_ABOUTW,
     TOK_ABOUTDW,
     TOK_IF,
     TOK_GOTO,
     TOK_VARIABLE,
     TOK_WHILE,
     TOK_ENDWHILE,
     TOK_MEMCMP,
     TOK_STRCMP,
     TOK_READB,         /*                     */
     TOK_READW,         /* Don't rearrange the */
     TOK_READDW,        /* order or put        */
     TOK_WRITEB,        /* anything in between */
     TOK_WRITEW,        /* for these MMIO      */
     TOK_WRITEDW,       /* commands            */
     TOK_CALL,
     TOK_ROUTINE,
/***************** for backward compatibility ***************/
     TOK_WAIT,
/***************** for backward compatibility ***************/
     TOK_WAITB,
     TOK_WAITW,
     TOK_WAITDW,
     TOK_VALUE,
     TOK_PMIREG,
     TOK_LPAREN,
     TOK_RPAREN,
     TOK_LBRACE,
     TOK_RBRACE,
     TOK_EQUALS,
     TOK_NOTEQUALS,
     TOK_SEMICOLON,
     TOK_COMMA,
     TOK_COLON,
     TOK_MINUS,
     TOK_HYPHEN = TOK_MINUS,
     TOK_NEGATE,         /*            */
     TOK_DOUBLEQUOTE,
     TOK_PLUS,
     TOK_REGOP_AND,
     TOK_REGOP_OR,
     TOK_REGOP_XOR,
     TOK_REGOP_SHL,
     TOK_LESS = TOK_REGOP_SHL,  /*            */
     TOK_REGOP_SHR,
     TOK_SM_END,

     TOK_EOF,
     TOK_IOPORT,
     TOK_MMIO,
     TOK_PIO,
     TOK_ISA,
     TOK_VLB,
     TOK_PCI,
     TOK_EISA,
     TOK_PCMCIA,
     TOK_MCA,
     TOK_BIG_ENDIAN,
     TOK_LITTLE_ENDIAN,
     TOK_QUOTEDSTRING,
     TOK_MMIO_REG_NAME,
     TOK_IOPORT_NAME,
     TOK_PMI_KEYVAR,
     TOK_SHADOWVRAM,
     TOK_ERROR,                /* error */
     TOK_PASS
} PMITOKEN;

typedef struct _TOK { /* tok */
  CHAR *tok_txt;
  PMITOKEN tok_val;
} TOK;

/*
 * definitions of bus types.
 */
#define ISA_BUS    0           /*            */
#define VLB_BUS    1
#define PCI_BUS    2
#define EISA_BUS   3
#define PCMCIA_BUS 4
#define MCA_BUS    5
#define BUS_MAX MCA_BUS

#endif /* PMIDEF_INCL */

/*
 * PMI token declarations
 * PMI_TOKEN_ARRAY should be defined to include the following array.
 * In this way, this array will not be allocated for every C file.
 */
#ifdef PMI_TOKEN_ARRAY

TOK Tokens[] =
{

/***************** for backward compatibility ***************/
  "[ADAPTERTYPE]",      TOK_ADAPTERTYPE,
  "[CHIPSET]",          TOK_CHIPSET,
/***************** for backward compatibility ***************/
  "[PMIVERSION]",       TOK_PMIVERSION,
  "[COMMENT]",          TOK_COMMENT,
  "[MODEINFO]",         TOK_MODEINFO,
  "[SETMODE]",          TOK_SETMODE,
  "[MONITORMODEINFO]",  TOK_MONITORMODEINFO,
  "[TRAPREGS]",         TOK_TRAPREGS,
  "[UNLOCK]",           TOK_UNLOCK,
  "[LOCK]",             TOK_LOCK,
  "[CLEANUP]",          TOK_CLEANUP,
  "[SETBANK]",          TOK_SETBANK,
  "[GETBANK]",          TOK_GETBANK,
  "[DECLARATIONS]",     TOK_DECLARATIONS,
  "[COPYVRAM]",         TOK_COPYVRAM,
  "[TUNEDISPLAY]",      TOK_TUNEDISPLAY,
  "[HARDWARE]",         TOK_HARDWARE,
  "[IDENTIFYADAPTER]",  TOK_IDENTIFYADAPTER,
  "[ISENGINEBUSY]",     TOK_ISENGINEBUSY,
  "[ENABLECONTROLLER]", TOK_ENABLECONTROLLER,
  "[DISABLECONTROLLER]",TOK_DISABLECONTROLLER,
  "[SETMONITORTIMINGS]",TOK_SETMONITORTIMINGS,
  "INCLUDE",            TOK_INCLUDE,                   /* text include */
  "INCLUDECODE",        TOK_INCLUDECODE,               /* DLL include  */
  /*
   * Hardware Section
   */
  "BUSTYPE",            TOK_BUSTYPE,
  "OEMSTRING",          TOK_OEMSTRING,
  "DACSTRING",          TOK_DACSTRING,
  "VERSION",            TOK_VERSION,
  "TOTALMEMORY",        TOK_TOTALMEMORY,
  "MEMORYIOADDRESS",    TOK_MEMORYIOADDRESS,
  "PORTIOADDRESS",      TOK_PORTIOADDRESS,
  "ENDIAN",             TOK_ENDIAN,
  /*
   * TrapRegs Section
   */
  "BYTE_IOPORT",        TOK_BYTE_IOPORT,
  "WORD_IOPORT",        TOK_WORD_IOPORT,
  "DWORD_IOPORT",       TOK_DWORD_IOPORT,
  "BYTE_MMIOPORT",      TOK_BYTE_MMIOPORT,
  "WORD_MMIOPORT",      TOK_WORD_MMIOPORT,
  "DWORD_MMIOPORT",     TOK_DWORD_MMIOPORT,
  "RESET",              TOK_RESET,
  "INDEX",              TOK_INDEX,
  "INDEXMASK",          TOK_INDEXMASK,
  "DATAMASK",           TOK_DATAMASK,
  "ACCEL",              TOK_ACCEL,
  "RO",                 TOK_RO,
  "WO",                 TOK_WO,
  "RW",                 TOK_RW,
  /*
   * ModeInfo Section
   */
  "INT10MODESET",       TOK_INT10MODESET,
  "MODEATTRIBUTES",     TOK_MODEATTRIBUTES,
  "BYTESPERSCANLINE",   TOK_BYTESPERSCANLINE,
  "TEXTROWS",           TOK_TEXTROWS,
  "XRESOLUTION",        TOK_XRESOLUTION,
  "YRESOLUTION",        TOK_YRESOLUTION,
  "XCHARSIZE",          TOK_XCHARSIZE,
  "YCHARSIZE",          TOK_YCHARSIZE,
  "BITSPERPIXEL",       TOK_BITSPERPIXEL,
  "NUMBEROFPLANES",     TOK_NUMBEROFPLANES,
  "PAGELENGTH",         TOK_PAGELENGTH,
  "SAVESIZE",           TOK_SAVESIZE,
  "BUFFERADDRESS",      TOK_BUFFERADDRESS,
  "APERTURESIZE",       TOK_APERTURESIZE,
  "COLORFORMAT",        TOK_COLORFORMAT,
  "COLORWEIGHT",        TOK_COLORWEIGHT,
/***************** for backward compatibility ***************/
  "INTERLACEMODE",      TOK_INTERLACEMODE,
/***************** for backward compatibility ***************/
  "VERTICALREFRESH",    TOK_VERTICALREFRESH,
  "HORIZONTALREFRESH",  TOK_HORIZONTALREFRESH,
  "VPOLARITYPOSITIVE",  TOK_VPOLARITYPOSITIVE,
  "HPOLARITYPOSITIVE",  TOK_HPOLARITYPOSITIVE,
  "SCREENLEFTEDGE",     TOK_SCREENLEFTEDGE,
  "SCREENRIGHTEDGE",    TOK_SCREENRIGHTEDGE,
  "SCREENTOPEDGE",      TOK_SCREENTOPEDGE,
  "SCREENBOTTOMEDGE",   TOK_SCREENBOTTOMEDGE,
  /*
   * PMI Commands
   */
  "INB",                TOK_INB,
  "OUTB",               TOK_OUTB,
  "INW",                TOK_INW,
  "OUTW",               TOK_OUTW,
  "INDW",               TOK_INDW,
  "OUTDW",              TOK_OUTDW,
  "BINB",               TOK_BINB,
  "BOUTB",              TOK_BOUTB,
  "RMWBI",              TOK_RMWBI,
  "RMWBN",              TOK_RMWBN,
/***************** for backward compatibility ***************/
  "RMWB",               TOK_RMWBI,
  "RMWW",               TOK_RMWBN,
/***************** for backward compatibility ***************/
  "RMWWN",               TOK_RMWWN,
  "ABOUTW",             TOK_ABOUTW,
  "ABOUTDW",            TOK_ABOUTDW,
  "IF",                 TOK_IF,
  "GOTO",               TOK_GOTO,
  "WHILE",              TOK_WHILE,
  "ENDWHILE",           TOK_ENDWHILE,
  "MEMCMP",             TOK_MEMCMP,
  "STRCMP",             TOK_STRCMP,
  "READB",              TOK_READB,      /*                     */
  "READW",              TOK_READW,      /* Don't rearrange the */
  "READDW",             TOK_READDW,     /* order or put        */
  "WRITEB",             TOK_WRITEB,     /* anything in between */
  "WRITEW",             TOK_WRITEW,     /* for these MMIO      */
  "WRITEDW",            TOK_WRITEDW,    /* commands            */
  "CALL",               TOK_CALL,
/***************** for backward compatibility ***************/
  "WAIT",               TOK_WAIT,
/***************** for backward compatibility ***************/
  "WAITB",              TOK_WAITB,
  "WAITW",              TOK_WAITW,
  "WAITDW",             TOK_WAITDW,
  /*
   * others
   */
  "MMIO",               TOK_MMIO,    /* used in [Declarations]  */
/***************** for backward compatibility ***************/
  "P",                  TOK_MMIO,    /* used in [Declarations]  */
/***************** for backward compatibility ***************/
  "PIO",                TOK_PIO,     /*                         */
  "ISA",                TOK_ISA,
  "VLB",                TOK_VLB,
  "PCI",                TOK_PCI,
  "EISA",               TOK_EISA,
  "PCMCIA",             TOK_PCMCIA,
  "MCA",                TOK_MCA,
  "SHADOWVRAM",         TOK_SHADOWVRAM,
  "BIG",                TOK_BIG_ENDIAN,
  "LITTLE",             TOK_LITTLE_ENDIAN

} ;

extern TOK Tokens[];

#endif  /* PMI_TOKEN_ARRAY */

/*
** PMI subsystem errors
*/
#define ERROR_ADAPTER_NOT_SUPPORTED          ERROR_USER_DEFINED_BASE+0x10
#define ERROR_REFRESH_NOT_SUPPORTED          ERROR_USER_DEFINED_BASE+0x11
#define ERROR_MODE_NOT_SUPPORTED             ERROR_USER_DEFINED_BASE+0x12
#define ERROR_REQ_SECTION_UNDEFINED          ERROR_USER_DEFINED_BASE+0x13
#define ERROR_PMI_FILE_SYNTAX                ERROR_USER_DEFINED_BASE+0x14
#define ERROR_NO_MONITOR_SUPPORT             ERROR_USER_DEFINED_BASE+0x15
#define ERROR_INVALID_CONFIGURATION          ERROR_USER_DEFINED_BASE+0x16
/*
** DIF subsystem defines
*/
typedef struct _MONMODEINFO { /* mmi */
        USHORT            usXResolution;
        USHORT            usYResolution;
        BYTE              bVertRefresh;
        BYTE              bHorizRefresh;
        BYTE              bVPolarityPos;
        BYTE              bHPolarityPos;
} MONMODEINFO;
#define MAX_PATH_NAME  256
#define MAX_MONITOR_LEN   128   /* length of name string */
#define MAX_MONITOR_MODES 10    /* up to 10 modes per monitor */
typedef struct _MonInfo { /* mi */
        CHAR             szMonitor[MAX_MONITOR_LEN];
        MONMODEINFO      ModeInfo[MAX_MONITOR_MODES];
} MONITORINFO, FAR *PMONITORINFO;

#define   DIF_SERVICE_DLL_NAME           "VIDEOCFG"
/*
** Functions exported by VIDEOCFG.DLL.
*/

/* Begin                                                               */
/* These functions are exported only to PM aware apps. Include PMWIN.H */
#ifdef MRESULT
BOOL EXPENTRY QueryScreenPageData(PHMODULE phmodResourceMRI,
                                  PUSHORT  pusDlgId,
                                  PSZ      pszName,
                                  PUSHORT  pusHelpId,
                                  PSZ      pszDlgProcName,
                                  BOOL     bPaletteManagedDisplay);
BOOL EXPENTRY QueryDisplayTypePageData(PHMODULE phmodResourceMRI,
                                       PUSHORT  pusDlgId,
                                       PSZ      pszName,
                                       PUSHORT  pusHelpId,
                                       PSZ      pszDlgProcName);
MRESULT EXPENTRY ScreenDlgProc(HWND hwndDlg, USHORT msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY DIF_DisplayTypeDlgProc(HWND hwndDlg, USHORT msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY DMQS_DisplayTypeDlgProc(HWND hwndDlg, USHORT msg, MPARAM mp1, MPARAM mp2);
#endif
/* End            */

APIRET EXPENTRY QueryNumMonitors(ULONG *pulNumMonitors);
APIRET EXPENTRY GetAllMonitors(MONITORINFO *pMonitors);
APIRET EXPENTRY AddMonitorData(MONITORINFO *pNewMonitor);
APIRET EXPENTRY GetCurrentCfg(ADAPTERINFO *pAdapter,MONITORINFO *pMonitor);
APIRET EXPENTRY SetCurrentCfg(ADAPTERINFO *pAdapter,MONITORINFO *pMonitor);
/*
** 16 entry point into the VIDEOCFG.DLL
*/
APIRET VIDEOAPI VCFG16Request(PVOID pIn,ULONG function,PVOID pOut1,PVOID pOut2);
typedef APIRET (VIDEOAPI  FNCFG16REQUEST)(PVOID, ULONG, PVOID, PVOID);
typedef FNCFG16REQUEST *PFNCFG16REQUEST;
/*
** functions exported to 16 bit
*/
#define VCFG_GET_CURRENT_CONFIG 0       //pIn = NULL, pOut1 = pAdapter, pOut2 = pMonitor
#define   SVGA_DATAFNAME  "svgadata.pmi"
#define   VIDEO_CFGFNAME  "video.cfg"
#define   MONITOR_FNAME   "monitor.dif"
/* INC */

#ifndef INCL_DOSDEVIOCTL                //@senja: bsedev.h can't be used by vvid
#ifndef BSEDEV_INCLUDED                 //don't define if bsedev already included
#define SCREENDD_SVGA_ID                0x08    /* Get SVGA info IOCTL */
#define SCREENDD_SVGA_OEM               0x09    /* Get OEM info IOCTL */
#define SCREENDD_CATEGORY               0x80
#define SCREENDD_NAME                   "SCREEN$"
                                           /* SCREENDD_SVGA_ID */
typedef struct _OEMSVGAINFO { /* */
        USHORT AdapterType;
        USHORT ChipType;
        ULONG  Memory;
} OEMSVGAINFO;
                                           /* SCREENDD_SVGA_OEM */
typedef struct _OEMINFO {    /* */
        ULONG  OEMLength;
        USHORT Manufacturer;
        ULONG  ManufacturerData;
} OEMINFO;
#endif
#endif
