/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/***    propname.h - property names for language translation
 *
 *      SCCSID = @(#)propname.h 6.23 92/01/22
 *
 *
 *
 *
 *
 *      Modification History:
 *      ---------------------
 *      25-Nov-1989 wayneca    Initial version.
 *
 *      07-May-1991 Richard Wooley
 *
 *                  Changed all occurences of the single line comment
 *                  notation to the standard notation to allow users to
 *                  maintain ANSI compatibility.  This is in response to
 *                  PTR B718526.  All future updates to this and all other
 *                  header files should use the standard commenting format.
 *
 *      06-13-91   ;BN003; HARE  Added LASTDRIVE advanced properties
 *      06-27-91   Bill Madden   Added DPMI advanced property      BN004
 *      08-05-91   Mary Nolterieke, Information Development.
 *                 Edited property names for consistency.
 *      09-18-91   Bill Madden   Changed DPX and DPMI advanced properties
 *      09-22-91   Kip Harris    Implemented DCR cp20 1532, specifies that
 *                 property names and enumerated text values should not be
 *                 represented as national langauage MRI, but instead rep-
 *                 resented as strings that look like environment variables.
 *      01-16-92   J. Hlavaty    Added DPX_NETBUFFSIZE
 *      01-22-92   Jeff Muir     Added DOS_BACKGROUND_EXECUTION
 *      01-18-94   J. Tran       Added VDM_PRIORITY   - 77667
 *      06-16-94   J. Tran       Changed VDM_PRIORITY to SESSION_PRIORITY - 85737
*/
/*
;***********************************************************************;BN001;
; 14Jul92 - Jeff Muir                                                   ;BN001;
; Added INT_DURING_IO property                                          ;BN001;
;***********************************************************************;BN001;
; 18Jul92 - Y.Nishida                                                   ;BN002;
; Added COM_SELECT property                                             ;BN002;
;***********************************************************************;BN002;
; ?????92 - ?                                                           ;BN003;
; Add DDE and CLIPBOARD                                                 ;BN003;
;***********************************************************************;BN003;
; ?????92 - ?                                                           ;BN004;
; Add         3.1 support                                               ;BN004;
;***********************************************************************;BN004;
; 21Aug92 - G.L.Fulk                                                    ;BN005;
; Add Multi-Autoexec support                                            ;BN005;
;***********************************************************************;BN005;
; 04Dec92 - TPL                                                         ;BN006;
;         3.1 changes (58090)                                           ;BN006;
;***********************************************************************;BN006;
; 01Feb93 - S. A. Barnes                                                ;BN007;
; Added PRINT_SEPARATE_OUTPUT (58213)                                   ;BN007;
;***********************************************************************;BN007;
; 02Mar93 - TPL                                                         ;BN008;
; Change I/O Trap setting (63263)                                       ;BN008;
;***********************************************************************;BN008;
; 19Mar93 - B. J. Thompson                                              ;BN009;
; Add AUDIO_ADAPTER_SHARING                                             ;BN009;
;***********************************************************************;BN009;
; 25Mar93 - TPL                                                         ;BN010;
; Change I/O Trap BACK!!! (64862)                                       ;BN010;
;***********************************************************************;BN010;
;***********************************************************************;BN009;
; 29Mar93 - TPL                                                         ;BN011;
; add COM_RECEIVE_BUFFER_FLUSH                                          ;BN011;
;***********************************************************************;BN011;
*/


/*--- DEM Property Names ---*/

#define PROP_NAME_AUTOEXEC          "DOS_AUTOEXEC"                    /*BN005*/


/*--- VKBD Property Names ---*/

#define PROP_NAME_POLL          "IDLE_SENSITIVITY"
#define PROP_NAME_DELAY         "IDLE_SECONDS"
#define PROP_NAME_FAST_PASTE    "VIDEO_FASTPASTE"
#define PROP_NAME_EXTRA_KEYS    "KBD_BUFFER_EXTEND"
#define PROP_NAME_KBD_RESTRICT  "KBD_RATE_LOCK"
#define PROP_NAME_KBD_CTRL_BP   "KBD_CTRL_BYPASS"
#define PROP_NAME_KBD_ALTHOM_BP "KBD_ALTHOME_BYPASS"

// DCR 1195
/*** WARNING - Do not change the order of the following ***/
#define HOT_KEY_LIST    \
 "NONE\0ALT_ESC\0CTRL_ESC\0"


/*--- VTIMER Property Names ---*/

#define PROP_NAME_DIRECT_ACCESS         "HW_TIMER"
#define PROP_NAME_SOUND_INHIBIT         "HW_NOSOUND"
#define PROP_NAME_BGND_EXEC             "DOS_BACKGROUND_EXECUTION"


/*--- VLPT Property Names ---*/

#define PROP_NAME_LPT1TIMEOUT "PRINT_TIMEOUT"
#define PROP_NAME_LPTSEPARATE "PRINT_SEPARATE_OUTPUT"                 /*BN007*/

/*--- VBIOS Property Names ---*/

#define PROP_NAME_BREAK             "DOS_BREAK"
#define PROP_NAME_SHELL             "DOS_SHELL"
#define PROP_NAME_RMSIZE            "DOS_RMSIZE"
#define PROP_NAME_FCB               "DOS_FCBS"
#define PROP_NAME_FCB2              "DOS_FCBS_KEEP"
#define PROP_NAME_FILES             "DOS_FILES"
#define PROP_NAME_DOSDD             "DOS_DEVICE"
#define PROP_NAME_DOS_OWN_UMB       "DOS_UMB"
#define PROP_NAME_DOS_LOADED_HIGH   "DOS_HIGH"
#define PROP_NAME_COPYROM           "HW_ROM_TO_RAM"
#define PROP_NAME_IOPL3             "HW_IOPL_LOCK"
#define PROP_NAME_INCLUDE_REGIONS   "MEM_INCLUDE_REGIONS"
#define PROP_NAME_EXCLUDE_REGIONS   "MEM_EXCLUDE_REGIONS"
#define PROP_NAME_LASTDRIVE         "DOS_LASTDRIVE"
#define PROP_NAME_VM_BOOT           "DOS_STARTUP_DRIVE"


/*--- VPIC Property Names ---*/

#define PROP_NAME_INT_DURING_IO     "INT_DURING_IO"                   /*BN001*/

#define VIDEO_DRIVER_NAME           "MDOS Video Device Driver"


/*--- VVIDEO Property Names ---*/

#define PROP_NAME_INT10EMULATE  "VIDEO_ROM_EMULATION"
#define PROP_NAME_RTRCEMULATE   "VIDEO_RETRACE_EMULATION"
#define PROP_NAME_MODERESTRICT  "VIDEO_MODE_RESTRICTION"
#define PROP_NAME_NORESTRICT    "NONE        "
#define PROP_NAME_CGARESTRICT   "CGA            "
#define PROP_NAME_MONORESTRICT  "MONO           "   /* length must match CGARESTRICT */
#define PROP_NAME_ONDEMAND      "VIDEO_ONDEMAND_MEMORY"
#define PROP_NAME_INT2F         "VIDEO_SWITCH_NOTIFICATION"
#define PROP_NAME_UPDATEWINDOW  "VIDEO_WINDOW_REFRESH"
#define PROP_NAME_SYNCOUTPUT    "Video_Window_scroll_synchronization"
#define PROP_NAME_8514A_IOTRAP  "VIDEO_8514A_XGA_IOTRAP"             /* BN010 */


/*--- VXMS Property Names ---*/

/*
 * Giving VXMS_PER_VDM_LIMIT as 0 will stop XMS operation in that
 * VDM. This field is restricted to 0-65535KB with default value as
 * 1024K. VXMS_MIN_HMA_USAGE are restricted to be in 0-63k with default
 * as 0. VXMS_NUM_HANDLES are restricted to 0-128 with default as 32.
 * VXMS_UMB_STATE is bool and defaults to deactive.
 */

#define PROP_NAME_VXMS_PER_VDM_LIMIT    "XMS_MEMORY_LIMIT"
#define PROP_NAME_VXMS_MIN_HMA          "XMS_MINIMUM_HMA"
#define PROP_NAME_VXMS_NUM_HANDLES      "XMS_HANDLES"


/*--- VEMM Property Names ---*/

#define PROP_VEMM_LIMIT   "EMS_MEMORY_LIMIT"
#define PROP_VEMM_HIGH    "EMS_HIGH_OS_MAP_REGION"
#define PROP_VEMM_LOW     "EMS_LOW_OS_MAP_REGION"
#define PROP_VEMM_FRAME   "EMS_FRAME_LOCATION"

/*** WARNING - Do not change the order of the following ***/
#define PROP_VEMM_LIST    \
 "AUTO\0NONE\0C000\0C400\0C800\0CC00\0D000\0D400\0D800\0DC00\0" \
 "8000\08400\08800\08C00\09000\0"


/*--- VMOUSE Property Names ---*/

#define PROP_NAME_MOUSECAPTURE  "MOUSE_EXCLUSIVE_ACCESS"

/***LT+ FAKEVERINFO defines a fake version entry for a DOS app.
 *
 *      MVDMR.LIB -> OS2KRNL
 *
 *      DOSEM fakes out the specified version for a DOS app which
 *      listed on a FAKEVERINFO structure.
 */

#define PROP_NAME_FAKE_VERSION  "DOS_VERSION"


/*--- DPMI Property Name ---*/

/* This property enables or disables DPMI support for this VDM. */

#define PROP_NAME_DPMI          "DPMI_MEMORY_LIMIT"
#define PROP_NAME_DPX_ENABLE     "DPMI_DOS_API"
#define PROP_NAME_DPX_NETBUFSIZE "DPMI_NETWORK_BUFF_SIZE"

#define PROP_DPX_TRANS_ALWAYS    "ENABLED"
#define PROP_DPX_TRANS_APP_SEL   "AUTO"
#define PROP_DPX_TRANS_NEVER     "DISABLED"

#define PROP_DPX_TRANS_LIST \
   PROP_DPX_TRANS_APP_SEL "\0" \
   PROP_DPX_TRANS_ALWAYS "\0" \
   PROP_DPX_TRANS_NEVER "\0"

/*--- This property supports VDM Priority  */

/* #define PROP_NAME_PRIORITY       "VDM_PRIORITY" */
#define PROP_NAME_PRIORITY       "SESSION_PRIORITY"                  /* 85737*/

/*--- VCOM Property Name ---*/

#define PROP_NAME_HOLD_RES      "COM_HOLD"
#define PROP_NAME_HW_COM        "COM_DIRECT_ACCESS"
#define PROP_NAME_COM_SELECT    "COM_SELECT"                          /*BN002*/
#define PROP_NAME_COM_RX_BUFFER_FLUSH    "COM_RECEIVE_BUFFER_FLUSH"   /*BN011*/


/*--- VTOUCH Property Name ---*/

#define PROP_NAME_EXCLUSIVE_TOUCH       "TOUCH_EXCLUSIVE_ACCESS"


/*---         properties ---*/

#define PROP_NAME_WIN_RUNMODE    "WIN_RUN_MODE"                       /*BN006*/
#define PROP_NAME_DDE            "WIN_DDE"                            /*BN003*/
#define PROP_NAME_CLIPBOARD      "WIN_CLIPBOARD"                      /*BN003*/
#define PROP_NAME_ATM            "WIN_ATM"                            /*atm*/

#define PROP_WMODE_STD           "3.0 Standard"                       /*BN006*/
#define PROP_WMODE_REAL          "Real"                               /*BN006*/
#define PROP_WMODE_AUTO          "Auto"                               /*BN006*/
#define PROP_WMODE_31STD         "3.1 Standard"                       /*BN006*/
#define PROP_WMODE_31ENH         "3.1 Enhanced Compatibility"         /*BN006*/

/*--- Audio properties ---*/

#define PROP_NAME_AUDIO_ADAPTER  "AUDIO_ADAPTER_SHARING"              /*BN009*/

#define PROP_SHARMODE_OPTIONAL      "Optional"                        /*BN009*/
#define PROP_SHARMODE_NONE          "None"                            /*BN009*/
#define PROP_SHARMODE_REQUIRED      "Required"                        /*BN009*/

