/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)perfhook.h	6.3 92/05/08";*/
/*      SCCSID = @(#)perfhook.h	6.3 92/05/08                         */
/***************************************************************************/
/*                                                                         */
/*                                                                         */
/***************************************************************************/
/*                                      */
/*    Performance hook include file     */
/*                                      */

#define PERFTRACE 1                             /* Set for major code '01' */
#define PERFBIT x040                            /* Bit for major code 1    */

/***
 *  Dekko card memory mapped I/O address data area
 */
struct Dekko_Addr
{
    unsigned long   reserved;           /* +0 - not used                   */
    unsigned short  majmin_code;        /* +4 - Major (hi) minor (lo) code */
    unsigned short  start_stop_sync;    /* +6 - not used                   */
    unsigned long   perf_data_4byte;    /* +8 - 4 byte performance data    */
    unsigned short  perf_data;          /* +C - 2 byte performance data    */
};

#if defined(MMIOPH)

#if defined(PINBALL_MMIOPH)
#define mmptr   far
#else
#define mmptr
#endif


/***
 *  Local variables used by the performance hook internal macros
 */
static struct Dekko_Addr mmptr  *dekko_addr;
static unsigned char mmptr      *dekko_ptr;
static          short            dekko_idx;
static unsigned long             dekko_quad;


/***************************************************************************/
/*                                                                         */
/*  TEST_TRACING........... Determines if tracing is active for the given  */
/*                          major code and if the "master" tracing switch  */
/*                          is currently active.                           */
/*                                                                         */
/***************************************************************************/

#define TEST_TRACING(RMT,Maj)   \
        (*RMT & 0x40) && (*(RMT+(Maj>>3)) & (0x80>>(Maj&7)))


/***************************************************************************/
/*                                                                         */
/*  SET_DEKKO_ADDRESS...... Loads the dekko card address into the variable */
/*                          "dekko_addr". Address value is obtained from   */
/*                          the info segment data.                         */
/*                                                                         */
/***************************************************************************/

#define SET_DEKKO_ADDRESS(infoseg_ptr) \
    dekko_addr = (struct Dekko_Addr *) infoseg_ptr.SIS_MMIOAddr;

#define SET_DEKKO_ADDRESS2(infoseg_ptr) \
    dekko_addr = (struct Dekko_Addr *) infoseg_ptr->SIS_MMIOAddr;


/***************************************************************************/
/*                                                                         */
/*  FORCE_WRITE............ Macro used to break the optimization of the    */
/*                          C complier. This macro will force it to        */
/*                          generate code for consecutive statements which */
/*                          write to the same memory location. This may    */
/*                          stop working without notice. It should be      */
/*                          checked each time the "C" compiler is changed. */
/*                                                                         */
/***************************************************************************/

#define FORCE_WRITE if(dekko_addr!=0);


/***************************************************************************/
/*                                                                         */
/*  WRITE_MAJ_MNR_CODES.... Writes the given major and minor codes into    */
/*                          the "majmin_code" element of the dekko addr.   */
/*                                                                         */
/***************************************************************************/

#define WRITE_MAJMNR_CODES(MajMnr) dekko_addr->majmin_code = MajMnr;


/***************************************************************************/
/*                                                                         */
/*  WRITE_BYTE_VALUE....... Writes the given byte value at the +C offset   */
/*                          data area of the dekko card. The byte is       */
/*                          written into the high byte of the data area    */
/*                          and the low byte is padded with a zero.        */
/*                                                                         */
/***************************************************************************/

#define WRITE_BYTE_VALUE(val) \
    dekko_addr->perf_data=(unsigned short)val; \
    FORCE_WRITE


/***************************************************************************/
/*                                                                         */
/*  WRITE_WORD_VALUE....... Writes the given word value at the +C offset   */
/*                          data area of the dekko card.                   */
/*                                                                         */
/***************************************************************************/

#define WRITE_WORD_VALUE(val) \
    dekko_addr->perf_data=(unsigned short)val; \
    FORCE_WRITE


/***************************************************************************/
/*                                                                         */
/*  WRITE_DWORD_VALUE...... Writes the double word value at the +8 offset  */
/*                          data area of the dekko card.                   */
/*                                                                         */
/***************************************************************************/

#define WRITE_DWORD_VALUE(val) \
    dekko_addr->perf_data_4byte=(unsigned long)val; \
    FORCE_WRITE


/***************************************************************************/
/*                                                                         */
/*  WRITE_BYTE_STREAM...... Write the stream of bytes indicated by         */
/*                          dekko_ptr and dekko_idx to the +8 offset of    */
/*                          the dekko card as a series of double words.    */
/*                                                                         */
/*  07/09/90 - Fixed extra quad written when last byte of string was on    */
/*             the quad boundry.                                           */
/*                                                                         */
/***************************************************************************/

#define WRITE_BYTE_STREAM                    \
        while (dekko_idx > 0) {              \
            dekko_quad = *(long mmptr *)dekko_ptr; \
            WRITE_DWORD_VALUE (dekko_quad)   \
            dekko_ptr += 4; dekko_idx -= 4; }


/***************************************************************************/
/*                                                                         */
/*  WRITE_ASCIIZ_STRING.... Writes the asciiz string to the dekko card as  */
/*                          a series of double words to the +8 offset. The */
/*                          final "dword" is padded with as many blanks as */
/*                          needed. The null terminator is always written. */
/*                                                                         */
/*  06/21/90 - Modified to check for null string. Write zeros if NULL.     */
/*                                                                         */
/***************************************************************************/

#define WRITE_ASCIIZ_STRING(str)              \
        if (str != NULL) {                    \
            dekko_ptr = (unsigned char mmptr *)str; \
            dekko_idx = 1;                    \
            while (*dekko_ptr++) dekko_idx++; \
            dekko_ptr = (unsigned char mmptr *)str; \
            WRITE_BYTE_STREAM  }              \
        else                                  \
            WRITE_DWORD_VALUE(0)


/***************************************************************************/
/*                                                                         */
/*  WRITE_NUMB_STRING...... Writes the length byte of the string to the +C */
/*                          offset of the dekko card. The data part of the */
/*                          string is then written to the +8 offset as a   */
/*                          series of double words.                        */
/*                                                                         */
/*  06/21/90 - Fixed pointer incrememt problem. Also allowed for fact that */
/*             length byte value includes the length byte.                 */
/*                                                                         */
/***************************************************************************/

#define WRITE_NUMB_STRING(str)                \
        if (str != NULL) {                    \
            dekko_ptr = (unsigned char mmptr *)str; \
            dekko_idx = *dekko_ptr - 1;       \
            dekko_ptr++;                      \
            WRITE_WORD_VALUE (dekko_idx)      \
            WRITE_BYTE_STREAM }               \
        else                                  \
            WRITE_DWORD_VALUE(0)


#if defined(PINBALL_MMIOPH)
/***************************************************************************/
/*                                                                         */
/*  WRITE_CRACKED_PATH..... Writes a cracked path to the dekko card. See   */
/*                          file \drv6\src\pinball\hdrs\misc.h for cracked */
/*                          path structure.                                */
/*                                                                         */
/***************************************************************************/

#define WRITE_CRACKED_PATH(pckpth)              \
        {   unsigned char far *p = &(pckpth->sp.c); \
            unsigned char far *ep= p-2;             \
            ep += pckpth->cbPath; ep += *ep;    \
            WRITE_WORD_VALUE (pckpth->hVPB)     \
            WRITE_WORD_VALUE (pckpth->cbPath)   \
            while (p!=ep){WRITE_NUMB_STRING(p) p+=*p;}\
        }
#endif


#endif
