/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)os2def16.h 6.6 92/02/29";*/
/*static char *SCCSID = "@(#)os2def16.h 6.6 92/02/29";*/
/***************************************************************************\
*
* Module Name: OS2DEF16.H
*
* OS/2 Common Definitions file for 16-bit compilations
*
*
\***************************************************************************/

#ifndef OS2_INCLUDED
#if !(defined(INCL_32) || defined(INCL_16))
#ifdef M_I386
    #define INCL_32
#else /* not M_I386 */
    #define INCL_16
#endif /* M_I386 */
#endif /* INCL_32 || INCL_16 */
#endif /* OS2_INCLUDED */

/* XLATOFF */
#ifdef INCL_32
#error message ("Using 16 bit definitions when compiling 32 bit code")
#endif /* INCL_16 */

#ifdef M_I386

#define PASCAL          _pascal
#define FAR             _far16
#define NEAR            _near
#define EXPENTRY        PASCAL FAR _loadds
#define APIENTRY        PASCAL FAR
#define APIRET          USHORT

#else /* not M_I386 */

#define PASCAL          _pascal
#define FAR             _far
#define NEAR            _near
#define EXPENTRY        PASCAL FAR _loadds
#define APIENTRY        PASCAL FAR
#define APIRET          USHORT

#endif /* M_I386 */

#define VOID    void
/* XLATON */

/* XLATOFF */
#ifndef NULL
#if (defined(M_I86SM) || defined(M_I86MM))
/* XLATON */
#define  NULL    0
/* XLATOFF */
#else
#if (defined(M_I86L) || defined(M_I86CM) || defined(M_I86LM) || defined(M_I86HM))
#define  NULL    0L
#else
#define  NULL    0
#endif
#endif
#endif /* ifndef NULL */
/* XLATON */

#ifndef FALSE
#define FALSE   0
#endif /* ifndef FALSE */

#ifndef TRUE
#define TRUE    1
#endif /* ifndef TRUE */

typedef unsigned short  SHANDLE;

typedef VOID FAR        *LHANDLE;

/* XLATOFF */
#define CHAR    char            /* ch  */
#define SHORT   short           /* s   */
#define LONG    long            /* l   */
#ifndef INCL_SAADEFS
#define INT     int             /* i   */
#endif /* !INCL_SAADEFS */
/* XLATON */

typedef unsigned char UCHAR;    /* uch */
typedef unsigned short USHORT;  /* us  */
typedef unsigned long ULONG;    /* ul  */
#ifndef INCL_SAADEFS
typedef unsigned int  UINT;     /* ui  */
#endif /* !INCL_SAADEFS */

typedef unsigned char BYTE;     /* b   */

typedef unsigned char FAR  *PSZ;
typedef unsigned char NEAR *NPSZ;

typedef unsigned char FAR  *PCH;
typedef unsigned char NEAR *NPCH;

typedef int   (PASCAL FAR  *PFN)();
typedef int   (PASCAL NEAR *NPFN)();

typedef BYTE   FAR  *PBYTE;
typedef BYTE   NEAR *NPBYTE;

typedef CHAR   FAR *PCHAR;
typedef SHORT  FAR *PSHORT;
typedef LONG   FAR *PLONG;
#ifndef INCL_SAADEFS
typedef INT    FAR *PINT;
#endif /* !INCL_SAADEFS */

typedef UCHAR  FAR *PUCHAR;
typedef USHORT FAR *PUSHORT;
typedef ULONG  FAR *PULONG;
#ifndef INCL_SAADEFS
typedef UINT   FAR *PUINT;
#endif /* !INCL_SAADEFS */

typedef VOID   FAR *PVOID;
typedef PVOID  FAR *PPVOID;

typedef unsigned short BOOL;    /* f   */
typedef BOOL FAR *PBOOL;

/* Quad-word */

/* XLATOFF */
typedef struct _QWORD {        /* qword */
        ULONG   ulLo;
        ULONG   ulHi;
} QWORD;

typedef QWORD FAR *PQWORD;
/* XLATON */


#ifndef INCL_SAADEFS

typedef unsigned short SEL;     /* sel */
typedef SEL FAR *PSEL;

/*** Useful Helper Macros */

/* Create untyped far pointer from selector and offset */
#define MAKEP(sel, off)     ((PVOID)MAKEULONG(off, sel))

/* Extract selector or offset from far pointer */
#define SELECTOROF(p)       (((PUSHORT)&(p))[1])
#define OFFSETOF(p)         (((PUSHORT)&(p))[0])
#endif  /* !INCL_SAADEFS */


/* Cast any variable to an instance of the specified type. */
#define MAKETYPE(v, type)   (*((type FAR *)&v))

/* Calculate the byte offset of a field in a structure of type type. */
#define FIELDOFFSET(type, field)    ((SHORT)&(((type *)0)->field))

/* Combine l & h to form a 32 bit quantity. */
#define MAKEULONG(l, h)  ((ULONG)(((USHORT)(l)) | ((ULONG)((USHORT)(h))) << 16))
#define MAKELONG(l, h)   ((LONG)MAKEULONG(l, h))

/* Combine l & h to form a 16 bit quantity. */
#define MAKEUSHORT(l, h) (((USHORT)(l)) | ((USHORT)(h)) << 8)
#define MAKESHORT(l, h)  ((SHORT)MAKEUSHORT(l, h))

/* Extract high and low order parts of 16 and 32 bit quantity */
#define LOBYTE(w)       LOUCHAR(w)
#define HIBYTE(w)       HIUCHAR(w)
#define LOUCHAR(w)      ((UCHAR)(w))
#define HIUCHAR(w)      ((UCHAR)(((USHORT)(w) >> 8) & 0xff))
#define LOUSHORT(l)     ((USHORT)(l))
#define HIUSHORT(l)     ((USHORT)(((ULONG)(l) >> 16) & 0xffff))

/*** Common Error definitions ****/

typedef ULONG ERRORID;  /* errid */
typedef ERRORID FAR *PERRORID;

/* Combine severity and error code to produce ERRORID */
#define MAKEERRORID(sev, error) (ERRORID)(MAKEULONG((error), (sev)))
/* Extract error number from an errorid */
#define ERRORIDERROR(errid)            (LOUSHORT(errid))
/* Extract severity from an errorid */
#define ERRORIDSEV(errid)              (HIUSHORT(errid))

/* Severity codes */
#define SEVERITY_NOERROR                    0x0000
#define SEVERITY_WARNING                    0x0004
#define SEVERITY_ERROR                      0x0008
#define SEVERITY_SEVERE                     0x000C
#define SEVERITY_UNRECOVERABLE              0x0010

/* Base component error values */

#define WINERR_BASE     0x1000  /* Window Manager                  */
#define GPIERR_BASE     0x2000  /* Graphics Presentation Interface */
#define DEVERR_BASE     0x3000  /* Device Manager                  */
#define SPLERR_BASE     0x4000  /* Spooler                         */

/*** Common types used across components */

/*** Common DOS types */

typedef SHANDLE HMODULE;        /* hmod */
typedef SHANDLE PID;            /* pid  */
typedef SHANDLE TID;            /* tid  */
#ifndef INCL_SAADEFS
typedef USHORT  SGID;           /* sgid */
#endif  /* !INCL_SAADEFS */

typedef HMODULE FAR *PHMODULE;
typedef PID FAR *PPID;
typedef TID FAR *PTID;

#ifndef INCL_SAADEFS
typedef VOID FAR *HSEM;     /* hsem */
typedef HSEM FAR *PHSEM;
#endif  /* !INCL_SAADEFS */

/*** Common SUP types */

typedef LHANDLE   HAB;      /* hab  */
typedef HAB FAR *PHAB;

/*** Common GPI/DEV types */

typedef LHANDLE   HPS;      /* hps  */
typedef HPS FAR *PHPS;

typedef LHANDLE   HDC;      /* hdc  */
typedef HDC FAR *PHDC;

typedef LHANDLE   HRGN;     /* hrgn */
typedef HRGN FAR *PHRGN;

typedef LHANDLE   HBITMAP;  /* hbm  */
typedef HBITMAP FAR *PHBITMAP;

typedef LHANDLE   HMF;      /* hmf  */
typedef HMF FAR *PHMF;

typedef LHANDLE   HPAL;     /* hpal */
typedef HPAL FAR *PHPAL;

typedef LONG     COLOR;    /* clr  */
typedef COLOR FAR *PCOLOR;

typedef struct _POINTL  {    /* ptl  */
    LONG  x;
    LONG  y;
} POINTL;
typedef POINTL  FAR  *PPOINTL;
typedef POINTL  NEAR *NPPOINTL;

typedef struct _POINTS { /* pts */
    SHORT x;
    SHORT y;
} POINTS;
typedef POINTS FAR *PPOINTS;

typedef struct _RECTL {      /* rcl */
    LONG  xLeft;
    LONG  yBottom;
    LONG  xRight;
    LONG  yTop;
} RECTL;
typedef RECTL FAR  *PRECTL;
typedef RECTL NEAR *NPRECTL;

typedef CHAR STR8[8];       /* str8 */
typedef STR8 FAR *PSTR8;

/*** common DEV/SPL types */

/* structure for Device Driver data */

typedef struct _DRIVDATA {      /* driv */
    LONG    cb;
    LONG    lVersion;
    CHAR    szDeviceName[32];
    CHAR    abGeneralData[1];
} DRIVDATA;
typedef DRIVDATA FAR *PDRIVDATA;

/* pointer data for DevOpenDC */

typedef PSZ FAR *PDEVOPENDATA;

/* array indices for array parameter for DevOpenDC, SplQmOpen or SplQpOpen */

#define ADDRESS          0
#ifndef INCL_SAADEFS
#define DRIVER_NAME      1
#define DRIVER_DATA      2
#define DATA_TYPE        3
#define COMMENT          4
#define PROC_NAME        5
#define PROC_PARAMS      6
#define SPL_PARAMS       7
#define NETWORK_PARAMS   8

/* structure definition as an alternative of the array parameter */

typedef struct _DEVOPENSTRUC {    /* dop */
    PSZ        pszLogAddress;
    PSZ        pszDriverName;
    PDRIVDATA  pdriv;
    PSZ        pszDataType;
    PSZ        pszComment;
    PSZ        pszQueueProcName;
    PSZ        pszQueueProcParams;
    PSZ        pszSpoolerParams;
    PSZ        pszNetworkParams;
} DEVOPENSTRUC;
typedef DEVOPENSTRUC FAR *PDEVOPENSTRUC;
#endif  /* !INCL_SAADEFS */

/* common PMWP object and PMSTDDLG drag data */

typedef struct _PRINTDEST {   /* prntdst */
   ULONG        cb;
   LONG         lType;
   PSZ          pszToken;
   LONG         lCount;
   PDEVOPENDATA pdopData;
   ULONG        fl;
   PSZ          pszPrinter;
} PRINTDEST;
typedef PRINTDEST FAR *PPRINTDEST;

#define PD_JOB_PROPERTY   0x0001      /* Flags for .fl field           */

/*** common AVIO/GPI types */

/* values of fsSelection field of FATTRS structure */
#define FATTR_SEL_ITALIC        0x0001
#define FATTR_SEL_UNDERSCORE    0x0002
#define FATTR_SEL_OUTLINE       0x0008
#define FATTR_SEL_STRIKEOUT     0x0010
#define FATTR_SEL_BOLD          0x0020

/* values of fsType field of FATTRS structure */
#define FATTR_TYPE_KERNING      0x0004
#define FATTR_TYPE_MBCS         0x0008
#define FATTR_TYPE_DBCS         0x0010
#define FATTR_TYPE_ANTIALIASED  0x0020

/* values of fsFontUse field of FATTRS structure */
#define FATTR_FONTUSE_NOMIX         0x0002
#define FATTR_FONTUSE_OUTLINE       0x0004
#define FATTR_FONTUSE_TRANSFORMABLE 0x0008
/* size for fields in the font structures */

#define FACESIZE 32

/* font struct for Vio/GpiCreateLogFont */

typedef struct _FATTRS {          /* fat */
    USHORT  usRecordLength;
    USHORT  fsSelection;
    LONG    lMatch;
    CHAR    szFacename[FACESIZE];
    USHORT  idRegistry;
    USHORT  usCodePage;
    LONG    lMaxBaselineExt;
    LONG    lAveCharWidth;
    USHORT  fsType;
    USHORT  fsFontUse;
} FATTRS;
typedef FATTRS FAR *PFATTRS;

/* values of fsType field of FONTMETRICS structure */
#define FM_TYPE_FIXED           0x0001
#define FM_TYPE_LICENSED        0x0002
#define FM_TYPE_KERNING         0x0004
#define FM_TYPE_DBCS            0x0010
#define FM_TYPE_MBCS            0x0018
#define FM_TYPE_64K             0x8000
#define FM_TYPE_ATOMS           0x4000
#define FM_TYPE_FAMTRUNC        0x2000
#define FM_TYPE_FACETRUNC       0x1000


/* values of fsDefn field of FONTMETRICS structure */
#define FM_DEFN_OUTLINE         0x0001
#define FM_DEFN_IFI         0x0002
#define FM_DEFN_WIN         0x0004
#define FM_DEFN_GENERIC         0x8000

/* values of fsSelection field of FONTMETRICS structure */
#define FM_SEL_ITALIC           0x0001
#define FM_SEL_UNDERSCORE       0x0002
#define FM_SEL_NEGATIVE         0x0004
#define FM_SEL_OUTLINE          0x0008          /* Hollow Outline Font */
#define FM_SEL_STRIKEOUT        0x0010
#define FM_SEL_BOLD             0x0020
#define FM_SEL_ISO9241_TESTED   0x0040

/* ISO 9241 is an international standard covering health and safety      */
/* in the work place for users of visual display terminals. Part 3 of    */
/* this standard covers clarity and legibility of text displayed on      */
/* computer screens, it places requirements on minimum sizes and         */
/* luminance contrast. The presence of FM_SEL_ISO9241_TESTED flag in the */
/* font metrics indicates that the font has been tested for compliance   */
/* to the standard. The FM_ISO_XXX flags indicate the results of the     */
/* test on the IBM 9515, 9517 and 9518 color displays at the supported   */
/* dimensions of 640x480 and 1024x768. To ensure compliance the          */
/* sXDeviceRes and sYDeviceRes must also match the target display        */
/* resolution.                                                           */

/* values of fbPassed/FailedISO field in the PANOSE structure */
#define FM_ISO_9518_640        0x01
#define FM_ISO_9515_640        0x02
#define FM_ISO_9515_1024       0x04
#define FM_ISO_9517_640        0x08
#define FM_ISO_9517_1024       0x10

/* values of fsCapabilities field of FONTMETRICS structure */
#define FM_CAP_NOMIX            0x0001

/* font metrics returned by GpiQueryFonts and others */

typedef struct _PANOSE { /* panose */
    BYTE    bFamilyType;
    BYTE    bSerifStyle;
    BYTE    bWeight;
    BYTE    bProportion;
    BYTE    bContrast;
    BYTE    bStrokeVariation;
    BYTE    bArmStyle;
    BYTE    bLetterform;
    BYTE    bMidline;
    BYTE    bXHeight;
    BYTE    fbPassedISO;
    BYTE    fbFailedISO;
} PANOSE;

typedef struct _FONTMETRICS {   /* fm */
    CHAR    szFamilyname[FACESIZE];
    CHAR    szFacename[FACESIZE];
    USHORT  idRegistry;
    USHORT  usCodePage;
    LONG    lEmHeight;
    LONG    lXHeight;
    LONG    lMaxAscender;
    LONG    lMaxDescender;
    LONG    lLowerCaseAscent;
    LONG    lLowerCaseDescent;
    LONG    lInternalLeading;
    LONG    lExternalLeading;
    LONG    lAveCharWidth;
    LONG    lMaxCharInc;
    LONG    lEmInc;
    LONG    lMaxBaselineExt;
    SHORT   sCharSlope;
    SHORT   sInlineDir;
    SHORT   sCharRot;
    USHORT  usWeightClass;
    USHORT  usWidthClass;
    SHORT   sXDeviceRes;
    SHORT   sYDeviceRes;
    SHORT   sFirstChar;
    SHORT   sLastChar;
    SHORT   sDefaultChar;
    SHORT   sBreakChar;
    SHORT   sNominalPointSize;
    SHORT   sMinimumPointSize;
    SHORT   sMaximumPointSize;
    USHORT  fsType;
    USHORT  fsDefn;
    USHORT  fsSelection;
    USHORT  fsCapabilities;
    LONG    lSubscriptXSize;
    LONG    lSubscriptYSize;
    LONG    lSubscriptXOffset;
    LONG    lSubscriptYOffset;
    LONG    lSuperscriptXSize;
    LONG    lSuperscriptYSize;
    LONG    lSuperscriptXOffset;
    LONG    lSuperscriptYOffset;
    LONG    lUnderscoreSize;
    LONG    lUnderscorePosition;
    LONG    lStrikeoutSize;
    LONG    lStrikeoutPosition;
    SHORT   sKerningPairs;
    SHORT   sFamilyClass;
    LONG    lMatch;
#ifndef PM12
#ifndef PM20
    LONG    FamilyNameAtom;
    LONG    FaceNameAtom;
    PANOSE  panose;
#endif
#endif
} FONTMETRICS;
typedef FONTMETRICS FAR *PFONTMETRICS;

/*** Common WIN types */

typedef LHANDLE HWND;      /* hwnd */
typedef HWND FAR *PHWND;

typedef LHANDLE HMQ;       /* hmq */
typedef LHANDLE FAR *PHMQ;

typedef struct _WRECT {    /* wrc */
    SHORT xLeft;
    SHORT dummy1;
    SHORT yBottom;
    SHORT dummy2;
    SHORT xRight;
    SHORT dummy3;
    SHORT yTop;
    SHORT dummy4;
} WRECT;
typedef WRECT FAR *PWRECT;
typedef WRECT NEAR *NPWRECT;

typedef struct _WPOINT {   /* wpt */
    SHORT x;
    SHORT dummy1;
    SHORT y;
    SHORT dummy2;
} WPOINT;
typedef WPOINT FAR *PWPOINT;
typedef WPOINT NEAR *NPWPOINT;
