/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)int2f.h    6.1 90/11/15";*/

/***	INT2F.H
 *
 *	SCCSID = @(#)int2f.h	13.1 90/05/30
 *
 *	Title:
 *
 *	INT 2F API definations
 *
 *	Description:
 *
 *	Contains the         3.0 INT 2F services definations
 */

/*INT32*/

#define INT2F_INT			0x2F

//  All         3.0 INT 2F API must be issued with AH = 16h

#define INT2F_WINDOWS_MULTIPLEX 	0x16

//          3.0 INT 2F API calls

#define INT2F_GET_VERSION		0x00	// install check/Get version
#define INT2F_OLD_GET_VMID_API		0x02	// 2.xx get VMID API call
#define INT2F_STARTUP			0x05	// sent when Win386 starting
#define INT2F_EXIT			0x06	// sent when Win386 exited
#define INT2F_DEVICE_BROADCAST		0x07	// sent by virtual device
#define INT2F_STARTUP_COMPLETE		0x08	// sent when start is done
#define INT2F_BEGIN_EXIT		0x09	// starting a NORMAL exit

#define INT2F_HIGH_FUNCTION		0x80
#define INT2F_HIGH_FUNCTION_BIT 	7

#define INT2F_RELEASE_TIME		0x80	// release cur VM's time-slice
#define INT2F_BEGIN_CRITICAL		0x81	// begin critical section
#define INT2F_END_CRITICAL		0x82	// end critical section
#define INT2F_GET_CUR_VMID		0x83	// returns BX = ID of current VM
#define INT2F_GET_DEVICE_API		0x84	// returns ES:DI -> Device API
#define INT2F_SWITCH_AND_CALL		0x85	// change VMs and call-back
#define INT2F_TEST_INT31_AVAIL		0x86	// returns AX=0 if Int 31 avail
#define INT2F_GET_PM_SWITCH_ADDR	0x87	// get call-back addr for PM
#define INT2F_GET_LDT_BASE_SEL		0x88	// get selector to LDT
#define INT2F_WIN_KERNEL_IDLE		0x89	//         kernel idle call

//  Flags passed to the INT2F_WIN_KERNEL_IDLE call to indicate
//  state of         in the BX register.

#define INT2F_WIN_IDLE_MOUSE_BUSY	0x01
#define INT2F_WIN_IDLE_MOUSE_BUSY_BIT	0

//  Flags returned by INT2F_GET_PM_SWITCH_ADDR

#define INT2F_32BIT_PROGRAMS_SUPPORTED	0x01

#define INT2F_286_PROCESSOR		0x02
#define INT2F_386_PROCESSOR		0x03
#define INT2F_486_PROCESSOR		0x04

//   Equates for OS/2 detect and get VDD API calls
#define INT2F_GETOS2VER 		0x4010
#define INT2F_GETVDDAPI 		0x4011
