/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)floppy.h	6.1 90/11/15";*/
/***	Floppy Device Driver (FLPY)
 *
 *	SCCSID = @(#)floppy.h	13.2 90/06/29
 *
 *
 *
 *
 *	DESCRIPTION
 *	Floppy hardware constants
 *
 *	MODIFICATION HISTORY
 *	06/13/90 MTS	Created.
 */


// Ports

#define PORT_STATUSA		0x3f0	//read-only
#define PORT_STATUSB		0x3f1	//read-only
#define PORT_DIGITALOUT 	0x3f2	//write-only
#define PORT_DIGITALIN		0x3f7	//read-only
#define PORT_CONFIG		0x3f7	//write-only
#define PORT_FDCSTATUS		0x3f4	//read-only
#define PORT_FDCDATA		0x3f5	//read/write

// Status A register

#define STATUSA_DIR		0x01	//direction
#define STATUSA_NOTWRTPROT	0x02	//not write protect
#define STATUSA_NOTINDEX	0x04	//not index
#define STATUSA_HEAD1		0x08	//select head 1
#define STATUSA_NOTTRACK0	0x10	//not track 0
#define STATUSA_STEP		0x20	//step
#define STATUSA_NO2NDDRIVE	0x40	//no 2nd drive installed
#define STATUSA_INTRPENDING	0x80	//interrupt pending

// Status B register

#define STATUSB_MOTOREN0	0x01	//motor enable 0
#define STATUSB_MOTOREN1	0x02	//motor enable 1
#define STATUSB_WRITEEN 	0x04	//write enable
#define STATUSB_READDATA	0x08	//pos. transition of -RD toggle this bit
#define STATUSB_WRITEDATA	0x10	//pos. transition of -WR toggle this bit
#define STATUSB_DRIVESEL	0x20	//drive select
#define STATUSB_RESERVED	0xc0	//reserved bits

// Digital Output register

#define DO_DRIVESEL0		0x01	//drive select 0
#define DO_DRIVESEL1		0x02	//drive select 1
#define DO_NOTFDCRESET		0x04	//-controller reset
#define DO_INTENABLE		0x08	//interrupt enable
#define DO_MOTOREN0		0x10	//motor enable 0
#define DO_MOTOREN1		0x20	//motor enable 1
#define DO_RESERVED		0xc0	//reserved bits

// Digital Input register

#define DI_NOTHIDENSEL		0x01	//not high density select
#define DI_RESERVED		0x7e	//reserved bits
#define DI_DISKCHANGED		0x80	//diskette changed

// Configuration Control register

#define CFG_DRC 		0x03	//drive control
#define CFG_DRC500K		0x00	//500 Kbit mode
#define CFG_DRC250K		0x02	//250 Kbit mode

// Diskette Drive Controller Status register

#define STATUS_DRV0BUSY 	0x01	//drive 0 busy
#define STATUS_DRV1BUSY 	0x02	//drive 1 busy
#define STATUS_RESERVED 	0x0c	//reserved bits
#define STATUS_FDCBUSY		0x10	//diskette controller busy
#define STATUS_NONDMA		0x20	//non-DMA mode
#define STATUS_DATAOUT		0x40	//data output from controller
#define STATUS_READY		0x80	//controller ready

#define FLPY_IRQ		0x06	//floppy uses IRQ 6
#define FLPY_DMA		0x02	//floppy uses DMA channel 2
