/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)eisa.h	6.1 90/11/15";*/
/* SCCSID = @(#)eisa.h	      13.3 90/06/13  */

/*
 * eisa.h
 */

/*
 *
 *
 */

typedef struct _EisaMemoryInfo { /* emi */
	unsigned char	fb;
	unsigned char	fbDataSize;
	unsigned short	usPaddrLSW;
	unsigned char	bPaddrMSB;
	unsigned short	usMemorySize;
} EisaMemoryInfo;

typedef struct _EisaIRQInfo { /* eiri */
	unsigned char	fb;
	unsigned char	bReserved;
} EisaIRQInfo;

typedef struct _EisaDMAInfo { /* edi */
	unsigned char	fbChan;
	unsigned char	fbType;
} EisaDMAInfo;

typedef struct _EisaPortInfo { /* epi */
	unsigned char	fb;
	unsigned short	usAddress;
} EisaPortInfo;

typedef struct _EisaSlotInfo { /* esi */
	unsigned char	bReturn;
	unsigned char	fb;
	unsigned char	bMajorRev;
	unsigned char	bMinorRev;
	unsigned short	usChecksum;
	unsigned char	cbFunc;
	unsigned char	fbFunc;
	unsigned long	ulID;
} EisaSlotInfo ;

typedef struct _EisaFuncInfo { /* efi */
	unsigned char	bReturn;
	unsigned long	ID;
	unsigned char	fbID;
	unsigned char	fbSlot;
	unsigned char	bMinorRev;
	unsigned char	bMajorRev;
	unsigned char	abSelections[26];
	unsigned char	fbFunction;
	unsigned char	achType[80];
	EisaMemoryInfo	emi[9];
	EisaIRQInfo	eiri[7];
	EisaDMAInfo	edi[4];
	EisaPortInfo	epi[20];
	unsigned char	achInitInfo[60];
} EisaFuncInfo ;

// Structure for parameters for Eisa call IOCTL

typedef struct EisaCallParameters { /* ecp */

	unsigned char SubFunction;
	unsigned char SlotNumber;
	unsigned char FunctionNumber;
};

// macros used in Eisa Rom Calls in OEMHLP$

#define EISA_STACK_SIZE		1900	    // stack for Eisa calls
#define EISA_PARAMETER_SIZE	3	    // parameters for Eisa calls
#define EISA_SLOT_SIZE		6	    // get slot info return
#define EISA_FUNC_SIZE		321	    // get function info return
#define EISA_ROM_ADDR		0x000F0000  // Rom bios segment base
#define EISA_ENTRY_OFFSET	0x0F859	    // int 15 entry in F000 seg
#define EISA_SLOT_INFO_16	0x0D800	    // ax for get slot info 16 bit
#define EISA_FUNC_INFO_16	0x0D801	    // ax for get func info 16 bit
#define EISA_FNNUMBER		4	    // Eisa GIOCTL function #
#define EISA_ERROR_EMPTY_SLOT	0x83	    // slot is empty
#define EISA_HAS_IRQ_ENTRIES	0x04	    // entry has IRQ entries
#define EISA_IRQ_LAST		0x80	    // Last IRQ entry
#define EISA_IRQ_SHARABLE	0x40	    // IRQ is sharable
#define EISA_IRQ_LEVEL		0x20	    // IRQ is level triggered
#define EISA_HAS_IO_ENTRIES     0x10        // Slot has I/O ports
#define EISA_FUNCTION_REQUEST   0x01        // OEMHLP$ request code
#define EISA_SLOT_REQUEST       0x00        // OEMHLP$ request code
#define EISA_INVALID_BIOS_CALL  0x86        // EISA BIOS calls not supported
#define EISA_DEVICE_TYPE_LEN    0x50        // Size of the device type string
#define EISA_NUMBER_PORTS       0x1F        // Mask for determining # of ports
#define EISA_DMA_BUFFER_CH      0x2000      // Mask for IRQ13 sharing

// The following constants are used to determine the reason for an NMI
// on an Eisa machine

#define EisaNMI_Port1		    0x61
#define EisaNMI_IoChk		    0x40	// Assertion of IOCHK
#define EisaNMI_Parity		    0x80	// Parity error from memory
#define EisaNMI_IoChk_Control	    0x04	// Assertion of IOCHK
#define EisaNMI_Parity_Control	    0x08	// Parity error from memory

#define EisaNMI_Port2		    0x461
#define EisaNMI_Software	    0x20	// Software Generated
#define EisaNMI_Bus		    0x40	// Bus Time Out
#define EisaNMI_FailSafe	    0x80	// Fail-Save Timer
#define EisaNMI_Software_Control    0x02	// Software Generated
#define EisaNMI_Bus_Control	    0x08	// Bus Time Out
#define EisaNMI_FailSafe_Control    0x04	// Fail-safe timer mask bit

#define EisaNMI_Ports_Mask	    0x3e0

// Message indexes
#define EisaNMINum_Software	5
#define EisaNMINum_Bus		6
#define EisaNMINum_FailSafe	7
#define EisaNMINum_IoChk	8
#define EisaNMINum_Parity	9

// the following constants are used by the WatchdoNMI handling

#define EISA_IT_ICOUNTL		0xFFFF		// lsb of count
#define EISA_IT_ICOUNTH		0xFFFF		// msb of count
#define EISA_IT_PERIOD		220		// period of nmi timer in milliseconds

#define EISA_IT2_C0_COUNT	0x48		// nmi timer count register
#define EISA_IT2_COMMAND	0x4b		// nmi timer command register

#define EISA_INVALID_SLOT	0x80
#define EISA_EMPTY_SLOT		0x83
#define EISA_FUNC_ENABLED	0x80
#define EISA_HAS_MEMORY 	0x02
#define EISA_MORE_ENTRIES	0x80
#define ESI_FLAG_RESERVED	0xC0
#define EFI_FUNC_FLAG_RESERVED	0x40
#define EISA_MEMORY_TYPE_MASK	0x18
