/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/


/********************  BidiHotKeys in BIDISTRUCT ****************************/
/*                                                                          */
/* The following defined value may be used to Enable/Disable the Bidi       */
/* keyboard hot keys.                                                       */
/* To enable a hot key, perform an 'OR' operation on the Bidi hot key flag  */
/* word in the KBVCBTYPE  structure with the required defined value.        */
/* To disable a hot key, perform an 'AND NOT' operation on the Bidi hot key */
/* flag word in the KBVCBTYPE  structure with the required defined value.   */
/*                                                                          */
/****************************************************************************/

#define BDHKFLAG_PUSH        0x0004
#define BDHKFLAG_END_PUSH    0x0008
#define BDHKFLAG_AUTO_PUSH   0x0010
#define BDHKFLAG_FIELD_REV   0x0020
#define BDHKFLAG_SCREEN_REV  0x0040
#define BDHKFLAG_BIDI_POPUP  0x0200
#define BDHKFLAG_AUTOMATIC   0x0400
#define BDHKFLAG_INITIAL     0x0800
#define BDHKFLAG_MIDDLE      0x1000
#define BDHKFLAG_FINAL       0x2000
#define BDHKFLAG_ISOLATED    0x4000

/*******************  Bidi Flags in BIDISTRUCT ******************************/
/*                                                                          */
/* The following defined value may be used to Enable/Disable the Bidi       */
/* functions.                                                               */
/* To enable a Bidi function, perform an 'OR' operation on the Bidi flags   */
/* word in the BDKBVCB  structure with the required defined value.          */
/* To disable a Bidi fuction, perform an 'AND NOT' operation on the Bidi    */
/* flags word in the BDKBVCB  structure with the required defined value.    */
/*                                                                          */
/****************************************************************************/

#define BDFLAG_AUTOPUSH_RTL  0x0001
#define BDFLAG_AUTOPUSH_LTR  0x0002
#define BDFLAG_PUSHLEVEL     0x0004
#define BDFLAG_LAYER         0x0010
#define BDFLAG_FIELD_REV     0x0020

/***********************  CSD in BIDIATT ************************************/
/*                                                                          */
/* The following defined value may be used to select the specified          */
/* bit in the Bidi Attributes.                                              */
/*                                                                          */
/****************************************************************************/

#define BDCSD_AUTOMATIC      0x00000000
#define BDCSD_PASSTHRU       0x00000001
#define BDCSD_BASE           0x00000010
#define BDCSD_INITIAL        0x00000011
#define BDCSD_MIDDLE         0x00000012
#define BDCSD_FINAL          0x00000013
#define BDCSD_ISOLATED       0x00000014
#define BDNUM_ARABIC         0x00000000
#define BDNUM_PASSTHRU       0x00001000
#define BDNUM_HINDU          0x00002000
#define BDORIENT_LTR         0x00000000
#define BDORIENT_RTL         0x00010000
#define BD_LEVEL             0x30000000
#define BD_SUPPORT           0x00000000


/********* the keyboard control block structure *********/
#pragma pack (2)
typedef struct  _bdkvcb   {
                             USHORT   BDLength;
                             USHORT   BDVersionId;
                             ULONG    BDAtts;
                             ULONG    Reserved;
                             USHORT   BDHotKeyFlags;
                             USHORT   BDFlags;
                             UCHAR    Reserved2[64];
                           } BDKVCB;


/******* the printer control block structure ************/
typedef struct  _bdprcb    {
                             USHORT   PRLength;
                             ULONG    PRAtts;
                             UCHAR    Reserved[14];
                           } BDPRCB;

/***** the Character Shape Determination structure *******/
typedef struct _csdrec
                           {
                             ULONG    RecLength;
                             PCHAR    Buffer;
                             ULONG    BufferLength;
                             ULONG    BufferIndex;
                           } CSDRec;
#pragma pack()

typedef   CSDRec far *       PCSDRec;
typedef   PBYTE              PRETINFO;
typedef   PBYTE              PSETINFO;


#ifdef INCL_16

#define NlsQueryBidiAtt Nls16QueryBidiAtt
 extern USHORT APIENTRY _loadds NlsQueryBidiAtt (    LONG       Effect,
                                                     PRETINFO   RetInfo);

#define NlsSetBidiAtt Nls16SetBidiAtt
 extern USHORT APIENTRY _loadds NlsSetBidiAtt (      LONG       Effect,
                                                     PSETINFO   SetInfo);

#define NlsShapeBidiString Nls16ShapeBidiString
 extern USHORT APIENTRY _loadds NlsShapeBidiString ( ULONG      BidiAtts,
                                                     ULONG      Reserved,
                                                     PCHAR      Source  ,
                                                     PCHAR      Target  ,
                                                     ULONG      Length  ,
                                                     ULONG      Increment);

#define NlsEditShape Nls16EditShape
 extern USHORT APIENTRY _loadds NlsEditShape (       ULONG      BidiAtts,
                                                     LONG       Effect,
                                                     PCSDRec    Source,
                                                     PCSDRec    Target,
                                                     PULONG     CSDState,
                                                     ULONG      Increment);

#define NlsInverseString Nls16InverseString
 extern USHORT APIENTRY _loadds  NlsInverseString(   PCHAR      Source,
                                                     PCHAR      Target,
                                                     ULONG      Length,
                                                     ULONG      Increment);

#define NlsConvertBidiNumerics Nls16ConvertBidiNumerics
 extern USHORT APIENTRY _loadds NlsConvertBidiNumerics ( ULONG  BidiAtts,
                                                         LONG   Reserved,
                                                         PUCHAR Source,
                                                         PUCHAR Target,
                                                         ULONG  Length,
                                                         ULONG  Increment);

#define NlsSetBidiPrint Nls16SetBidiPrint
 extern USHORT APIENTRY _loadds NlsSetBidiPrint (        ULONG  BidiAtts,
                                                         ULONG  Length,
                                                         USHORT FileHandle);

#define NlsConvertBidiString Nls16ConvertBidiString
 extern USHORT APIENTRY _loadds NlsConvertBidiString (   PUCHAR Source,
                                                         PUCHAR Target,
                                                         ULONG  Length,
                                                         ULONG  Increment,
                                                         ULONG  SBidiAtts,
                                                         ULONG  TBidiAtts,
                                                         ULONG  Reserved);
#endif /* #ifdef endif */
