/*
 *	Copyright (C) 1993 IBM Corporation
 *
 *	DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample
 *	code created by IBM Corporation.  This sample code is not part of
 *	any standard or IBM product and is provided to you solely for the
 *	purpose of assisting you in the development of your applications.
 *	The code is provided "AS IS", without warranty of any kind.
 *	IBM shall not be liable for any damages arising out of your
 *	use of the sample code, even if they have been advised of the
 *	possibility of such damages.
 */

#define INCL_WIN
#include <os2.h>
#include <stdio.h>
#include <ctype.h>
#include <stdarg.h>
#include <string.h>
#include <io.h>


#define	FMTTBLSIZE	16
//#define	MAXLOGFILESIZE	65536L

#define	LOGFILE		"CLIENT.LOG"

#define	DATETIMEFMT	"%02d-%02d-%02d %02d:%02d:%02d.%02d"


static FILE	*logfp = NULL;

#ifdef	MAXLOGFILESIZE
static long	extraBytes = 0L;
#endif

static short	been_here = 0;

static char *DdeMsgText[] = {
	"WM_DDE_INITIATE",
	"WM_DDE_REQUEST",
	"WM_DDE_ACK",
	"WM_DDE_DATA",
	"WM_DDE_ADVISE",
	"WM_DDE_UNADVISE",
	"WM_DDE_POKE",
	"WM_DDE_EXECUTE",
	"WM_DDE_TERMINATE",
	"WM_DDE_INITIATEACK"
};

static	struct {
	USHORT	status;
	char	*text;
}	DdeStatusText[] = {
	{ DDE_FACK,		"DDE_FACK"	},
	{ DDE_FBUSY,		"DDE_FBUSY"	},
	{ DDE_FNODATA,		"DDE_FNODATA"	},
	{ DDE_FACKREQ,		"DDE_FACKREQ"	},
	{ DDE_FRESPONSE,	"DDE_FRESPONSE"	},
	{ DDE_NOTPROCESSED,	"DDE_NOTPROCESSED" },
	{ DDE_FRESERVED,	"DDE_FRESERVED"	}
};

static	struct {
	USHORT	usFormat;
	char	*text;
}	DdeFormatText[ FMTTBLSIZE ];

static	USHORT	ddeFormatCnt = 0;


#ifdef	MAXLOGFILESIZE
static void
wrapFile( size_t bytes )
{
#ifdef	OS2_1X
	int	logfd = fileno( logfp );
#else
	int	logfd = _fileno( logfp );
#endif
	char tmp[ 1024 ];
	
	if ( bytes < sizeof( tmp ) )
	{
	    fseek( logfp, MAXLOGFILESIZE, SEEK_SET );
	    bytes = fread( tmp, sizeof( char ), bytes, logfp );
	    rewind( logfp );
	    fwrite( tmp, sizeof( char ), bytes, logfp );
	}
	else
	    rewind( logfp );
#ifdef	OS2_1X
	chsize( logfd, MAXLOGFILESIZE );
#else
	_chsize( logfd, MAXLOGFILESIZE );
#endif
}
#endif


static char *
formatStatus( USHORT fsStatus )
{
	static char	tmp[ 256 ];
	register char	*bp = tmp;
	register int	i;
	USHORT		cnt = 0;

	sprintf( bp, "%d", fsStatus );

	for ( i = 0; i < sizeof(DdeStatusText)/sizeof(DdeStatusText[0]); i++ )
		if ( fsStatus & DdeStatusText[i].status )
		{
		    fsStatus &= ~DdeStatusText[i].status;
		    if ( cnt++ )
			bp += sprintf( bp, " | " );

		    bp += sprintf( bp, DdeStatusText[i].text );
		}   /* if */

	if ( fsStatus )
	    sprintf( bp, "%s0x%04X", cnt ? " | " : "", fsStatus );

	return tmp;
}


static char *
formatFormat( USHORT usFormat )
{
	static char szItemName[ 32 ];
	register int i;

	for ( i = 0; i < ddeFormatCnt; i++ )
		if ( DdeFormatText[i].usFormat == usFormat )
		    break;

	if ( i < ddeFormatCnt )
	    return ( DdeFormatText[i].text );
	else
	{
	    USHORT rc = WinQueryAtomName( WinQuerySystemAtomTable(),
					  (ATOM) usFormat,
					  szItemName, sizeof( szItemName ) );

	    if ( !rc )
		sprintf( szItemName, "%u", usFormat );
	    else
	    {
		szItemName[ rc ] = 0;

		if ( ddeFormatCnt < FMTTBLSIZE )
		{
		    DdeFormatText[ ddeFormatCnt ].text = strdup( szItemName );
		    if ( DdeFormatText[ ddeFormatCnt ].text != NULL )
		    {
			DdeFormatText[ ddeFormatCnt ].usFormat = usFormat;
			ddeFormatCnt++;
		    }
		}
	    }
	}

	return ( szItemName );
}


static void
dumpDdeData( PSZ data, ULONG datalen )
{
	register int	i;
	char		tmp[ 128 ];
	register char	*cp = &tmp[16], *cp1 = tmp;
	register PSZ	dp;

	for ( i = 0, dp = data; i < datalen; i++, dp++ )
	{
		if ( i % 16 == 0 && i )
		{
		    cp = &tmp[16], cp1 = tmp;

		    fprintf( logfp, "\t\t%*s|%.*s|  %s\n",
			     6, "", 16, tmp, &tmp[16] );
		}
		else if ( ( i % 4 ) == 0 && i )
		    *cp++ = ' ';

		if ( isprint( *dp ) )
		    *cp1++ = *dp;
		else
		    *cp1++ = '.';

		cp += sprintf( cp, "%02X", data[i] );
	}

	if ( cp1 != tmp )
	{
	    if ( i % 16 )
		memset( cp1, '_', 16 - ( i % 16 ) );
	    *cp = 0;
	    fprintf( logfp, "\t\t%*s|%.*s|  %s\n",
		     6, "", 16, tmp, &tmp[16] );
	}
}


void
DdeMsgLog( USHORT msg, HWND hwndDdeClient, void *param )
{
	PDDEINIT	pddei = (PDDEINIT) param;
	PDDESTRUCT	pddes = (PDDESTRUCT) param;
	DATETIME	tbuf;

	if ( msg < WM_DDE_FIRST || msg > WM_DDE_LAST )
	    return;

	if ( !been_here )
	{
	    been_here++;
	    logfp = fopen( LOGFILE, "w+b" );
	}

	if ( logfp == NULL )
	    return;

	DosGetDateTime( &tbuf );

	fprintf( logfp, DATETIMEFMT "  " "0x%04lX %s:\t",
		 tbuf.year % 100, tbuf.month, tbuf.day,
		 tbuf.hours, tbuf.minutes, tbuf.seconds, tbuf.hundredths,
		 (ULONG) hwndDdeClient, DdeMsgText[ msg - WM_DDE_FIRST ] );

	switch ( msg )
	{
	case WM_DDE_POKE:
	case WM_DDE_EXECUTE:
	case WM_DDE_DATA:
	    fprintf( logfp, "%lu, %s, %s, %s\n",
		     pddes->cbData,
		     formatStatus( pddes->fsStatus ),
		     formatFormat( pddes->usFormat ),
		     DDES_PSZITEMNAME( pddes ) );
	    if ( pddes->cbData )
		dumpDdeData( DDES_PABDATA( pddes ), pddes->cbData );
	    break;

	case WM_DDE_REQUEST:
	case WM_DDE_ADVISE:
	case WM_DDE_UNADVISE:
	case WM_DDE_ACK:
	    fprintf( logfp, "%lu, %s, %s, %.*s\n",
		     pddes->cbData,
		     formatStatus( pddes->fsStatus ),
		     formatFormat( pddes->usFormat ),
		     pddes->offabData - pddes->offszItemName,
		     DDES_PSZITEMNAME( pddes ) );
	    break;

	case WM_DDE_INITIATE:
	case WM_DDE_INITIATEACK:
	    fprintf( logfp, "%d, %s, %s\n",
		     pddei->cb, pddei->pszAppName, pddei->pszTopic );
	    break;

	case WM_DDE_TERMINATE:
	    fprintf( logfp, "\n" );
	    break;

	default:
	    break;
	}

	fflush( logfp );

#ifdef	MAXLOGFILESIZE
	if ( ( extraBytes = ftell( logfp ) - MAXLOGFILESIZE ) > 0 )
	    wrapFile( (size_t) extraBytes );
#endif
}
