/******************************************************************************
 * (C) COPYRIGHT International Business Machines Corp. 2000 - 2002
 *
 * 5724-D04
 *
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication, or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * Source File Name = sqlcli.h
 *
 * Function = Include File defining:
 *              DB2 CLI Interface - Constants
 *              DB2 CLI Interface - Data Structures
 *              DB2 CLI Interface - Function Prototypes
 *
 * Operating System = Common C Include File
 *
 *****************************************************************************/

#ifndef __clidll__
#ifdef UNDER_CE
#define __clidll__ __declspec(dllimport)
#else 
#define __clidll__
#endif // of under_ce
#endif // end of #ifndef __clidll__

#ifndef SQL_H_SQLCLI
#define SQL_H_SQLCLI            /* Permit duplicate Includes */


/* DB2CLI_VER            DB2 Call Level Interface Version Number (0x0210).
 *                       To revert to Version 1.0 definitions,
 *                       issue #define DB2CLI_VER 0x0110 before including
 *                       sqlcli.h and sqlcli1.h
 */

/* If DB2CLI_VER is not defined, assume version 2.10 */
#ifndef DB2CLI_VER
#define DB2CLI_VER 0x0310
#endif

#ifndef DB2E_C_VER
#define DB2E_C_VER 0x720F
#endif


#ifdef __cplusplus
extern "C" {
#endif

//#include <stdlib.h>

#include "sqlsystm.h"                  /* System dependent defines  */

#if defined(DB2WIN) || defined(DB2NT)
#include <windows.h>
#else
#ifndef FAR
#define FAR
#endif
#endif
#ifdef DB2OS2
#define INCL_WIN
#define INCL_DOS
/* #include <os2.h> */
#endif

#ifdef DB2MAC

/* #include <Quickdraw.h> */
typedef GrafPtr HWND;

#ifdef SQL_API
#undef SQL_API
#endif

#endif

#define SQL_API SQL_API_FN


/* generally useful constants */
//define  SQL_MAX_MESSAGE_LENGTH   1024 /* message buffer size             */
#define  SQL_MAX_MESSAGE_LENGTH   127 /* message buffer size             */
#define  SQL_MAX_ID_LENGTH        18   /* maximum identifier name size,
                                          e.g. cursor names               */

/* date/time length constants */
#define SQL_DATE_LEN           10
#define SQL_TIME_LEN            8  /* add P+1 if precision is nonzero */
#define SQL_TIMESTAMP_LEN      26  /* add P+1 if precision is nonzero */

/* handle type identifiers */
#define SQL_HANDLE_ENV             1
#define SQL_HANDLE_DBC             2
#define SQL_HANDLE_STMT            3
#define SQL_HANDLE_DESC            4

/* RETCODE values             */
#define  SQL_SUCCESS                        0
#define  SQL_SUCCESS_WITH_INFO              1
#define  SQL_NEED_DATA                      99
#define  SQL_NO_DATA                        100
#define  SQL_STILL_EXECUTING                2
#define  SQL_ERROR                          -1
#define  SQL_INVALID_HANDLE                 -2
#define  SQL_SUCCESS_WITH_VERSION_CONFLICT  4

/* test for SQL_SUCCESS or SQL_SUCCESS_WITH_INFO */
#define SQL_SUCCEEDED(rc) ((((rc)&(~1))==0) || ((rc)&(~4) == 0))

/* SQLFreeStmt option values  */
#define  SQL_CLOSE               0
#define  SQL_DROP                1
#define  SQL_UNBIND              2
#define  SQL_RESET_PARAMS        3

/* SQLTransact option values  */
#define  SQL_COMMIT              0
#define  SQL_ROLLBACK            1

/* Standard SQL data types */
#define  SQL_UNKNOWN_TYPE        0
#define  SQL_CHAR                1
#define  SQL_NUMERIC             2
#define  SQL_DECIMAL             3
#define  SQL_INTEGER             4
#define  SQL_SMALLINT            5
#define  SQL_FLOAT               6
#define  SQL_REAL                7
#define  SQL_DOUBLE              8
#define  SQL_DATETIME            9
#define  SQL_VARCHAR            12
//BA 1679
#define  SQL_WCHAR              (-8)
#define  SQL_WVARCHAR           (-9)
#define  SQL_WLONGVARCHAR       (-10)
//EA 1679
/* One-parameter shortcuts for date/time data types */
#define SQL_TYPE_DATE      91
#define SQL_TYPE_TIME      92
#define SQL_TYPE_TIMESTAMP 93

/* Statement attribute values for cursor sensitivity */
#define SQL_UNSPECIFIED     0
#define SQL_INSENSITIVE     1
#define SQL_SENSITIVE       2

/* Default conversion code for SQLBindCol(), SQLBindParam() and SQLGetData() */
#define SQL_DEFAULT        99

/* SQLGetData() code indicating that the application row descriptor
 * specifies the data type
 */
#define SQL_ARD_TYPE      (-99)

/* SQL date/time type subcodes */
#define SQL_CODE_DATE       1
#define SQL_CODE_TIME       2
#define SQL_CODE_TIMESTAMP  3

/* SQL extended data types */
#define  SQL_GRAPHIC            -95
#define  SQL_VARGRAPHIC         -96
#define  SQL_LONGVARGRAPHIC     -97
#define  SQL_BLOB               -98
#define  SQL_CLOB               -99
#define  SQL_DBCLOB             -350
#define  SQL_DATALINK           -400
#define  SQL_USER_DEFINED_TYPE  -450  //d1679

/* C data type to SQL data type mapping */
#define  SQL_C_DBCHAR         SQL_DBCLOB
#define  SQL_C_DECIMAL_IBM    SQL_DECIMAL
#define  SQL_C_DATALINK       SQL_C_CHAR
#define  SQL_C_PTR            2463		//d1679
/*
 *  locator type identifier
 */

#define SQL_BLOB_LOCATOR       31
#define SQL_CLOB_LOCATOR       41
#define SQL_DBCLOB_LOCATOR    -351

/*
 * C Data Type for the LOB locator types
 */
#define SQL_C_BLOB_LOCATOR     SQL_BLOB_LOCATOR
#define SQL_C_CLOB_LOCATOR     SQL_CLOB_LOCATOR
#define SQL_C_DBCLOB_LOCATOR   SQL_DBCLOB_LOCATOR

/*
 * NULL status defines; these are used in SQLColAttributes, SQLDescribeCol,
 * to describe the nullability of a column in a table.
 */

#define  SQL_NO_NULLS         0
#define  SQL_NULLABLE         1
#define  SQL_NULLABLE_UNKNOWN 2

/* values of UNNAMED field in descriptor used in SQLColAttribute */
#define SQL_NAMED             0
#define SQL_UNNAMED           1

/* values of ALLOC_TYPE field in descriptor */
#define SQL_DESC_ALLOC_AUTO 1
#define SQL_DESC_ALLOC_USER 2

/* Special length values  */
#define  SQL_NULL_DATA        -1
#define  SQL_DATA_AT_EXEC     -2
#define  SQL_NTS              -3      /* NTS = Null Terminated String    */
#define  SQL_NTSL             -3L     /* NTS = Null Terminated String    */

/* SQLColAttributes defines */
#define  SQL_COLUMN_SCHEMA_NAME      16
#define  SQL_COLUMN_CATALOG_NAME     17
#define  SQL_COLUMN_DISTINCT_TYPE    1250
#define  SQL_DESC_DISTINCT_TYPE      SQL_COLUMN_DISTINCT_TYPE
#define  SQL_COLUMN_REFERENCE_TYPE   1251
#define  SQL_DESC_REFERENCE_TYPE     SQL_COLUMN_REFERENCE_TYPE

/* identifiers of fields in the SQL descriptor */
#define SQL_DESC_COUNT                  1001
#define SQL_DESC_TYPE                   1002
#define SQL_DESC_LENGTH                 1003
#define SQL_DESC_OCTET_LENGTH_PTR       1004
#define SQL_DESC_PRECISION              1005
#define SQL_DESC_SCALE                  1006
#define SQL_DESC_DATETIME_INTERVAL_CODE 1007
#define SQL_DESC_NULLABLE               1008
#define SQL_DESC_INDICATOR_PTR          1009
#define SQL_DESC_DATA_PTR               1010
#define SQL_DESC_NAME                   1011
#define SQL_DESC_UNNAMED                1012
#define SQL_DESC_OCTET_LENGTH           1013
#define SQL_DESC_ALLOC_TYPE             1099


/* SQLColAttribute defines for SQL_COLUMN_UPDATABLE condition */
#define  SQL_UPDT_READONLY            0
#define  SQL_UPDT_WRITE               1
#define  SQL_UPDT_READWRITE_UNKNOWN   2

/*
 * SQLColAttribute defines for SQL_COLUMN_SEARCHABLE condition.
 */
#define  SQL_PRED_NONE         0
#define  SQL_PRED_CHAR         1
#define  SQL_PRED_BASIC        2

/* NULL handle defines    */
#define  SQL_NULL_HENV                0L
#define  SQL_NULL_HDBC                0L
#define  SQL_NULL_HSTMT               0L
#define  SQL_NULL_HDESC               0L
#define  SQL_NULL_HANDLE              0L

/* identifiers of fields in the diagnostics area */
#define SQL_DIAG_RETURNCODE        1
#define SQL_DIAG_NUMBER            2
#define SQL_DIAG_ROW_COUNT         3
#define SQL_DIAG_SQLSTATE          4
#define SQL_DIAG_NATIVE            5
#define SQL_DIAG_MESSAGE_TEXT      6
#define SQL_DIAG_DYNAMIC_FUNCTION  7
#define SQL_DIAG_CLASS_ORIGIN      8
#define SQL_DIAG_SUBCLASS_ORIGIN   9
#define SQL_DIAG_CONNECTION_NAME  10
#define SQL_DIAG_SERVER_NAME      11
#define SQL_DIAG_DYNAMIC_FUNCTION_CODE 12

/* dynamic function codes */
#define SQL_DIAG_ALTER_TABLE            4
#define SQL_DIAG_CREATE_INDEX          (-1)
#define SQL_DIAG_CREATE_TABLE          77
#define SQL_DIAG_CREATE_VIEW           84
#define SQL_DIAG_DELETE_WHERE          19
#define SQL_DIAG_DROP_INDEX            (-2)
#define SQL_DIAG_DROP_TABLE            32
#define SQL_DIAG_DROP_VIEW             36
#define SQL_DIAG_DYNAMIC_DELETE_CURSOR 38
#define SQL_DIAG_DYNAMIC_UPDATE_CURSOR 81
#define SQL_DIAG_GRANT                 48
#define SQL_DIAG_INSERT                50
#define SQL_DIAG_REVOKE                59
#define SQL_DIAG_SELECT_CURSOR         85
#define SQL_DIAG_UNKNOWN_STATEMENT      0
#define SQL_DIAG_UPDATE_WHERE          82

/*
 *  IBM specific SQLGetDiagField values.
 */

#define SQL_DIAG_DEFERRED_PREPARE_ERROR   1279

/* SQL_DIAG_ROW_NUMBER values */
#define SQL_ROW_NO_ROW_NUMBER                   (-1)
#define SQL_ROW_NUMBER_UNKNOWN                  (-2)

/* SQL_DIAG_COLUMN_NUMBER values */
#define SQL_COLUMN_NO_COLUMN_NUMBER             (-1)
#define SQL_COLUMN_NUMBER_UNKNOWN               (-2)

/*
 * The following are provided to enhance portability and compatibility
 * with ODBC
 */

#if !defined(DB2OS2) && !defined(UNDER_ZR)
typedef           unsigned char         UCHAR;
typedef  unsigned long                  ULONG;
typedef  unsigned short                 USHORT;
#endif

typedef           signed   char         SCHAR;
typedef           long     int          SDWORD;
typedef           short    int          SWORD;
typedef  unsigned long     int          UDWORD;
typedef  unsigned short    int          UWORD;
typedef                    double       SDOUBLE;
typedef                    float        SFLOAT;
typedef  unsigned          char         SQLDATE;
typedef  unsigned          char         SQLTIME;
typedef  unsigned          char         SQLTIMESTAMP;
typedef  unsigned          char         SQLDECIMAL;
typedef  unsigned          char         SQLNUMERIC;

typedef  signed   long                  SLONG;
typedef  signed   short                 SSHORT;


#if defined(WINDOWS)
typedef  long     double                LDOUBLE;
#else
typedef           double                LDOUBLE;
#endif

#if !defined(UNDER_ZR)
  typedef void FAR *         PTR;
#endif
typedef void FAR *         HENV;
typedef void FAR *         HDBC;
typedef void FAR *         HSTMT;

typedef signed short       RETCODE;



/* SQL portable types for C  */
typedef  UCHAR             SQLCHAR;
typedef  UCHAR             SQLVARCHAR;
typedef  SCHAR             SQLSCHAR;
typedef  SDWORD            SQLINTEGER;
typedef  SWORD             SQLSMALLINT;
typedef  SDOUBLE           SQLDOUBLE;
typedef  SDOUBLE           SQLFLOAT;
typedef  SFLOAT            SQLREAL;

typedef  SQLSMALLINT       SQLRETURN;

#if (DB2CLI_VER >= 0x0200)
typedef  UDWORD            SQLUINTEGER;
typedef  UWORD             SQLUSMALLINT;
#else
typedef  SQLINTEGER        SQLUINTEGER;
typedef  SQLSMALLINT       SQLUSMALLINT;
#endif

typedef  PTR               SQLPOINTER;

/*
 * Double Byte Character Set support
 */
//BA1679
#ifdef UNICODE
#undef SQL_WCHART_CONVERT
#endif

#ifdef SQL_WCHART_CONVERT
typedef  wchar_t           SQLDBCHAR;
#else
typedef  unsigned short    SQLDBCHAR;
#endif

#ifdef DB2WIN
typedef  wchar_t           SQLWCHAR;
#else
typedef  unsigned short    SQLWCHAR;
#endif
//EA1679
/*
#ifdef SQL_WCHART_CONVERT
typedef  wchar_t           SQLDBCHAR;
typedef  wchar_t           SQLWCHAR;
#else
typedef  unsigned short    SQLDBCHAR;
typedef  unsigned short    SQLWCHAR;
#endif

#ifdef UNICODE
typedef SQLWCHAR        SQLTCHAR;
#else
typedef SQLCHAR         SQLTCHAR;
#endif  //
*/

#ifdef DB2WIN

typedef  SQLINTEGER        SQLHANDLE;
/*
typedef  HENV              SQLHENV;
typedef  HDBC              SQLHDBC;
typedef  HSTMT             SQLHSTMT;
*/
typedef  SQLINTEGER        SQLHENV;
typedef  SQLINTEGER        SQLHDBC;
typedef  SQLINTEGER        SQLHSTMT;
typedef  HWND              SQLHWND;

#else

#ifndef __SQLTYPES
typedef  SQLINTEGER        SQLHANDLE;
typedef  SQLINTEGER        SQLHENV;
typedef  SQLINTEGER        SQLHDBC;
typedef  SQLINTEGER        SQLHSTMT;
#endif

#if defined(DB2OS2) || defined (DB2WIN) || defined (DB2NT) || defined(DB2MAC)
typedef  HWND              SQLHWND;
#else
typedef  SQLPOINTER        SQLHWND;
#endif

#endif
typedef  SQLHANDLE         SQLHDESC;

#ifndef __SQLTYPES

/*
 * SQL_NO_NATIVE_BIGINT_SUPPORT and SQL_BIGINT_TYPE are defined in sqlsystm.h
 *
 */

#if defined(SQL_NO_NATIVE_BIGINT_SUPPORT)
typedef struct
{
        SQLUINTEGER dwLowWord;
        SQLINTEGER  dwHighWord;
} SQLBIGINT;
typedef struct
{
        SQLUINTEGER dwLowWord;
        SQLUINTEGER dwHighWord;
} SQLUBIGINT;
#elif defined(SQL_BIGINT_TYPE)
typedef  SQL_BIGINT_TYPE   SQLBIGINT;
typedef  unsigned SQL_BIGINT_TYPE  SQLUBIGINT;
#endif

typedef  struct DATE_STRUCT
  {
    SQLSMALLINT    year;
    SQLUSMALLINT   month;
    SQLUSMALLINT   day;
  } DATE_STRUCT;

typedef DATE_STRUCT SQL_DATE_STRUCT;

typedef  struct TIME_STRUCT
  {
    SQLUSMALLINT   hour;
    SQLUSMALLINT   minute;
    SQLUSMALLINT   second;
  } TIME_STRUCT;

typedef TIME_STRUCT SQL_TIME_STRUCT;

typedef  struct TIMESTAMP_STRUCT
  {
    SQLSMALLINT    year;
    SQLUSMALLINT   month;
    SQLUSMALLINT   day;
    SQLUSMALLINT   hour;
    SQLUSMALLINT   minute;
    SQLUSMALLINT   second;
    SQLUINTEGER    fraction;     /* fraction of a second */
  } TIMESTAMP_STRUCT;


typedef TIMESTAMP_STRUCT SQL_TIMESTAMP_STRUCT;

typedef enum
{
        SQL_IS_YEAR                                             = 1,
        SQL_IS_MONTH                                    = 2,
        SQL_IS_DAY                                              = 3,
        SQL_IS_HOUR                                             = 4,
        SQL_IS_MINUTE                                   = 5,
        SQL_IS_SECOND                                   = 6,
        SQL_IS_YEAR_TO_MONTH                    = 7,
        SQL_IS_DAY_TO_HOUR                              = 8,
        SQL_IS_DAY_TO_MINUTE                    = 9,
        SQL_IS_DAY_TO_SECOND                    = 10,
        SQL_IS_HOUR_TO_MINUTE                   = 11,
        SQL_IS_HOUR_TO_SECOND                   = 12,
        SQL_IS_MINUTE_TO_SECOND                 = 13
} SQLINTERVAL;

typedef struct tagSQL_YEAR_MONTH
{
                SQLUINTEGER             year;
                SQLUINTEGER             month;
} SQL_YEAR_MONTH_STRUCT;

typedef struct tagSQL_DAY_SECOND
{
                SQLUINTEGER             day;
                SQLUINTEGER             hour;
                SQLUINTEGER             minute;
                SQLUINTEGER             second;
                SQLUINTEGER             fraction;
} SQL_DAY_SECOND_STRUCT;

typedef struct tagSQL_INTERVAL_STRUCT
{
        SQLINTERVAL             interval_type;
        SQLSMALLINT             interval_sign;
        union {
                SQL_YEAR_MONTH_STRUCT           year_month;
                SQL_DAY_SECOND_STRUCT           day_second;
        } intval;

} SQL_INTERVAL_STRUCT;

/* internal representation of numeric data type */
#define SQL_MAX_NUMERIC_LEN             16
typedef struct tagSQL_NUMERIC_STRUCT
{
        SQLCHAR         precision;
        SQLSCHAR        scale;
        SQLCHAR         sign;   /* 1 if positive, 0 if negative */
        SQLCHAR         val[SQL_MAX_NUMERIC_LEN];
} SQL_NUMERIC_STRUCT;

#endif

/* Core Function Prototypes  */

#ifndef DB2E_ENGINE  // do not define this macro in application programs.
#define SQLAllocConnect(a,b) SQLAllocConnectVer(a,b,DB2E_C_VER)
#define SQLAllocEnv(a) SQLAllocEnvVer(a,DB2E_C_VER)
#define SQLAllocStmt(a,b) SQLAllocStmtVer(a,b,DB2E_C_VER)
#define SQLAllocHandle(a,b,c) SQLAllocHandleVer(a,b,c,DB2E_C_VER)
#endif

__clidll__ 
SQLRETURN SQL_API_FN  SQLAllocConnectVer  (SQLHENV           henv,
										   SQLHDBC     FAR   *phdbc,
										   SQLINTEGER version);

__clidll__ 
SQLRETURN SQL_API_FN  SQLAllocEnvVer      (SQLHENV     FAR   *phenv,
										   SQLINTEGER version);

__clidll__ 
SQLRETURN SQL_API_FN  SQLAllocStmtVer     (SQLHDBC           hdbc,
										   SQLHSTMT    FAR   *phstmt,
										   SQLINTEGER version);

__clidll__ 
SQLRETURN SQL_API_FN SQLAllocHandleVer(    SQLSMALLINT fHandleType,
										   SQLHANDLE hInput,
										   SQLHANDLE * phOutput,
										   SQLINTEGER version);
__clidll__ 
SQLRETURN SQL_API_FN  SQLBindCol       (SQLHSTMT          hstmt,
                                        SQLUSMALLINT      icol,
                                        SQLSMALLINT       fCType,
                                        SQLPOINTER        rgbValue,
                                        SQLINTEGER        cbValueMax,
                                        SQLINTEGER  FAR   *pcbValue);

__clidll__ 
SQLRETURN SQL_API SQLBindParameter(
    									SQLHSTMT           hstmt,
    									SQLUSMALLINT       ipar,
    									SQLSMALLINT        fParamType,
    									SQLSMALLINT        fCType,
    									SQLSMALLINT        fSqlType,
    									SQLUINTEGER        cbColDef,
    									SQLSMALLINT        ibScale,
    									SQLPOINTER         rgbValue,
    									SQLINTEGER         cbValueMax,
    									SQLINTEGER 		  *pcbValue);

__clidll__ 
SQLRETURN SQL_API_FN  SQLCancel        (SQLHSTMT          hstmt);

__clidll__ 
SQLRETURN SQL_API_FN  SQLColAttribute  (SQLHSTMT          hstmt,
                                        SQLUSMALLINT      icol,
                                        SQLUSMALLINT      fDescType,
                                        SQLPOINTER        rgbDesc,
                                        SQLSMALLINT       cbDescMax,
                                        SQLSMALLINT FAR   *pcbDesc,
                                        SQLPOINTER         pfDesc);

__clidll__ 
SQLRETURN SQL_API_FN  SQLConnect       (SQLHDBC           hdbc,
                                        SQLCHAR     FAR   *szDSN,
                                        SQLSMALLINT       cbDSN,
                                        SQLCHAR     FAR   *szUID,
                                        SQLSMALLINT       cbUID,
                                        SQLCHAR     FAR   *szAuthStr,
                                        SQLSMALLINT       cbAuthStr);

__clidll__ 
SQLRETURN SQL_API_FN  SQLDescribeCol   (SQLHSTMT          hstmt,
                                        SQLUSMALLINT      icol,
                                        SQLCHAR     FAR   *szColName,
                                        SQLSMALLINT       cbColNameMax,
                                        SQLSMALLINT FAR   *pcbColName,
                                        SQLSMALLINT FAR   *pfSqlType,
                                        SQLUINTEGER FAR   *pcbColDef,
                                        SQLSMALLINT FAR   *pibScale,
                                        SQLSMALLINT FAR   *pfNullable);

__clidll__ 
SQLRETURN SQL_API_FN  SQLDisconnect    (SQLHDBC           hdbc);

__clidll__ 
SQLRETURN SQL_API_FN  SQLError         (SQLHENV           henv,
                                        SQLHDBC           hdbc,
                                        SQLHSTMT          hstmt,
                                        SQLCHAR     FAR   *szSqlState,
                                        SQLINTEGER  FAR   *pfNativeError,
                                        SQLCHAR     FAR   *szErrorMsg,
                                        SQLSMALLINT       cbErrorMsgMax,
                                        SQLSMALLINT FAR   *pcbErrorMsg);

__clidll__ 
SQLRETURN SQL_API_FN  SQLExecDirect    (SQLHSTMT          hstmt,
                                        SQLCHAR     FAR   *szSqlStr,
                                        SQLINTEGER        cbSqlStr);

__clidll__ 
SQLRETURN SQL_API_FN  SQLExecute       (SQLHSTMT          hstmt);

__clidll__ 
SQLRETURN SQL_API_FN  SQLFetch         (SQLHSTMT          hstmt);

__clidll__ 
SQLRETURN SQL_API_FN  SQLFreeConnect   (SQLHDBC           hdbc);

__clidll__ 
SQLRETURN SQL_API_FN  SQLFreeEnv       (SQLHENV           henv);

__clidll__ 
SQLRETURN SQL_API_FN  SQLFreeStmt      (SQLHSTMT          hstmt,
                                        SQLUSMALLINT      fOption);

__clidll__ 
SQLRETURN SQL_API_FN SQLCloseCursor(    SQLHSTMT hStmt );

__clidll__ 
SQLRETURN SQL_API_FN  SQLGetCursorName (SQLHSTMT          hstmt,
                                        SQLCHAR     FAR   *szCursor,
                                        SQLSMALLINT       cbCursorMax,
                                        SQLSMALLINT FAR   *pcbCursor);

__clidll__ 
SQLRETURN SQL_API_FN  SQLGetData       (SQLHSTMT          hstmt,
                                        SQLUSMALLINT      icol,
                                        SQLSMALLINT       fCType,
                                        SQLPOINTER        rgbValue,
                                        SQLINTEGER        cbValueMax,
                                        SQLINTEGER  FAR   *pcbValue);

__clidll__ 
SQLRETURN SQL_API_FN  SQLNumResultCols (SQLHSTMT          hstmt,
                                        SQLSMALLINT FAR   *pccol);

__clidll__ 
SQLRETURN SQL_API_FN  SQLPrepare       (SQLHSTMT          hstmt,
                                        SQLCHAR     FAR   *szSqlStr,
                                        SQLINTEGER        cbSqlStr);

__clidll__ 
SQLRETURN SQL_API_FN  SQLRowCount      (SQLHSTMT          hstmt,
                                        SQLINTEGER  FAR   *pcrow);

__clidll__ 
SQLRETURN SQL_API_FN  SQLSetCursorName (SQLHSTMT          hstmt,
                                        SQLCHAR     FAR   *szCursor,
                                        SQLSMALLINT       cbCursor);

__clidll__ 
SQLRETURN SQL_API_FN  SQLSetParam      (SQLHSTMT          hstmt,
                                        SQLUSMALLINT      ipar,
                                        SQLSMALLINT       fCType,
                                        SQLSMALLINT       fSqlType,
                                        SQLUINTEGER       cbParamDef,
                                        SQLSMALLINT       ibScale,
                                        SQLPOINTER        rgbValue,
                                        SQLINTEGER  FAR   *pcbValue);

__clidll__ 
SQLRETURN SQL_API_FN  SQLTransact      (SQLHENV           henv,
                                        SQLHDBC           hdbc,
                                        SQLUSMALLINT      fType);

__clidll__ 
SQLRETURN SQL_API_FN SQLEndTran(        SQLSMALLINT fHandleType,
                                        SQLHANDLE hHandle,
                                        SQLSMALLINT fType );

__clidll__ 
SQLRETURN SQL_API_FN SQLFreeHandle(     SQLSMALLINT fHandleType,
                                        SQLHANDLE hHandle );

__clidll__ 
SQLRETURN SQL_API_FN SQLGetDiagRec(     SQLSMALLINT fHandleType,
                                        SQLHANDLE hHandle,
                                        SQLSMALLINT iRecNumber,
                                        SQLCHAR * pszSqlState,
                                        SQLINTEGER * pfNativeError,
                                        SQLCHAR * pszErrorMsg,
                                        SQLSMALLINT cbErrorMsgMax,
                                        SQLSMALLINT * pcbErrorMsg );

__clidll__ 
SQLRETURN SQL_API_FN SQLGetDiagField(   SQLSMALLINT fHandleType,
                                        SQLHANDLE hHandle,
                                        SQLSMALLINT iRecNumber,
                                        SQLSMALLINT fDiagIdentifier,
                                        SQLPOINTER pDiagInfo,
                                        SQLSMALLINT cbDiagInfoMax,
                                        SQLSMALLINT * pcbDiagInfo );

__clidll__ 
SQLRETURN  SQL_API_FN SQLCopyDesc(      SQLHDESC hDescSource,
                                        SQLHDESC hDescTarget );

__clidll__ 
SQLRETURN  SQL_API_FN SQLGetDescField(SQLHDESC DescriptorHandle,
           SQLSMALLINT RecNumber, SQLSMALLINT FieldIdentifier,
           SQLPOINTER Value, SQLINTEGER BufferLength,
           SQLINTEGER *StringLength);

__clidll__ 
SQLRETURN  SQL_API_FN SQLGetDescRec(SQLHDESC DescriptorHandle,
           SQLSMALLINT RecNumber, SQLCHAR *Name,
           SQLSMALLINT BufferLength, SQLSMALLINT *StringLength,
           SQLSMALLINT *Type, SQLSMALLINT *SubType,
           SQLINTEGER *Length, SQLSMALLINT *Precision,
           SQLSMALLINT *Scale, SQLSMALLINT *Nullable);

__clidll__ 
SQLRETURN  SQL_API_FN SQLSetDescField(SQLHDESC DescriptorHandle,
           SQLSMALLINT RecNumber, SQLSMALLINT FieldIdentifier,
           SQLPOINTER Value, SQLINTEGER BufferLength);

__clidll__ 
SQLRETURN  SQL_API_FN SQLSetDescRec(SQLHDESC DescriptorHandle,
           SQLSMALLINT RecNumber, SQLSMALLINT Type,
           SQLSMALLINT SubType, SQLINTEGER Length,
           SQLSMALLINT Precision, SQLSMALLINT Scale,
           SQLPOINTER Data, SQLINTEGER *StringLength,
           SQLINTEGER *Indicator);


__clidll__ 
SQLRETURN SQL_API_FN  SQLSetStmtAttr   (SQLHSTMT          hstmt,
                                        SQLINTEGER        fOption,
                                        SQLPOINTER        pvParam,
                                        SQLINTEGER       fStrLen);
//f728 mhsing
__clidll__ 
SQLRETURN SQL_API_FN  SQLFetchScroll	(SQLHSTMT		hstmt,
										 SQLSMALLINT	fOrientation,
										 SQLINTEGER		nFetchOffset);

//f751 mhsing
__clidll__ 
SQLRETURN SQL_API SQLPrimaryKeys(
    SQLHSTMT		      hstmt,
    SQLCHAR 		FAR   *szCatalogName,
    SQLSMALLINT           cbCatalogName,
    SQLCHAR 		FAR   *szSchemaName,
    SQLSMALLINT           cbSchemaName,
    SQLCHAR 		FAR   *szTableName,
    SQLSMALLINT           cbTableName);

__clidll__ 
SQLRETURN SQL_API SQLForeignKeys(
    SQLHSTMT			   hstmt,
    SQLCHAR         FAR    *szPkCatalogName,
    SQLSMALLINT            cbPkCatalogName,
    SQLCHAR         FAR    *szPkSchemaName,
    SQLSMALLINT            cbPkSchemaName,
    SQLCHAR         FAR    *szPkTableName,
    SQLSMALLINT            cbPkTableName,
    SQLCHAR         FAR    *szFkCatalogName,
    SQLSMALLINT            cbFkCatalogName,
    SQLCHAR         FAR    *szFkSchemaName,
    SQLSMALLINT            cbFkSchemaName,
    SQLCHAR         FAR    *szFkTableName,
    SQLSMALLINT            cbFkTableName);


#ifdef __cplusplus
}
#endif

/*
 * Include ODBC header files for
 * functions that are not specified in the X/Open Call Level Interface.
 * This is included with permission from Microsoft.
 * Do not modify (i.e. must not add, remove, rearrange) any part of the
 * contents of sqlext.h
 * Note: SQLDrivers is not supported by DB2 CLI.
 */
#ifndef __SQL
#define __SQL
#define ODBCVER 0x0300
#endif
#if !defined(WINDOWS) && !defined(WIN32) && !defined(SQLWIN) && !defined(SQLWINT)
typedef signed char *      LPWSTR;
typedef long     int       DWORD;
#ifndef VOID
#define VOID void
#endif
#endif
#include "sqlext.h"
#include "sqlcli1.h"

#endif /* SQL_H_SQLCLI */
