/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VFUSR.C
 *
 * DESCRIPTIVE NAME = Virtual Floppy Device Driver User-event Processing
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS     VFExit
 *               VFCreate
 *               VFCreateNoSupport
 *               VFTerminate
 *
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "vfdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif
#pragma  BEGIN_GLOBAL_DATA
extern HVDM hvdmFloppyOwner;                            /* VDM handle of
                                                           floppy owner     */
extern FLAGS flFloppy;                                  /* floppy flags     */

extern HVDD hVDDVPIC;                                   /* @VD1535          */
                                                    /* VDDtoVdd comm to VPIC
                                                       Mask/Unmask IRQ6     */
extern HVDHSEM hsemFloppyOwnership;                     /* Block simultaneous
                                                           VDMs             */
                                                        /* @VD1535          */
extern VDHSEMSTATE semStateOwned;                       /* Data area fro
                                                           sem info
                                                           deadlock         */
                                                        /* @V9819           */

#pragma  END_GLOBAL_DATA
#pragma  BEGIN_SWAP_DATA
extern HHOOK hhookvirrWaitPFD;                          /* VIRR hook handle
                                                           for waiting PFD  */
extern IOH iotFDPort;                                   /* port hook
                                                           structure        */

#ifndef  NOMOTORTRAP
extern IOH iotFDPortDO;                                 /* pork hook for
                                                           digital output
                                                           reg.             */
#endif
extern IOH iotFDPortNoSupport;                          /* port hook for no
                                                           PFD support      */
extern HIRQ hirq;                                       /* floppy IRQ handle*/
                                                        /* @VD1535          */
#pragma  END_SWAP_DATA
#pragma  BEGIN_INSTANCE_DATA
extern HFILE DeviceHandle;                              /* @VD1535          */
                                                        /* Handle to be used
                                                           w/. DevIOCTL     */
/* DevIOCTL parms */

extern SUSPENDRESTARTPARM SuspendRestartParmPacket;     /* @VD1535          */
extern ULONG LengthParm,LengthData;                     /* @VD1535          */
extern ULONG ActionTaken;                               /* @VD1535          */
extern CHAR FileName[];                                 /* @VD1535          */
extern HHOOK hhookctxtMotorResume;                      /* @VD1535          */
                                                        /* Hook to call
                                                           Resume from Task */
                                                        /* time             */
                                                        /* @V3516          */
#pragma  END_INSTANCE_DATA
#pragma  BEGIN_SWAP_INSTANCE
extern HVDM hvdmThisVDM;                                /* VDM handle       */
extern HHOOK hhookvirrWaitInUse;                        /* VIRR hook handle
                                                           for waiting
                                                           InUse            */
#pragma  END_SWAP_INSTANCE
#pragma  BEGIN_SWAP_CODE

/****************************************************************************
 *
 * FUNCTION NAME = VFExit
 *
 * DESCRIPTION   =
 *
 *  EP  VFExit() - VFD exit handler
 *
 *  This registered subroutine is called when MVDM is going to shut
 *  down.  This allows the VDD to clean up resources that it has
 *  allocated.
 *  (see VDHInstallUserHook for complete semantics).
 *
 *  ENTRY
 *      None
 *  EXIT
 *      returns TRUE
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      Init-time
 *      VDM Task-time
 *
 *  PCODE
 *      if register with PFLPY
 *          call PFLPY to do de-registration;
 *      endif
 *
 * INPUT         = (VOID)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

BOOL HOOKENTRY VFExit(VOID)
{
  PRINTTRACE("VFExit: de-register with PFD.\n");
  return  TRUE;
}                                                       /* VFExit           */

/****************************************************************************
 *
 * FUNCTION NAME = VFCreate
 *
 * DESCRIPTION   =
 *
 *  EP  VFCreate() - VDM creation notification
 *
 *  This registered subroutine is called each time a new VDM is created
 *  (see VDHInstallUserHook for complete semantics).
 *
 *  ENTRY
 *      hvdm -> new VDM
 *  EXIT
 *      SUCCESS
 *          TRUE
 *      FAILURE
 *          FALSE
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      VDM Task-time
 *
 *  PCODE
 *      store vdm handle for this vdm;
 *      define I/O port hooks;
 *      allocate wait virr hooks;
 *
 * INPUT         = (HVDM hvdm)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

BOOL HOOKENTRY VFCreate(HVDM hvdm)
{
  hvdmThisVDM = hvdm;

  if (

#ifdef   NOMOTORTRAP
       (VDHInstallIOHook(hvdm,
                         PORT_STATUSA,
                         8,                             /* 8 ports          */
                         &iotFDPort,
                         !VDH_ASM_HOOK) == 0) ||

#else
       (VDHInstallIOHook(hvdm,
                         PORT_STATUSA,
                         2,                            /* statusA and statusB */
                         &iotFDPort,
                         !VDH_ASM_HOOK) == 0) ||
       (VDHInstallIOHook(hvdm,
                         PORT_DIGITALOUT,
                         1,
                         &iotFDPortDO,
                         !VDH_ASM_HOOK) == 0) ||
       ( VDHInstallIOHook (hvdm,
                           PORT_FDCSTATUS,
                           4,
                           &iotFDPort,
                           !VDH_ASM_HOOK) == 0) ||
#endif
       ((hhookvirrWaitInUse = VDHAllocHook(VDH_WAITVIRRS_HOOK,
                                           VFWaitInUse,
                                           sizeof(HVDM))) == NULL)
   )                                                      /* end if */
                                                          /* @VD1535    ||   */
    return  FALSE;
  *(PHVDM)VDHQueryHookData(hhookvirrWaitInUse) = NO_VDM;  /* @V3987          */
  REFHVDM(hvdm,
          HHOOK,
          hhookctxtMotorResume) = VDHAllocHook(VDH_CONTEXT_HOOK,
                                               VFVDDResume,
                                               sizeof(HVDM));  /* @V3516    */

  if (hVDDVPIC == NULL)                          /* Get handle for VDDtoVDD */ /* @VD1535 */
      hVDDVPIC = VDHOpenVDD(VPIC_NAME);

  VDHRequestVDD(hVDDVPIC,
                CURRENT_VDM,
                2,
                NULL,
                NULL);                                  /* @VD1535          */
                                                        /* Initially mask off
                                                           IRQ6 for VDM     */
  return  TRUE;
}                                                       /* VFCreate         */

/****************************************************************************
 *
 * FUNCTION NAME = VFCreateNoSupport
 *
 * DESCRIPTION   =
 *
 *  EP  VFCreateNoSupport() - VDM creation notification
 *
 *  This registered subroutine is called only when there is no PFLPY
 *  support each time a new VDM is created.
 *  (see VDHInstallUserHook for complete semantics).
 *
 *  ENTRY
 *      hvdm -> new VDM
 *  EXIT
 *      SUCCESS
 *          TRUE
 *      FAILURE
 *          FALSE
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      VDM Task-time
 *
 *  PCODE
 *      define I/O port hooks;
 *
 * INPUT         = (HVDM hvdm)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

BOOL HOOKENTRY VFCreateNoSupport(HVDM hvdm)
{

  if ((VDHInstallIOHook(hvdm,
                        PORT_STATUSA,
                        8,                              /* 8 ports          */
                        &iotFDPortNoSupport,
                        !VDH_ASM_HOOK) == 0))
    return  FALSE;
  return  TRUE;
}
                                                        /* VFCreateNoSupport*/

/****************************************************************************
 *
 * FUNCTION NAME = VFTerminate
 *
 * DESCRIPTION   =
 *
 *  EP  VFTerminate() - VDM termination notification
 *
 *  This registered subroutine is called each time a VDM is terminated
 *  (see VDHInstallUserHook for complete semantics).
 *
 *  ENTRY
 *      hvdm -> new VDM
 *  EXIT
 *      returns TRUE
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      VDM Task-time
 *
 *  PCODE
 *      if this VDM is waiting for PFD
 *          indicate waiter has died;
 *      else if this VDM owns the floppy
 *          indicate this VDM no longer owns or use the floppy;
 *          call PFD to release floppy ownership;
 *      endif
 *
 * INPUT         = (HVDM hvdm)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

BOOL HOOKENTRY VFTerminate(HVDM hvdm)
{
  PHVDM phvdm;

  if ((flFloppy&F_WAITINGPFD) && (hhookvirrWaitPFD))
  {

    if (hvdm == *(phvdm = (PHVDM)VDHQueryHookData(hhookvirrWaitPFD)))
    {
      PRINTTRACE("VFTerminate: floppy requester just died.\n");
      *phvdm = NO_VDM;                                  /* indicate waiter
                                                           has died         */
    }

    /*
    **    if ((flFloppy & F_WAITINGPFD) &&
    **      (hvdm == *(phvdm = (PHVDM)VDHQueryHookData(hhookvirrWaitPFD)))) {
    **        PRINTTRACE("VFTerminate: floppy requester just died.\n");
    **        *phvdm = NO_VDM;        indicate waiter has died
    */

  }

  else

    if (hvdm == hvdmFloppyOwner)
    {
      flFloppy &= ~(F_FLOPPYINUSE+F_PFDWAITING);
      PRINTTRACE("VFTerminate: return ownership to PFD.\n");
      RESTART_PDD(hvdmFloppyOwner)hvdmFloppyOwner = NO_VDM;
    }
  return  TRUE;
}                                                       /* VFTerminate      */
#pragma  END_SWAP_CODE
