/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VFEVENT.C
 *
 * DESCRIPTIVE NAME = Virtual Floppy Device Driver External Event Processing
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  This module contains the VFD's external event handlers.
 *
 *
 * FUNCTIONS       ResetDskBIOSData
 *                 VFDMAMaskEvent
 *                 VFEOIProc
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  INCL_ROMBIOS                                   /* @V5143           */
#include "vfdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif
extern VOID PASCAL INTEOIVDMIRQ(IRQN);
#pragma  BEGIN_GLOBAL_DATA
extern HHOOK hhookctxtFlpyIntr;                         /* context hook
                                                           handle for
                                                           floppy intr      */
extern HHOOK hhookDsktMotorTmr;                         /* Dskt Motor Off
                                                           timeout timer    */
                                                        /* @V0855           */
extern HVDM hvdmFloppyOwner;                            /* VDM handle of
                                                           floppy owner     */
extern FLAGS flFloppy;                                  /* floppy flags     */
extern BYTE hvdmFloppyOwner3F2;                         /* 3F2 access data  */
                                                        
extern ULONG motor_timeout;                             /* floppy motor
                                                           timeout value    */
                                                        /* @V0024           */
#pragma  END_GLOBAL_DATA
#pragma  BEGIN_SWAP_DATA

/*
**  @VD1535   @V3987
**  @VD1535   @V3987
*/
/*
** extern  BOOL    flPhysHookIRQ6;   Does the PDD own the interrupt handler?
** extern  FPFNPDD fpfnPFDProc;      16:32 PDD entry point
*/

extern HIRQ hirq;                                       /* floppy IRQ
                                                           handle           */
extern HHOOK hhookvirrWaitPFD;                          /* VIRR hook handle
                                                           for waiting PFD  */
extern IOH iotFDPort;                                   /* port hook
                                                           structure        */
#pragma  END_SWAP_DATA
#pragma  BEGIN_INSTANCE_DATA
#pragma  END_INSTANCE_DATA
#pragma  BEGIN_SWAP_INSTANCE
extern HVDM hvdmThisVDM;                                /* VDM handle       */
                                                        /* @V3987           */

#pragma  END_SWAP_INSTANCE
#pragma  BEGIN_GLOBAL_CODE

/* @V5143  */
/****************************************************************************
 *
 * FUNCTION NAME = ResetDsktBIOSData
 *
 * DESCRIPTION   =
 *
 *  This subroutine is called as a result of the PDD granting floppy
 *  ownership to a VDM. BIOS doesn't know the real state of the floppy ctrl
 *  and it needs to redetermine state.
 *
 *  ENTRY
 *      None
 *  EXIT
 *      Nonr
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 * INPUT         = (HVDM hvdm)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID PRIVENTRY ResetDsktBIOSData(HVDM hvdm)
{
  pVDMBase(hvdm)->rb_fbFSeekStatus |= 0x03;

  /*
  **pVDMBase(hvdm)->rb_bF0State      &= 0xEF;
  **pVDMBase(hvdm)->rb_bF1State      &= 0xEF;
  **pVDMBase(hvdm)->rb_bF0Cyl         = 0xFF;
  **pVDMBase(hvdm)->rb_bF1Cyl         = 0xFF;
  */

}

/****************************************************************************
 *
 * FUNCTION NAME = VFDMAMaskEvent
 *
 * DESCRIPTION   =
 *
 *  This subroutine is called by VDMA to inform the VFD about the
 *  masking/unmasking event of the floppy DMA channel.
 *
 *  ENTRY
 *      hvdm  ->VDM
 *      fMask - VDD_DMA_MASKOFF (unmasking DMA channel)
 *              otherwise (masking DMA channel)
 *  EXIT
 *      None
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      VDM Task-time
 *
 *  PCODE
 *      if DMA channel is unmasked
 *          if this VDM hasn't owned the floppy yet
 *              try opening the floppy;
 *          endif
 *      else if FDC is in idle state
 *          if in-use timeout timer has been set
 *              disarm the timer;
 *          endif
 *          indicate floppy is not in use, release ownership if PFD is waiting
 *      else if hasn't arm in-use timeout timer yet
 *          indicate the timeout timer has been armed;
 *          arm the in-use timeout timer;
 *      endif
 *
 * INPUT         = (HVDM hvdm,ULONG fMask)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

ULONG HOOKENTRY VFDMAMaskEvent(HVDM hvdm,ULONG fMask)
{

  if (fMask == VDD_DMA_MASKOFF)
  {
    PRINTTRACE("VFDMAMaskEvent: DMA channel is unmasked.\n");

    if (hvdm != hvdmFloppyOwner)
      vfOpenFloppy(hvdm);

    else
    {                                                   /* @Vmarc         */

      if (flFloppy&F_TIMEOUTSETMOTOROFF)
        VDHDisarmTimerHook(hhookDsktMotorTmr);          /* @Vmarc         */
      flFloppy |= F_TIMEOUTSETMOTOROFF;                 /* @Vmarc         */
      VDHArmTimerHook(hhookDsktMotorTmr,
                      motor_timeout,
                      VDH_TIMER_GLOBAL_CONTEXT);        /* @Vmarc   f19   */
    }                                                   /* @Vmarc         */
  }

  else
  {
    PRINTTRACE("VFDMAMaskEvent: DMA channel is masked.\n");
    vfCloseFloppy(hvdm);
  }
  return 1;
}                                                       /* VFDMAMaskEvent   */

/****************************************************************************
 *
 * FUNCTION NAME = VFEOIProc
 *
 * DESCRIPTION   =
 *
 *  This subroutine is registered with VPIC at VDD init time
 *  and is called by VPIC whenever a VDM issues an EOI to the
 *  floppy IRQ.
 *
 *  ENTRY
 *      None
 *  EXIT
 *      Nonr
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      VDM Task-time
 *
 *  PCODE
 *      clear VIRR;
 *
 * INPUT         = (PCRF pcrf)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID HOOKENTRY VFEOIProc(PCRF pcrf)
{
  PRINTTRACE("VFEOIProc: floppy interrupt EOI.\n");
  VDHClearVIRR(CURRENT_VDM,
               hirq);
  PRINTTRACE("VFEOIProc: Unmask interrupt.\n");         
  INTEOIVDMIRQ(FLPY_IRQ);                               
}                                                       /* VFEOIProc        */
#pragma  END_SWAP_CODE
