/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VFDATA.C
 *
 * DESCRIPTIVE NAME = Virtual Floppy Device Driver Data Declaration
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION   This module contains the VFD's private data.
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "vfdp.h"
#pragma  BEGIN_GLOBAL_DATA

#ifdef   VDDSTRICT
CHAR szAssertMsg[] = "VFLPY assertion failure in %s, line %d\n";
#endif

#ifdef   VDDDEBUG
CHAR szModule[] = "VFLPY: ";
#endif
HHOOK hhookctxtFlpyIntr;              /* context hook handle for floppy intr */
HHOOK hhookDsktMotorTmr;              /* Dskt motor TimeOut   @V0855         */
HVDM hvdmFloppyOwner = NO_VDM;        /* VDM handle of floppy owner          */
FLAGS flFloppy = 0;                   /* floppy flags                        */
BYTE hvdmFloppyOwner3F2;              
ULONG motor_timeout = MOTOR_TIMEOUT;  /* Floppy motor timeout   @V0024       */
HVDD hVDDVPIC = NULL;                 /* @VD1535 VDDtoVDD comm with          */
                                      /* VPIC. MASK/UNMASK IRQ6              */
HVDHSEM hsemFloppyOwnership;          /* @VD1535 Block VDMs simultaneously   */
                                      /* accessing floppy                    */
PHVDHSEM phsemFloppyOwnership = & hsemFloppyOwnership;/* pointer to sem      */
                                       /* handle                             */
VDHSEMSTATE semStateOwned;             /* Data area for sem info.            */
REDETERMINEMEDIAPARM RedetermineMediaParmPacket,RedetermineMediaDataPacket;
                                       /* @VD1535 SUSPEND/RESTART IOCTL call */
                                       /* parm packet                        */
HFILE hRedetermineMedia = 0;           /* @V3026                             */
ULONG RedetermineMediaLengthData;      /* @V3026                             */
CHAR AFileName[3] = "A:\0";            /* @V3026                             */

/*
** By default we'll trap all direct hardware accesses. This will allow us
** to handle situations where the program uses the ctrlr in peculiar ways.
** Consider what Norton backup does to check if the changeline bit was active,
** the program selects the corresponding drive and then sits there polling
** 3F7 until the changeline bit is set. This is OK until the 2 sec timeout
** timer comes in and turns the motor off. At this point the controller will
** never return the right status if the dskt is replaced because the drive
** is not selected anymore. If the app selected the drive everytime before
** the check is done then things would be fine, but that'd be too easy and
** we wouldn't have the fun of debugging this type of problems.
** INT 13 accesses can be trusted to be more careful than this and thus we
** don't trap all controller accesses for BIOS functions.
**                       ! norton !
*/

CHAR VfSetIOHookVar = 1;              /* norton                              */
#pragma  END_GLOBAL_DATA
#pragma  BEGIN_SWAP_DATA
HIRQ hirq;                            /* floppy IRQ handle                   */
HHOOK hhookvirrWaitPFD = NULL;        /* VIRR hook handle for waiting PFD    */
HHOOK hhooktimerInUseTimeout;         /* timer hook handle for inuse timeout */
IOH iotFDPort = {                     /* port hook structure */
                 VFPortInput, VFPortOutput, NULL, NULL, NULL };

#ifndef  NOMOTORTRAP
IOH iotFDPortDO = {                   /* port hook for digital output reg. */
                 NULL, VFPortDO, NULL, NULL, NULL };

#endif
IOH iotFDPortNoSupport = {            /* port hook for no PFD support        */
                 VFNoSupportIn, VFNoSupportOut, NULL, NULL, NULL } ;

#pragma  END_SWAP_DATA
#pragma  BEGIN_INSTANCE_DATA

/* start @VD1535*/

HFILE DeviceHandle = 0,               /* Handle used to issue                */
Device_Handle = 0;                    /* DevIOCTL calls.                     */
CHAR FileName[3] = "C:\0",            /* Kernel code to allow IOCTL          */
File_Name[3] = "C:\0";                /* calls w/o valid handle not          */
/* working yet, use C: drive.*/
ULONG ActionTaken;
ULONG LengthParm,LengthData;          /* DevIOCTL call parameters            */
HHOOK hhookctxtMotorResume;           /* for calling IOCTL Resume at         */
/* tasktime.  3516*/
SUSPENDRESTARTPARM SuspendRestartParmPacket;/* SUSPEND/RESTART IOCTL call    */

/* parm packet.*/

/* end @VD1535*/

#pragma  END_INSTANCE_DATA
#pragma  BEGIN_SWAP_INSTANCE
HVDM hvdmThisVDM;                     /* VDM handle                          */
HHOOK hhookvirrWaitInUse;             /* VIRR hook handle for waiting InUse  */

#ifdef   MONITORPORT
BOOL fPortTrapEnabled = TRUE;         /* port trap is enabled                */
#endif
#pragma  END_SWAP_INSTANCE
