/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VDSKP.H
 *
 * DESCRIPTIVE NAME = VDSK private constants, types, and macros declarations.
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include <disk.h>                     /* public disk constants               */
#include <vdskpdd.h>                  /* public/exported vdsk-pdsk stuff     */
#include <sysbloks.h>                 /* NoPdd                               */

/*
** Definitions for Inter-VDD communication
*/

#define  VDSK_NAME     "VDSK"          /* Name of this VDD                   */

/* InterVDD commands*/

#define  VDSK_INT13BOOT 0              /* VBIOS int 13 support               */

/* error codes*/

#define  VDSK_NO_ERROR 0
#define  VDSK_INVALID_FUNCTION 1

/*
**    Subcomponent-specific constants
*/

#define  HVDM_NOVDM    ((HVDM)(-1))   /* hvdm of no vdm                      */
#define  UNDEF_BYTE    0xff           /* hardware tri-state byte             */
#define  DRIVE_HDMASK  0x80           /* hard disk mask of drive number      */
#define  NUMMEDIAS     4              /* total number of medias supported    */
#define  MAX_FD        2              /* number of supported floppy drives   */
#define  MAX_HD        2            /* number of supported hard disk drives  */
#define  MAX_DRIVES    (MAX_FD+MAX_HD)
#define  DASDTYPE_NONE 0              /* no drive                            */
#define  DASDTYPE_FDNOCHANGEDET 1     /* floppy without change detection     */
#define  DASDTYPE_FDCHANGEDET 2       /* floppy with change detection        */
#define  DASDTYPE_HD   3              /* hard disk                           */
#define  DISKTYPE_NONE 0              /* no disk                             */
#define  DISKTYPE_360IN360 1          /* 360K disk in 360K drive             */
#define  DISKTYPE_360IN1200K 2        /* 360K disk in 1.2M drive             */
#define  DISKTYPE_1200KIN1200K 3      /* 1.2M disk in 1.2M drive             */
#define  DISKTYPE_720IN720 4          /* 720K disk in 720K drive             */
#define  DISKTYPE_720IN1440K 5        /* 720K disk in 1.44M drive            */
#define  DISKTYPE_1440KIN1440K 6      /* 1.44M disk in 1.44M drive           */
/* NoPdd*/

/*
**   IOCTL structures used when there is no PDD support
**
**    These structures define Parameter and Data packet formats
**    used in IOCTL calls.
**
*/

/* Disk/Diskette Control*/

#define  IOCTL_DISK    0x0008         /* NoPdd                               */
#define  IOCTL_PHYSICALDISK 0x0009    /* NoPdd                               */
#define  NUMBER_PHYSICAL_DISKS 1      /*                                     */
#define  PHYSICAL_HANDLE 2            /* NoPdd                               */
#define  RELEASE_PHYSICAL_HANDLE 3    /* NoPdd                               */
/* NoPdd*/
#define  DSK_LOCKDRIVE 0x0000         /* NoPdd                               */
#define  DSK_UNLOCKDRIVE 0x0001       /* NoPdd                               */
#define  DSK_REDETERMINEMEDIA 0x0002  /* NoPdd                               */
#define  DSK_SETLOGICALMAP 0x0003     /* NoPdd                               */
#define  DSK_BLOCKREMOVABLE 0x0020    /* NoPdd                               */
#define  DSK_GETLOGICALMAP 0x0021     /* NoPdd                               */
#define  DSK_SETDEVICEPARAMS 0x0043   /* NoPdd                               */
#define  DSK_WRITETRACK 0x0044        /* NoPdd                               */
#define  DSK_FORMATVERIFY 0x0045      /* NoPdd                               */
#define  DSK_GETDEVICEPARAMS 0x0063   /* NoPdd                               */
#define  DSK_READTRACK 0x0064         /* NoPdd                               */
#define  DSK_VERIFYTRACK 0x0065
#define  RECOMMENDED_BPB 0 /* Used by VDHDEVIOCTL    NoPdd                   */
#define  TRACK_TABLE_ENTRY 4 /* Size of a FORMAT TRACK TABLE ENTRY    NoPdd  */
#define  STANDARD_TRACK 1 /* Track starts at sec 1 and sectors are consecutive
                                         NoPdd                            */
/*#define SIZE_512_BYTES                200        Sector size                                       NoPdd*/
#define  SECTOR_SIZE   512 /* Sector size    NoPdd                           */
#define  MAX_SECTORS_PER_TRACK 0x3f /* Read Drive Params Max Sector number bits
                                       0-5    NoPdd                       */
#define  MAX_INT13Error 9 /* Errors returned by VDHGetError after VDHDevIOCTL /
                                      / NoPdd                             */
/* NoPdd*/
typedef struct ErrorIOCTLtoINT13_s
{                                     /* NoPdd                               */
  int IOCTL,                          /* NoPdd                               */
  INT13;                              /* NoPdd                               */
} ERRORIOCTLTOINT13;
                                      /* NoPdd                               */
/* NoPdd*/
typedef struct GetDeviceParmsParm_s
{                                     /* NoPdd                               */
  BYTE Command,   DriveNum;           /* NoPdd                               */
} GETDEVICEPARMSPARM;
                                      /* NoPdd                               */
typedef GETDEVICEPARMSPARM *PGETDEVICEPARMSPARM;/* NoPdd                     */
/* NoPdd*/
typedef struct xbpb_s
{    /* BIOS Parameter Block (from sysbloks.h)    NoPdd                      */
  USHORT bytes_per_sector;/* sector size    NoPdd                            */
  UCHAR sectors_per_cluster;/* sectors per allocation unit    NoPdd          */
  USHORT reserved_sectors;/* number of reserved sectors    NoPdd             */
  UCHAR nbr_fats;/* number of fats    NoPdd                                  */
  USHORT root_entries;/* number of directory entries    NoPdd                */
  USHORT total_sectors;/* number of sectors    NoPdd                         */
  UCHAR media_type;/* fatid byte    NoPdd                                    */
  USHORT sectors_per_fat;/* sectors in a copy of the FAT    NoPdd            */
  USHORT sectors_per_track;/* number of sectors per track    NoPdd           */
  USHORT number_of_heads;/* number of heads    NoPdd                         */
  ULONG hidden_sectors;/* number of hidden sectors    NoPdd                  */
  ULONG large_total_sectors;/* large total sectors    NoPdd                  */
  UCHAR reserved[6];/* 6 reserved bytes    NoPdd                             */
} XBPB;
                                      /* NoPdd                               */
/* NoPdd*/
typedef struct GetDeviceParmsData_s
{                                     /* NoPdd                               */
  struct xbpb_s ExtendedBPB;          /* NoPdd                               */
  USHORT NumCyl;                      /* NoPdd                               */
  UCHAR DeviceType;                   /* NoPdd                               */
  USHORT DeviceAttributes;            /* NoPdd                               */
} GETDEVICEPARMSDATA;
                                      /* NoPdd                               */
typedef GETDEVICEPARMSDATA *PGETDEVICEPARMSDATA;/* NoPdd                     */
/* NoPdd*/
typedef struct GetPhysDeviceParmsData_s
{                                     /* NoPdd                               */
  USHORT Reserved;                    /* NoPdd                               */
  USHORT NumCyl;                      /* NoPdd                               */
  USHORT NumHeads;                    /* NoPdd                               */
  USHORT SecperTrack;                 /* NoPdd                               */
  USHORT Reserved2[4];                /* NoPdd                               */
} GETPHYSDEVICEPARMSDATA;
                                      /* NoPdd                               */
typedef GETPHYSDEVICEPARMSDATA *PGETPHYSDEVICEPARMSDATA;/* NoPdd             */
/* NoPdd*/
typedef struct RWVData_s
{                                     /* NoPdd                               */
  PVOID Data;                         /* NoPdd                               */
} RWVFDATA;
                                      /* NoPdd                               */
typedef RWVFDATA *PRWVFDATA;          /* NoPdd                               */
/* NoPdd*/
typedef struct FormatData_s
{                                     /* NoPdd                               */
  BYTE StartSector;                   /* NoPdd                               */
} FORMATDATA;
                                      /* NoPdd                               */
typedef FORMATDATA *PFORMATDATA;      /* NoPdd                               */
/* NoPdd*/
typedef struct TrackTableEntry_s
{                                     /* NoPdd                               */
  USHORT Sector,  Size;               /* NoPdd                               */
} TRACKTABLEENTRY;
                                      /* NoPdd                               */
typedef TRACKTABLEENTRY *TRACKTABLETYPE;/* NoPdd                             */
/* NoPdd*/
typedef struct RWVParm_s
{                                     /* NoPdd                               */
  UCHAR Command;                      /* NoPdd                               */
  USHORT Head;                        /* NoPdd                               */
  USHORT Cyl;                         /* NoPdd                               */
  USHORT FirstSector;                 /* NoPdd                               */
  USHORT NumSec;                      /* NoPdd                               */
  TRACKTABLEENTRY TrackTable[MAX_SECTORS_PER_TRACK *TRACK_TABLE_ENTRY];/*    */
                                       /* NoPdd                              */
} RWVPARM;
                                      /* NoPdd                               */
typedef RWVPARM *PRWVPARM;            /* NoPdd                               */
/* NoPdd*/
typedef struct FormatParm_s
{                                     /* NoPdd                               */
  UCHAR Command;                      /* NoPdd                               */
  USHORT Head;                        /* NoPdd                               */
  USHORT Cyl;                         /* NoPdd                               */
  USHORT NumberTracks;                /* NoPdd                               */
  USHORT NumSec;                      /* NoPdd                               */
} FORMATPARM;
                                      /* NoPdd                               */
typedef FORMATPARM *PFORMATPARM;      /* NoPdd                               */

/*
**  LT+ Subcomponent-specific types
**
**      Virtual Floppy Structure
**
**      This structure stores various attributes and states of
**      the virtaul floppy drive.
**
**      Media Type Structure
**
**      This structure stores the attributes of a particular
**      media type.
*/

typedef struct virtfloppy_s
{
  BOOL vf_fDiskChanged;               /* disk has been changed               */
  USHORT vf_usFormatTracks;           /* number of tracks set by SetMedia    */
  USHORT vf_usFormatSectors;          /* sectors/track set by SetMedia       */
  BYTE vf_bDriveType;                 /* see DRVTYPE_* equates in vdskpdd.h  */
} VIRTFLOPPY;

typedef struct mediatype_s
{
  USHORT mt_usTracks;                 /* number of tracks                    */
  USHORT mt_usSectors;                /* number of sectors per track         */
} MEDIATYPE;

/*end*/

/*
**  LT+ Virtual disk and Disk mapping information
**
**  VIRTDISK describes the header of a virtual disk file.  Following the
**  header is an optional track table, and TRACKINFO describes the format
**  of each entry in that table.  The track table is not present if
**  the last two fields in the header (nsecTrack and nbSector) contain
**  non-zero values, thereby indicating a homogenous disk structure.
**
**  Currently, up to 4 MAPDISK structures are supported for every VDM; the
**  first two entries are for physical drives 0 and 1 (specified in the
**  virtual machine drive property as A: and B:), and subsequent entries are
**  for physical hard drives 0x80 and up (specified as C: and up).  Each
**  MAPDISK describes the remapping that should occur, if any, and for
**  virtual disk files, it also contains the virtual disk file header (which
**  is read in during VDM creation).
**
**  When a request comes in for one of those drives, we check the flags in
**  corresponding MAPDISK structure.  If no flags are set, no remapping
**  or virtualization occurs (drive behaves normally).  This is the default.
**  If the drive is disabled (eg, "A:=*"), then all requests are returned
**  with an error.  If the drive is remapped to another physical drive (eg,
**  "A:=B:") then the request is routed to the mapped drive.  Finally, if
**  the drive is remapped to a virtual disk file, the appropriate file I/O
**  is performed.
*/

#define  PARTITION_ACTIVE 0x80        /* status values                       */
#define  PARTITION_12BITFAT 1         /* type valus                          */
#define  PARTITION_16BITFAT 4
#define  PARTITION_LARGEFAT 6
typedef struct mbr_s
{                                     /* Master Boot Record                  */
  UCHAR boot_code[0x1BE];
  UCHAR partition_status;
  UCHAR starting_head;
  USHORT starting_sec_cyl;
  UCHAR partition_type;
  UCHAR ending_head;
  USHORT ending_sec_cyl;
  ULONG starting_abs_sector;
  ULONG total_sectors;
} MBR;

typedef MBR *PMBR;
typedef struct bpb_s
{                                 /* BIOS Parameter Block (from sysbloks.h)  */
  UCHAR boot_code[0x0B];
  USHORT bytes_per_sector;            /* sector size                         */
  UCHAR sectors_per_cluster;          /* sectors per allocation unit         */
  USHORT reserved_sectors;            /* number of reserved sectors          */
  UCHAR nbr_fats;                     /* number of fats                      */
  USHORT root_entries;                /* number of directory entries         */
  USHORT total_sectors;               /* number of sectors                   */
  UCHAR media_type;                   /* fatid byte                          */
  USHORT sectors_per_fat;             /* sectors in a copy of the FAT        */
  USHORT sectors_per_track;           /* number of sectors per track         */
  USHORT number_of_heads;             /* number of heads                     */
  ULONG hidden_sectors;               /* number of hidden sectors            */
  ULONG large_total_sectors;          /* large total sectors                 */
  UCHAR reserved[6];                  /* 6 reserved bytes                    */
} BPB;

typedef struct virtdisk_s
{
  UCHAR vd_fbVirtDisk;                /* flags                               */
  UCHAR vd_nHeads;                    /* # heads                             */
  USHORT vd_nCyls;                    /* # cylinders                         */
  USHORT vd_nsecTrack;                /* # sectors per track                 */
  USHORT vd_nbSector;                 /* # bytes per sector                  */
} VIRTDISK;

typedef VIRTDISK *PVIRTDISK;
#define  VDFLAGS_WRITEPROTECT 0x01    /* virtual disk is "write-protected"   */
typedef struct trackinfo_s
{
  USHORT ti_nsecTrack;                /* # sectors per track                 */
  USHORT ti_nbSector;                 /* # bytes per sector                  */
  ULONG ti_offsetFile;                /* offset within virtual disk file     */
} TRACKINFO;

typedef TRACKINFO *PTRACKINFO;
typedef struct mapdisk_s
{
  UCHAR md_fbPhysDisk;                /* flags                               */
  UCHAR md_iPhysical;                 /* # of remapped physical drive        */
  HFILE md_hfVirtDisk;                /* handle to virtual disk, if any      */
  VIRTDISK md_vdInfo;                 /* virtual disk info, if any           */
  ULONG md_nsecHidden;             /* from BPB, if any (logical disks only)  */
  UCHAR md_type;                  /* disk type, if any (logical disks only)  */
} MAPDISK;

typedef MAPDISK *PMAPDISK;
#define  MDFLAGS_VIRTUAL 0x01         /* physical remapped to virtual        */
#define  MDFLAGS_DISABLED 0x02       /* physical remapped to disabled drive  */
#define  MDFLAGS_PHYSICAL 0x04   /* physical remapped to different physical  */
#define  MDFLAGS_LOGICAL 0x08         /* physical remapped to logical drive  */

/*end*/

/*
**    Private Function Prototypes
*/

/*  File: vdsk.c*/
BOOL EXPENTRY VDDInit(PSZ);

BOOL HOOKENTRY VDSKExit(VOID);
BOOL HOOKENTRY VDSKCreateVDM(HVDM);
BOOL HOOKENTRY VDSKTerminateVDM(HVDM);
BOOL PRIVENTRY VDSKOpenVirtDisks(PSZ);/* 1125                                */
VOID PRIVENTRY VDSKCloseVirtDisks(VOID);
LONG EXPENTRY vdskVDDEntry(HVDM,ULONG,PVOID,PVOID);/* 6.2                    */
/*  File: vdskint.c*/
SBOOL VDDENTRY VDSKPDDProc(ULONG,F16PVOID,F16PVOID);
BOOL HOOKENTRY VDSKInt13Proc(PCRF);
VOID HOOKENTRY VDSKInt13Return(PVOID,PCRF);
VOID HOOKENTRY VDSKDiskRequest(PULONG,PCRF);
VOID HOOKENTRY VDSKWaitRequest(PVOID,PCRF);
VOID PRIVENTRY VDSKRequestDone(PCRF);
VOID PRIVENTRY VDSKInt13Done(INT,PCRF);
VOID PRIVENTRY VDSKInt13QueryHDParms(PCRF);
VOID PRIVENTRY VDSKInt13QueryFDParms(PCRF);
VOID PRIVENTRY VDSKInt13QueryHDDASDType(PCRF);
VOID PRIVENTRY VDSKInt13QueryFDDASDType(PCRF);
VOID PRIVENTRY VDSKInt13QueryChange(PCRF);
VOID PRIVENTRY VDSKInt13SetDiskType(PCRF);
VOID PRIVENTRY VDSKInt13SetMediaType(PCRF);
VOID PRIVENTRY VDSKSetDiskChanged(HVDM,ULONG);
BOOL PRIVENTRY VDSKCheckVirtDisk(INT,PCRF);
BOOL PRIVENTRY VDSKSetUpIoctlReqFormat(PCHAR,PFORMATPARM,PFORMATDATA,PCRF);/**/
                                       /* NoPdd                              */
BOOL PRIVENTRY VDSKSetUpIoctlReqRWV(PCHAR,PRWVPARM,PRWVFDATA,PCRF);/* NoPdd  */
VOID PRIVENTRY rcMapError(PCRF,BOOL); /* NoPdd                               */
/*  File: vdskio.c*/
BYTE HOOKENTRY VDSKReadPort(ULONG,PCRF);
VOID HOOKENTRY VDSKWritePort(BYTE,ULONG,PCRF);

/*
** This is a private VDH service and this prototype should be deleted once\
** this service becomes public.
** BOOL VDHENTRY VDHPhysicalDisk(ULONG,PULONG,ULONG,PULONG,ULONG);   NoPdd
*/

/*
**   Random macro support
**
**   If VDDSTRICT is defined, the Assert macros generate appropriate code.
**
**   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
**   exception of AssertRC, in which case the function is still called, but
**   the return code is not checked).
**
**   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
**   failed assertions (assuming VDDSTRICT is defined) break at the assertion
**   rather than in the kernel's "panic" service.  VDDDEBUG requires the
**   kernel debugger, in other words.
**
**   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
**   generated, and failed assertions (assuming VDDSTRICT is defined) simply
**   panics.
*/

#ifdef   VDDSTRICT

/*c-begin*/

extern CHAR szAssertMsg[];
  #define  MODNAME       static CHAR szFile[]

  #ifdef   VDDDEBUG
    #define  Assert(t)     {                                                \
if (!(t) )  \
{ \
  PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
  INT3(); \
} \
}

  #else
    #define  Assert(t)     {                                                \
                           \

if (!(t)
)
{
  \PANIC(szAssertMsg,
         szFile,
         __LINE__);
  \
}

\
}
  #endif
  #define  AssertTRUE(t) Assert(t)
  #define  AssertFALSE(t) Assert(!(t))
  #define  AssertZERO(t) Assert(!(t))
  #define  AssertNONZERO(t)Assert(t)
 #define  AssertRC(t)   Assert(t)    /* verify function return code good    */
/*c-end*/

#else
/*c-begin*/
#define    Assert(t)                  /*                                     */
 #define  AssertTRUE(t)              /*                                     */
 #define  AssertFALSE(t)             /*                                     */
 #define  AssertZERO(t)              /*                                     */
 #define  AssertNONZERO(t)           /*                                     */
 #define  AssertRC(t)   (t)         /* perform function, but don't verify   */
/*c-end*/
#endif

/*
** Random debugging support
*/

#ifdef   VDDDEBUG
/*c-begin*/
extern CHAR szModule[];
  #undef   PRINTDEBUG
  #define  PRINTDEBUG    printf(szModule);                                  \
                         printf
/*c-end*/
#endif
