/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/vdev/vaspi/vaspip.h, vaspi, r207 94/08/15";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = VASPIP.H
 *
 * DESCRIPTIVE NAME = VASPI.SYS - OS/2 Virtual ASPI Device Driver
 *
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION : Function profile definition
 *
 *      VASPI is organized as follows:
 *         VAINIT.C    - Init routine
 *         VAUSER.C    - UserHooks for VDM Creation, VDMTermination
 *         VADATA.C    - Data
 *         VAEVENT.C   - Entry point in VDD for PDD to call
 *         VAMEM.C     - Memory and queue management routines
 *         VAROUTER.C  - ASPI Router and DOS Link routines
 *
 *         VASPI.H     - Defines, etc
 *         VASPIX.H    - External data definitions
 *         VASPIP.H    - Function profile definitions
 *         VASPIMAC.H  - Macros
 *
 *
*/
/* procedure declarations from VAEVENT.C  */

SBOOL VDDENTRY VASPIEventProc(ULONG ulFunc, F16PVOID pSRB, F16PVOID f16p2);
BOOL HOOKENTRY ASPIContextRoutine(PVOID pHookData, PCRF pcrf);
BOOL HOOKENTRY ASPIPostRoutine(PVOID pHookData, PCRF pcrf);
BOOL HOOKENTRY ASPIPostReturn(PVOID pHookData, PCRF pcrf);


/* procedure declarations from VAINIT.C   */

BOOL PASCAL VDDInit(PSZ psz);
int PASCAL vaspiGetKeyword(PPSZ ppsz);
VOID GetAdapterInfo(PASPI_SRB_INQUIRY pSRB, USHORT currentAdapter);


/* procedure declarations from VAROUTER.C */

BOOL HOOKENTRY VASPIRouter(PVOID Unused, PCRF pcrf);
VOID DoVirtASPIInquiry();
VOID DoVirtASPIDeviceType();
BOOL DoVirtASPIExecuteIO();
VOID ConfirmDataTransfer(NPDASPI_SRB_EXECUTE_IO pDosSRBIO);
VOID DoVirtASPIAbortIO();
VOID DoVirtASPIResetDevice();

VOID DoSimpleSRB();
VOID SetupSRB();

/* procedure declarations from VAMEM.C */

ULONG ReserveBuf( LONG cBytes );
VOID  ReleaseBuf( PVOID pUserBuf, ULONG Size );
PVOID AllocBuf( ULONG cBytes );
PWAITQ_HEAD GetDeviceWaitQueuePtr(UCHAR adapter, UCHAR target,UCHAR lun);
VOID QueueDeviceWaitQueue(PWAITQ_HEAD pDeviceWaitQ,NPVSRB_LINK pSRBL);
NPVSRB_LINK GetDeviceWaitQueueSRB(PWAITQ_HEAD pDeviceWaitQ);
VOID QueueActiveSRB(NPVSRB_LINK pSRBL);
VOID RemoveActiveSRB(NPVSRB_LINK currentVirtSRB);
ULONG GetPhysicalSRBAddress(PASPI_SRB_HEADER DosSRBAddress);

/* procedure declarations from VAUSER.C   */

BOOL  PASCAL VASPICreate(HVDM hvdm);
VOID GetDeviceInfo(PASPI_SRB_DEVICE_TYPE pSRB, UCHAR adapter,
                   UCHAR target, UCHAR lun);
VOID  PASCAL VASPIDestroy(HVDM hvdm);
VOID  HOOKENTRY VASPIService( PVOID Unused, PCRF pCRF );
VOID  HOOKENTRY VASPIVPMService( PVOID Unused, PCRF pCRF );
VOID  HOOKENTRY TimerExpired( PVOID Unused, PCRF pCRF );
