/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/*static char *SCCSID = "@(#)tcfgx.h  6.2 92/02/13";*/

/*** TCFGX.H - TCFGX Device Driver Include File
 *
 *   DESCRIPTION
 *
 *     TESTCFG external definitions and pragmas
 *
 *   MODIFICATION HISTORY
 *
 * 6.3  08/12/94   91719       E.Bentley IDE CDROM only accept Inquiries of
 *                                       12 bytes.
 *      05/08/96               F.Schroeder Added IEEE-1284 Query Device ID
 */

/* TESTCFG function protocols */

USHORT main(PREQPACKET rp);        /* main entry point for TESTCFG       */
USHORT far CFG_IOCtl(PREQPACKET rp);   /* IOCTL routines for TESTCFG     */
USHORT CFG_Read_POSID(PREQPACKET rp);  /* Read POS IDs                   */
USHORT CFG_Read_EISAID(PREQPACKET rp); /* Read EISA IDs                  */
USHORT CFG_Read_ADPMEM(PREQPACKET rp); /* Copy Adapter ROM/RAM           */
USHORT CFG_In_IO(PREQPACKET rp);       /* Input Port                     */
USHORT CFG_Out_IO(PREQPACKET rp);      /* Output Port                    */
USHORT CFG_Misc_Query(PREQPACKET rp);  /* Miscellaneous Query            */

USHORT far CFG_SCSI_Inquiry(PREQPACKET rp);/* SCSI Inquiry command           */
unsigned near Build_UnitCBs(PINQUIRYDATAPACKET  pBuffer, UCHAR DevType);
USHORT near Do_Inquiry(PUNITINFO pUnitInfo, PINQUIRYDATAPACKET  pBuffer, USHORT DevBus);
USHORT near Do_AllocDeallocUnit(USHORT command_modifier,PUNITINFO  pUnitInfo);
void   near BuildIORB_UnitControl (USHORT command_modifier,USHORT unit_handle);

void   CFG_INITCODE(void);             /* Dummy marker for beginning of Init  */
USHORT far CFG_Init(PREQPACKET rp);    /* TESTCFG Init Routine                */
void   CFG_Init_EISA(USHORT hOEM);     /* Initialize EISA ID Values           */
void   CFG_Init_POS(void);             /* Initialize POS  ID Values           */

/* Assembly worker routines */
void STRATEGYCFG(void);             /* name of strategy routine in TESTCFGA */
UCHAR  NC InB   (USHORT Port);
USHORT NC InW   (USHORT Port);
ULONG  NC InDW  (USHORT Port);
void   NC OutB  (USHORT Port,UCHAR Data);
void   NC OutW  (USHORT Port, USHORT Data);
void   NC OutDW (USHORT Port,ULONG Data);
USHORT NC strlen(POINTER);
USHORT NC GetDCTable(POINTER);
USHORT NC ZeroCB(PBYTE ControlBlock, USHORT Length);
void   NC BlockCopy(PBYTE Dest, PBYTE Orig, USHORT Length);

/*************************************************************************
 *                 F U N C T I O N   P R O T O T Y P E S                 *
 *************************************************************************/

/*  Special Routines
 */
int  NC SegLimit        (SEL, OFF far *);

/* Memory Management
 */
int  NC VerifyAccess    (FARPOINTER pMem, USHORT Length, FLAG AccessType);

/*  Physical/Virtual Conversion
 */
int  NC PhysToVirt      (PHYSADDR, USHORT, PFLAG);
int  NC UnPhysToVirt    (void);
int  NC VirtToPhys      (ULONG, PULONG);
int  FC IsAPMPresent    (void);

/* ABIOS services
 */
int  NC GetLIDEntry(USHORT DevID,USHORT RelID,USHORT DevState,PUSHORT LID);
int  NC FreeLIDEntry(USHORT LID);
int  NC ABIOSCall(USHORT LID,POINTER RBOffset,USHORT Entry);
void NC ProcBlock(ULONG EventId, ULONG WaitTime, USHORT IntWaitFlag );
void NC ProcRun(ULONG EventId, PUSHORT AwakeCount);
void NC SlcWarp(void);

void far adapterInit( PSZ pRP );                      /* IEEE-1284 support */
USHORT parInitComp( PSZ pRP );
USHORT parDevIDQuery( PSZ pRP1 );

#pragma alloc_text(INITCODE, adapterInit)
#pragma alloc_text(STATICCODE, parInitComp)
#pragma alloc_text(STATICCODE, parDevIDQuery)

/* Pragmas to put code in correct segments */
#pragma alloc_text(STATICCODE, main)
#pragma alloc_text(STATICCODE, ProcRun)

#pragma alloc_text(SWAPCODE,CFG_IOCtl)
#pragma alloc_text(SWAPCODE,CFG_Read_POSID)
#pragma alloc_text(SWAPCODE,CFG_Read_EISAID)
#pragma alloc_text(SWAPCODE,CFG_Read_ADPMEM)
#pragma alloc_text(SWAPCODE,CFG_In_IO)
#pragma alloc_text(SWAPCODE,CFG_Out_IO)
#pragma alloc_text(SWAPCODE,CFG_Misc_Query)

#pragma alloc_text(SWAPCODE,CFG_SCSI_Inquiry)
#pragma alloc_text(SWAPCODE,Build_UnitCBs)
#pragma alloc_text(SWAPCODE,Do_Inquiry)
#pragma alloc_text(SWAPCODE,Do_AllocDeallocUnit)
#pragma alloc_text(SWAPCODE,BuildIORB_UnitControl)

#pragma alloc_text(SWAPCODE,InB)
#pragma alloc_text(SWAPCODE,InW)
#pragma alloc_text(SWAPCODE,InDW)
#pragma alloc_text(SWAPCODE,OutB)
#pragma alloc_text(SWAPCODE,OutW)
#pragma alloc_text(SWAPCODE,OutDW)
#pragma alloc_text(SWAPCODE,GetDCTable)
#pragma alloc_text(SWAPCODE,ZeroCB)
#pragma alloc_text(SWAPCODE,BlockCopy)

#pragma alloc_text(SWAPCODE,VerifyAccess)
#pragma alloc_text(SWAPCODE,IsAPMPresent)
#pragma alloc_text(SWAPCODE,PhysToVirt)
#pragma alloc_text(SWAPCODE,UnPhysToVirt)
#pragma alloc_text(SWAPCODE,ProcBlock)

#pragma alloc_text(INITCODE, CFG_INITCODE)
#pragma alloc_text(INITCODE, CFG_Init)
#pragma alloc_text(INITCODE, CFG_Init_EISA)
#pragma alloc_text(INITCODE, CFG_Init_POS)
#pragma alloc_text(INITCODE,SegLimit)
#pragma alloc_text(INITCODE,VirtToPhys)
#pragma alloc_text(INITCODE,GetLIDEntry)
#pragma alloc_text(INITCODE,ABIOSCall)
#pragma alloc_text(INITCODE,FreeLIDEntry)
#pragma alloc_text(INITCODE, SlcWarp)

