/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

#define MAX_SCSI_DEVICES 32
#define MAX_DT_ADAPTERS  8
#define MAX_DT_UNITS     56
#define MAX_DT_SIZE (sizeof(DEVICETABLE) + ((MAX_DT_ADAPTERS-1) * 2) +        \
              (MAX_DT_ADAPTERS * (sizeof(ADAPTERINFO)-sizeof(UNITINFO))) +    \
              (MAX_DT_UNITS * sizeof(UNITINFO))  )
#define FILTER_WORKSPACE_SIZE   24

struct SCSI_command {
        UCHAR   byte_0;
        UCHAR   byte_1;
        UCHAR   byte_2;
        UCHAR   byte_3;
        UCHAR   byte_4;
        UCHAR   byte_5;
        UCHAR   byte_6;
        UCHAR   byte_7;
        UCHAR   byte_8;
        UCHAR   byte_9;
        UCHAR   byte_10;
        UCHAR   byte_11;
        UCHAR   byte_12;
        UCHAR   byte_13;
        UCHAR   byte_14;
        UCHAR   byte_15;
};

typedef struct _IORB_CDB           {  /* IOCDB */

  IORB_ADAPTER_PASSTHRU  apt;
  struct SCSI_command    CDB;
  UCHAR                  CDB_data[64];
  UCHAR                  filter_workspace[FILTER_WORKSPACE_SIZE];

} IORB_CDB, FAR *PIORB_CDB, *NPIORB_CDB;

#define ATAPI_Cmd_Length 12

/************************************************/
/* SCSI Inquiry Command  (0x12)                 */
/************************************************/
struct CDB_Inquiry {

        UCHAR   OpCode;

        UCHAR   EVPD       : 1;
        UCHAR   reserved_1 : 4;
        UCHAR   LUN        : 3;

        UCHAR   page_code;
        UCHAR   reserved_2;
        UCHAR   alloc_length;
        UCHAR   control;
};

typedef struct _IORB_DMWORK
{
   PUNITINFO    pUnitInfo;
   USHORT        Reserved_1;
   PBYTE         pRequest;
   SCATGATENTRY  SGList;
   NPIORB        WaitingQueueLink;
   NPIORB        pCoReqIORB;

} IORB_DMWORK, *PIORB_DMWORK;



void near BuildCDB_Inquiry(PUNITINFO pUnitInfo, PIORB_CDB  pIORB, USHORT DevBus);
void near BuildIORB_PassthruCDB (PUNITINFO pU,ULONG dl,ULONG pD, PIORB_CDB pI);
#pragma alloc_text(SWAPCODE,BuildCDB_Inquiry)
#pragma alloc_text(SWAPCODE,BuildIORB_PassthruCDB)

void _loadds far IORBPost(PIORBH pIORB);
#pragma alloc_text(STATICCODE, IORBPost)
