/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/snooper/parallel/parproto.h, parsnp, c.basedd, currbld 96/04/17" */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  PARPROTO.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME:  Functional prototypes provided by the PARALLEL port   */
/*                      snooper device driver.                                */
/*                                                                            */
/*   FUNCTION: This module is the PARALLEL port snooper device driver         */
/*             functional prototype include file.                             */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  None                                                      */
/*                                                                            */
/*   EXTERNAL REFERENCES:  None                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/01/09  Frank Schroeder Original developer.                     */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

/* PARUTIL.C */
void SetInstanceFlags( parInstance_t *pInst, ULONG Flags );
void ResetInstanceFlags( parInstance_t *pInst, ULONG Flags );
void LockInstance( parInstance_t *pInst );
void UnLockInstance( parInstance_t *pInst );
parInstance_t *AllocateInstance( void );
USHORT AllocateInstancePool( void );
USHORT StartInstanceTimer( void );
void DestroyInstance( parInstance_t *pInst );
void DeallocateInstance( parInstance_t *pInst );
USHORT StopInstanceTimer( void );
void SetRPErrorCode( parInstance_t *pInst );

/* PARMISC.C */
void IOWrite8 (USHORT BaseAddr, USHORT BaseOffset, UCHAR Data);
UCHAR IORead8 (USHORT BaseAddr, USHORT BaseOffset);
void IOWrite32( USHORT BaseAddr, USHORT BaseOffset, ULONG Data );
ULONG IORead32( USHORT BaseAddr, USHORT BaseOffset );
void IODelay(void);
void  TimeExecutionStall( USHORT delay );

/* PARIDC */
void  attachIDC( void );
void  reqexcl( void );
void  relexcl( void );

/* PARIOCTL.C */
void far adapterInit( PSZ pRP );
USHORT parInitComp( PSZ pRP );
USHORT parDevIDQuery( PSZ pRP1 );
void parDeviceIDQuery( parInstance_t *pInst );
void CompleteRP( parInstance_t *pInst );

/* PARNEG.C     */
void do_negotiate( parInstance_t *pInst );
USHORT CommModeToExtReq( parInstance_t *pInst,
                         UCHAR         ReqCommMode,
                         UCHAR         *pExtReqByte );

/* PARSPP.C     */
USHORT do_data_xfer( parInstance_t *pInst );
void do_read_byte_mode( parInstance_t *pInst );
UCHAR StatusToNibble( UCHAR StatusReg );
void byte_read_timeout( parInstance_t *pInst );

/* PARISR.C     */
void FAR addTimerEventHandler();
void setDelayTimer( parInstance_t *pInst,
                    USHORT        TimerId,
                    void          (*TimeoutRtn)( parInstance_t *pInst ),
                    USHORT        TimeoutMS );
void cancelDelayTimer( parInstance_t *pInst,
                       USHORT        TimerId );

/* Pragmas to put code in correct segments for testcfg */

#pragma alloc_text(STATICCODE, SetInstanceFlags)      /* IEEE-1284 support */
#pragma alloc_text(STATICCODE, ResetInstanceFlags)
#pragma alloc_text(STATICCODE, LockInstance)
#pragma alloc_text(STATICCODE, UnLockInstance)
#pragma alloc_text(STATICCODE, SetRPErrorCode)
#pragma alloc_text(STATICCODE, IOWrite8)
#pragma alloc_text(STATICCODE, IORead8)
#pragma alloc_text(STATICCODE, IOWrite32)
#pragma alloc_text(STATICCODE, IORead32)
#pragma alloc_text(STATICCODE, IODelay)
#pragma alloc_text(STATICCODE, TimeExecutionStall)
#pragma alloc_text(STATICCODE, attachIDC)
#pragma alloc_text(STATICCODE, reqexcl)
#pragma alloc_text(STATICCODE, relexcl)
#pragma alloc_text(STATICCODE, parInitComp)
#pragma alloc_text(STATICCODE, parDevIDQuery)
#pragma alloc_text(STATICCODE, parDeviceIDQuery)
#pragma alloc_text(STATICCODE, CompleteRP)
#pragma alloc_text(STATICCODE, do_negotiate)
#pragma alloc_text(STATICCODE, CommModeToExtReq)
#pragma alloc_text(STATICCODE, do_data_xfer)
#pragma alloc_text(STATICCODE, do_read_byte_mode)
#pragma alloc_text(STATICCODE, StatusToNibble)
#pragma alloc_text(STATICCODE, byte_read_timeout)
#pragma alloc_text(STATICCODE, addTimerEventHandler)
#pragma alloc_text(STATICCODE, setDelayTimer)
#pragma alloc_text(STATICCODE, cancelDelayTimer)

#pragma alloc_text(INITCODE, adapterInit)             /* IEEE-1284 support */
#pragma alloc_text(INITCODE, AllocateInstance)
#pragma alloc_text(INITCODE, AllocateInstancePool)
#pragma alloc_text(INITCODE, StartInstanceTimer)
#pragma alloc_text(INITCODE, DestroyInstance)
#pragma alloc_text(INITCODE, DeallocateInstance)
#pragma alloc_text(INITCODE, StopInstanceTimer)

