/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

#include        "par.h"

/*--------------------------------------------------------------------*/
/*                                                                    */
/* parisr.c - Parallel ADD Interrupt entry points                     */
/*                                                                    */
/* This routine contains the inital entry points for parallel port    */
/* interrupts and timer interrupts.                                   */
/*                                                                    */
/*--------------------------------------------------------------------*/


/*---------------------------------------------------------------*/
/*                                                               */
/* Parallel ADD Timer Handler                                    */
/*                                                               */
/* This routine accepts periodic timer calls from timer          */
/* services and manages a set of internal timers for each        */
/* active instance.                                              */
/*                                                               */
/*---------------------------------------------------------------*/
void FAR addTimerEventHandler()
{
  parInstance_t         *pInst;
  USHORT                i;

  pInst = pInstanceHead;

  /*----------------------------------------------*/
  /* Scan all active instances on each timer tick */
  /*----------------------------------------------*/
  while ( pInst )
  {
    /*--------------------------------------------*/
    /* Scan all internal timers for the instance  */
    /*--------------------------------------------*/
    for ( i = 0; i < TIMERS_PER_INSTANCE; i++ )
    {
      /*--------------------------------------------------*/
      /* If an instance timer made a 1->0 transition then */
      /* call the associated timeout routine              */
      /*--------------------------------------------------*/
      if ( pInst->Timers[i].TimerCount )
      {
        if ( !--(pInst->Timers[i].TimerCount) )
        {
          (pInst->Timers[i].TimeoutRtn)( pInst );
        }
      }
    }

    pInst = pInst->pNextInst;
  }
}

/*----------------------------------------------------------*/
/*                                                          */
/* Schedule an internal instance timer                      */
/*                                                          */
/* This routine starts the indicated instance timer.        */
/*                                                          */
/* When the timer expires, the routine passed in TimeoutRtn */
/* will be called.                                          */
/*                                                          */
/*----------------------------------------------------------*/
void setDelayTimer( parInstance_t *pInst,
                    USHORT        TimerId,
                    void          (*TimeoutRtn)( parInstance_t *pInst ),
                    USHORT        TimeoutMS )
{

  LockInstance( pInst );
  pInst->Timers[TimerId].TimeoutRtn = TimeoutRtn;
  pInst->Timers[TimerId].TimerCount = TimeoutMS/MSPerTick;
  UnLockInstance( pInst );
}


/*----------------------------------------------------------*/
/* Cancel an internal instance timer                        */
/*                                                          */
/* This routine cancels an instance timer by clearing       */
/* the TimerCount field.                                    */
/*----------------------------------------------------------*/
void cancelDelayTimer( parInstance_t *pInst,
                       USHORT        TimerId )
{
  LockInstance( pInst );
  pInst->Timers[TimerId].TimerCount = 0;
  UnLockInstance( pInst );
}
