; SCCSID = "src/snooper/parallel/paridc.asm, parsnp, c.basedd, currbld 96/04/26"
;/****************************************************************************/
;/*                                                                          */
;/*                           IBM Confidential                               */
;/*                                                                          */
;/*                 Copyright (c) IBM Corporation 1996                       */
;/*                           All Rights Reserved                            */
;/*                                                                          */
;/****************************************************************************/
;/************************** START OF SPECIFICATIONS *************************/
;/*                                                                          */
;/*   SOURCE FILE NAME:  PARIDC.ASM                                          */
;/*                                                                          */
;/*   DESCRIPTIVE NAME:  PARALLEL port snooper IDC routines                  */
;/*                                                                          */
;/*   FUNCTION: This module is the PARALLEL port snooper device driver       */
;/*             IDC routines.                                                */
;/*                                                                          */
;/*   NOTES:                                                                 */
;/*      DEPENDENCIES: None                                                  */
;/*      RESTRICTIONS: None                                                  */
;/*                                                                          */
;/*   ENTRY POINTS:  None                                                    */
;/*                                                                          */
;/*   EXTERNAL REFERENCES:  None                                             */
;/*                                                                          */
;/* Change Log                                                               */
;/*                                                                          */
;/*  Mark    yy/mm/dd  Programmer      Comment                               */
;/*  ----    --------  ----------      -------                               */
;/*          96/04/16  Frank Schroeder Original developer.                   */
;/*                                                                          */
;/**************************** END OF SPECIFICATIONS *************************/
.286C

INCLUDE devhlp.inc

_DATA segment dword public 'DATA'
      EXTRN _Device_Help:DWORD

idc   struc
 realentry     dd    ?
 rm_ds         dw    ?
 pm_offset     dw    ?
 pm_selector   dw    ?
 pm_ds         dw    ?
idc   ends

pidc  idc      <0>
pname db       'LPT1    ',0

_DATA ends

STATICCODE segment dword public 'CODE'
ASSUME CS:STATICCODE,DS:_DATA,ES:NOTHING

; attachIDC - attach to the parallel port device driver
;             using the devhlp_attachdd function.
;
         PUBLIC _attachIDC
_attachIDC proc  near
ASSUME CS:STATICCODE,DS:_DATA,ES:NOTHING

        mov     bx, OFFSET pname
        mov     di, OFFSET pidc
        mov     dl, DevHlp_Attachdd
        call    [_Device_Help]
        ret
_attachIDC endp

; reqexcl - request exclusive hardware access from the
;           parallel port device driver.
;
         PUBLIC _reqexcl
_reqexcl  proc  near
ASSUME CS:STATICCODE,DS:_DATA,ES:NOTHING
        push    ds
        push    es

        or      pidc.pm_offset, 0       ; if no IDC entry point
        jz      _reqexcl_1              ; then just exit

        push    ds
        pop     es

        xor     ax, ax                  ; 0 = request exclusive access
        mov     bx, 1                   ; 0 = do not block, 1 = block
        mov     cx, 0                   ; port id
        mov     ds, pidc.pm_ds          ; ds = idc ds
        call    DWORD PTR es:pidc.pm_offset ; call PRINT0x.SYS

_reqexcl_1:
        pop     es
        pop     ds
        ret
_reqexcl endp

; relexcl - release exclusive access to hardware from the
;           parallel port device driver.
;
         PUBLIC _relexcl
_relexcl  proc  near
ASSUME CS:STATICCODE,DS:_DATA,ES:NOTHING
        push    ds
        push    es

        or      pidc.pm_offset, 0       ; if no IDC entry point
        jz      _relexcl_1              ; then just exit

        push    ds
        pop     es

        mov     ax, 1                   ; 1 = release exclusive access
        mov     cx, 0                   ; port id
        mov     ds, pidc.pm_ds          ; ds = idc ds
        call    DWORD PTR es:pidc.pm_offset ; call PRINT0x.SYS

_relexcl_1:
        pop     es
        pop     ds
        ret
_relexcl  endp

STATICCODE    ends
         end
