/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = "src/snooper/parallel/pardata.c, parsnp, c.basedd, currbld 96/04/17" */
/****************************************************************************/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  PARDATA.C                                             */
/*                                                                            */
/*   DESCRIPTIVE NAME:  PARALLEL port snooper device driver data segment      */
/*                                                                            */
/*   FUNCTION: This module allocates the global data area for the             */
/*             PARALLEL port snooper device driver.                           */
/*                                                                            */
/*   NOTES:                                                                   */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:                                                            */
/*             None                                                           */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*             None                                                           */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          96/01/09  Frank Schroeder Original developer.                     */
/*  159486  96/07/17  Jon Grimm       Change testcfg to be snooper.           */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#include "par.h"

/*--------------------------------------------------------*/
/* Global data for parallel port device driver            */
/*--------------------------------------------------------*/

USHORT             cInstances = 0;

parInstance_t      *pFreeInstanceList = 0;
parInstance_t      *pInstanceHead = 0;
parInstance_t      *pInstanceFoot = 0;

USHORT             MSPerTick = 32L;

parInstance_t      InstanceCBs[MAX_LPT] = {0};

USHORT InitData = 0;


PFNRM  RM_Help3 = 0;
UCHAR  DrvrNameTxt[]     = "TESTCFG.SYS ";
USHORT DrvrNameSize      = sizeof(DrvrNameTxt);
UCHAR  DrvrDescriptTxt[] = "TESTCFG Test Configuration Device Driver";
UCHAR  VendorNameTxt[]   = "IBM OS/2";

DRIVERSTRUCT DriverStruct =
{
   DrvrNameTxt,                              /* DrvrName                */
   DrvrDescriptTxt,                          /* DrvrDescript            */
   VendorNameTxt,                            /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   1996,7,17,                                /* Date                    */
   DRF_STATIC,                               /* DrvrFlags               */
   DRT_SERVICE,                              /* DrvrType                */
   DRS_SNOOPER,                              /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};

