/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/pc_samp/pc_samp.c, pc_samp, c.basedd 93/03/21";*/

/**************************************************************************
 *
 * SOURCE FILE NAME = PC_SAMP.C
 *
 * DESCRIPTIVE NAME = PC_SAMP.EXE - Adapter Presence Detection Sample
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :  Calling sequences for TESTCFG Device Driver
 *
 *
 *
*/
#define INCL_DOSDEVICES
#include <os2def16.h>
#include <bsedos16.h>


#define DEBUG   1

#if DEBUG
VOID NEAR printf(NPSZ,...);
#define DBGPRINT(a,b) printf(a,b)
#else
#define DBGPRINT(a,b)
#endif

#define TSTCFG_CAT              0x80
#define TSTCFG_FCN_READBIOS     0x40
#define TSTCFG_FCN_INPUT        0x41
#define TSTCFG_FCN_OUTPUT       0x42
#define TSTCFG_FCN_BUSTYPE      0x60

/*------------------------*/
/* TESTCFG Open Variables */
/*------------------------*/

HFILE             hTESTCFG;
USHORT            rc;
USHORT            action;

/*------------------------------*/
/* Determine Bus Type Variables */
/*------------------------------*/

ULONG           Command = 0;
ULONG           BusType;
PSZ             BusText[] = { "ISA", "MCA", "EISA" };

/*----------------------*/
/* Port I/O Variables   */
/*----------------------*/

struct _PortAddr
{
  USHORT        ioaddr;
  USHORT        iowidth;
};

struct _PortAddr PortIOAddress = {0x3F7, 1};
USHORT           PortContents  =  0;

/*----------------------*/
/* BIOS READ Variables  */
/*----------------------*/

struct _BIOSAddr
{
  ULONG          Command;
  ULONG          PhysAddr;
};
struct _BIOSAddr BIOSReadAddress = {0l, 0xE0000l};
BYTE             BIOSContents[28];
USHORT           i;


/*-----------------------------------*/
/*                                   */
/* Sample of TESTCFG Function Calls  */
/*                                   */
/*-----------------------------------*/

main()
{

  /*------------------------*/
  /* Open TESTCFG Driver    */
  /*------------------------*/

  if ( rc=DosOpen( "TESTCFG$",
                   &hTESTCFG,
                   &action,
                   0L,
                   0,
                   1,
                   0x40,
                   0L              ) )

    {
      DBGPRINT( "Cannot open TESTCFG driver - Rc = %d\n\r", rc );
      return(1);
    }

  /*----------------------------*/
  /* Determine Machine Bus Type */
  /*----------------------------*/

  if ( rc = DosDevIOCtl( (PVOID) &BusType,
                         (PVOID) &Command,
                         (USHORT) TSTCFG_FCN_BUSTYPE,
                         (USHORT) TSTCFG_CAT,
                         (HFILE)  hTESTCFG           ) )
     {
       DBGPRINT( "Cannot determine Bus Type - Rc = %d\n\r", rc );
       return(1);
     }

  if (BusType > 2) BusType = 3;

  DBGPRINT( "Machine Bus Type = %s\n\r", BusText[BusType]);

  /*----------------------------*/
  /* Read BIOS ROM at E000:0    */
  /*----------------------------*/

  if ( rc = DosDevIOCtl2( (PVOID) &BIOSContents,
                          (USHORT) sizeof(BIOSContents),
                          (PVOID) &BIOSReadAddress,
                          (USHORT) sizeof(BIOSReadAddress),
                          (USHORT) TSTCFG_FCN_READBIOS,
                          (USHORT) TSTCFG_CAT,
                          (HFILE)  hTESTCFG           ) )
     {
       DBGPRINT( "Cannot read BIOS - Rc = %d\n\r", rc );
       return(1);
     }

   DBGPRINT( "BIOS ROM at %05lx = ", BIOSReadAddress.PhysAddr);

   for ( i=0; i < sizeof(BIOSContents); i++ )
     {
       DBGPRINT("%02x",BIOSContents[i]);
     }
    DBGPRINT("\n\r",0);

  /*----------------------------*/
  /* Read I/O Port 0x3F7        */
  /*----------------------------*/

  if ( rc = DosDevIOCtl( (PVOID) &PortContents,
                         (PVOID) &PortIOAddress,
                         (USHORT) TSTCFG_FCN_INPUT,
                         (USHORT) TSTCFG_CAT,
                         (HFILE)  hTESTCFG           ) )
     {
       /*  PORT I/O IOCTL failed  */
       DBGPRINT( "Cannot read port - Rc = %d\n\r", rc );
       return(1);
     }

  DBGPRINT( "Port Value    = %04x\n\r", PortIOAddress.ioaddr );
  DBGPRINT( "Port Contents = %04x\n\r", PortContents );

  return(0);

}
