/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%W% %E%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  SCSTRAT1.C
 *
 * DESCRIPTIVE NAME = OS2SCSI.DMD - OS/2 SCSI.SYS Emulation
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Strategy 1 entry point and request router
 *
 *
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "devcmd.h"
#include "error.h"
#include "strat2.h"
#include "reqpkt.h"
#include "scb.h"
#include "iorb.h"
#include "scsi.h"
#include "scscsi.h"
#include "scgen.h"
#include "scproto.h"


void near IDCEntry()
{
  PRPH          pRPH;

  _asm { mov word ptr pRPH[0], bx };
  _asm { mov word ptr pRPH[2], es };

  DDRoute(pRPH, IDC_ENTRY);

  _asm {LEAVE};
  _asm {retf};
}

void near DDStrat1Entry()
{
  PRPH          pRPH;

  _asm { mov word ptr pRPH[0], bx };
  _asm { mov word ptr pRPH[2], es };

  DDRoute(pRPH, STRAT1_ENTRY);

  _asm {LEAVE};
  _asm {retf};
}


void near DDRoute(pRPH, EntryType)
PRPH          pRPH;
USHORT        EntryType;
{
  USHORT        Cmd, status;

  Cmd = pRPH->Cmd;

  /*----------------------------*/
  /* Filter out invaid requests */
  /*----------------------------*/

  switch (Cmd)
  {
     case CMDGenIOCTL:
        status = f_DriveGenIOCtl(EntryType, pRPH);
        break;

     case CMDInitBase:
        status = f_DriveInit( (PRPINITIN) pRPH );
        break;

     default:
        status = STDON + STERR + ERROR_I24_BAD_COMMAND;
  }
  pRPH->Status = status;
}

