/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%W% %E%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = SCPROTO.H
 *
 * DESCRIPTIVE NAME = OS2SCSI.DMD - OS/2 SCSI.SYS Emulation
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : C function prototype statements
 *
 *
 *
*/

/*--------------------------------*/
/* OS2SCSI Entry Point Prototypes */
/*--------------------------------*/


/*--------------------*/
/* Strategy 1 Router  */
/*--------------------*/

void near DDStrat1Entry();
void near IDCEntry();
void near DDRoute(PRPH, USHORT);


/*----------------------------*/
/* Strategy 1 Worker Routines */
/*----------------------------*/

USHORT near CmdErr(PRPH);


/*----------*/
/* SCINIT.C */
/*----------*/

USHORT far  f_DriveInit(PRPINITIN);
USHORT near Build_UnitCBs();


/*------------*/
/* SCGIOCTL.C */
/*------------*/
USHORT near DriveGenIOCtl(USHORT,PRPH);
USHORT far  f_DriveGenIOCtl(USHORT,PRPH);

USHORT near AllocDev(     PRP_GENIOCTL);
USHORT near ReadDevParms( PRP_GENIOCTL);
USHORT near Reset_Init(   PRP_GENIOCTL);
USHORT near SetTimeout(   PRP_GENIOCTL);
USHORT near ReadTimeout(  PRP_GENIOCTL);
USHORT near DeallocDev(   PRP_GENIOCTL);
USHORT near RetTypeCnt(   PRP_GENIOCTL);
USHORT near SendAbort(    PRP_GENIOCTL, USHORT);
USHORT near XferSCB(      PRP_GENIOCTL);

/*------------*/
/* SCXFRSCB.C */
/*------------*/
BOOL   near DistributeCommand(   NPUCB                );
BOOL   near SendOtherSCSI(       NPUCB, PBYTE, USHORT );
BOOL   near SendSCB(             NPUCB                );
BOOL   near SendExecuteIO(       NPUCB, USHORT, USHORT);
BOOL   near SendFormat(          NPUCB                );
BOOL   near GetCmdCmpStatus(     NPUCB                );
BOOL   near MakeReqSenseCDB(     NPUCB                );
BOOL   near MakeReadDevCapCDB(   NPUCB                );
BOOL   near MakeDevInquiryCDB(   NPUCB                );
BOOL   near MakeReassignBlockCDB(NPUCB                );

void   _loadds far  GetNotification( PIORBH );
void   _loadds far  NotifyIORBDone(  PIORBH );

/*------------*/
/* SCCRTTSB.C */
/*------------*/
void   near CreateTSB(   NPUCB, PTSB);
void   far  f_CreateTSB( NPUCB, PTSB);

/*------------*/
/* SCSUBRS.C  */
/*------------*/
USHORT       near SetAdditionalData();

VOID         near WaitOtherIORB(    NPUCB);
VOID         near ReleaseOtherIORB( NPUCB);

USHORT       near WaitIORB(           PRP_GENIOCTL, USHORT);
VOID         near ReleaseIORB(        PRP_GENIOCTL);
USHORT       near HoldInTimeOutQ(     NPUCB, PRP_GENIOCTL);
NPQELE       near AddToTimeOutQ(      NPUCB, PRP_GENIOCTL);
USHORT       near RemoveFromTimeOutQ( NPUCB, NPQELE      );

BOOL         near ValidateUserPacket( PRP_GENIOCTL, NPUCB, USHORT);
VOID         near UnlockUserPacket(   NPUCB);

VOID         near FlushReqPkt( NPUCB);

USHORT       near CheckIORBError(   NPUCB, NPIORBH);
USHORT       far  f_CheckIORBError( NPUCB, NPIORBH);

USHORT       near AllocateGDTSel(VOID);
VOID         near DeallocateGDTSel(USHORT);

ULONG        near MS_to_S(ULONG);
ULONG        near S_to_MS(ULONG);

/*--------------------*/
/* pragma definition  */
/*--------------------*/

#pragma alloc_text(InitCode, f_DriveInit)
#pragma alloc_text(InitCode, Build_UnitCBs)
#pragma alloc_text(InitCode, SetAdditionalData)

