/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/os2scsi/scgen.h, scsy, mer.basedd 93/03/19";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = SCGEN.H
 *
 * DESCRIPTIVE NAME = OS2SCSI.DMD - OS/2 SCSI.SYS Emulation
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Internal control block structures
 *
 *
 *
*/
#include "cmdparse.h"

/***********************/
/* Max CDB Buffer Size */
/***********************/

#define  MAX_CDB_SIZE           sizeof(SCSICDB12)


/*********************************/
/* Unit Control Block Definition */
/*********************************/

#define MAX_TIMEOUT_ENTRIES     4

typedef struct _QELE  QELE, near *NPQELE, far *PQELE;

typedef struct _QELE
{
  NPQELE        Next;
  ULONG         pRP;

} QELE, near *NPQELE, far *PQELE;


/*-------------------------------*/
/* Unit Control Block Definition */
/*-------------------------------*/

typedef struct _UnitControlBlock
{
  USHORT                Index;
  UNITINFO              UnitInfo;               /* Additional Driver Info     */
  USHORT                UnitStatus;             /* Unit Status                */
  USHORT                IntUnitFlags;           /* Internal unit flags        */

  void                 (far *AdapterDriverEP)();/* ADD Entry Point            */

  USHORT                DeviceKeyIndex;
  BYTE                  SCBArcCardLevel;
  BYTE                  Reserved_1;

  ULONG                 Timeout;                /* Timeout value              */

  UCHAR                 hLockDataP[12];         /* lock handle of data pkt    */
  ULONG                 ppDataPkt;              /* phys   addr for data pkt   */
  ULONG                 lnDataPkt;              /* linear addr for data pkt   */

  USHORT                WaitReqCnt;             /* Count of waiting req pkts  */
  USHORT                OtherReqCnt;            /* Count of waiting req pkts  */

  NPQELE                TimeOutQHead;
  NPQELE                TimeOutQFoot;
  NPQELE                TimeOutQFree;
  QELE                  TimeOutQ[MAX_TIMEOUT_ENTRIES];

  PSCBHDR               pCurrentSCBH;           /* Current SCB chained        */
  ULONG                 ppCurrentSCB;           /* Current SCB phys pointer   */

  IORBH                 XferSCB_IORB;
  BYTE                  XferSCB_Reserved[MAX_IORB_SIZE-sizeof(IORBH)];
  SCSI_STATUS_BLOCK     XferSCB_SSB;
  BYTE                  Align_1;

  IORBH                 Other_IORB;
  BYTE                  Other_Reserved[MAX_IORB_SIZE-sizeof(IORBH)];
  SCSI_STATUS_BLOCK     Other_SSB;
  BYTE                  Align_2;

  BYTE                  CDB_Buff[MAX_CDB_SIZE];


  USHORT                SenseSel;
  USHORT                lnSenseData;
  PSCSI_REQSENSE_DATA   pSenseData;

  USHORT                LastStatus;             /* status       - last cmd    */
  USHORT                LastErrCode;            /* error code   - last cmd    */
  SCSI_STATUS_BLOCK     LastSSB;                /* status block - last cmd    */
  BYTE                  Align_3;
  ULONG                 ppLastSCB;              /* SCB o        - last cmd    */

} UNITCB, near *NPUCB;


/*--------------------------------*/
/* Internal Unit Flags Definition */
/*--------------------------------*/

#define IUF_ALLOCATED           0x0001         /* Device already allocated    */
#define IUF_IBM_SCB             0x0002         /* Supports IBM SCB commands   */

#ifdef SHARING
#define IUF_SHARED              0x0004         /* Device is deallocated for sharing    */
#endif

#define IUF_IORB_BUSY           0x8000         /* Xfer  SCB IORB buffer in use*/
#define IUF_OTHERIORB_BUSY      0x4000         /* Other IORB     buffer in use*/
#define IUF_REQ_FLUSH           0x2000         /* Q'd reqs should be flushed  */
#define IUF_REQ_ABORT           0x1000         /* Abort in progress           */


/**************************/
/* Selectors for S/G List */
/**************************/

typedef struct _SELARRAY
{
  SEL           GDTSel[];
} SELARRAY, near *NPSELARRAY;

/********************/
/* Macro Definition */
/********************/

#define  CLEAR_IORB_BUFF  for(i=0; i<MAX_IORB_SIZE; i++) *((NPBYTE)npIORB+i)=0;  \
                          ((NPIORBH)npIORB)->RequestControl = IORB_DISABLE_RETRY;\
                          *(NPUCB *)((NPIORBH)npIORB->DMWorkSpace) = npUCB;
#define  CLEAR_CDB_BUFF  for(i=0; i<MAX_CDB_SIZE; i++) *((NPBYTE)npCDB+i)=0
#define  CLEAR_SSB_BUFF  for(i=0; i<sizeof(SCSI_STATUS_BLOCK); i++) *((NPBYTE)npSSB+i)=0

#define  DISABLE _asm {cli}
#define  ENABLE  _asm {sti}

/*****************************/
/* Return code from WaitIORB */
/*****************************/

#define  REQ_FLUSHED     0xFFFF           /* Request was flushed              */
#define  REQ_INTERRUPTED 0xFFFE           /* Request was interrupted (Ctrl-C) */

/***********************************************/
/* Return code from Get Command Cmplete Status */
/***********************************************/

#define  REQ_CMDCMPST 0x8000           /* Command was SCBCMDSTATUS            */
                                       /* after call DistributeCommand        */
#define  MAX_REQ_WAIT          (1000l)

/********************************/
/* Allocate/Deallocate Selector */
/********************************/

#define MAX_GDT_SEL_STACK            4
#define R0_STACK_SEL            0x0030
#define LDT_SEL                 0x0004

#define IDC_ENTRY               0
#define STRAT1_ENTRY            1


/************/
/* (SCSI.H) */
/************/

#define SCSI_FORMAT_UNIT        0x04
#define DEFECT_BLOCK_FORMAT     0
#define DEFAULT_TIMEOUT         60      /* 60 second default timeout          */

/***********/
/* (SCB.H) */
/***********/

#define RD_SCB                  SCBEfRD
#define ES_SCB                  SCBEfES
#define PT_SCB                  SCBEfPT
#define SCB_ND_NS              (SCBCfND | SCBCfNS)

/**********/
/* IORB.H */
/**********/

#define IORB_ERR_MASK           0x7F00

/*--------------------------------------------------------------*/
/* Init data allocated at the end of the data segment has the   */
/* following structure:                                         */
/*--------------------------------------------------------------*/

typedef struct _INITDATA
{
   UCHAR           ScratchBuffer[1024*4];      /* Scratch buffer              */
   UCHAR           ScratchIORB[MAX_IORB_SIZE]; /* IORB used during init       */
} INITDATA, NEAR *NPINITDATA;


/*
** TOKEN IDs  - opt.id definitions
**
** note:  - Assign a unique token id (1 - 255) for each valid
**          option.
*/

#define TOK_ID_ADAPTER        1
#define TOK_ID_PORT           2
#define TOK_ID_UNIT           3
#define TOK_ID_DMA            4
#define TOK_ID_IRQ            5
#define TOK_ID_AHS            6
#define TOK_ID_NOT_AHS        7
#define TOK_ID_FORMAT         8
#define TOK_ID_S_BYTES        9
#define TOK_ID_MCA           10
#define TOK_ID_PS2           TOK_ID_MCA
#define TOK_ID_SLOT          11
#define TOK_ID_DM            12
#define TOK_ID_NOT_DM        13
#define TOK_ID_SM            14
#define TOK_ID_NOT_SM        15
#define TOK_ID_HCW           16
#define TOK_ID_NOT_HCW       17
#define TOK_ID_HCR           18
#define TOK_ID_NOT_HCR       19
#define TOK_ID_DEV0          20
#define TOK_ID_CAM           21
#define TOK_ID_NOT_CAM       22
#define TOK_ID_FDT           23
#define TOK_ID_NOT_FDT       24
#define TOK_ID_GEO           25
#define TOK_ID_SMS           26
#define TOK_ID_NOT_SMS       27
#define TOK_ID_SN            28
#define TOK_ID_NOT_SN        29
#define TOK_ID_ET            30
#define TOK_ID_NOT_ET        31
#define TOK_ID_CHGLINE       32
#define TOK_ID_SHARE         33


#define OUTBUF_LEN         255

#define TOKVBUF_LEN        255

#define TOKLEN_ID_END      TOKL_ID_END

BOOL NEAR Parse_Command(PSZ pCmdLine);
USHORT NEAR Command_Line_Parser(PSZ pCmdLine, POPTIONTABLE pOptTable, PBYTE pOutBuf, USHORT OutBuf_Len);
/* static */ VOID   NEAR Insert_End_Token(PBYTE pOutBuf, USHORT out_buf_index);
/* static */ USHORT NEAR Locate_First_Slash(PSZ * ppcmdline_slash);
/* static */ USHORT NEAR strlen(const CHAR FAR *);
/* static */ BOOL   NEAR strncmp(const CHAR FAR *,const CHAR FAR *,USHORT);
/* static */ USHORT NEAR Parse_Option_Value(POPT ptable_option, PUSHORT ptokv_index);
/* static */ VOID   NEAR Skip_Over_Blanks();
/* static */ USHORT NEAR Insert_Token(PBYTE pOutBuf, PUSHORT pout_buf_index, USHORT out_buf_len,
                         USHORT tokv_index, BYTE option_id);
/* static */ USHORT NEAR Locate_Next_Slash(PSZ * ppcmdline_slash);


#pragma alloc_text(InitCode, Parse_Command)
#pragma alloc_text(InitCode, Command_Line_Parser)
#pragma alloc_text(InitCode, Insert_End_Token)
#pragma alloc_text(InitCode, Locate_First_Slash)
#pragma alloc_text(InitCode, strlen)
#pragma alloc_text(InitCode, strncmp)
#pragma alloc_text(InitCode, Parse_Option_Value)
#pragma alloc_text(InitCode, Skip_Over_Blanks)
#pragma alloc_text(InitCode, Insert_Token)
#pragma alloc_text(InitCode, Locate_Next_Slash)

