/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/os2scsi/scdata.c, scsy, mer.basedd 93/03/19";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = SCDATA.C
 *
 * DESCRIPTIVE NAME = OS2SCSI.DMD - OS/2 SCSI.SYS Emulation
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Static/Initialization Data
 *
 *
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "devhdr.h"
#include "strat2.h"
#include "reqpkt.h"
#include "scb.h"
#include "iorb.h"
#include "scsi.h"
#include "scscsi.h"
#include "scgen.h"
#include "scproto.h"

/***************************************************************/
/*  GLOBAL DATA                                                */
/*  -----------                                                */
/***************************************************************/

/*-------------------------------------------------------------*/
/* Disk Device Driver Header                                   */
/*                                                             */
/* This must be at the beginning of the data segment           */
/* AND MUST NOT BE MOVED.                                      */
/*-------------------------------------------------------------*/

struct _DDHDR DiskDDHeader =
{
   (PVOID) -1L,                         /* Pointer to next DD Header          */
   DEVLEV_3 | DEV_CHAR_DEV | DEV_IOCTL, /* Device attribute (2 bytes)         */
   (USHORT) DDStrat1Entry,              /* Offset to Strategy routine         */
   (USHORT) IDCEntry,                   /* Offset to IDC Entry Point          */
   "SCSI-02$",                          /* Device Name (the same as SCSI.SYS) */
   0,                                   /* Protect mode CS of strategy EP     */
   0,                                   /* Protect mode DS of strategy EP     */
   0,
   0,
   DEV_ADAPTER_DD
};


USHORT          NumDrivers = 0;            /* number of adapter drivers       */
USHORT          NumUnitCBs = 0;            /* number of unit control blocks   */

NPSELARRAY      npSelArray = 0;            /* near pointer to GDT sel buffer  */

ULONG           plDataSeg= 0;              /* linear addr of our data seg     */
PVOID           pDataSeg = 0;              /* virt ptr of our data segment    */
PFN             Device_Help=0L;            /* far ptr to devhelp function     */

UCHAR           CDB_cCode_to_cLen[8] =     /* Maps high 3 bits of CDB         */
                 {0x06, 0x0A, 0x0A, 0x00,  /* command code to CDB length.     */
                  0x00, 0x0C, 0x0A, 0x00};

USHORT          GDTSelStack[MAX_GDT_SEL_STACK+1] = {0};
USHORT          GDTSelStackPtr = MAX_GDT_SEL_STACK;

TSB             TSB_GetCmdCmp = {
                                 1,        /* Ending status                   */
                                 0,        /* Retry count                     */
                                 0,        /* Residual byte count             */
                                 0,        /* Residual physical buffer addr   */
                                 0x0c,     /* Additional status length        */
                                 0,        /* SCSI Status                     */
                                 1,        /* Command status                  */
                                 0,        /* Device error code               */
                                 0,        /* Command error code              */
                                 0,        /* Diagnostic error modifier       */
                                 0,        /* Cache info word                 */
                                 0   };    /* Phys ptr to last SCB processed  */

#ifdef SHARING
USHORT          ShareAllocation = FALSE;   /* If true, device allocation is to be shared. */
                                           /* Being allocated before and released         */
                                           /* after IOCtl requests.                       */
#endif

/* Dont put any other static data past here.  Will get blown away by pool */
UNITCB          UnitCB[1] = {0};           /* UnitCBs allocated here          */
UCHAR           Pool[(sizeof(UNITCB) * MAX_SCSI_DEVICES) + sizeof(INITDATA)] = {0};

#ifdef PARSE

BYTE     outbuf[OUTBUF_LEN] = {0};
BYTE     tokvbuf[TOKVBUF_LEN] = {0};
PSZ      pcmd_line = NULL;
PSZ      pcmdline_slash = NULL;

#define ENTRY_STATE        0
#define MAX_STATES         2


/*                                        opt.state[] initialization definitions
**                                         ____ entry state
**                                         |                           previous
**                                         v                               opt |
**  ----Command Line Option --------      ----- STATE TABLE  --------------    |
**  token id          string   type        0    1    2                         |
**                                                                           <-|
**                                         *   /SHARE
**
**
**
*/

// if strings are not assigned to variable names they get put at beginning of data segment
// and through off device driver header
CHAR share[]   = "/SHARE";
CHAR end[]     = "\0";

OPT OPT_SHARE =
   {TOK_ID_SHARE,   share,   TYPE_0,      {0,  E,  E}};

OPT OPT_END =
   {TOK_ID_END,     end,     TYPE_0,      {O,  O,  O}};


/*                                                                          */
/*   The following is a generic OPTIONTABLE for ADDs which support diskette */
/*   devices.                                                               */
/*                                                                          */

OPTIONTABLE  opttable =
{   ENTRY_STATE, MAX_STATES,
    {(POPT) &OPT_SHARE,
     (POPT) &OPT_END
    }
};

#endif
