/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/os2dasd/dmdata.c, dsdm, r207 93/10/08";*/
#define SCCSID  "src/dev/dasd/os2dasd/dmdata.c, dsdm, r207 93/10/08"

/**************************************************************************
 *
 * SOURCE FILE NAME = DMDATA.C
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Static/Initialization data for DASD Device Mgr
 *
 *
 *
*/


#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#define INCL_ERROR_H

#include "os2.h"
#include "misc.h"
#include "gas.h"    /* @V111573 */

#include "dmdefs.h"

#include "devhdr.h"
#include "devcmd.h"
#include "strat2.h"
#include "reqpkt.h"
#include "dhcalls.h"
#include "scb.h"
#include "abios.h"
#include "iorb.h"

#include "rmbase.h"
#include "rmcalls.h"

#include "dmtrace.h"
#include "dmgencb.h"
#include "dmproto.h"
#include "ata.h"
#include "dmioctl.h"
#include "ioctl.h"
#include "dskioctl.h"

/***************************************************************/
/*  GLOBAL DATA                                                */
/*  -----------                                                */
/*  1. Static data                                             */
/*  2. Dynamic data allocated at init time:                    */
/*     - UnitCB                                                */
/*     - VolCB                                                 */
/*     - VCS                                                   */
/*  3. Dynamic data allocated at run time:                     */
/*     - IORB                                                  */
/*  4. Static init data discarded after init time              */
/***************************************************************/

#define MAXADAPTERDRIVERS       32         /* Max adapter device drivers     */

/*  ScratchBuffer should appear after DiskDDHeader and should not be         */
/*  moved to make sure it does not span a 64K boundary.  It wont here        */
/*  since the data segment is page frame aligned.                            */

UCHAR           ScratchBuffer[1024] = {0};                                      

PFN             Device_Help=0L;            /* far ptr to devhelp function    */
PBYTE           pSysInfoSeg=0L;            /* Pointer to sys info seg        */
PBYTE           pSIS_mec_table=0L;         /* Pointer to RAS MEC Trace Table */
PVOID           pDataSeg=0L;               /* virt ptr of our data segment   */
ULONG           ppDataSeg=0L;              /* phys addr of our data segment  */
ULONG           plDataSeg=0L;              /* linear addr of our data seg    */
ULONG           ppScratchBuffer=0L;        /* Phys addr of ScratchBuffer     */
USHORT          ScratchBufSem=0;           /* Semaphore for ScratchBuffer    */
USHORT          DDFlags=0;                 /* Global driver flags            */
UCHAR FAR      *pInterruptLevel = 0;       /* ptr to Interruptlevel d159983  */
USHORT          DefaultQueueMethod=0;      /* Queuing - priority/nopriority  */ /*@V74404*/
USHORT          DefaultSortMethod=0;       /* Sorting - fifo/elevator        */ /*@V74404*/

NPUNITCB        UnitCB_Head=0;             /* near ptr to first UnitCB       */
NPVOLCB         VolCB_Head=0;              /* near ptr to first VolCB        */
// d159983 NPVOLCB         VolCB_Hint=0;              /* hint for VolCB        154306   */
NPVOLCB         pVolCB_DriveA=0;           /* Pointer to A: VolCB            */
NPVOLCB         pVolCB_DriveB=0;           /* Pointer to B: VolCB            */
NPVOLCB         pVolCB_DriveC=0;           /* Pointer to C: VolCB            */
NPVOLCB         pVolCB_80=0;               /* Pointer to VolCB for drive 80H */
USHORT          NextLogDriveNum=0;         /* next logical drive number      */

NPBYTE          pNextFreeCB=0;             /* ptr to next free control blk   */
NPVOLCB         pLastLogVolCB=0;

USHORT          NumDrivers=0;              /* number of adapter drivers      */
USHORT          NumUnitCBs=0;              /* number of unit control blocks  */
USHORT          NumVolCBs=0;               /* number of volume control blocks*/
USHORT          NumLogDrives=0;            /* number of logical drives       */
USHORT          NumRemovableDisks=0;       /* number of removable disk drives*/
USHORT          NumFixedDisks=0;           /* number of fixed disk drives    */
USHORT          NumRMasFixed=0;            /*HCT number of removable as fixed disk drives*/
BOOL            TreatAsFixed=TRUE;         /* treating removables as fixed   */
BOOL            OpticalAsFixed=FALSE;      /* treating Optical as fixed      */
USHORT          NumPartitions=0;           /* number of fixed disk partitions*/
USHORT          NumFTPartitions=0;         /* number of fault tol. partitions*/
NPVOLCB         pExtraVolCBs=0;            /* Pointer to extra volcbs        */
USHORT          NumExtraVolCBs=0;          /* number of extra volcbs         */
USHORT          NumAdapters=0;             /* number of adapters             */
USHORT          NumReqsInProgress=0;       /* num requests in progress       */
USHORT          NumReqsWaiting=0;          /* num requests on waiting queues */
USHORT          NumRLEReqsWaiting=0;       /* @RAWIO - num RLE requests on queues */
USHORT          TraceFlags=0;              /* Trace Flags                    */
NPBYTE          pDMTraceBuf=0;             /* pointer to internal trace buffer*/
NPBYTE          pDMTraceHead=0;            /* pointer to head of trace buffer */
NPBYTE          pDMTraceEnd=0;             /* pointer to end of trace buffer */

NPBYTE          CB_FreeList=0;             /* Control Block Free List for    */
                                           /*  IORBs and CWAs                */

USHORT          PoolSem=0;                 /* Pool semaphore                 */
USHORT          PoolSize=0;                /* Size of control block pool     */
USHORT          FreePoolSpace=0;           /* Free space left in pool        */

UCHAR           fBigFat=0;                 /* flags for drives               */
UCHAR           XActPDrv=0;

PVOID           pFSD_EndofInt=0L;          /* FSD's End of interrupt routine */
PVOID           pFSD_AccValidate=0L;       /* FSD's Access Validation routine*/
PVOID           pDiskFT_Request=0L;        /* DISKFT's Request routine       */
PVOID           pDiskFT_Done=0L;           /* DISKFT's Done routine          */
USHORT          DiskFT_DS=0L;              /* DISKFT's DS selector           */

PRTYQ           DeferredQRP={0};           /* Queue for Deferred FT Requests */
PRTYQ           DeferredQRLE={0};          /* Queue for Deferred FT Requests */
USHORT          NumReqsDeferred=0;         /* num requests on Deferred queues*/


DriverCaps      DriverCapabilities= {0};   /* Driver Capabilities structure  */

BYTE            PFV_PreviousState=0;                                 /*@V55646*/

DISKTABLE_ENTRY  DiskTable[DISKTABLECOUNT] =
                           {
                               { 32l*KB, 3,   8, 512, 0},
                               { 64l*KB, 2,   4, 512, vf_Big},
                               {256l*KB, 2,   4, 512, vf_Big},
                               {512l*KB, 3,   8, 512, vf_Big},
                               {  1l*MB, 4,  16, 512, vf_Big},
                               {  2l*MB, 5,  32, 512, vf_Big},
                               {  4l*MB, 6,  64, 512, vf_Big},
                               {  8l*MB, 7,  64, 512, vf_Big+vf_NoDOSPartition},
                            {0xFFFFFFFF, 7,  64, 512, vf_Big+vf_NoDOSPartition}
                           };



BPB  BPB_Minimum = {512, 1, 1, 1, 16,  4,    0xF0,        1,  0, 0, 0, 0};
BPB  BPB_160KB   = {512, 1, 1, 2, 64,  320,  MEDIA_160KB, 1,  8, 1, 0, 0};
BPB  BPB_180KB   = {512, 1, 1, 2, 64,  360,  MEDIA_180KB, 2,  9, 1, 0, 0};
BPB  BPB_320KB   = {512, 2, 1, 2, 112, 640,  MEDIA_320KB, 1,  8, 2, 0, 0};
BPB  BPB_360KB   = {512, 2, 1, 2, 112, 720,  MEDIA_360KB, 2,  9, 2, 0, 0};
BPB  BPB_12MB    = {512, 1, 1, 2, 224, 2400, MEDIA_12MB,  7, 15, 2, 0, 0};
BPB  BPB_720KB   = {512, 2, 1, 2, 112, 1440, MEDIA_720KB, 3,  9, 2, 0, 0};
BPB  BPB_144MB   = {512, 1, 1, 2, 224, 2880, MEDIA_144MB, 9, 18, 2, 0, 0};
BPB  BPB_288MB   = {512, 2, 1, 2, 240, 5760, MEDIA_288MB, 9, 36, 2, 0, 0};
BPB  BPB_125MB   ={1024, 1, 1, 2, 192, 1232, MEDIA_125MB, 2,  8, 2, 0, 0};      

PBPB DummyBPB = 0L;                     /* Pointer to BPB for drive aliasing*/

NPBPB InitBPBArray[MAX_DRIVE_LETTERS]={0}; /* BPB array returned in INIT packet*/

/* Note: If changing number of CmdTable entries, update DMDATA.H also */

CMDTABLE CmdTable[20] =                                              /*@V84908*/
{                                                                    /*VVVVVVV*/
   {PB_REQ_LIST*256 + PB_READ_X,            TRACE_READ},
   {PB_REQ_LIST*256 + PB_WRITE_X,           TRACE_WRITE},
   {PB_REQ_LIST*256 + PB_WRITEV_X,          TRACE_WRITE + TRACE_VERIFY},
   {PB_REQ_LIST*256 + PB_PREFETCH_X,        TRACE_READ + TRACE_PREFETCH},
   {IOCC_EXECUTE_IO*256+IOCM_READ,          TRACE_READ},
   {IOCC_EXECUTE_IO*256+IOCM_WRITE,         TRACE_WRITE},
   {IOCC_EXECUTE_IO*256+IOCM_WRITE_VERIFY,  TRACE_WRITE | TRACE_VERIFY},
   {IOCC_EXECUTE_IO*256+IOCM_READ_VERIFY,   TRACE_READ | TRACE_VERIFY},
   {IOCC_EXECUTE_IO*256+IOCM_READ_PREFETCH, TRACE_READ | TRACE_PREFETCH},
   {IOCC_FORMAT*256+IOCM_FORMAT_TRACK,      TRACE_FORMAT | TRACE_VERIFY},
   {CMDINPUT,         TRACE_READ},
   {CMDInputBypass,   TRACE_READ},
   {CMDOUTPUT,        TRACE_WRITE},
   {CMDOutputBypass,  TRACE_WRITE},
   {CMDOUTPUTV,       TRACE_WRITE | TRACE_VERIFY},
   {CMDOutputBypassV, TRACE_WRITE | TRACE_VERIFY},
   {CMDGenIOCTL*256 + IODC_RT, TRACE_IOCTL | TRACE_READ},
   {CMDGenIOCTL*256 + IODC_WT, TRACE_IOCTL | TRACE_WRITE},
   {CMDGenIOCTL*256 + IODC_VT, TRACE_IOCTL | TRACE_READ | TRACE_VERIFY},
   {CMDGenIOCTL*256 + IODC_FT, TRACE_IOCTL | TRACE_FORMAT | TRACE_VERIFY},
};                                                                   /*AAAAAAA*/
                                                                     /*@V84908*/

PFNRM   RM_Help0   = NULL;
PFNRM   RM_Help3   = NULL;

HDRIVER hRMOS2DASD = NULL;

USHORT  RMFlags    = 0;

/* @V111573 Generic Alert Unrecoverable error */
DASDLOGDATA GenAlert_URErr = {DEFAULTLOGHEAD32,
                              DEFAULTPSIDS,
                              DEFAULTGAS,
                              DEFAULTGASPCS,
                              DEFAULTGASFCS};

/* @V111573 Generic Alert Recoverable error */
DASDLOGDATA GenAlert_RErr =  {DEFAULTLOGHEAD32,
                              DEFAULTPSIDS,
                              DEFAULTGAS,
                              DEFAULTGASPCS,
                              DEFAULTGASFCS};

NPVOLCB         DriveToVolCB[256] = {0};    /* Drive to VolCB lookup d159983 */
                                            /* a bit wasteful, the algorithm */
                                            /* can be changed if needed      */
UCHAR EjectCDB[6]={0x1b,0,0,0,2,0};
UCHAR EjectCDB1[6]={0x1b,0,0,0,0,0};
UCHAR StartCDB[6]={0x1b,0,0,0,1,0};
MSGTABLE Msginfo={1178,1,0};
UCHAR ShutdownIORB[MAX_IORB_SIZE]={0};      /* Shutdown time IORB   */

/*  UnitCBs are allocated after all static data                              */
UNITCB          FirstUnitCB[1]={0};     /* First UnitCB allocated here       */

USHORT          CBPool[24*KB]={0};      /* Pool for Control blocks           */


UCHAR RMFixed_Txt[]     = "FIXDSK_#  Fixed Disk Drive ";
UCHAR RMRemovable_Txt[] = "REMDSK_#  Removable Disk Drive";
UCHAR RMDskt_Txt[]      = "DSKT_#  Diskette Drive "  ;

UCHAR RMSysName_Txt[]   = "x:  Logical DASD Volume";

UCHAR OS2DASD_Txt01[] = "OS2DASD.DMD";
UCHAR OS2DASD_Txt02[] = "OS2DASD OS/2 DASD Device Manager";
UCHAR OS2DASD_Txt03[] = "IBM";

#define OS2DASD_VER_MAJOR       3
#define OS2DASD_VER_MINOR       0

DRIVERSTRUCT RMDASDDesc =
{
  OS2DASD_Txt01,              /* DrvrName;       */
  OS2DASD_Txt02,              /* DrvrDescript;   */
  OS2DASD_Txt03,              /* VendorName;     */
  CMVERSION_MAJOR,            /* MajorVer;       */
  CMVERSION_MINOR,            /* MinorVer;       */
  1994, 9, 13,                /* Date;           */
  DRF_STATIC,                 /* DrvrFlags;      */
  DRT_ADDDM,                  /* DrvrType;       */
  DRS_DM,                     /* DrvrSubType;    */
  NULL                        /* DrvrCallback;   */
};
