/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/os2aspi/aspipro.h, aspi, r206 93/03/20";*/

/**************************************************************************
 *
 * SOURCE FILE NAME = ASPIPRO.H
 *
 * DESCRIPTIVE NAME = OS2ASPI.DMD - OS/2 ASPI Device Manager
 *                    ASPI Device Manager - C function prototypes
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  Define ASPI to Device Module shared structures
 *
 *
 *
*/
typedef void   near *NPVOID;
typedef USHORT near *NPUSHORT;

/*----------------------*/
/* Module: ASPISTR1.C   */
/*----------------------*/

VOID FAR ASPIEntry (USHORT ASPIDataSegment,PASPI_SRB_HEADER pSRB);
VOID FAR ASPIStr1(VOID);
VOID NEAR StatusError(PRPH pRPH, USHORT errorCode );

/*----------------------*/
/* Module: ASPIINIT.C   */
/*----------------------*/

USHORT NEAR ASPIInit(PRPINITIN pRPI);
USHORT ScanForSCSIAdapters(VOID (FAR *pADD_IORB_Entry) (PIORB),
                           struct DevClassTableEntry FAR *pADDEntry);
USHORT GetADDDeviceTable( VOID (FAR * pADD_IORB_Entry) (PIORB));
USHORT CheckUnitAllocated( VOID (FAR * pADD_IORB_Entry) (PIORB), NPUNITINFO npUI );
NPACB BuildACB(NPADAPTERINFO npAI );
NPSCSI_INQDATA GetInquiryData( NPATE npATE );
NPATE BuildATE(VOID (FAR * pADD_IORB_Entry) (PIORB), NPUNITINFO npUI,USHORT allocationStatus);
NPVOID NEAR InitAllocate( USHORT Size );
VOID NEAR InitSRBPool(VOID);
VOID FAR _loadds InitPost (PIORBH pIORBH);                           /*@V64399*/
USHORT ParseCmdLine(PDDD_PARM_LIST pADDParms);
VOID TTYWrite(PSZ Buf);

/*----------------------*/
/* Module: ASPISRB.C    */
/*----------------------*/

VOID NEAR _loadds ASPISRBEntr(PASPI_SRB_HEADER pSRBH, USHORT virtualASPI);
USHORT NEAR DoASPIInquiry(PASPI_SRB_INQUIRY pSRBI, USHORT virtualASPI);
USHORT NEAR DoASPIDeviceType(PASPI_SRB_DEVICE_TYPE pSRBDT, USHORT virtualASPI);
VOID NEAR DoASPIExecuteIO(PASPI_SRB_EXECUTE_IO pSRBIO, USHORT virtualASPI);
VOID NEAR DoASPIResetDevice(PASPI_SRB_RESET_DEVICE pSRB, USHORT virtualASPI);
VOID NEAR DoASPIAbortIO(PASPI_SRB_ABORT_IO pSRBIO, USHORT virtualASPI);
VOID NEAR AbortIORB(NPATE npATE,PASPI_SRB_ABORT_IO pSRBIO,
                    PASPI_SRBWORK pSRBToAbortWork,NPSRB_LINK npSRBLink,
                    USHORT virtualASPI);
USHORT NEAR DoASPISetAdapterParms(PASPI_SRB_ADAPTER_PARMS pSRAP, USHORT virtualASPI);
VOID NEAR SRBToIORBPassThru(NPATE npATE,PASPI_SRB_EXECUTE_IO pSRBIO,
                            NPSRB_LINK npSRBLink,USHORT virtualASPI);
VOID NEAR SRBToIORBReset(NPATE npATE,PASPI_SRB_RESET_DEVICE pSRBRD,
                         NPSRB_LINK npSRBLink, USHORT virtualASPI);
VOID CalculateCommandTimeout(PIORB_ADAPTER_PASSTHRU pIORB);
USHORT DetermineDirectionBits(NPATE npATE,PIORB_ADAPTER_PASSTHRU pIORB,PASPI_SRB_EXECUTE_IO pSRBIO);
NPACB FindAdapter(UCHAR adapterIndex);
NPATE FindTarget(UCHAR adapterIndex,UCHAR targetID, UCHAR targetLUN);
NPSRB_LINK AllocateIORB(NPATE npATE, PASPI_SRB_HEADER pSRBH,
                        VOID (NEAR *ASPIRequestRoutine)(),USHORT virtualASPI);
VOID FreeIORB(NPSRB_LINK npSRBLink);
VOID BuildPassThruIORB( NPATE npATE,PASPI_SRB_EXECUTE_IO pSRBIO,
                        NPSRB_LINK npSRBLink, USHORT virtualASPI);
VOID SendIORB(PIORBH pIORB, VOID (FAR *pADD_IORB_Entry)(PIORB));
USHORT SendIORBandWait( NPIORB npIORB, VOID (FAR * pADD_IORB_Entry) (PIORB));
VOID FAR _loadds NotifyIORBDone(PIORB fpIORB);                       /*@V61779*/
VOID ConvertIORBError(PIORBH pIORBH,PASPI_SRB_EXECUTE_IO pSRBIO);
VOID CallPostRoutine(PASPI_SRB_EXECUTE_IO pSRBIO);
USHORT SendUnitControlCommand(NPATE npATE,USHORT unitControlCommand);
VOID InsertSRBActiveQueue(NPATE npATE,NPSRB_LINK npSRBLink,PASPI_SRB_HEADER pSRBH);
VOID DeleteSRBActiveQueue(NPATE npATE,NPSRB_LINK npSRBLink);
VOID FreeGDTSelector(SEL GDTselector);
VOID FAR _loadds AllocationPost(PIORB pIORB);                        /*@V64399*/

/*----------------------*/
/* Module: ASPIASUB.ASM */
/*----------------------*/

VOID  NEAR memcpy( PBYTE Dst, PBYTE Src, USHORT cb );
VOID  NEAR memset( PBYTE Dst, UCHAR Value, USHORT byteCount);
ULONG NEAR ULONGdivUSHORT( ULONG Dividend, USHORT Divisor, NPUSHORT npRemainder );
ULONG NEAR ULONGmulULONG( ULONG Multiplier, ULONG Multiplicand );


/*----------------------*/
/* Module: ASPIVIRT.ASM */
/*----------------------*/
VOID _pascal _far VirtualASPIEntry (ULONG,PASPI_SRB_HEADER, PVOID);
VOID CallVirtPostRoutine(PVOID pSRB);
