/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = %W% %E% */
/**************************************************************************
 *
 * SOURCE FILE NAME = ASPIDATA.C
 *
 * DESCRIPTIVE NAME = OS2ASPI.DMD - OS/2 ASPI Device Manager
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : ASPI Device Manager - Static/Initialization Data
 *
 *
 *
*///#define PDDENTRY PASCAL FAR32 // to declare PDD and VDD entry points
//#define VDDENTRY _pascal _far _loadds
//typedef unsigned short (VDDENTRY *FPFNVDD)(unsigned long, unsigned long, unsigned long);   /* fpfnvdd */

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include <os2.h>

#include <devcmd.h>
#include <devclass.h>
#include <dskinit.h>

#define INCL_INITRP_ONLY
#include <reqpkt.h>

#include <iorb.h>
#include <addcalls.h>
#include <scsi.h>
#include <dhcalls.h>

#include <aspi.h>
#include <aspicons.h>
#include <aspitype.h>
#include <aspipro.h>
#include <cmdparse.h>
#include <cmdpdefs.h>

/*--------------*/
/* Static Data  */
/*--------------*/

PFN                  Device_Help = 0;

PVOID                pDataSeg = 0L;           /* virt ptr of our data segment   */
ULONG                ppDataSeg = 0L;          /* phys addr of our data segment  */
UCHAR                numberOfASPIAdapters = 0;

USHORT               InitComplete = 0;

UCHAR                OS2ASPI_Text[17] = { "OS2ASPI Dev Mgr " };
UCHAR                ASPI_PDDName[8] = "ASPI";
NPACB                npACBAnchor = 0;
USHORT               IORBWaitSem = 0;
USHORT               virtSRBWaitSem = 0;
USHORT               allocationOverride = FALSE;
USHORT               shareTargets = FALSE;
USHORT               VDDProc[3] =  {0};   /* addr of VDD entry point */

/* Assign a value to the first element to insure that the array is NOT */
/* allocated at the end of the data segment.                           */
SRB_WAIT_Q           SRBWaitQueue[25] = {0};                         /*@V61092*/

ULONG                maxPageCount = 0;

/*--------------------*/
/* Configuration Data */
/*--------------------*/
NPSRB_LINK           npSRBLinkFreeList = 0;
USHORT               freeSRBSpace = 0;

/**
 ** Use GENDTBL.CMD to build these tables.
 **
 ** It will calculate the table contents and detect conflicts
 ** between CDB direction settings.....
 **/

UCHAR DirTableDASD[] =
{
  0x09, 0x20, 0x06, 0x84, 0x00, 0x22, 0xE0, 0xF5,
  0xC0, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

UCHAR DirTableTAPE[] =
{
  0x00, 0x20, 0x14, 0x84, 0x00, 0x00, 0x00, 0x70,
  0x80, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

UCHAR DirTablePROCESSOR[]=
{
  0x00, 0x20, 0x00, 0x84, 0x00, 0x00, 0x00, 0x70,
  0x80, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

UCHAR DirTablePRINTER[] =
{
  0x08, 0x30, 0x04, 0x84, 0x00, 0x00, 0x00, 0x70,
  0x80, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

UCHAR DirTableSCANNER[] =
{
  0x00, 0x00, 0x04, 0x84, 0x08, 0x20, 0x00, 0x70,
  0x80, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

UCHAR DirTableCHANGER[] =
{
  0x00, 0x00, 0x06, 0x04, 0x00, 0x00, 0x00, 0x10,
  0x80, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

UCHAR DirTableCOMM[] =
{
  0x00, 0x20, 0x04, 0x04, 0x00, 0x20, 0x00, 0x10,
  0x80, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/**
 ** Direction exception list.
 **
 ** If a Vendor/Device is detected that matches one in this list,
 ** then the exception list is scanned for an OpCode match before
 ** using the default direction table.
 **/
UCHAR ExVendId01[] = "HP";
UCHAR ExProdId01[] = "C17";
UCHAR ExList01[]   = { 3, 0x0A, 1, 0x08, 0, 0x12, 0 };

UCHAR ExVendId02[] = "HP";
UCHAR ExProdId02[] = "C25";
UCHAR ExList02[]   = { 3, 0x0A, 1, 0x08, 0, 0x12, 0 };

DIREXCEPT DirTableExceptions[] =
{
   {ExVendId01, ExProdId01, ExList01},
   {ExVendId02, ExProdId02, ExList02},
};

USHORT MaxDirExceptions = (sizeof(DirTableExceptions) / sizeof(DIREXCEPT));

/* Assign a value to the first element to insure that the array is NOT */
/* allocated at the end of the data segment.                           */
BYTE                 ConfigPool[MAX_CONFIG_DATA]  = {0};

/*---------------------*/
/* Initialization Data */
/*---------------------*/

BYTE                 InitDataStart = 0;
UCHAR                deviceTableBuffer[MAX_DT_SIZE]={0};
DEVICETABLE          *pDeviceTable = (DEVICETABLE *) deviceTableBuffer;
USHORT               ConfigPoolAvail = MAX_CONFIG_DATA;
USHORT               numberOfSRBs;
NPBYTE               npConfigPool = ConfigPool;
USHORT               NumADDS = 0;
UCHAR                numberOfASPITargets = 0;
NPACB                npLastACB = 0;                                  /*@V55762*/
NPATE                npFirstATE = 0;                                 /*@V55762*/
NPATE                npLastATE = 0;                                  /*@V55762*/
IORBH                InitIORB = {0};
UCHAR                InitIORBPad[MAX_IORB_SIZE-sizeof(IORBH)] = {0};
UCHAR                *invalidParameters = "Invalid parameters for OS2ASPI.DMD";

#define MSG_REPLACEMENT_STRING  1178

MSGTABLE  InitMsg = { MSG_REPLACEMENT_STRING,
                      1,
                      0,
                          };

/* Unit control IORB for initialization */                           /*@V64399*/
UCHAR UnitControlIORB[sizeof(IORB_UNIT_CONTROL)] ={0};               /*@V64399*/
NPIORB_UNIT_CONTROL  npIORBUnitControl = (NPIORB_UNIT_CONTROL) &UnitControlIORB; /*@V64399*/

UCHAR InqIORB[sizeof(IORB_ADAPTER_PASSTHRU)+sizeof(SCSI_INQDATA)] = {0};
NPIORB_ADAPTER_PASSTHRU npIORBInq = (NPIORB_ADAPTER_PASSTHRU) &InqIORB;


/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#define TOKVBUF_LEN 255

PSZ        pcmdline1              = 0;
PSZ        pcmdline_slash         = 0;
PSZ        pcmdline_start         = 0;
INT        tokv_index             = 0;
INT        state_index            = 0;
INT        length                 = 0;
CHARBYTE   tokvbuf[TOKVBUF_LEN]   = { 0 };
POPT       pend_option            = 0;
POPT       ptable_option          = 0;
BYTE       *poutbuf1              = 0;
BYTE       *poutbuf_end           = 0;
CC         cc                     = { 0, 0 };

#define OUTBUF_LEN       255

BYTE     outbuf[OUTBUF_LEN] = {0};
USHORT   outbuf_len         = OUTBUF_LEN + 1;
PBYTE    poutbuf            = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         2

//                                       opt.state[] initialization definitions
//
//                                              ____ entry state
//                                              |                   previous
//                                              v                     opt |
//  ----Command Line Option --------           ----- STATE TABLE -----    |
//  token id          string   type             0   1   2   3             |
//                                                                        |
//                                              *  /A:  /I  /U: <-----------
//                                                          /GEO:
//                                                          /T:

OPT OPT_ALL =
    {TOK_ID_ALL,     "/ALL",    TYPE_0,        {0,  E,  E}};

OPT OPT_SHARE =
    {TOK_ID_SHARE,   "/SHARE",  TYPE_0,        {0,  E,  E}};

OPT OPT_END =
    {TOK_ID_END,     "\0",      TYPE_0,        {O,  O,  O}};

OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    { (POPT) &OPT_ALL,
      (POPT) &OPT_SHARE,
      (POPT) &OPT_END
    }
};

//

USHORT      nUnsupportedAdapters  =  2;
CHAR FAR*   pUnsupportedAdapterNames[] =
{
   "IPSRAID",
   // Insert other unsupported AdapterName strings here and increment the
   // above count, nUnsupportedAdapters.
   "NoSuchAdapter"
};

//

