/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = OPPROTO.H
 *
 * DESCRIPTIVE NAME = C function prototypes for OS/2 Optical Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*---------------------------------------*
 * Function declarations - Static Code   *
 *---------------------------------------*/

typedef void (near * NPSUB)(NPUNITCB,NPIORB_CDB);
USHORT InitializeDevice (NPUNITCB,NPSUB);
USHORT NEAR DriveInit (PRPINITIN, NPUNITCB);
VOID   NEAR Strat1 (PRPH);
VOID   NEAR Strat1b (void);
USHORT NEAR MediaCheck (PRP_MEDIACHECK, NPUNITCB);
USHORT NEAR BuildBPB (PRP_BUILDBPB, NPUNITCB);
USHORT NEAR Read (PRP_RWV, NPUNITCB);
USHORT NEAR RemovableMedia (PRPH, NPUNITCB);
USHORT NEAR DriveGenIOCTL (PRP_GENIOCTL, NPUNITCB);
USHORT NEAR f_DriveGenIOCTL (PRP_GENIOCTL, NPUNITCB);
USHORT NEAR ResetMedia (PRPH, NPUNITCB);
USHORT NEAR GetLogDriveMap (PRPH, NPUNITCB);
USHORT NEAR SetLogDriveMap (PRPH, NPUNITCB);
USHORT NEAR PartFixedDisks (PRP_PARTFIXEDDISKS, NPUNITCB);
USHORT NEAR GetUnitMap (PRP_GETUNITMAP, NPUNITCB);
USHORT NEAR DiskIO (PBYTE, NPUNITCB);
USHORT NEAR DiskIO_Wait (PBYTE, NPUNITCB);
USHORT NEAR GetVolumeSize (NPUNITCB, PULONG ,PULONG);
USHORT NEAR ClearCheckCondition (NPUNITCB);
USHORT NEAR GetPlayStatus (NPUNITCB, BOOL FAR *);
USHORT NEAR Tosh_GetDensityCode(NPUNITCB, USHORT FAR *);
USHORT NEAR GetSectorMode(NPUNITCB, USHORT FAR *);
USHORT NEAR Get_UnitCB_Addr (UCHAR, NPUNITCB FAR *);
BOOL   NEAR Strncmp (UCHAR *, UCHAR *, USHORT);
USHORT NEAR Check_MultiSession_Mounted (NPUNITCB, ULONG);
VOID   NEAR SubmitRequestsToADD(NPUNITCB);
USHORT NEAR CmdErr (PRPH, NPUNITCB);
USHORT NEAR Write (PRP_RWV, NPUNITCB);
USHORT NEAR StatusDevReady (PRPH, NPUNITCB);
USHORT NEAR StatusComplete (PRPH, NPUNITCB);
USHORT NEAR Submit_ModeSelect (NPUNITCB, USHORT, USHORT);
USHORT NEAR StatusError (PRPH, USHORT);
USHORT NEAR ChainModeSelectRead (NPUNITCB, ULONG, USHORT, ULONG,
                                                  USHORT, USHORT);
USHORT NEAR ReadSector (NPUNITCB, ULONG, USHORT, ULONG, USHORT, BOOL);
USHORT NEAR WriteSector (NPUNITCB, ULONG, ULONG, ULONG, USHORT,BOOL);
USHORT NEAR Read_2352 (NPUNITCB, ULONG, USHORT, ULONG);
USHORT NEAR ATAPI_Read_2352 (NPUNITCB, ULONG, USHORT, ULONG);
USHORT NEAR ReadWriteVerifyTrack (PRP_GENIOCTL, NPUNITCB);
USHORT NEAR ReadWriteEraseScan (PRP_GENIOCTL, NPUNITCB);
USHORT NEAR DoModeSelect ( NPUNITCB, USHORT );     // enable verify realloc
USHORT NEAR FormatTrack(PRP_GENIOCTL, NPUNITCB);
BOOL VerifyBPB ( BPB far *bpb );
USHORT NEAR ReadCtrl( PRP_GENIOCTL pRP, NPUNITCB     pUnitCB);
USHORT NEAR WriteCtrl( PRP_GENIOCTL pRP, NPUNITCB     pUnitCB);

/*
** opiorb.c prologs
*/
USHORT AllocIORB (NPUNITCB, NPIORB FAR *);
VOID   AllocIORB_Wait (NPUNITCB, NPIORB FAR *);
USHORT NEAR SubmitIORB_Wait (NPUNITCB,NPIORB_CDB );
VOID   FreeIORB (NPUNITCB, NPIORB_CDB);
VOID   BuildIORB_DeviceControl (NPUNITCB, USHORT, NPIORB FAR *);
VOID   BuildIORB_PassthruCDB (NPUNITCB, ULONG, ULONG, NPIORB_CDB FAR *);
VOID   BuildIORB_FormatUnit (NPUNITCB, BYTE,BYTE, ULONG ,USHORT, NPIORB_CDB FAR *);
VOID   BuildIORB_Read ( NPUNITCB,ULONG,USHORT,USHORT,ULONG,NPIORB_EXECUTEIO FAR *, BOOL);
VOID   BuildIORB_Write ( NPUNITCB,ULONG,USHORT,USHORT,ULONG,NPIORB_EXECUTEIO FAR *, BOOL);

VOID   BuildCDB_TestUnitReady(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_RezeroUnit(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_RequestSense(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_Read_6(NPUNITCB, ULONG, USHORT, USHORT,
                                         ULONG, NPIORB_CDB FAR *, BOOL);
VOID   BuildCDB_Read_10(NPUNITCB, ULONG, USHORT, USHORT,
                                         ULONG, NPIORB_CDB FAR *, BOOL);
VOID   BuildCDB_Write_10(NPUNITCB, ULONG, USHORT, USHORT,
                                         ULONG, NPIORB_CDB FAR *,BOOL);
VOID   BuildCDB_Write_12(NPUNITCB, ULONG, USHORT, ULONG,
                                         ULONG, NPIORB_CDB FAR *,BOOL);
VOID   BuildCDB_Seek_6(NPUNITCB, ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_Seek_10(NPUNITCB, ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_Inquiry(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_ModeSelect(NPUNITCB, USHORT, NPIORB_CDB FAR *);
VOID   BuildCDB_GetLockStatus (NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_PreventAllowRemoval(NPUNITCB, USHORT, NPIORB_CDB FAR *);
VOID   BuildCDB_ReadCapacity(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_ReadHeader (NPUNITCB, ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_StartStopUnit (NPUNITCB, USHORT, NPIORB_CDB FAR *);

VOID   _loadds FAR  NotifyDoneIORB(PIORB);
VOID  FAR  InitPost(PIORB);

/*-----------------------------------------------*
 * Function declarations for CDBLDCDB  routines  *
 *-----------------------------------------------*/
VOID BuildCBD_ReadCapacity (NPUNITCB, NPIORB FAR *);


/*-------------------------------------------------------*
 * Function declarations for CDASUBR assembler routines  *
 *-------------------------------------------------------*/
VOID   FAR  f_ZeroCB (PBYTE, USHORT);
VOID   FAR  f_BlockCopy (PBYTE, PBYTE, USHORT);
ULONG  FAR  f_add32(ULONG, ULONG);
VOID   FAR  f_SWait (PVOID);
VOID   NEAR SWait (PVOID);
VOID   FAR  f_SSig (PVOID);
VOID   NEAR SSig (PVOID);
VOID   NEAR ZeroFSGS (VOID);
VOID   NEAR PadRaw2340 (UCHAR FAR *, USHORT);


/*-----------------------------------*
 * Pragma declarations - DevHelps    *
 *-----------------------------------*/
#pragma alloc_text(Code, DevHelp_VMUnLock)
#pragma alloc_text(Code, DevHelp_VMLock)
#pragma alloc_text(Code, DevHelp_VirtToLin)
#pragma alloc_text(Code, DevHelp_AllocReqPacket)
#pragma alloc_text(Code, DevHelp_FreeReqPacket)
#pragma alloc_text(Code, DevHelp_VerifyAccess)


