/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = OPIOCTL.H
 *
 * DESCRIPTIVE NAME = Internal data structures for IOCTL handling in
 *                    the OS/2 Optical Device Mgr.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*----------------------------------------*
 * Category 0x80 Optical IOCTL Definitions *
 *----------------------------------------*/
#define IOC_CDROM            0x80         /* CD-ROM Category Code           */

#define IOCD_LOCK_UNLOCK     0x40         /* Lock/Unlock Drive Door         */
#define IOCD_EJECT           0x41         /* Eject Disk                     */
#define IOCD_CLOSE_TRAY      0x42         /* Close Tray                     */
#define IOCD_QUERY_PARTITION 0x43         /* MO.SYS Query Partition Info    */
#define IOCD_WRITE_CTRL      0x4F         /* Write Drive Control String     */
#define IOCD_DEVICE_STATUS   0x60         /* Device Status                  */
#define IOCD_ERASE_MEDIA     0x61         /* MO.SYS Erase Media             */
#define IOCD_WRITE_NOERASE   0x62         /* MO.SYS Write No Erase          */
#define IOCD_WRITE_LONG      0x63         /* MO.SYS WriteLong               */
#define IOCD_READ_LONG       0x64         /* MO.SYS ReadLong                */
#define IOCD_MEDIA_SCAN      0x66         /* MO.SYS Media Scan              */
#define IOCD_MEDIA_SCAN2     0x67         /* MO.SYS Media Scan 2            */
#define IOCD_READ_CTRL       0x6F         /* Read Drive Control String      */
#define PRVNT_BIT            0x04
#define DRIVE_IS_LOCKED                 1
#define DRIVE_IS_UNLOCKED               2
#ifndef IODC_WP
#define IODC_WP 0x67
#endif
/*----------------------------------------*
 * Category 0x87 OPTICAL IOCTL Definitions *
 *----------------------------------------*/
#define IOC_OPTICAL 0x87

#define IOCD_CHANGE_TIMEOUT_VALUE 0x40
/*------------------------------------*
 * Misc constants                     *
 *------------------------------------*/
#define OK                          0

#define NO_TABLE_ENTRY              0
#define MINIMUM_TABLE_ENTRY         FUNCTION_CODE_BASE
#define MAXIMUM_TABLE_ENTRY         0x7F

/*
** VMLOCK flag equates
*/
#define VMDHL_NOBLOCK           0x0001
#define VMDHL_CONTIGUOUS        0x0002
#define VMDHL_16M               0x0004
#define VMDHL_WRITE             0x0008
#define VMDHL_LONG              0x0010
#define VMDHL_VERIFY            0x0020

#define ERIMO_SIGNATURE             0xA4DF
#define ERIMO_RELEASE_LEVEL         1

#define DP_DEVICEATTR_NON_REMOVABLE     0x0001
#define DP_DEVICEATTR_CHANGELINE        0x0002
#define DP_DEVICEATTR_GT16MBSUPPORT     0x0004
/*------------------------------------------------*
 * Cat 0x80, Func 0x40:  Reset Drive              *
 *------------------------------------------------*/
struct ResetDrive {
        ULONG       ID_code;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x44:  Eject Disk               *
 *------------------------------------------------*/
struct EjectDisk {
        UCHAR       ID_code;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x45:  Close Tray               *
 *------------------------------------------------*/
struct CloseTray {
        ULONG       ID_code;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x46:  Lock/Unlock Door         *
 *------------------------------------------------*/
struct LockUnlock {
//        ULONG       ID_code;
        UCHAR       lock_flag;
};


struct QueryDeviceSupport {
            UCHAR       command;
};

struct QueryDeviceSupportData {
            USHORT      signature;
            USHORT      release_level;
            USHORT      revision_level;
            USHORT      total_format_time;
};

struct UserChangeTimeout {
            UCHAR       command;
            ULONG       new_timeout_value;
};

struct UserChangeTimeoutData {
            ULONG       previous_timeout_value;
};

typedef union {
        struct {
               BYTE   Opcode;
               BYTE   reserved :5;
               BYTE   LUN      :3;
               BYTE   reserved2[10];
               } ScsiCommand;
        BYTE   commandArray[12];
        } CMDSTRUCT, near * NPCMDSTRUCT,*PCMDSTRUCT;

typedef struct DDI_CtrlString {
            ULONG       identifier;                 // CD01 in cdrom
            ULONG       datasize;
            PVOID       tsb_area;
            ULONG       sense_length;
            PBYTE       sense_data_area;
            ULONG       scsi_command_length;
            UCHAR       scsi_command [12];
} CTRLSTRING, near * NPCTRLSTRING, far * PCTRLSTRING;

typedef struct _LOCKSTRUC FAR *PLOCKSTRUC;

/*------------------------------------------------*
 * Function declarations and pragma statements    *
 *------------------------------------------------*/
USHORT NEAR GetDeviceParms8(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR SetDeviceParms8(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR GetDeviceParms9(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR RemovableMediaControl(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR RemovableDeviceStatus(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR DeviceSupport(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR ResetDrive(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR EjectDisk(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CloseTray(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR LockUnlock(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR VerifyParameters (NPUNITCB, PRP_GENIOCTL, USHORT, USHORT, PLOCKSTRUC);
USHORT NEAR ChangeTimeout (PRP_GENIOCTL, NPUNITCB);
