/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = OPIOC80.C
 *
 * DESCRIPTIVE NAME = IOCTL handling routines for OS/2 Optical Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "oph.h"

/****************************************************************************
 *
 * FUNCTION NAME = EjectDisk
 *
 * DESCRIPTION   = Issue an eject disk command to the device.
 *
 *                 USHORT EjectDisk (PRP_GENIOCTL pRP, NPUNITCB pUnitCB)
 *
 * INPUT         = pRP              - Request Packet
 *                 pUnitCB          - Pointer to UnitCB
 *
 * OUTPUT        = USHORT           - Packet Status word
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

USHORT EjectDisk (pRP, pUnitCB)

PRP_GENIOCTL pRP;
NPUNITCB     pUnitCB;

{
   USHORT     rc;
   NPIORB_CDB pIORB;

   /*
   ** Issue SCSI Start-Stop Unit command to eject the media
   */
   BuildCDB_StartStopUnit (pUnitCB, CDBF_EJECT, (NPIORB_CDB FAR *) &pIORB);

   rc = SubmitIORB_Wait (pUnitCB, pIORB);

   FreeIORB (pUnitCB, pIORB);

   // if we got a not ready, there COULD be media present
   // clear the error (I hope this works)
   if (rc != STDON)
     {
     BuildCDB_StartStopUnit (pUnitCB, CDBF_START, (NPIORB_CDB FAR *) &pIORB);
     SubmitIORB_Wait (pUnitCB, pIORB);

     FreeIORB (pUnitCB, pIORB);
     }
//      rc = STDON;

   return(rc);
}


/****************************************************************************
 *
 * FUNCTION NAME = CloseTray
 *
 * DESCRIPTION   = Issue a close tray command to the device.
 *
 *                 USHORT CloseTray (PRP_GENIOCTL pRP, NPUNITCB pUnitCB)
 *
 * INPUT         = pRP              - Request Packet
 *                 pUnitCB          - Pointer to UnitCB
 *
 * OUTPUT        = USHORT           - Packet Status word
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

USHORT CloseTray (pRP, pUnitCB)

PRP_GENIOCTL pRP;
NPUNITCB     pUnitCB;

{
   USHORT     rc;
   NPIORB_CDB pIORB;

   /*
   ** Issue SCSI Start-Stop Unit command to close the tray
   */
   BuildCDB_StartStopUnit (pUnitCB, CDBF_CLOSE_TRAY, (NPIORB_CDB FAR *) &pIORB);

   rc = SubmitIORB_Wait (pUnitCB, pIORB);

   FreeIORB (pUnitCB, pIORB);

   if (rc == STDON + STERR + ERROR_I24_NOT_READY)
      rc = STDON;

   return(rc);
}


/****************************************************************************
 *
 * FUNCTION NAME = LockUnLock
 *
 * DESCRIPTION   = Issue a lock or unlock drive door command to the device.
 *
 *                 USHORT LockUnLock (PRP_GENIOCTL pRP, NPUNITCB pUnitCB)
 *
 * INPUT         = pRP              - Request Packet
 *                 pUnitCB          - Pointer to UnitCB
 *
 * OUTPUT        = USHORT           - Packet Status word
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

USHORT LockUnLock (pRP, pUnitCB)

PRP_GENIOCTL pRP;
NPUNITCB     pUnitCB;

{
   NPIORB_CDB pIORB;
   USHORT     rc, lock_flag;

   if (pRP->Category == 8)
      lock_flag = ((PDDI_DsktRemovMediaCtl_param)pRP->ParmPacket)->Command;
   else
      lock_flag = ((struct LockUnlock FAR *)pRP->ParmPacket)->lock_flag;

   if (lock_flag > CDBF_LOCK_DOOR)
      return (STDON + STERR + ERROR_I24_INVALID_PARAMETER);

   /*
   ** Issue SCSI PreventAllowRemoval command to lock/unlock the media
   */
   BuildCDB_PreventAllowRemoval (pUnitCB, lock_flag, (NPIORB_CDB FAR *) &pIORB);

   rc = SubmitIORB_Wait (pUnitCB, pIORB);

   FreeIORB (pUnitCB, pIORB);

   if (rc == STDON)
   {
   pUnitCB->DeviceInfo.Door_Locked=lock_flag?TRUE:FALSE;
   }

   return(rc);

}


/****************************************************************************
 *
 * FUNCTION NAME = DeviceSupport
 *
 * DESCRIPTION   = Return device status.
 *
 *                 USHORT DeviceSupport (PRP_GENIOCTL pRP, NPUNITCB pUnitCB)
 *
 * INPUT         = pRP              - Request Packet
 *                 pUnitCB          - Pointer to UnitCB
 *
 * OUTPUT        = USHORT           - Packet Status word
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

USHORT DeviceSupport (pRP, pUnitCB)

PRP_GENIOCTL pRP;
NPUNITCB     pUnitCB;

{
   USHORT rc;
   struct QueryDeviceSupportData far *data=(struct QueryDeviceSupportData far *)pRP->DataPacket;

   data->signature = ERIMO_SIGNATURE;
   data->release_level = ERIMO_RELEASE_LEVEL;
   data->revision_level = (USHORT)pUnitCB->InquiryData.revision_level;

   if ( pUnitCB->DeviceInfo.vendor_id_code == IBM )
     {
     data->total_format_time = ERIMO_TOTAL_FORMATTING_TIME_Min;
     }
   else
     {
     data->total_format_time = TOTAL_FORMATTING_TIME_Min;
     }

   return(STDON);
}

