/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = OPGENCB.H
 *
 * DESCRIPTIVE NAME = Internal control blocks for OS/2 Optical Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
struct vendor_id_entry {
        UCHAR   *vendor_id_string;
        USHORT  vendor_id_code;
};

struct product_id_entry {
        UCHAR   *product_id_string;
        USHORT  product_id_code;
};

struct drive_caps_entry {
        USHORT  product_id_code;
        USHORT  capabilities;
};

/*
** vendor_id_code definitions
*/
#define IBM             0x01
#define MAXTOR          0x02
#define MELCO           0x03
#define RICOH           0x04
#define SONY            0x05
#define PINNACLE        0x06
#define OTHER           0xff

/*
** product_id_code definitions
*/
#define ERIMO1          0x01
#define ERIMOPRIME      0x02
#define TOPCAT          0x03

struct DeviceInfo {
        USHORT vendor_id_code;
        USHORT product_id_code;
        USHORT interface_type;
        USHORT current_block_size;
        USHORT raw_block_size;
        USHORT current_density;
        USHORT disk_density;
        USHORT current_disk_type;
        ULONG  volume_descr_terminator;
        USHORT last_cmd;
        ULONG  FormatTime;

        USHORT Installed :1;
        USHORT lock_status_supported :1;
        USHORT needs_mode_select:1;
        USHORT Door_Locked:1;
        USHORT BuildBPBOffMedium:1;
        USHORT prevent_writes:1;
        USHORT format_in_progress:1;
        USHORT format_unit_done:1;
        USHORT default_bpb_changed:1;
        USHORT reserved:7;

};

/* interface_type definitions */
#define  INTERFACE_SCSI         0x01
#define  INTERFACE_ATAPI        0x02
#define  INTERFACE_PROPRIETARY  0x03



struct  BlockParameters {
        union
        USHORTB   block_size;
        USHORT    density_code;
};

struct BootRecord {
            USHORT          short_jump;
            UCHAR           nop;
            UCHAR           OEM_name [8];
            BPB             MediaBPB;
            UCHAR           filler [ (MAX_SECTOR_SIZE*2) -
                                     (sizeof(BPB) + 13 ) ];
            USHORT          signature;
};

/*
**
** Unit Control Block
** ------------------
**
** This control blocks relates hardware devices to the Adapter
** Dependent Driver which manages them.
**
*/

typedef struct _PRTYQ
{
  NPIORB    Head;
  NPIORB    Tail;
} PRTYQ;

#define  NUM_RLE_QUEUES        9
#define  NUM_RP_QUEUES         2

typedef struct _UnitControlBlock
{
  NPUNITCB    pNextUnitCB;                /* Pointer to Next UnitCB       */
  USHORT      Flags;                      /* UnitCB Flags                 */
  USHORT      LogDriveNum;                /* Logical  Drive Number        */
  USHORT      PhysDriveNum;               /* Physical Drive Number        */
  UNITINFO    UnitInfo;                   /* Additional Driver Info       */
  struct
  DeviceInfo  DeviceInfo;                 /* Device Information Block     */
  struct
  Inquiry_Data InquiryData;               /* Device Inquiry Data          */
  UCHAR       Pad;                        /* Word align                   */
  USHORT      ADDHandle;                  /* ADD handle                   */
  USHORT      AdapterNumber;              /* Logical Adapter Number       */
  ULONG       TotalSectors;               /* Total Sectors for this drive */
  ULONG       Reserved;                   /* Read capacity Block Length   */
  USHORT      MaxHWSGList;                /* Max HW scatter/gather list   */
  NPIORBH     pDedicatedIORB;             /* Dedicated IORB for this unit */
  VOID (FAR * AdapterDriverEP)();         /* ADD Entry Point              */
  USHORT      NumReqsInProgress;          /* # of requests in progress    */
  USHORT      NumReqsWaiting;             /* Number of requests waiting   */
  NPIORBH     InProgressQueue;            /* Queue of in progress requests*/
  PRTYQ       WaitingQueue;               /* Priority Queues              */
  BPB         CurrentBPB;                 /* current media BPB            */
} UNITCB;

/* Flag definitions for Flags field in UNITCB */
#define UCF_IORB_ALLOCATED  0x0001        /* Dedicated IORB allocated       */
#define UCF_HW_SCATGAT      0x0002        /* Unit supports ScatGat in HW    */
#define UCF_16M             0x0004        /* Unit supports > 16M addressing */
#define UCF_CHS_ADDRESSING  0x0008        /* Unit supports CHS Addressing   */
#define UCF_REMOVABLE_NON_FLOPPY  0x0010  /* Removable, non floppy          */
#define UCF_UNCERTAIN_MEDIA 0x0020        /* Uncertain media                */


/*
** IORB DMWorkSpace Structure
*/

typedef struct _IORB_DMWORK
{
   NPUNITCB      pUnitCB;
   USHORT        Reserved_1;
   PBYTE         pRequest;
   SCATGATENTRY  SGList;
   NPIORB        WaitingQueueLink;
   NPIORB        pCoReqIORB;

} IORB_DMWORK, FAR *PIORB_DMWORK, NEAR *NPIORB_DMWORK;



typedef struct _DRIVERENTRY
{
   UCHAR        DriverName[17];
   PFN          AdapterDriverEP;
} DRIVERENTRY;


typedef struct _DRIVERTABLE
{
   USHORT       NumDrivers;
   DRIVERENTRY  DriverEntry[MAX_DRIVERS];
} DRIVERTABLE;


/*
** Init data allocated at the end of the data segment has the
** following structure:
*/

#define MAX_DEVICE_TABLE_SIZE 1024
/*
**      (sizeof(DEVICETABLE) + ((MAX_ADAPTERS_PER_ADD - 1) * 2) +
**      ((sizeof(ADAPTERINFO) - sizeof(UNITINFO)) * MAX_ADAPTERS_PER_ADD) +
**      sizeof(UNITINFO) * MAX_UNITS_PER_ADD)
*/
typedef struct _INITDATA
{
   UCHAR           ScratchBuffer2[MAX_DEVICE_TABLE_SIZE];  /* Scratch buffer  */
   UCHAR           ScratchIORB[MAX_IORB_SIZE]; /* IORB used during init       */
   RP_RWV          InitPkt;                    /* RP used during init         */
} INITDATA;


