/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = OPDEFS.H
 *
 * DESCRIPTIVE NAME = Typedefs/Defines for OS/2 Optical Device Manager
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*------------------------------*
 * Common typedefs              *
 *------------------------------*/
typedef struct _UnitControlBlock   UNITCB, *NPUNITCB;
typedef struct _VolChars           *NPVOLCHARS;
typedef struct _BPB                BPB;
typedef struct _PB_Read_Write      PB_Read_Write, FAR *PPB_Read_Write;
typedef struct _Req_List_Header    Req_List_Header, FAR *PReq_List_Header;
typedef struct {
        USHORT (near *Strat1Near)();
        } CMDFUNC;

typedef struct _INITDATA     INITDATA;

#define MAX_DRIVE_LETTERS       26
#define MAX_QUEUING_COUNT       16
#define MAX_ADAPTERS_PER_ADD    16
#define MAX_UNITS_PER_ADD       32
#define MAX_IORBS_PER_DRIVE      8
#define MAX_IORBS_PER_POOL      64
#define INIT_POOL_SIZE          32 * 1024

/*
**** Device Types returned in Get Device Parms IOCTL
*/
#define TYPE_CDROM             0x07
#define TYPE_OPTICAL           0x08

#define COMMAND_INFO_MASK 0x01

/*
** Change Media Flags
*/
#define MEDIA_CHANGED           0xFF
#define MEDIA_UNSURE_CHANGED    0x00
#define MEDIA_UNCHANGED         0x01


#define DEFAULT_CYLINDER_COUNT 0xFFFF

#define CDBF_START                0x01
#define CDBF_EJECT                0x02
#define CDBF_CLOSE_TRAY           0x03
#define CDBF_PREVENT_REMOVAL      0x01
#define CDBF_LOCK_DOOR            0x01


#define PRIMARY_VOL_DESCR_RBA     0x10
#define VOL_DESCR_TERMINATOR      0xFF

/*----------------------------------------------------*
 * Global DDFlags defines                             *
 *----------------------------------------------------*/
#define CDF_INIT_TIME           0x00000002    /* Init time flag           */
#define CDF_QUIET               0x00000004    /* Quiet error fail at init */
#define CDF_VERBOSE             0x00000008    /* verbose display at init  */
#define CDF_INIT_COMPLETE       0x00000010    /* INIT FINISHED            */
#define CDF_SINGLE_UNIT         0x00000020    /* changer devices as single*/

/*
** MACROS
*/
#define ENABLE  _asm {sti}
#define DISABLE _asm {cli}
#define PUSHFLAGS _asm {pushf}
#define POPFLAGS _asm {popf}

/*                                                                      @V91985
** Not   Ready Defs                                                     @V91985
*/                                                                   /*@V91985*/
#define NO_SECONDS_BEFORE_ERROR  6                                   /*@V91985*/
#define MAX_NOT_READY_RETRIES    ( NO_SECONDS_BEFORE_ERROR * 4 )     /*@V91985*/
#define NOT_READY_WAIT           250                                 /*@V91985*/

/*                                                                     @V91985
** ASC not in SCSI.h                                                   @V91985
*/                                                                   /*@V91985*/
#define ASC_MEDIUM_NOT_PRESENT   0x3A                                /*@V91985*/

#define DEFAULT_LASER_TIMEOUT       5

#define MAX_ALLOWED_DEFECT_LIST_SIZE    800
#define MINIMUM_ALLOWED_ADC_VALUE       380

        /* BIOS parameter block */

#define ERIMO_SECTOR_SIZE           512
#define ERIMO_UNIT_SIZE             4
#define ERIMO_RESERVED_SECTORS      1
#define ERIMO_NUMBER_OF_FATS        2
#define ERIMO_DIRECTORY_SIZE        512
#define ERIMO_TOTAL_SECTORS         0
#define ERIMO_MEDIA_DESCRIPTOR      0xF0
#define ERIMO_SECTORS_PER_FAT       243
#define ERIMO_SECTORS_PER_TRACK     25
#define ERIMO_NUMBER_OF_HEADS       1
#define ERIMO_HIDDEN_SECTORS        0
#define ERIMO_BIG_TOTAL_SECTORS     248800L

#define SECTOR_SIZE                 512
#define UNIT_SIZE                   4
#define RESERVED_SECTORS            1
#define NUMBER_OF_FATS              2
#define DIRECTORY_SIZE              512
#define TOTAL_SECTORS               0
#define MEDIA_DESCRIPTOR            0xF0
#define SECTORS_PER_FAT             243
#define SECTORS_PER_TRACK           31
#define NUMBER_OF_HEADS             1
#define HIDDEN_SECTORS              0
#define BIG_TOTAL_SECTORS           248800L

#define MAX_SECTOR_SIZE             512
#define NUMBER_OF_CYLINDERS     9952

#define MillisecondsFromMinutes 60000L

#define ERIMO_TOTAL_FORMATTING_TIME 20L*MillisecondsFromMinutes
#define TOTAL_FORMATTING_TIME       70L*MillisecondsFromMinutes
#define ERIMO_TOTAL_FORMATTING_TIME_Min 20L
#define TOTAL_FORMATTING_TIME_Min 70L

#define REVERT_TO_BPB_OFF_MEDIUM    0
#define CHANGE_DEFAULT_BPB          1
#define CHANGE_MEDIUM_BPB           2
#define MAX_COMMAND_INFORMATION     2
#ifndef min
#define min(a,b)        (((a) < (b)) ? (a) : (b))
#endif
