/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = OPDATA.H
 *
 * DESCRIPTIVE NAME = Data externs for OS/2 Optical Device Manager
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS          Externs for data defined in OPDATA.C
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**  External data declarations in DMDATA.C
*/

extern PFN          Device_Help;          /* far ptr to devhelp function    */
extern PBYTE        pSysInfoSeg;          /* Pointer to sys info seg        */
extern PVOID        pDataSeg;             /* virt ptr of our data segment   */
extern ULONG        ppDataSeg;            /* phys addr of our data segment  */
extern ULONG        plDataSeg;            /* linear addr of our data seg    */
extern USHORT       ScratchBufSem;        /* Semaphore for ScratchBuffer    */
extern USHORT       CDFlags;              /* Global driver flags            */

extern NPUNITCB     UnitCB_Head;          /* near ptr to first UnitCB       */

extern NPBYTE       pNextFreeCB;          /* ptr to next free control blk   */

extern USHORT       NumDrivers;           /* number of adapter drivers      */
extern USHORT       NumUnitCBs;           /* number of unit control blocks  */
extern USHORT       NumDrives;            /* number of drives               */
extern USHORT       FirstDriveNumber;     /* First drive number             */
extern USHORT       NumAdapters;          /* number of adapters             */
extern USHORT       NumReqsInProgress;    /* num requests in progress       */
extern USHORT       NumReqsWaiting;       /* num requests on waiting queues */
extern USHORT       TraceFlags;           /* Trace Flags                    */

extern NPBYTE       CB_FreeList;          /* Control Block Free List for    */
                                          /*  IORBs and CWAs                */
extern USHORT       PoolSem;              /* Pool semaphore                 */
extern USHORT       PoolSize;             /* Size of control block pool     */
extern USHORT       FreePoolSpace;        /* Free space left in pool        */
extern USHORT       CodeBreakAddress;     /* end of code segment address    */
extern USHORT       DataBreakAddress;     /* end of data segment address    */

extern DriverCaps   DriverCapabilities;   /* Driver Capabilities structure  */

extern PBPB DummyBPB;                     /* Pointer to BPB for drive aliasing*/
extern BPB  DefaultBPB;                   /* Pointer to BPB for drive aliasing*/
extern BPB  ErimoDefaultBPB;              /* Pointer to BPB for drive aliasing*/
extern struct BootRecord BootRecord;
extern CHAR    WorkBuf[];
extern BOOL    ForceLowLevelFormat;            /* for FormatTrack() */
extern BOOL    Unconditional_Install;          // even if powered off
extern USHORT  LaserTimeoutValue;
extern USHORT  MaxAllowedDefectListSize;
extern USHORT  MinimumAllowedADCvalue;

extern NPBPB InitBPBArray[MAX_DRIVE_LETTERS]; /* BPB array returned in INIT packet*/
extern IORB_CDB     default_iorb_cdb;
extern UCHAR        volume_id_string[];
extern UNITCB       FirstUnitCB[];        /* First UnitCB allocated here    */
extern UCHAR        CBPool[];             /* Start of Pool                  */
extern USHORT       InitData;             /* Start of Init data             */

extern UCHAR        InitTimeIORB[];
