/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = OPDATA.C
 *
 * DESCRIPTIVE NAME = Static/Initialization data for Optical Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#define INCL_ERROR_H

#include "os2.h"
#include "misc.h"
#include "opdefs.h"
#include "strat2.h"
#include "reqpkt.h"
#include "iorb.h"
#include "scsi.h"
#include "opbscsi.h"
#include "opgencb.h"

/*
**  GLOBAL DATA
**  -----------
**  1. Static data
**  2. Dynamic data allocated at init time:
**     - UnitCB
**  3. Dynamic data allocated at run time:
**     - IORB
**  4. Static init data discarded after init time
*/

#define MAXADAPTERDRIVERS       32         /* Max adapter device drivers     */


PFN             Device_Help=0L;            /* far ptr to devhelp function    */
USHORT          RMFlags=0;
ULONG           RM_Help0 =0;
ULONG           RM_Help3 =0;
PBYTE           pSysInfoSeg=0L;            /* Pointer to sys info seg        */
PVOID           pDataSeg=0L;               /* virt ptr of our data segment   */
ULONG           ppDataSeg=0L;              /* phys addr of our data segment  */
ULONG           plDataSeg=0L;              /* linear addr of our data seg    */
USHORT          ScratchBufSem=0;           /* Semaphore for ScratchBuffer    */
USHORT          CDFlags= CDF_QUIET;        /* Global driver flags            */

NPUNITCB        UnitCB_Head=0;             /* near ptr to first UnitCB       */

NPBYTE          pNextFreeCB=0;             /* ptr to next free control blk   */

USHORT          NumDrivers=0;              /* number of adapter drivers      */
USHORT          NumUnitCBs=0;              /* number of unit control blocks  */
USHORT          NumDrives=0;               /* number of drives               */
USHORT          FirstDriveNumber=0;        /* First drive number             */
USHORT          NumAdapters=0;             /* number of adapters             */
USHORT          NumReqsInProgress=0;       /* num requests in progress       */
USHORT          NumReqsWaiting=0;          /* num requests on waiting queues */
USHORT          TraceFlags=0;              /* Trace Flags                    */

NPBYTE          CB_FreeList=0;             /* Control Block Free List for    */
                                           /*  IORBs and CWAs                */

USHORT          PoolSem=0;                 /* Pool semaphore                 */
USHORT          PoolSize=0;                /* Size of control block pool     */
USHORT          FreePoolSpace=0;           /* Free space left in pool        */
USHORT          CodeBreakAddress=0;        /* end of code segment address    */
USHORT          DataBreakAddress=0;        /* end of data segment address    */

BOOL    ForceLowLevelFormat =0;            /* for FormatTrack() */
BOOL    Unconditional_Install = FALSE;  // even if powered off
USHORT  LaserTimeoutValue        = DEFAULT_LASER_TIMEOUT;
USHORT  MaxAllowedDefectListSize = MAX_ALLOWED_DEFECT_LIST_SIZE;
USHORT  MinimumAllowedADCvalue   = MINIMUM_ALLOWED_ADC_VALUE;

struct BootRecord BootRecord= {0};
char WorkBuf[ERIMO_SECTOR_SIZE*2];

NPBPB InitBPBArray[MAX_DRIVE_LETTERS]={0}; /*BPB array returned in INIT packet*/

BPB  ErimoDefaultBPB = {
                ERIMO_SECTOR_SIZE,            /* in global.h */
                ERIMO_UNIT_SIZE,
                ERIMO_RESERVED_SECTORS,
                ERIMO_NUMBER_OF_FATS,
                ERIMO_DIRECTORY_SIZE,
                ERIMO_TOTAL_SECTORS,
                ERIMO_MEDIA_DESCRIPTOR,
                ERIMO_SECTORS_PER_FAT,
                ERIMO_SECTORS_PER_TRACK,
                ERIMO_NUMBER_OF_HEADS,
                ERIMO_HIDDEN_SECTORS,
                ERIMO_BIG_TOTAL_SECTORS,
                0
};

BPB DefaultBPB = {                          //  sector size to os/2
                MAX_SECTOR_SIZE,
                UNIT_SIZE,                  /* in global.h */
                RESERVED_SECTORS,
                NUMBER_OF_FATS,
                DIRECTORY_SIZE,
                TOTAL_SECTORS,
                MEDIA_DESCRIPTOR,
                SECTORS_PER_FAT,
                SECTORS_PER_TRACK,
                NUMBER_OF_HEADS,
                HIDDEN_SECTORS,
                BIG_TOTAL_SECTORS,
                0
};

UCHAR  volume_id_string[] = "CD001";

/*
** Default CDB Passthru IORB
*/
IORB_CDB  default_iorb_cdb = {

   sizeof(IORB_ADAPTER_PASSTHRU),            /* IORB Length                */
   0,                                        /* Unit Identifier            */
   IOCC_ADAPTER_PASSTHRU,                    /* Command Code               */
   IOCM_EXECUTE_CDB,                         /* Command Modifier           */
   IORB_ASYNC_POST + IORB_REQ_STATUSBLOCK,   /* Request Control Flags      */
   0,                                        /* Status                     */
   0,                                        /* Error Code                 */
   0,                                        /* Cmd completion timeout (s) */
   sizeof(SCSI_STATUS_BLOCK),                /* Status block length        */
   0,                                        /* Status block               */
   0,                                        /* Reserved, MBZ              */
   0,                                        /* Pointer to next IORB       */
   0,                                        /* Notification Address       */
   0,                                        /* For use by DM              */
   0,                                        /* For use by ADD             */

   1,                                        /* Count of S/G list elements */
   0,                                        /* far ptr to S/G List        */
   0,                                        /* physical addr of S/G List  */
   0,                                        /* Length of CDB              */
   0,                                        /* Pointer to CDB             */
   0,                                        /* phys ptr to SCB            */
   0                                         /* Flags                      */
};

/*
**  UnitCBs are allocated after all static data
*/
UNITCB          FirstUnitCB[1]={0};     /* First UnitCB allocated here       */

USHORT          CBPool[24*KB]={0};      /* Pool for Control blocks           */

