/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:   RSCTYPE.H                                            */
/*                                                                            */
/*   DESCRIPTIVE NAME: 	Type definitions for IBMRSCSI                         */
/*                                                                            */
/*   FUNCTION:  Contains types and constants used in IBMRSCSI.FLT             */
/*                                                                            */
/*   NOTES:                                                                   */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS: NONE                                                       */
/*                                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:  NONE                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          01/11/23  VJ              Initial Version                         */
/*  VJ2002  02/01/07  VJ              IDs added                               */
/* VJ268869 02/02/08  VJ              SyQuest support added                   */ 
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

#define NO_VERBOSE          0x00
#define VERBOSE_MODE        0x01
#define VERBOSE_WAIT_MODE   0x02
                           
                           
                           
#define MAX_UNITS            16
                           
#define SCRATCH_BUF_SIZE     2048
#define CB_POOL_SIZE         MAX_UNITS*sizeof(UCB)
                           
#define FF_INIT_TIME         0x0001
#define FF_REGISTERED        0x0002
#define FF_INIT_COMPLETE     0x8000

#define  DISABLE _asm {cli}
#define  ENABLE  _asm {sti}

// convert word(double word) value from big endian to small endian representation
#define  MAKEUSINTEL(w)                MAKEUSHORT(HIBYTE(w),LOBYTE(w))
#define  MAKEULINTEL(w)                MAKEULONG(MAKEUSINTEL(HIUSHORT(w)),MAKEUSINTEL(LOUSHORT(w)))

#define MAXADAPTERNAMELEN 15

typedef struct _AdapterName
{
   UCHAR          Name[MAXADAPTERNAMELEN];
   BYTE           Tbyte;
   USHORT         Term;
}    ADAPTERNAME;

typedef struct _AdapterControlBlock NEAR *NPACB;
typedef struct _UnitControlBlock    NEAR *NPUCB;



typedef struct __ModeHeader_
{
   USHORT      dataLength;       // total data length in big endian form
   UCHAR       mediumTypeCode;   // medium type code
   UCHAR       flags;            // device specific parameters
   UCHAR       reserved[4];
} ModeHeader, NEAR *NPMODEHEADER, FAR *PMODEHEADER;


typedef struct _FlexibleDiskPage_
{
   UCHAR       pageCode;            // 0x05 - flexible disk page code
   UCHAR       pageLength;          // page length in bytes
   USHORT      transferRate;        // device transfer data rate
   UCHAR       noOfHeads;           // no of heads
   UCHAR       sectorsPerTrack;     // sector count per track
   USHORT      dataBytesPerSector;  // sector size in bytes in big endian form
   USHORT      noOfCylinders;       // no of cylinders in big endian form
   UCHAR       reserved1[9];
   UCHAR       motorOnDelay;        // motor on delay in 1/10 s
   UCHAR       motorOffDelay;       // motor off delay in 1/10 s
   UCHAR       reserved2[7];
   USHORT      mediumRotationRate;  // medium rotation rate in big endian form
   UCHAR       reserved3[2];
}  FlexibleDiskPage, NEAR *NPFDP, FAR *PFDP;

typedef struct _InquiryData
{
   UCHAR       pad[8];
   CHAR        VendorID[8];
   CHAR        ProductID[8];
   CHAR        Revision[4];

}INQDATA, NEAR *NPINQDATA, FAR *PINQDATA;

#define SCSI_BUFFER_SIZE  128

typedef struct _UnitControlBlock
{
   USHORT         DriverUnitHandle;     // Save the downstream unit handle here.
   PIORB          pIORB;
   BYTE           IORBBuffer[128];
   SCATGATENTRY   scEntry;
   UCHAR          Buffer[SCSI_BUFFER_SIZE];
   VOID (FAR * AdapterDriverEP)(PIORB);      // Downstream Entry Point, recall:
                                             // filters can be on a unit basis.
   UNITINFO       UnitInfo;             // 18 bytes of stuff
   UCHAR          DevType;

}   UCB, NEAR *NPUCB;

typedef struct UNITTABLE
{
   NPUCB npUCB[MAX_UNITS];
   UCHAR nLastEntry;

}UT;

#define DEVTYPE_IOMEGA_ZIP_100    0x01
#define DEVTYPE_IOMEGA_ZIP_250    0x02
#define DEVTYPE_SYQUEST_SQ3270S   0x03   // VJ268869  
#define DEVTYPE_END_OF_GEORTBL    0xFF
#define DEVTYPE_UNKNOWN           0xFE
#define DEVTYPE_DEFAULT           DEVTYPE_IOMEGA_ZIP_100

#define ID_UNKNOWN                "UNKNOWN" // VJ2002

typedef struct GEORTBL_
{
   UCHAR    DevType;
   GEOMETRY OrgGeo;
   GEOMETRY NewGeo;

}GEORTBL, NEAR *NPGEORTBL, FAR *PGEORTBL;

#define MAX_VENDOR_ID_SIZE  8
#define MAX_PRODUCT_ID_SIZE 8
#define MAX_REVISION_SIZE   4

typedef struct DEVTYPETBL_
{
  UCHAR DevType;
  CHAR  VendorID[MAX_VENDOR_ID_SIZE];
  CHAR  ProductID[MAX_PRODUCT_ID_SIZE];


}DEVTYPETBL, NEAR *NPDEVTYPETBL, FAR* PDEVTYPETBL;


#define MAX_VERBOSE_MSG_SIZE   80
#define MSG_REPLACEMENT_STRING 1178


VOID  FAR DBGPrint6x( PSZ s, 
                     ULONG par1, 
                     ULONG par2, 
                     ULONG par3, 
                     ULONG par4, 
                     ULONG par5,
                     ULONG par6);
#ifdef DEBUG

/* debug message level definitions */
   #define  DBG_CRITICAL      0
   #define  DBG_HLVLFLOW      1  
   #define  DBG_IRQFLOW       2
   #define  DBG_DETAILED      4
   #define  DBG_SPECIFIC      8
   #define  DBG_DBGSPCL       16


   #define         DBGPrint(s)              DBGPrint6x((s),0,0,0,0,0,0)
   #define         DBGPrint1(s,a)           DBGPrint6x((s),(a),0,0,0,0,0)
   #define         DBGPrint2(s,a,b)         DBGPrint6x((s),(a),(b),0,0,0,0)
   #define         DBGPrint3(s,a,b,c)       DBGPrint6x((s),(a),(b),(c),0,0,0)
   #define         DBGPrint4(s,a,b,c,d)     DBGPrint6x((s),(a),(b),(c),(d),0,0)
   #define         DBGPrint5(s,a,b,c,d,e)   DBGPrint6x((s),(a),(b),(c),(d),(e),0)
   #define         DBGPrint6(s,a,b,c,d,e,f) DBGPrint6x((s),(a),(b),(c),(d),(e),(f))

#endif

#define BUILD_STR_SIZE  512

#define COMM_PORT_1     0x2f8
#define COMM_PORT_2     0x3f8
#define COMM_PORT       COMM_PORT_1
#define UART_LINE_STAT  0x5
#define  EFLAGS_IF   0x0200   // interrupt flag


#define  DBG_LEVEL_MASK    0x001f
#define  DBG_FLAGS_CLI     0x8000

/*----------------------------------------------*/
/* assembler commands                           */
/*----------------------------------------------*/
#define CLI()  _asm{cli}
#define STI()  _asm{sti}
#define CLC()  _asm{clc}
#define STC()  _asm{stc}

// eflags register flag definitions
#define  EFLAGS_IF   0x0200   // interrupt flag

/*
** I/O Instruction macro
*/
/* 8 bit OUT */
#define outp8(port, data) _asm{ \
      _asm    push ax          \
      _asm    push dx          \
      _asm    mov  al,data     \
      _asm    mov  dx,port     \
      _asm    out  dx,al       \
      _asm    pop  dx          \
      _asm    pop  ax          \
}

/* 8 bit IN */
#define inp8(port, data) _asm{  \
      _asm    push ax          \
      _asm    push dx          \
      _asm    mov  dx,port     \
      _asm    in   al,dx       \
      _asm    mov  data,al     \
      _asm    pop  dx          \
      _asm    pop  ax          \
}

/* 16 bit OUT */
#define outp16(port, data) _asm{ \
      _asm    push ax          \
      _asm    push dx          \
      _asm    mov  ax,data     \
      _asm    mov  dx,port     \
      _asm    out  dx,ax       \
      _asm    pop  dx          \
      _asm    pop  ax          \
}

/* 16 bit IN */
#define inp16(port, data) _asm{  \
      _asm    push ax          \
      _asm    push dx          \
      _asm    xor  ax,ax       \
      _asm    mov  dx,port     \
      _asm    in   ax,dx       \
      _asm    mov  data,ax     \
      _asm    pop  dx          \
      _asm    pop  ax          \
}

/* 32 bit OUT */
#define outp32(port, data) { \
      USHORT  sData[2];          \
      *((PULONG)&sData)=data;    \
         _asm {                  \
      _asm _emit   66h           \
      _asm    push ax            \
      _asm    push dx            \
      _asm _emit   66h           \
      _asm    mov  ax,sData[0]   \
      _asm    mov  dx,port       \
      _asm _emit   66h           \
      _asm    out  dx,ax         \
      _asm    pop  dx            \
      _asm _emit   66h           \
      _asm    pop  ax            \
      } \
      }

/* 32 bit IN */ 
#define inp32(port, data) { \
      USHORT  sData[2];          \
         _asm {                  \
      _asm _emit   66h           \
      _asm    push ax            \
      _asm    push dx            \
      _asm _emit   66h           \
      _asm    xor  ax,ax         \
      _asm    mov  dx,port       \
      _asm _emit   66h           \
      _asm    in   ax,dx         \
      _asm _emit   66h           \
      _asm    mov  sData[0],ax   \
      _asm    pop  dx            \
      _asm _emit   66h           \
      _asm    pop  ax            \
      }                          \
      data=*((PULONG)&sData);    \
      }

#define CR 0x0d
#define LF 0x0a

#define LEADING_ZEROES          0x8000
#define SIGNIFICANT_FIELD       0x0007

#define NUM_ARGS 7


VOID FAR VPrint6x( PSZ s, ULONG par1, ULONG par2, ULONG par3, ULONG par4, ULONG par5, ULONG par6 );

#define         VPrint(s)              VPrint6x((s),0,0,0,0,0,0)
#define         VPrint1(s,a)           VPrint6x((s),(a),0,0,0,0,0)
#define         VPrint2(s,a,b)         VPrint6x((s),(a),(b),0,0,0,0)
#define         VPrint3(s,a,b,c)       VPrint6x((s),(a),(b),(c),0,0,0)
#define         VPrint4(s,a,b,c,d)     VPrint6x((s),(a),(b),(c),(d),0,0)
#define         VPrint5(s,a,b,c,d,e)   VPrint6x((s),(a),(b),(c),(d),(e))
#define         VPrint6(s,a,b,c,d,e,f) VPrint6x((s),(a),(b),(c),(d),(e),(f))



#define   VMSG_INITIALIZING     0 
#define   VMSG_BLANK            1 
#define   VMSG_INIT_FAILED      2 
#define   VMSG_REG_FAILED       3 
#define   VMSG_ALLOC_FAILED     4 
#define   VMSG_ACCEPTING        5 
#define   VMSG_DEVLIST_HEAD     6 
#define   VMSG_LINE             7 
#define   VMSG_DEVCLASS_FAILED  8 
#define   VMSG_UNIT_LISTING     9 
#define   VMSG_END_OF_OUTPUT   10 
#define   VMSG_WAIT_MODE       11 


typedef CHAR VMSG[MAX_VERBOSE_MSG_SIZE], FAR *PVMSG, NEAR *NPVMSG;

typedef struct VERBOSE_
{
   UCHAR     VerboseMode;
   BOOL      IsVPrint;
   VMSG      VerboseMsg;
   PSZ       pVerboseMsg;
   MSGTABLE  MsgTable;

}VERBOSE, NEAR *NPVERBOSE, FAR *PVERBOSE;

