
        page    ,132

;/*
;*   Licensed Material -- Property of IBM
;*
;*   (c) Copyright IBM Corp. 2001  All Rights Reserved
;*/
;/************************** START OF SPECIFICATIONS ***************************/
;/*                                                                            */
;/*   SOURCE FILE NAME:  RSCSEGS.ASM                                           */
;/*                                                                            */
;/*   DESCRIPTIVE NAME:   RSCSEGS                                              */
;/*                                                                            */
;/*   FUNCTION:  Segment definitions for the IBMRSCSI                          */
;/*                                                                            */
;/*   NOTES:                                                                   */
;/*                                                                            */
;/*      DEPENDENCIES: None                                                    */
;/*      RESTRICTIONS: None                                                    */
;/*                                                                            */
;/*   ENTRY POINTS:  _HexLongToASCII                                           */
;/*                                                                            */
;/*                                                                            */
;/*   EXTERNAL REFERENCES:                                                     */
;/*                                                                            */
;/* Change Log                                                                 */
;/*                                                                            */
;/*  Mark    yy/mm/dd  Programmer      Comment                                 */
;/*  ----    --------  ----------      -------                                 */
;/*          01/11/23  VJ              Initial Version                         */
;/*                                                                            */
;/**************************** END OF SPECIFICATIONS ***************************/

        
        .XCREF
        .XLIST
         INCLUDE devhdr.inc
        .LIST
        .CREF


;/*-------------------------------------*/
;/* Assembler Helper to order segments  */
;/*-------------------------------------*/

DDHeader        segment dword public 'DDHEADER'
DiskDDHeader   dd      -1
               dw      DEVLEV_3 + DEV_CHAR_DEV ; ????? Need dev. level ?????
               dw      _RSCStrat   ;
               dw      0
               db      "IBMRSCS$"  ; Need 8 character string
               dw      0
               dw      0
               dw      0
               dw      0
               dd      DEV_ADAPTER_DD
               dw      0

DDHeader        ends

LIBDATA         segment dword public 'DATA'
LIBDATA         ends

CONST           segment dword public 'CONST'
CONST           ends

_DATA           segment dword public 'DATA'
_DATA           ends

_BSS            segment dword public 'BSS'
_BSS            ends


.386
_TEXT SEGMENT WORD PUBLIC USE16 'CODE'
ASSUME cs:_TEXT

EXTRN   _RSCStrat:near
EXTRN	_WriteChar:NEAR

	PUBLIC	_HexLongToASCII
;/********************** START OF SPECIFICATIONS ***********************/
;/*                                                                    */
;/* SUBROUTINE NAME:  _HexLongToASCII                                  */
;/*                                                                    */
;/* DESCRIPTIVE NAME:  HexLongToASCII                                  */
;/*                                                                    */
;/* FUNCTION: Converts hexadecimal long number to the ascii string     */
;/*                                                                    */
;/* NOTES:                                                             */
;/*                                                                    */
;/* CONTEXT:                                                           */
;/*                                                                    */
;/* ENTRY POINT:    _HexLongToASCII                                    */
;/*     LINKAGE:   NEAR                                                */
;/*                                                                    */
;/* INPUT: PSZ StrPtr, USHORT wHexVal, USHORT Option                   */
;/*                                                                    */
;/* EXIT-NORMAL: PSZ ptr to the ascii string created is returned       */
;/*                                                                    */
;/* EXIT-ERROR:  n/a                                                   */
;/*                                                                    */
;/* EFFECTS:                                                           */
;/*                                                                    */
;/* INTERNAL REFERENCES:                                               */
;/*    ROUTINES:        WriteChar                                      */
;/*                                                                    */
;/* EXTERNAL REFERENCES: none                                          */
;/*    ROUTINES:                                                       */
;/*                                                                    */
;/************************ END OF SPECIFICATIONS ***********************/
        
_HexLongToASCII	PROC NEAR
;|*** CHAR far *
;|*** near HexLongToASCII(CHAR far * StrPtr, unsigned long wHexVal, unsigned short Option)
;|*** {
	enter	12,0
fNonZero        equ     [bp-2]
Digit           equ     [bp-6]
Power           equ     [bp-10]
ShiftVal        equ     [bp-12]
Option          equ     [bp+12]
wHexVal         equ     [bp+8]
StrPtr          equ     [bp+4]

FALSE           equ     0
TRUE            equ     1
LEADING_ZEROES  equ     80h

;|***    int	     fNonZero=FALSE;
; Line 6
	mov	WORD PTR fNonZero,FALSE	;fNonZero
	mov	DWORD PTR Power,-268435456	;f0000000H	;Power
	mov	WORD PTR ShiftVal,28	;001cH	;ShiftVal
					$FC117:
	cmp	DWORD PTR Power,0	;Power
	je	$FB118
	mov	ax,WORD PTR Power	;Power
	mov	dx,WORD PTR [bp-8]
	and	ax,WORD PTR wHexVal	;wHexVal
	and	dx,WORD PTR [bp+10]
	mov	cl,BYTE PTR ShiftVal	;ShiftVal
	or	cl,cl
	je	SHORT $L139
					$L138:
	shr	dx,1
	rcr	ax,1
	dec	cl
	jne	SHORT $L138
					$L139:
	mov	WORD PTR Digit,ax	;Digit
	mov	ax,dx
	or	ax,WORD PTR Digit	;Digit
	je	SHORT $I119
	mov	WORD PTR fNonZero,TRUE	;fNonZero
					$I119:
	mov	ax,dx
	or	ax,WORD PTR Digit	;Digit
	jne	SHORT $I121
	cmp	WORD PTR fNonZero,FALSE	;fNonZero
	jne	SHORT $I121
	test	BYTE PTR [bp+13],LEADING_ZEROES	;0080H
	jne	SHORT $I121
	cmp	DWORD PTR Power,15	;0000000fH	;Power
	jne	SHORT $I120
	cmp	WORD PTR fNonZero,FALSE	;fNonZero
	jne	SHORT $I120
					$I121:
	or	dx,dx
	jne	SHORT $I122
	cmp	WORD PTR Digit,9	;Digit
	ja	SHORT $I122
	mov	al,BYTE PTR Digit	;Digit
	add	al,48	;0030H
	jmp	SHORT $L141
					$I122:
	mov	al,BYTE PTR Digit	;Digit
	add	al,55	;0037H
					$L141:
	push	ax
	call	_WriteChar
	add	sp,2
					$I120:
	mov	eax,DWORD PTR Power	;Power
	shr	eax,4
	mov	DWORD PTR Power,eax	;Power
	sub	WORD PTR ShiftVal,4	;ShiftVal
	jmp	$FC117
	nop	
					$FB118:
	mov	ax,WORD PTR [bp+4]	;StrPtr
	mov	dx,WORD PTR [bp+6]
	leave	
	ret	

_HexLongToASCII	ENDP



                
_TEXT           ends
.286

Code            segment dword public 'CODE'
Code            ends

LIBCODE         segment dword public 'CODE'
LIBCODE         ends

InitCode        segment dword public 'CODE'
InitCode        ends

RMCode          segment dword public 'CODE'                             
RMCode          ends                                                    

DGROUP          group   DDHeader, CONST, _BSS, LIBDATA, _DATA
StaticGroup     group   Code, LIBCODE, _TEXT, InitCode, RMCode          

        end
