/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:  RSCPRO.H                                              */
/*                                                                            */
/*   DESCRIPTIVE NAME: IBMRSCSI Prototypes		                              */
/*                                                                            */
/*   FUNCTION: Contains IBMRSCSI filter device driver functions prototypes    */
/*                                                                            */
/*   NOTES:                                                                   */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:  n/a                                                       */
/*                                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:                                                     */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          01/11/23  VJ              Initial Version                         */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/

VOID         NEAR  RSCStrat();      // IBMRSCSI strategy entry


VOID ReplaceGeo(UCHAR DevType, PGEOMETRY pGeo);
VOID FAR SetMem( PBYTE d, USHORT n , UCHAR Value);
VOID FAR CopyBytes(PBYTE source, PBYTE destination, USHORT n);

VOID ProcessGeometry(NPUCB npUCB);
VOID FAR ExecuteIORB(NPUCB npUCB, PIORB pIORB);

USHORT FAR BuildIORB( NPUCB  npUCB, 
                      USHORT CommandCode, 
                      USHORT CommandModifier, 
                      ULONG  p1, 
                      ULONG  p2);

VOID NEAR SetDevType(PUCHAR pDevType, PSZ VendorID, PSZ ProductID);
#pragma alloc_text (InitCode, SetDevType)


BOOL NEAR CompareIDs( PSZ s1, PSZ s2, USHORT n );
#pragma alloc_text (InitCode, CompareIDs)

VOID FormatName(PSZ String, USHORT StrLen);
#pragma alloc_text (InitCode, FormatName)


USHORT FAR RSCInit( PRPINITIN pRP );
#pragma alloc_text (InitCode, RSCInit)

VOID ProcessVerbose(PCHAR pCmdStr);
#pragma alloc_text (InitCode, ProcessVerbose)


VOID RSCBuildCBs( VOID );
#pragma alloc_text (InitCode, RSCBuildCBs)

VOID NEAR InitSubmitIORB_Wait( NPIORB npIORB, NPUCB npUCB );
#pragma alloc_text (InitCode, InitSubmitIORB_Wait)

VOID _loadds FAR RSCIORBEntry(PIORBH pIorbIn );  // IBMRSCSI IORB entry

VOID _loadds FAR RSCNotify( PIORBH pIORB );      // IBMRSCSI IORB Notify routine


VOID WriteChar( CHAR c );
PSZ  DecWordToASCII( PSZ StrPtr, USHORT wDecVal, USHORT Option);
PSZ  DecLongToASCII( PSZ StrPtr, ULONG lDecVal, USHORT Option);
PSZ  HexWordToASCII( PSZ StrPtr, USHORT wHexVal, USHORT Option);
PSZ  HexLongToASCII( PSZ StrPtr, ULONG wHexVal, USHORT Option);

VOID StrPrint( PSZ DbgStr,
               ULONG arg1, 
               ULONG arg2, 
               ULONG arg3, 
               ULONG arg4, 
               ULONG arg5, 
               ULONG par6);

VOID  FAR DBGPrint6x( PSZ s, 
                      ULONG par1, 
                      ULONG par2, 
                      ULONG par3, 
                      ULONG par4, 
                      ULONG par5,
                      ULONG par6);

