/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*
*
*/
/************************** START OF SPECIFICATIONS ***************************/
/*                                                                            */
/*   SOURCE FILE NAME:    RSCDATA.C                                           */
/*                                                                            */
/*   DESCRIPTIVE NAME: 	 IBMRSCSI Data definitions                            */
/*                                                                            */
/*   FUNCTION:  Global data variables for IBMRSCSI.FLT                        */
/*                                                                            */
/*   NOTES:                                                                   */
/*                                                                            */
/*      DEPENDENCIES: None                                                    */
/*      RESTRICTIONS: None                                                    */
/*                                                                            */
/*   ENTRY POINTS:    NONE                                                    */
/*                                                                            */
/*                                                                            */
/*   EXTERNAL REFERENCES:  NONE                                               */
/*                                                                            */
/* Change Log                                                                 */
/*                                                                            */
/*  Mark    yy/mm/dd  Programmer      Comment                                 */
/*  ----    --------  ----------      -------                                 */
/*          01/11/23  VJ              Initial Version                         */
/*                                                                            */
/* VJ012402 02/01/24  VJ              Geometry replacing table expanded       */
/*                                    to fix Adaptec driver     in CP1, which */
/*                                    underreports only total sectors value,  */
/*                                    not both cylinder and totals sectors    */
/*                                    like the latest version does            */
/*                                                                            */
/* VJ268869 02/02/08  VJ              SyQuest support added                   */
/*                                                                            */
/**************************** END OF SPECIFICATIONS ***************************/
#include "rsc.h"


// SCSI MODESENSE 6 PageCode 5 command block
SCSICDB6   SCSIModeSense6  = { SCSI_MODE_SENSE   , 0, 5, 0,   0xFF, 0}; 

// SCSI MODESENSE 6 PageCode 5 command block
SCSICDB10  SCSIModeSense10 = { SCSI_MODE_SENSE_10, 0, 5, 0,  {0xFF} , 0}; 

UT gUT = {0}; // Unit info table


// TotalSectors, BytesPerSector, Reserved, NumHeads, TotalCylinders, SectorsPerTrack
GEORTBL gGeoRTable[] = {

   DEVTYPE_IOMEGA_ZIP_100, // IOMEGA ZIP 100 Geometry Replace Values
   {196607L, 512, 0, 64, 95L, 32}, 
   {196608L, 512, 0, 64, 96L, 32},

   DEVTYPE_IOMEGA_ZIP_250, // IOMEGA ZIP 250 Geometry Replace Values
   {196607L, 512, 0, 64, 95L, 32}, 
   {196608L, 512, 0, 64, 96L, 32},

   DEVTYPE_IOMEGA_ZIP_100, // IOMEGA ZIP 100 Geometry Replace Values           // VJ012402
   {196607L, 512, 0, 64, 96L, 32},                                             // VJ012402
   {196608L, 512, 0, 64, 96L, 32},                                             // VJ012402
                                                                               // VJ012402
   DEVTYPE_IOMEGA_ZIP_250, // IOMEGA ZIP 250 Geometry Replace Values           // VJ012402
   {196607L, 512, 0, 64, 96L, 32},                                             // VJ012402
   {196608L, 512, 0, 64, 96L, 32},                                             // VJ012402

   DEVTYPE_SYQUEST_SQ3270S, // SyQuest SQ3270S Geometry Replace Values         // VJ268869  
   {524287L, 512, 0, 64, 255L, 32},                                            // VJ268869   
   {524288L, 512, 0, 64, 256L, 32},                                            // VJ268869  

   DEVTYPE_SYQUEST_SQ3270S, // SyQuest SQ3270S Geometry Replace Values         // VJ268869  
   {524287L, 512, 0,  0,   0L,  0},//for CP1 and Aurora version of adaptec dd  // VJ268869   
   {524288L, 512, 0, 64, 256L, 32},                                            // VJ268869  



   DEVTYPE_END_OF_GEORTBL, // End Of Replace Table
   {DEVTYPE_END_OF_GEORTBL},
   {DEVTYPE_END_OF_GEORTBL}
};

/* By the IDs specified in the following table filter identifies device type */
DEVTYPETBL gDevTypes[] = {

   DEVTYPE_IOMEGA_ZIP_100, "IOMEGA", "ZIP 250",  // IOMEGA ZIP100
   DEVTYPE_IOMEGA_ZIP_250, "IOMEGA", "ZIP 100",  // IOMEGA ZIP250
   DEVTYPE_SYQUEST_SQ3270S,"SYQUEST", "SQ3270S",
   DEVTYPE_END_OF_GEORTBL, "", ""
};


USHORT   gRSCFlags    = 0;
USHORT   gRSCHandle   = 0;

#ifdef DEBUG
CHAR DBGPrefix[] = "IBMRSCSI: ";
#endif

PFN      Device_Help        = 0L;    // far ptr to devhelp function


BYTE     gCBPool[CB_POOL_SIZE] = {0};

// Starting form this point everything is discarded from the memory after INIT is completed 
PBYTE      gpEndOfData; 

// SCSI INQUIRY command block
SCSICDB6   SCSIInquiry     = { SCSI_INQUIRY      , 0, 0, 0,   0xFF, 0}; 

UCHAR    gDTBuf[SCRATCH_BUF_SIZE]; // Device Table buffer, used at INIT

/******** Resource Management related data ********************/
HDRIVER        hRMDriver        = 0;  
ADAPTERNAME    FilterName        = {"IBMRSCSI Filter",0,0};
UCHAR          RMDrvrNameTxt[]   = "IBMRSCSI.FLT";
UCHAR          RMDrvrDescTxt[]   = "SCSI Removables Support";
UCHAR          RMVendorNameTxt[] = "IBM";

DRIVERSTRUCT   gRMDriverStr =
{
   RMDrvrNameTxt,          /* PSZ       DrvrName;        */
   RMDrvrDescTxt,          /* PSZ       DrvrDescript;    */
   RMVendorNameTxt,        /* PSZ       VendorName;      */
   CMVERSION_MAJOR,        /* UCHAR     MajorVer;        */
   CMVERSION_MINOR,        /* UCHAR     MinorVer;        */
   2001, 11, 06,           /* DATESTAMP Date;            */
   DRF_STATIC,             /* USHORT    DrvrFlags;       */
   DRT_ADDDM,              /* USHORT    DrvrType;        */
   DRS_FILTER,             /* USHORT    DrvrSubType;     */
   NULL                    /* PFNRMCB   DrvrCallback;    */
};                                                                 

USHORT   RMFlags               = 0;                                 
PFNRM    RM_Help0              = NULL;                              
PFNRM    RM_Help3              = NULL;  


/********************************* Verbose Stuff ***************************************/
VERBOSE gVerboseTable = {
   NO_VERBOSE,                           //  UCHAR     VerboseMode;                       
   FALSE,                                //  BOOL      IsVPrint;                            
   {0},                                  //  CHAR      VerboseMsg[MAX_VERBOSE_MSG_SIZE];  
   NULL,                                 //  PSZ       pVerboseMsg;                       
   {MSG_REPLACEMENT_STRING, 1, 0}        //  MSGTABLE  MsgTable;                          
};

PVERBOSE gpVRB = &gVerboseTable;


/* Verbose messages definitions */
VMSG gVMSGs[]={
   " IBMRSCSI.FLT is initializing ͻ", //  0  VMSG_INITIALIZING    
   "                                                                        ", //  1  VMSG_BLANK           
   " IBMRSCSI.FLT:INIT FAILED - no removable SCSI drives found. Unloading...", //  2  VMSG_INIT_FAILED     
   " IBMRSCSI.FLT: FAILED TO REGISTER. Unloading...                         ", //  3  VMSG_REG_FAILED      
   "     ERROR allocating unit.                                             ", //  4  VMSG_ALLOC_FAILED     
   " IBMRSCSI.FLT: accepted devices listing:                                ", //  5  VMSG_ACCEPTING       
   " Unit     Adapter        Device Class     VendorID  ProductID  Revision ", //  6  VMSG_DEVLIST_HEAD    
   "  ", //  7  VMSG_LINE            
   " IBMRSCSI: ERROR registering Device Class.                              ", //  8  VMSG_DEVCLASS_FAILED 
   "  %d\t%s %s   %s  %s   %s     ",                                           //  9  VMSG_UNIT_LISTING    
   " END OF IBMRSCSI.FLT OUTPUT ͼ", // 10  VMSG_END_OF_OUTPUT   
   "SYSFLTR: IBMRSCSI output completed.                                      "};// 11  VMSG_WAIT_MODE    

   
/***************************************************************************************/


