/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = SCSIPRO.H
 *
 * DESCRIPTIVE NAME = IBM2SCSI.ADD - Adapter Driver for IBM scsi adapters.
 *                    Prototype definitions.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  Defines all function prototypes.
 *
 *
*/

/*-------------------*/
/* Organized by file */
/*-------------------*/

/*------------*/
/* SCSISTR1.C */
/*------------*/

VOID NEAR SCSIStrat1();

/*------------*/
/* SCSISUBS.C */
/*------------*/

NPDCB  NEAR FindDeviceEntry(USHORT);
VOID   NEAR BuildSCB(NPSCB, USHORT, NPDCB, ULONG, ULONG, ULONG, USHORT, USHORT);
NPSCBH NEAR AllocSCB(NPDCB, PIORB);
NPSCBH NEAR FreeSCB(USHORT, NPSCBH, NPDCB);
VOID   NEAR QueueIORB(PIORB, NPDCB, USHORT);
PIORB  NEAR DeQueueIORB(NPDCB);
VOID   NEAR StartIORB(PIORB, NPDCB);
USHORT NEAR FinishIORB(PIORB, NPDCB);
NPDCB  NEAR ValidIORBCommand(PIORB);
USHORT NEAR CountSGBlocks(PSCATGATENTRY, USHORT, USHORT);
VOID   NEAR InitIORBWorkSpace(PIORB);
PIORB  NEAR GetNextWork(NPDCB);
VOID   NEAR Trace(USHORT, PIORB);
ULONG  NEAR VirtToPhys (PBYTE);
PIORB  NEAR CompleteIORBChain(NPDCB, PIORB, PIORB, USHORT);
USHORT NEAR StartLocateModeSCB(USHORT, ULONG, USHORT);

/*------------*/
/* SCSISUB2.C */
/*------------*/

USHORT NEAR InitMoveMode(USHORT);
VOID   NEAR InitAutoReqSense(PIORB, PSTDHEAD, NPDCB);
VOID   NEAR StartCtrlEl(PREQH, NPDCB);
VOID   NEAR AllocEntityID(NPDCB);
USHORT NEAR AllocEntityIDStage(PIORB, NPDCB);
USHORT NEAR AbortDevice (NPDCB, PIORB, USHORT, USHORT);
VOID   NEAR ResetDevice (NPDCB, PIORB);
USHORT NEAR MMDevCtrlDone(PIORB, NPDCB);
USHORT NEAR HoldDevice(NPDCB, USHORT);
USHORT NEAR StartUnit(PIORB, NPDCB);
USHORT NEAR MMStartUnit_AbortDone(PIORB, NPDCB);
USHORT NEAR MMStartUnit_StartDone(PIORB, NPDCB);
ULONG  FAR  _loadds SignalAdapter (USHORT, ULONG);
ULONG  FAR  _loadds PipeFull (ULONG, PREQH);


/*------------*/
/* SCSIREQ1.C */
/*------------*/

VOID   _loadds FAR  IORBEntry(PIORB);
VOID   NEAR IOCC_Configuration(PIORB_CONFIGURATION, NPDCB);
VOID   NEAR IOCM_GetDeviceTable(PIORB_CONFIGURATION, NPDCB);
VOID   NEAR IOCM_CompleteInit(PIORB_CONFIGURATION, NPDCB);
VOID   NEAR IOCC_UnitControl(PIORB_UNIT_CONTROL, NPDCB);
VOID   NEAR IOCC_Geometry(PIORB_GEOMETRY, NPDCB);
VOID   NEAR IOCC_MM_Geometry(PIORB_GEOMETRY, NPDCB);
USHORT NEAR IOCM_GeometrySetup(PIORB_GEOMETRY, NPDCB);
USHORT NEAR IOCM_GeometryDone(PIORB_GEOMETRY, NPDCB);
USHORT NEAR IOCM_GeometryCheckBootSector(PIORB_GEOMETRY, NPDCB); /*@V95775*/

/*------------*/
/* SCSIREQ2.C */
/*------------*/

VOID   NEAR IOCC_Format(PIORB_FORMAT, NPDCB);
VOID   NEAR IOCC_MM_Format(PIORB_FORMAT, NPDCB);
VOID   NEAR IOCC_UnitStatus(PIORB_UNIT_STATUS, NPDCB);
USHORT NEAR IOCC_SetupUnitStatus(PIORB_UNIT_STATUS, NPDCB);
VOID   NEAR IOCC_MM_UnitStatus(PIORB_UNIT_STATUS, NPDCB);
USHORT NEAR IOCC_UnitStatusDone(PIORB_UNIT_STATUS, NPDCB);
VOID   NEAR IOCC_AdapterPassthru(PIORB_ADAPTER_PASSTHRU, NPDCB);
USHORT NEAR IOCC_SetupPassthruCDB(PIORB_ADAPTER_PASSTHRU, NPDCB);
VOID   NEAR IOCC_MM_AdapterPassthru(PIORB_ADAPTER_PASSTHRU, NPDCB);
VOID   NEAR IOCC_Undefined(PIORB, NPDCB);


/*------------*/
/* SCSIREQ3.C */
/*------------*/

VOID   NEAR IOCC_ExecuteIO(PIORB_EXECUTEIO, NPDCB);
VOID   NEAR IOCC_MM_ExecuteIO(PIORB_EXECUTEIO, NPDCB);
USHORT NEAR IOCC_MM_ExecIOBuildCtrlEl(PIORB_EXECUTEIO, NPDCB);
USHORT NEAR IOCC_ExecIOBldSCBChain(PIORB_EXECUTEIO, NPDCB);
USHORT NEAR IOCC_ExecIODone(PIORB_EXECUTEIO, NPDCB);
VOID   NEAR IOCC_DeviceControl(PIORB_DEVICE_CONTROL, NPDCB);
USHORT NEAR IOCM_MediaControl(PIORB, NPDCB);
VOID   NEAR IOCM_MM_MediaControl(PIORB, NPDCB);


/*-----------*/
/* SCSIINT.C */
/*-----------*/


VOID   NEAR SCSIInterruptHdlr();
BOOL   NEAR GetSenseData(NPDCB,);
PIORB  NEAR FindFailingIORB(NPDCB);
USHORT NEAR GetIntrAdapter();
VOID   NEAR ProcessLocateModeDevice (NPDCB);
ULONG  FAR  _loadds DequeueSignal(ULONG);
ULONG  FAR  _loadds EnqueueSignal(ULONG);
ULONG  FAR  _loadds ProcessMoveModeElement(PEXTREPLY, ULONG);
VOID   NEAR ProcessGoodElement(PIORB);
VOID   NEAR ProcessErrorElement(PIORB, PEXTREPLY);
NPDCB  NEAR GetIntrDevice(USHORT);
USHORT NEAR ProcessSenseData (PIORB, NPDCB);
USHORT NEAR RemoveIORBFromActiveChain(PIORB, NPDCB);
USHORT NEAR ProcessTSB(PTSB, PIORB);


/*------------*/
/* SCSITIMR.C */
/*------------*/

VOID FAR  TimerHandler();
USHORT NEAR ResetAdapter(USHORT);
VOID NEAR AdapterResetComplete(USHORT);
VOID NEAR RestartIO(USHORT);
VOID NEAR AdapterResetFailed(USHORT);

/*--------*/
/* io.asm */
/*--------*/

USHORT NEAR _StartIO(USHORT,ULONG, USHORT);
UCHAR  NEAR ReadReg(USHORT);
VOID   NEAR WriteReg(USHORT, USHORT);
VOID   NEAR WriteAttn(USHORT, USHORT);
USHORT NEAR ResetToggle(USHORT);


/*-------------*/
/* dprintf.asm */
/*-------------*/

VOID NEAR dprintf(CHAR FAR * msg, ...);

/*------------*/
/* SCSIINIT.C */
/*------------*/

VOID   NEAR Code_End();
USHORT NEAR SCSIInit();
VOID   NEAR BuildSCBPool();
VOID   NEAR BuildUnitHandleTable();
VOID   NEAR InitTimerPool();
VOID   NEAR InitTraceBuffer();
VOID   NEAR FreeResources();
USHORT NEAR GetEBDAPtr();
USHORT NEAR GetSCSIDataPtr(PSCSIDATATBL FAR *);
USHORT NEAR InitSCSISubsystem();
USHORT NEAR ScanDIRs(PDIR, USHORT, USHORT, USHORT);
USHORT NEAR GetINQData(USHORT, NPDCB);
USHORT NEAR GetPOSData(USHORT, PSCSIADPINFO);
USHORT NEAR InitDevice(NPDCB, USHORT, PDIR);
USHORT NEAR InitAdapter(PSCSIADPINFO, USHORT, USHORT);
USHORT NEAR PatchTribble(USHORT);
VOID   NEAR GetInitParms (PRPINITIN);

