/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = SCSIDATA.C
 *
 * DESCRIPTIVE NAME = IBM2SCSI.ADD - Adapter Driver for IBM SCSI adapters.
 *                    Data segment definition.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  This file maps the data segment.
 *
*/

/*----------------------*/
/* System include files */
/*----------------------*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "devhdr.h"

/*----------------------*/
/* ADD include files    */
/*----------------------*/

#include "strat2.h"
#include "reqpkt.h"
#include "iorb.h"
#include "scb.h"
#include "abios.h"
#include "dhcalls.h"

/*----------------------*/
/* Local include files  */
/*----------------------*/

#include "mmscb.h"
#include "scsi.h"
#include "scsiadd.h"
#include "scsipro.h"
#include "delivery.h"

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*   The free space is mapped as follows:                                  */
/*                                                                         */
/*                                                                         */
/*   +-----------------------------------+                                 */
/*   |                                   |                                 */
/*   | Adapter Control Blocks (8)        |                                 */
/*   |                                   |                                 */
/*   +-----------------------------------+<-----+                          */
/*   |                                   |      |                          */
/*   |   Device Control Blocks for       |      | This section is repeated */
/*   |   adapter 0                       |      | for each adapter present */
/*   |                                   |      | in the system. (up to 8) */
/*   +-----------------------------------+      |                          */
/*   |                                   |      |                          */
/*   |   Pipe memory for Adapter 0       |      |                          */
/*   |   (if move mode)                  |      |                          */
/*   |                                   |      |                          */
/*   +-----------------------------------+<-----+                          */
/*   |                                   |                                 */
/*   | Unit Handle table                 |                                 */
/*   |                                   |                                 */
/*   +-----------------------------------+                                 */
/*   |                                   |                                 */
/*   | SCB Pool for locate mode          |                                 */
/*   |                                   |                                 */
/*   +-----------------------------------+                                 */
/*   |                                   |                                 */
/*   | Timer Element Array               |                                 */
/*   |                                   |                                 */
/*   +-----------------------------------+                                 */
/*   |                                   |                                 */
/*   | Trace Buffer (if enabled)         |                                 */
/*   |                                   |                                 */
/*   +-----------------------------------+                                 */
/*                                                                         */
/*                                                                         */
/*-------------------------------------------------------------------------*/



/*---------------------------------------------------------------------*/
/* Disk DD Header                                                      */
/*---------------------------------------------------------------------*/

DDHDR SCSIADDHeader =
{
   (PVOID) -1L,                  /* Far PTR to next device header (4 bytes)  */
   DEVLEV_3 + DEV_CHAR_DEV,      /* Device attribute (2 bytes)               */
   (USHORT)  SCSIStrat1,
   (USHORT)  0,
   ADDNAME,                      /* for char device. Use ATTACHDD function.  */
   0,                            /* USHORT protmodeCS                        */
   0,                            /* USHORT protmodeDS                        */
   0,                            /* USHORT realmodeCS                        */
   0,                            /* USHORT realmodeDS                        */
   DEV_ADAPTER_DD
};


/*--------------------------------------------------------------------*/
/*     Static Data                                                    */
/*--------------------------------------------------------------------*/

PFN       Device_Help       = 0L;       /* Device Helper service pointer     */

CHAR      DelivName[8]      = DELIVNAME;

DDTABLE   DDTbl             = {0};

USHORT    DeliveryHandle    = 0;

USHORT    ADDStatus         = 0;        /* ADD status variable               */
USHORT    IntCount          = 0;        /* nest level of interrupts          */
USHORT    Init_Complete     = FALSE;    /* true when init done               */
USHORT    CurDskLID         = 1;        /* used to alloc/dealloc disk LIDs   */
USHORT    cAdapters         = 0;        /* number of adapters                */
USHORT    cDevices          = 0;        /* total # of devices                */
USHORT    RetryCount        = 5;        /* retry 5 times                     */
USHORT    MaxSCBs           = 4;        /* max SCBs per IORB per interrupt   */
USHORT    ADDHandle         = 0;        /* handle returned to us on register */
USHORT    GroupSize         = 4;        /* # of IORBs to chain together      */
USHORT    QueueSize         = DFLT_QS;  /* # outstanding IORBs allowed       */
USHORT    PipeSize          = DFLT_PS;  /* pipe size 4 move mode 1K granular */
USHORT    LedCnt            = 0;        /* LED option count                  */
USHORT    UnitHandle        = 0;
USHORT    IgnoreMask        = 0;        /* adapter ignore mask               */
USHORT    TraceIORBs        = FALSE;    /* trace indicator                   */
USHORT    verbose           = FALSE;    /* verbose option                    */
USHORT    comport           = 0x03f8;   /* com1 default                      */
USHORT    old_part          = 0;        /* use old partitioning if over 1 gig*/

UCHAR     ledmask_on        = 0;
UCHAR     ledmask_off       = 0;
UCHAR     FirstSCSIDrive    = 0;        /* Int 13h 1st SCSI drive number     */
UCHAR     SelectableBootDrv = 0;        /* selectable boot swap drive        */

SEL       sEBDA             = 0;        /* selector for EBDA                 */

ULONG     ppData            = 0;        /* phys addr of beginning of data    */
ULONG     DfltTimeout       = DFLT_TO;  /* default timeout                   */

NPBYTE    free              = 0;        /* ptr to free memory                */

NPABRBH   npRBH             = 0;        /* request block header              */

NPDCB     npDCB             = 0;        /* current device control block      */

NPTRACEINFO TraceBuf        = NULL;     /* trace buffer ptr                  */
USHORT    TraceIndex        = 0;        /* cur trace buf index (most recent) */
MBR       mbr               = {0};    /*   master boot record for geometry   */ /*@V95775*/
                                        /* calculation                       */

/*-----------------------*/
/* IORB routing tables.  */
/*-----------------------*/

CALLTBL   IORBCallTbl[] = {     /* call table for locate mode  */
         { 0                , 0                       , IOCC_Undefined       },
         { 0                , IOCM_COMPLETE_INIT      , IOCC_Configuration   },
         { NEEDDCB          , IOCM_CHANGE_UNITINFO    , IOCC_UnitControl     },
         { DFLTCTRL         , IOCM_GET_DEVICE_GEOMETRY, IOCC_Geometry,       },
         { DFLTCTRL         , IOCM_WRITE_VERIFY       , IOCC_ExecuteIO       },
         { DFLTCTRL         , IOCM_FORMAT_MEDIA       , IOCC_Format          },
         { DFLTCTRL         , IOCM_GET_LOCK_STATUS    , IOCC_UnitStatus      },
         { DFLTCTRL         , IOCM_EJECT_MEDIA        , IOCC_DeviceControl   },
         { DFLTCTRL         , IOCM_EXECUTE_CDB        , IOCC_AdapterPassthru }
          } ;


CALLTBL   IORBMMCallTbl[] = {   /* call table for move mode  */
         { 0                , 0                       , IOCC_Undefined       },
         { 0                , IOCM_COMPLETE_INIT      , IOCC_Configuration   },
         { NEEDDCB          , IOCM_CHANGE_UNITINFO    , IOCC_UnitControl     },
         { DFLTCTRL         , IOCM_GET_DEVICE_GEOMETRY, IOCC_MM_Geometry,    },
         { DFLTCTRL         , IOCM_WRITE_VERIFY       , IOCC_MM_ExecuteIO    },
         { DFLTCTRL         , IOCM_FORMAT_MEDIA       , IOCC_MM_Format       },
         { DFLTCTRL         , IOCM_GET_LOCK_STATUS    , IOCC_UnitStatus      },
         { DFLTCTRL         , IOCM_EJECT_MEDIA        , IOCC_DeviceControl   },
         { DFLTCTRL         , IOCM_EXECUTE_CDB        , IOCC_MM_AdapterPassthru}
          } ;


/*---------------------------------------------------------*/
/* Sense data map for mapping sense codes to IORB errors.  */
/*---------------------------------------------------------*/

USHORT AddSenseDataMap[] = {      /* Index = Sense Code from sense data      */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 00h No sense information                */
   IOERR_RBA_ADDRESSING_ERROR,    /* 01h No index/sector signal              */
   IOERR_RBA_ADDRESSING_ERROR,    /* 02h No seek complete                    */
   IOERR_RBA_CRC_ERROR,           /* 03h Write fault                         */
   IOERR_UNIT_NOT_READY,          /* 04h Drive not ready                     */
   IOERR_ADAPTER_DEVICE_TIMEOUT,  /* 05h LUN not selected                    */
   IOERR_RBA_ADDRESSING_ERROR,    /* 06h No track zero found                 */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 07h Multiple drives selected            */
   IOERR_ADAPTER_DEVICE_TIMEOUT,  /* 08h Logical unit communication failure  */
   IOERR_RBA_ADDRESSING_ERROR,    /* 09h Track following error               */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Ah Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Bh Reserved                            */
   IOERR_RBA_CRC_ERROR,           /* 0Ch Write Error                         */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Dh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Eh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 0Fh Reserved                            */
   IOERR_RBA_ADDRESSING_ERROR,    /* 10h ID CRC or ECC error                 */
   IOERR_RBA_CRC_ERROR,           /* 11h Unrecovered Read error              */
   IOERR_RBA_ADDRESSING_ERROR,    /* 12h No address mark found               */
   IOERR_RBA_ADDRESSING_ERROR,    /* 13h No addr mark in data field          */
   IOERR_RBA_ADDRESSING_ERROR,    /* 14h No record found                     */
   IOERR_RBA_ADDRESSING_ERROR,    /* 15h Seek positioning error              */
   IOERR_RBA_ADDRESSING_ERROR,    /* 16h Data synchroniztion mark error      */
   IOERR_RBA_CRC_ERROR,           /* 17h Recovered read w/ retries           */
   IOERR_RBA_CRC_ERROR,           /* 18h Recovered read data with correction */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 19h Defect list error                   */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 1Ah Parameter overrun                   */
   IOERR_ADAPTER_DEVICEBUSCHECK,  /* 1Bh Synchronous transfer err            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 1Ch Primary defect list not found       */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 1Dh Compare error                       */
   IOERR_RBA_ADDRESSING_ERROR,    /* 1Eh Recovered ID with ECC correction    */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 1Fh Reserved                            */
   IOERR_CMD_NOT_SUPPORTED,       /* 20h Invalid command op code             */
   IOERR_RBA_ADDRESSING_ERROR,    /* 21h Illegal logical blk addr            */
   IOERR_CMD_SYNTAX,              /* 22h Illegal func for dev type           */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 23h Reserved                            */
   IOERR_CMD_SYNTAX,              /* 24h Illegal field in CDW                */
   IOERR_CMD_SYNTAX,              /* 25h Invalid LUN                         */
   IOERR_CMD_SYNTAX,              /* 26h Invalid param list field            */
   IOERR_MEDIA_WRITE_PROTECT,     /* 27h Write protected                     */
   IOERR_MEDIA_CHANGED,           /* 28h Medium changed                      */
   IOERR_DEVICE_RESET,            /* 29h Power on reset or bus device reset  */
   IOERR_MEDIA_CHANGED,           /* 2Ah Mode select parameters changed      */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Bh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Ch Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Dh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Eh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 2Fh Reserved                            */
   IOERR_MEDIA_NOT_SUPPORTED,     /* 30h Incompatible cartridge              */
   IOERR_MEDIA_NOT_FORMATTED,     /* 31h Medium format corrupted             */
   IOERR_MEDIA_NOT_FORMATTED,     /* 32h No defect spare location available  */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 33h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 34h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 35h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 36h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 37h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 38h Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 39h Reserved                            */
   IOERR_MEDIA_NOT_PRESENT,       /* 3Ah Medium Not Present                  */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 3Bh Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 3Ch Reserved                            */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 3Dh Reserved                            */
   IOERR_UNIT_NOT_READY,          /* 3Eh LUN  not self-configured yet        */
   IOERR_ADAPTER_REFER_TO_STATUS, /* 3Fh Reserved                            */
   IOERR_DEVICE_DIAGFAIL,         /* 40h RAM failure                         */
   IOERR_DEVICE_DIAGFAIL,         /* 41h Data path diagnostic failure        */
   IOERR_DEVICE_DIAGFAIL,         /* 42h Power-on diag failure               */
   IOERR_DEVICE_DEVICEBUSCHECK,   /* 43h Message reject error                */
   IOERR_DEVICE,                  /* 44h Internal controller error           */
   IOERR_UNIT_NOT_READY,          /* 45h Select/reselect failed              */
   IOERR_DEVICE_BUSY,             /* 46h Unsuccessful soft reset             */
   IOERR_DEVICE_DEVICEBUSCHECK,   /* 47h SCSI interface parity error         */
   IOERR_DEVICE_DEVICEBUSCHECK,   /* 48h Initiator detected error            */
   IOERR_DEVICE_DEVICEBUSCHECK,   /* 49h Inappropriate/illegal message       */
   IOERR_ADAPTER_REFER_TO_STATUS  /* > 49H - Reserved                        */
   };

USHORT   MaxAddSenseData   = sizeof(AddSenseDataMap) / sizeof(USHORT);

DELIVERYTABLE DelivTbl     = {0};

HOSTRTNTBL    HostRtnTbl   =
   { SignalAdapter,           /* signal adapter                */
     ProcessMoveModeElement,  /* router for dequeued elements  */
     PipeFull,                /* pipe full handler             */
     EnqueueSignal,           /* handler for enqueue signal    */
     DequeueSignal            /* handler for dequeue signal    */
     };

CHAR     AdapterName[18]   = "IBM SCSI Adapter";
CHAR     CorvetteDesc[20]  = "IBM SCSI-2 Adapter!";

/**********************************************************************/
/*     Control tables/variables                                       */
/**********************************************************************/

NPSCBH    npSCBFreeList     = 0,     /* pointer to start of free list      */
          npSCBLastFree     = 0;     /* pointer to last free SCB in list   */

ULONG     *Timers           = 0;     /* ptr to timer array                  */
NPDCB     *UnitHandleTbl    = 0;     /* ptr to unit handle table (dcb ptrs) */

ACB ACBTbl[MAX_SUPPORTED_ADAPTERS] = {0};      /* adapter control blocks   */

/**********************************************************************/
/*     Memory pool for device control blocks, etc ...                 */
/**********************************************************************/

UCHAR MemPool[MEMPOOLSIZE] = {0};


/**********************************************************************/
/*     Discardable init time data.                                    */
/**********************************************************************/

SCSI_INQDATA inqdata             = {0};        /* inquiry data           */
IORBH        initIORB            = {0};        /* init time IORB         */
PIORB        pInitIORB           = 0;          /* ptr to init time IORB  */
SCB          initSCB             = {0};
TSB          initTSB             = {0};
ULONG        ppinitSCB           = 0L;
ULONG        ppinitTSB           = 0L;

USHORT       ldatable[16]        = {0};        /* logical device assgn tbl  */

#define MSG_REPLACEMENT_STRING  1178

static UCHAR AdapterLevelWng[] =                             \
"\n\r"                                                       \
"Warning: OS/2 2.0 detected a downlevel IBM 16-Bit SCSI Adapter.\n\r" \
"         Please have the adapter upgraded.\n\r";

MSGTABLE  AdapterWngMsg = { MSG_REPLACEMENT_STRING,
                            1,
                            AdapterLevelWng
                          };


static UCHAR InvalidParm[] =                                     \
"\n\r"                                                           \
"Warning: IBM2SCSI.ADD detected an error in the parameters \n\r" \
"         specified on the BASEDEV= line in CONFIG.SYS.\n\r "    \
"         Please correct the error and restart the system.\n\r";


MSGTABLE  InvalidParmMsg = { MSG_REPLACEMENT_STRING,
                             1,
                             InvalidParm
                           };

UCHAR    msgbuf[100]     = {0};

MSGTABLE InitMsg = { MSG_REPLACEMENT_STRING, 1, 0};

/*-----------------------------------------------------*/
/* Patch data for different versions of Tribble uCode. */
/*-----------------------------------------------------*/

UCHAR Patch15data[] = {0xC0, 0x01, 0xA9, 0x81, 0x19, 0xB7, 0x15, 0x08,
                       0x19, 0xB7, 0x11, 0x04, 0xD0, 0x01, 0x80, 0x03,
                       0xD0, 0x01, 0x22, 0x15, 0x81, 0x15, 0x81, 0x43,
                       0x6F, 0x08, 0xE5, 0x6F, 0x78, 0x03, 0xF2, 0x7B,
                       0x7C, 0x7C, 0x74, 0x7A, 0x04, 0x8B, 0x82, 0xE0,
                       0x8C, 0x82, 0xF0, 0x0B, 0x0C, 0xDA, 0xF6, 0x75,
                       0x82, 0x74, 0x12, 0x1D, 0x29, 0x50, 0x03, 0x02,
                       0x1D, 0x15, 0x75, 0x82, 0x78, 0x78, 0x00, 0x7A,
                       0x03, 0xE0, 0xF2, 0x05, 0x82, 0x08, 0xDA, 0xF9,
                       0xE0, 0x60, 0x05, 0x74, 0x1D, 0x02, 0x12, 0x15,
                       0x43, 0x66, 0x01, 0x79, 0xD8, 0xE5, 0xF0, 0xF7,
                       0x75, 0x82, 0xAD, 0xE0, 0x70, 0x0C, 0x75, 0x82,
                       0xAF, 0xE0, 0x70, 0x03, 0x02, 0x18, 0x33, 0x02,
                       0x9D, 0x56, 0xE0, 0xF5, 0x67, 0x05, 0x82, 0xE0,
                       0xF5, 0x68, 0x43, 0x66, 0x80, 0x75, 0xA0, 0xC0,
                       0x7A, 0x06, 0x78, 0x10, 0x75, 0x82, 0x9D, 0xE0,
                       0xF2, 0x08, 0x05, 0x82, 0xDA, 0xF9, 0x7A, 0x07,
                       0x7B, 0xB4, 0x7C, 0x9D, 0x8C, 0x82, 0xE0, 0x8B,
                       0x82, 0xF0, 0x0B, 0x0C, 0xDA, 0xF6, 0x75, 0x82,
                       0xAF, 0xE0, 0x60, 0x03, 0x02, 0x9D, 0x56, 0x75,
                       0x82, 0xA1, 0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0,
                       0x70, 0x08, 0x05, 0x82, 0xE0, 0x70, 0x03, 0x02,
                       0x1D, 0x15, 0x12, 0x1F, 0x2F, 0x75, 0x82, 0x27,
                       0xE0, 0x54, 0x01, 0x60, 0x05, 0x75, 0x82, 0xAC,
                       0xE4, 0xF0, 0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4,
                       0xE0, 0x44, 0x02, 0x78, 0x16, 0xF2, 0xD2, 0x0C,
                       0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75, 0xA0,
                       0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2, 0x78,
                       0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02, 0xF2,
                       0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01, 0xF5,
                       0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2, 0x75,
                       0x82, 0x70, 0x12, 0x1D, 0x29, 0x50, 0x22, 0x75,
                       0x82, 0x27, 0xE0, 0x54, 0x10, 0x60, 0x46, 0x12,
                       0x0D, 0xF6, 0x40, 0x41, 0x12, 0x0E, 0x16, 0x40,
                       0x3C, 0x75, 0x82, 0xC4, 0xE0, 0x75, 0x82, 0xCC,
                       0xF0, 0x75, 0x82, 0xC5, 0xE0, 0x75, 0x82, 0xCD,
                       0xF0, 0x78, 0x18, 0x7C, 0xBB, 0x12, 0x1E, 0xCE,
                       0x75, 0x82, 0xAC, 0xE0, 0x44, 0x12, 0x75, 0x82,
                       0xAC, 0xF0, 0x75, 0x82, 0x72, 0xE0, 0x70, 0x18,
                       0x78, 0x1C, 0x7C, 0xBF, 0x12, 0x1E, 0xE2, 0x12,
                       0x0D, 0xF6, 0x75, 0x82, 0xAC, 0xE0, 0x50, 0x02,
                       0x54, 0xEF, 0x78, 0x1E, 0xF2, 0x02, 0x1D, 0x15,
                       0x75, 0x82, 0x72, 0x12, 0x1D, 0x1A, 0xE4, 0x75,
                       0x82, 0xBF, 0xF0, 0x05, 0x82, 0xF0, 0x05, 0x82,
                       0x74, 0x01, 0xF0, 0xE4, 0x78, 0x1C, 0xF2, 0x08,
                       0xF2, 0x12, 0x20, 0xB7, 0x75, 0x82, 0x70, 0x12,
                       0x1D, 0x29, 0x40, 0xCB, 0x80, 0xD4, 0xE0, 0xF5,
                       0x67, 0x05, 0x82, 0xE0, 0xF5, 0x68, 0x43, 0x66,
                       0x40, 0x75, 0xA0, 0xC0, 0x7A, 0x06, 0x78, 0x18,
                       0x75, 0x82, 0xA5, 0xE0, 0xF2, 0x08, 0x05, 0x82,
                       0xDA, 0xF9, 0x7A, 0x07, 0x7B, 0xBB, 0x7C, 0xA5,
                       0x8C, 0x82, 0xE0, 0x8B, 0x82, 0xF0, 0x0B, 0x0C,
                       0xDA, 0xF6, 0x75, 0x82, 0xAC, 0xE0, 0xF5, 0xF0,
                       0x54, 0x04, 0x60, 0x03, 0x02, 0x9E, 0xE6, 0x75,
                       0x82, 0xAD, 0xE0, 0x70, 0x05, 0x74, 0x3C, 0x02,
                       0x12, 0x15, 0x75, 0x82, 0xA1, 0xE0, 0x70, 0x0D,
                       0x05, 0x82, 0xE0, 0x70, 0x08, 0x05, 0x82, 0xE0,
                       0x70, 0x03, 0x02, 0x9E, 0x22, 0x12, 0x1F, 0x2F,
                       0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4, 0xE0, 0x44,
                       0x02, 0xF0, 0xC0, 0xE0, 0x75, 0x82, 0x27, 0xE0,
                       0x54, 0x01, 0x60, 0x06, 0xD0, 0xE0, 0x54, 0xEF,
                       0xC0, 0xE0, 0xD0, 0xE0, 0x78, 0x16, 0xF2, 0xD2,
                       0x0C, 0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75,
                       0xA0, 0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2,
                       0x78, 0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02,
                       0xF2, 0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01,
                       0xF5, 0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2,
                       0x75, 0x82, 0xA9, 0xE0, 0x70, 0x0D, 0x05, 0x82,
                       0xE0, 0x70, 0x08, 0x05, 0x82, 0xE0, 0x70, 0x03,
                       0x02, 0x9C, 0xD7, 0x75, 0x82, 0x27, 0xE0, 0x54,
                       0x01, 0x70, 0x0C, 0x75, 0xA0, 0xC0, 0x75, 0x82,
                       0xAC, 0xE0, 0x44, 0x02, 0x78, 0x1E, 0xF2, 0x02,
                       0x1D, 0x15, 0x12, 0x1F, 0xFA, 0x75, 0x82, 0x27,
                       0xE0, 0x54, 0x01, 0x60, 0x05, 0x75, 0x82, 0xA4,
                       0xE4, 0xF0, 0x75, 0xA0, 0xC0, 0x75, 0x82, 0xAC,
                       0xE0, 0x44, 0x02, 0x78, 0x1E, 0xF2, 0xC2, 0x0C,
                       0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75, 0xA0,
                       0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2, 0x78,
                       0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02, 0xF2,
                       0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01, 0xF5,
                       0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2, 0x75,
                       0x82, 0x70, 0x12, 0x1D, 0x29, 0x50, 0x22, 0x75,
                       0x82, 0x27, 0xE0, 0x54, 0x10, 0x60, 0x46, 0x12,
                       0x0D, 0xF6, 0x40, 0x41, 0x12, 0x0E, 0x16, 0x40,
                       0x3C, 0x75, 0x82, 0xC4, 0xE0, 0x75, 0x82, 0xCA,
                       0xF0, 0x75, 0x82, 0xC5, 0xE0, 0x75, 0x82, 0xCB,
                       0xF0, 0x78, 0x10, 0x7C, 0xB4, 0x12, 0x1E, 0xCE,
                       0x75, 0x82, 0xA4, 0xE0, 0x44, 0x12, 0x75, 0x82,
                       0xA4, 0xF0, 0x75, 0x82, 0x72, 0xE0, 0x70, 0x18,
                       0x78, 0x14, 0x7C, 0xB8, 0x12, 0x1E, 0xE2, 0x12,
                       0x0D, 0xF6, 0x75, 0x82, 0xA4, 0xE0, 0x50, 0x02,
                       0x54, 0xEF, 0x78, 0x16, 0xF2, 0x02, 0x1D, 0x15,
                       0x75, 0x82, 0x72, 0x12, 0x1D, 0x1A, 0xE4, 0x75,
                       0x82, 0xB8, 0xF0, 0x05, 0x82, 0xF0, 0x05, 0x82,
                       0x74, 0x01, 0xF0, 0xE4, 0x78, 0x14, 0xF2, 0x08,
                       0xF2, 0x12, 0x20, 0xB7, 0x75, 0x82, 0x70, 0x12,
                       0x1D, 0x29, 0x40, 0xCB, 0x80, 0xD4, 0x75, 0x82,
                       0xA9, 0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0, 0x70,
                       0x08, 0x05, 0x82, 0xE0, 0x70, 0x03, 0x02, 0x9C,
                       0x92, 0x12, 0x1F, 0xFA, 0x75, 0xA0, 0xC0, 0x75,
                       0x82, 0xAC, 0xE0, 0x44, 0x02, 0xF0, 0xC0, 0xE0,
                       0x75, 0x82, 0x27, 0xE0, 0x54, 0x01, 0x60, 0x06,
                       0xD0, 0xE0, 0x54, 0xEF, 0xC0, 0xE0, 0xD0, 0xE0,
                       0x78, 0x1E, 0xF2, 0xC2, 0x0C, 0x54, 0x01, 0xC4,
                       0x23, 0xC0, 0xE0, 0x75, 0xA0, 0xE8, 0x78, 0x03,
                       0x79, 0xDB, 0xE7, 0xF2, 0x78, 0x00, 0xD0, 0xE0,
                       0xC0, 0xE0, 0x44, 0x02, 0xF2, 0xD0, 0xE0, 0xC4,
                       0xB2, 0xE1, 0x44, 0x01, 0xF5, 0x75, 0x78, 0x05,
                       0x75, 0xA0, 0xE0, 0xF2, 0x75, 0x82, 0xAD, 0xE0,
                       0x70, 0x03, 0x02, 0x9E, 0x67, 0x75, 0x82, 0xA1,
                       0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0, 0x70, 0x08,
                       0x05, 0x82, 0xE0, 0x70, 0x03, 0x02, 0x9E, 0x67,
                       0x75, 0x82, 0x27, 0xE0, 0x54, 0x01, 0x70, 0x0C,
                       0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4, 0xE0, 0x44,
                       0x02, 0x78, 0x16, 0xF2, 0x02, 0x1D, 0x15};

UCHAR Patch15vdata[] = {0x80, 0x53, 0x43, 0x53, 0x49, 0x5F, 0x4E, 0x43,
                        0x5F, 0x50, 0x41 ,0x54, 0x43, 0x48};

UCHAR Patch16data[] = {0xC0, 0x01, 0xA9, 0x81, 0x19, 0xB7, 0x15, 0x08,
                       0x19, 0xB7, 0x17, 0x04, 0xD0, 0x01, 0x80, 0x03,
                       0xD0, 0x01, 0x22, 0x15, 0x81, 0x15, 0x81, 0x43,
                       0x6F, 0x08, 0xE5, 0x6F, 0x78, 0x03, 0xF2, 0x7B,
                       0x7C, 0x7C, 0x74, 0x7A, 0x04, 0x8B, 0x82, 0xE0,
                       0x8C, 0x82, 0xF0, 0x0B, 0x0C, 0xDA, 0xF6, 0x75,
                       0x82, 0x74, 0x12, 0x1D, 0x2F, 0x50, 0x03, 0x02,
                       0x1D, 0x1B, 0x75, 0x82, 0x78, 0x78, 0x00, 0x7A,
                       0x03, 0xE0, 0xF2, 0x05, 0x82, 0x08, 0xDA, 0xF9,
                       0xE0, 0x60, 0x05, 0x74, 0x1D, 0x02, 0x12, 0x1B,
                       0x43, 0x66, 0x01, 0x79, 0xD8, 0xE5, 0xF0, 0xF7,
                       0x75, 0x82, 0xAD, 0xE0, 0x70, 0x0C, 0x75, 0x82,
                       0xAF, 0xE0, 0x70, 0x03, 0x02, 0x18, 0x39, 0x02,
                       0x9D, 0x56, 0xE0, 0xF5, 0x67, 0x05, 0x82, 0xE0,
                       0xF5, 0x68, 0x43, 0x66, 0x80, 0x75, 0xA0, 0xC0,
                       0x7A, 0x06, 0x78, 0x10, 0x75, 0x82, 0x9D, 0xE0,
                       0xF2, 0x08, 0x05, 0x82, 0xDA, 0xF9, 0x7A, 0x07,
                       0x7B, 0xB4, 0x7C, 0x9D, 0x8C, 0x82, 0xE0, 0x8B,
                       0x82, 0xF0, 0x0B, 0x0C, 0xDA, 0xF6, 0x75, 0x82,
                       0xAF, 0xE0, 0x60, 0x03, 0x02, 0x9D, 0x56, 0x75,
                       0x82, 0xA1, 0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0,
                       0x70, 0x08, 0x05, 0x82, 0xE0, 0x70, 0x03, 0x02,
                       0x1D, 0x1B, 0x12, 0x1F, 0x35, 0x75, 0x82, 0x27,
                       0xE0, 0x54, 0x01, 0x60, 0x05, 0x75, 0x82, 0xAC,
                       0xE4, 0xF0, 0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4,
                       0xE0, 0x44, 0x02, 0x78, 0x16, 0xF2, 0xD2, 0x0C,
                       0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75, 0xA0,
                       0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2, 0x78,
                       0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02, 0xF2,
                       0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01, 0xF5,
                       0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2, 0x75,
                       0x82, 0x70, 0x12, 0x1D, 0x2F, 0x50, 0x22, 0x75,
                       0x82, 0x27, 0xE0, 0x54, 0x10, 0x60, 0x46, 0x12,
                       0x0D, 0xFC, 0x40, 0x41, 0x12, 0x0E, 0x1C, 0x40,
                       0x3C, 0x75, 0x82, 0xC4, 0xE0, 0x75, 0x82, 0xCC,
                       0xF0, 0x75, 0x82, 0xC5, 0xE0, 0x75, 0x82, 0xCD,
                       0xF0, 0x78, 0x18, 0x7C, 0xBB, 0x12, 0x1E, 0xD4,
                       0x75, 0x82, 0xAC, 0xE0, 0x44, 0x12, 0x75, 0x82,
                       0xAC, 0xF0, 0x75, 0x82, 0x72, 0xE0, 0x70, 0x18,
                       0x78, 0x1C, 0x7C, 0xBF, 0x12, 0x1E, 0xE8, 0x12,
                       0x0D, 0xFC, 0x75, 0x82, 0xAC, 0xE0, 0x50, 0x02,
                       0x54, 0xEF, 0x78, 0x1E, 0xF2, 0x02, 0x1D, 0x1B,
                       0x75, 0x82, 0x72, 0x12, 0x1D, 0x20, 0xE4, 0x75,
                       0x82, 0xBF, 0xF0, 0x05, 0x82, 0xF0, 0x05, 0x82,
                       0x74, 0x01, 0xF0, 0xE4, 0x78, 0x1C, 0xF2, 0x08,
                       0xF2, 0x12, 0x20, 0xBD, 0x75, 0x82, 0x70, 0x12,
                       0x1D, 0x2F, 0x40, 0xCB, 0x80, 0xD4, 0xE0, 0xF5,
                       0x67, 0x05, 0x82, 0xE0, 0xF5, 0x68, 0x43, 0x66,
                       0x40, 0x75, 0xA0, 0xC0, 0x7A, 0x06, 0x78, 0x18,
                       0x75, 0x82, 0xA5, 0xE0, 0xF2, 0x08, 0x05, 0x82,
                       0xDA, 0xF9, 0x7A, 0x07, 0x7B, 0xBB, 0x7C, 0xA5,
                       0x8C, 0x82, 0xE0, 0x8B, 0x82, 0xF0, 0x0B, 0x0C,
                       0xDA, 0xF6, 0x75, 0x82, 0xAC, 0xE0, 0xF5, 0xF0,
                       0x54, 0x04, 0x60, 0x03, 0x02, 0x9E, 0xE6, 0x75,
                       0x82, 0xAD, 0xE0, 0x70, 0x05, 0x74, 0x3C, 0x02,
                       0x12, 0x1B, 0x75, 0x82, 0xA1, 0xE0, 0x70, 0x0D,
                       0x05, 0x82, 0xE0, 0x70, 0x08, 0x05, 0x82, 0xE0,
                       0x70, 0x03, 0x02, 0x9E, 0x22, 0x12, 0x1F, 0x35,
                       0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4, 0xE0, 0x44,
                       0x02, 0xF0, 0xC0, 0xE0, 0x75, 0x82, 0x27, 0xE0,
                       0x54, 0x01, 0x60, 0x06, 0xD0, 0xE0, 0x54, 0xEF,
                       0xC0, 0xE0, 0xD0, 0xE0, 0x78, 0x16, 0xF2, 0xD2,
                       0x0C, 0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75,
                       0xA0, 0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2,
                       0x78, 0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02,
                       0xF2, 0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01,
                       0xF5, 0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2,
                       0x75, 0x82, 0xA9, 0xE0, 0x70, 0x0D, 0x05, 0x82,
                       0xE0, 0x70, 0x08, 0x05, 0x82, 0xE0, 0x70, 0x03,
                       0x02, 0x9C, 0xD7, 0x75, 0x82, 0x27, 0xE0, 0x54,
                       0x01, 0x70, 0x0C, 0x75, 0xA0, 0xC0, 0x75, 0x82,
                       0xAC, 0xE0, 0x44, 0x02, 0x78, 0x1E, 0xF2, 0x02,
                       0x1D, 0x1B, 0x12, 0x20, 0x00, 0x75, 0x82, 0x27,
                       0xE0, 0x54, 0x01, 0x60, 0x05, 0x75, 0x82, 0xA4,
                       0xE4, 0xF0, 0x75, 0xA0, 0xC0, 0x75, 0x82, 0xAC,
                       0xE0, 0x44, 0x02, 0x78, 0x1E, 0xF2, 0xC2, 0x0C,
                       0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75, 0xA0,
                       0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2, 0x78,
                       0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02, 0xF2,
                       0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01, 0xF5,
                       0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2, 0x75,
                       0x82, 0x70, 0x12, 0x1D, 0x2F, 0x50, 0x22, 0x75,
                       0x82, 0x27, 0xE0, 0x54, 0x10, 0x60, 0x46, 0x12,
                       0x0D, 0xFC, 0x40, 0x41, 0x12, 0x0E, 0x1C, 0x40,
                       0x3C, 0x75, 0x82, 0xC4, 0xE0, 0x75, 0x82, 0xCA,
                       0xF0, 0x75, 0x82, 0xC5, 0xE0, 0x75, 0x82, 0xCB,
                       0xF0, 0x78, 0x10, 0x7C, 0xB4, 0x12, 0x1E, 0xD4,
                       0x75, 0x82, 0xA4, 0xE0, 0x44, 0x12, 0x75, 0x82,
                       0xA4, 0xF0, 0x75, 0x82, 0x72, 0xE0, 0x70, 0x18,
                       0x78, 0x14, 0x7C, 0xB8, 0x12, 0x1E, 0xE8, 0x12,
                       0x0D, 0xFC, 0x75, 0x82, 0xA4, 0xE0, 0x50, 0x02,
                       0x54, 0xEF, 0x78, 0x16, 0xF2, 0x02, 0x1D, 0x1B,
                       0x75, 0x82, 0x72, 0x12, 0x1D, 0x20, 0xE4, 0x75,
                       0x82, 0xB8, 0xF0, 0x05, 0x82, 0xF0, 0x05, 0x82,
                       0x74, 0x01, 0xF0, 0xE4, 0x78, 0x14, 0xF2, 0x08,
                       0xF2, 0x12, 0x20, 0xBD, 0x75, 0x82, 0x70, 0x12,
                       0x1D, 0x2F, 0x40, 0xCB, 0x80, 0xD4, 0x75, 0x82,
                       0xA9, 0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0, 0x70,
                       0x08, 0x05, 0x82, 0xE0, 0x70, 0x03, 0x02, 0x9C,
                       0x92, 0x12, 0x20, 0x00, 0x75, 0xA0, 0xC0, 0x75,
                       0x82, 0xAC, 0xE0, 0x44, 0x02, 0xF0, 0xC0, 0xE0,
                       0x75, 0x82, 0x27, 0xE0, 0x54, 0x01, 0x60, 0x06,
                       0xD0, 0xE0, 0x54, 0xEF, 0xC0, 0xE0, 0xD0, 0xE0,
                       0x78, 0x1E, 0xF2, 0xC2, 0x0C, 0x54, 0x01, 0xC4,
                       0x23, 0xC0, 0xE0, 0x75, 0xA0, 0xE8, 0x78, 0x03,
                       0x79, 0xDB, 0xE7, 0xF2, 0x78, 0x00, 0xD0, 0xE0,
                       0xC0, 0xE0, 0x44, 0x02, 0xF2, 0xD0, 0xE0, 0xC4,
                       0xB2, 0xE1, 0x44, 0x01, 0xF5, 0x75, 0x78, 0x05,
                       0x75, 0xA0, 0xE0, 0xF2, 0x75, 0x82, 0xAD, 0xE0,
                       0x70, 0x03, 0x02, 0x9E, 0x67, 0x75, 0x82, 0xA1,
                       0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0, 0x70, 0x08,
                       0x05, 0x82, 0xE0, 0x70, 0x03, 0x02, 0x9E, 0x67,
                       0x75, 0x82, 0x27, 0xE0, 0x54, 0x01, 0x70, 0x0C,
                       0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4, 0xE0, 0x44,
                       0x02, 0x78, 0x16, 0xF2, 0x02, 0x1D, 0x1B};

UCHAR Patch16vdata[] = {0xB8, 0x53, 0x43, 0x53, 0x49, 0x5F, 0x4E, 0x43,
                        0x5F, 0x50, 0x41 ,0x54, 0x43, 0x48};

UCHAR Patch17data[] = {0xC0, 0x01, 0xA9, 0x81, 0x19, 0xB7, 0x15, 0x08,
                       0x19, 0xB7, 0x6B, 0x04, 0xD0, 0x01, 0x80, 0x03,
                       0xD0, 0x01, 0x22, 0x15, 0x81, 0x15, 0x81, 0x43,
                       0x6F, 0x08, 0xE5, 0x6F, 0x78, 0x03, 0xF2, 0x7B,
                       0x7C, 0x7C, 0x74, 0x7A, 0x04, 0x8B, 0x82, 0xE0,
                       0x8C, 0x82, 0xF0, 0x0B, 0x0C, 0xDA, 0xF6, 0x75,
                       0x82, 0x74, 0x12, 0x1D, 0x83, 0x50, 0x03, 0x02,
                       0x1D, 0x6F, 0x75, 0x82, 0x78, 0x78, 0x00, 0x7A,
                       0x03, 0xE0, 0xF2, 0x05, 0x82, 0x08, 0xDA, 0xF9,
                       0xE0, 0x60, 0x05, 0x74, 0x1D, 0x02, 0x12, 0x6F,
                       0x43, 0x66, 0x01, 0x79, 0xD8, 0xE5, 0xF0, 0xF7,
                       0x75, 0x82, 0xAD, 0xE0, 0x70, 0x0C, 0x75, 0x82,
                       0xAF, 0xE0, 0x70, 0x03, 0x02, 0x18, 0x8D, 0x02,
                       0x9D, 0x56, 0xE0, 0xF5, 0x67, 0x05, 0x82, 0xE0,
                       0xF5, 0x68, 0x43, 0x66, 0x80, 0x75, 0xA0, 0xC0,
                       0x7A, 0x06, 0x78, 0x10, 0x75, 0x82, 0x9D, 0xE0,
                       0xF2, 0x08, 0x05, 0x82, 0xDA, 0xF9, 0x7A, 0x07,
                       0x7B, 0xB4, 0x7C, 0x9D, 0x8C, 0x82, 0xE0, 0x8B,
                       0x82, 0xF0, 0x0B, 0x0C, 0xDA, 0xF6, 0x75, 0x82,
                       0xAF, 0xE0, 0x60, 0x03, 0x02, 0x9D, 0x56, 0x75,
                       0x82, 0xA1, 0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0,
                       0x70, 0x08, 0x05, 0x82, 0xE0, 0x70, 0x03, 0x02,
                       0x1D, 0x6F, 0x12, 0x1F, 0x89, 0x75, 0x82, 0x27,
                       0xE0, 0x54, 0x01, 0x60, 0x05, 0x75, 0x82, 0xAC,
                       0xE4, 0xF0, 0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4,
                       0xE0, 0x44, 0x02, 0x78, 0x16, 0xF2, 0xD2, 0x0C,
                       0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75, 0xA0,
                       0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2, 0x78,
                       0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02, 0xF2,
                       0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01, 0xF5,
                       0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2, 0x75,
                       0x82, 0x70, 0x12, 0x1D, 0x83, 0x50, 0x22, 0x75,
                       0x82, 0x27, 0xE0, 0x54, 0x10, 0x60, 0x46, 0x12,
                       0x0E, 0x50, 0x40, 0x41, 0x12, 0x0E, 0x70, 0x40,
                       0x3C, 0x75, 0x82, 0xC4, 0xE0, 0x75, 0x82, 0xCC,
                       0xF0, 0x75, 0x82, 0xC5, 0xE0, 0x75, 0x82, 0xCD,
                       0xF0, 0x78, 0x18, 0x7C, 0xBB, 0x12, 0x1F, 0x28,
                       0x75, 0x82, 0xAC, 0xE0, 0x44, 0x12, 0x75, 0x82,
                       0xAC, 0xF0, 0x75, 0x82, 0x72, 0xE0, 0x70, 0x18,
                       0x78, 0x1C, 0x7C, 0xBF, 0x12, 0x1F, 0x3C, 0x12,
                       0x0E, 0x50, 0x75, 0x82, 0xAC, 0xE0, 0x50, 0x02,
                       0x54, 0xEF, 0x78, 0x1E, 0xF2, 0x02, 0x1D, 0x6F,
                       0x75, 0x82, 0x72, 0x12, 0x1D, 0x74, 0xE4, 0x75,
                       0x82, 0xBF, 0xF0, 0x05, 0x82, 0xF0, 0x05, 0x82,
                       0x74, 0x01, 0xF0, 0xE4, 0x78, 0x1C, 0xF2, 0x08,
                       0xF2, 0x12, 0x21, 0x11, 0x75, 0x82, 0x70, 0x12,
                       0x1D, 0x83, 0x40, 0xCB, 0x80, 0xD4, 0xE0, 0xF5,
                       0x67, 0x05, 0x82, 0xE0, 0xF5, 0x68, 0x43, 0x66,
                       0x40, 0x75, 0xA0, 0xC0, 0x7A, 0x06, 0x78, 0x18,
                       0x75, 0x82, 0xA5, 0xE0, 0xF2, 0x08, 0x05, 0x82,
                       0xDA, 0xF9, 0x7A, 0x07, 0x7B, 0xBB, 0x7C, 0xA5,
                       0x8C, 0x82, 0xE0, 0x8B, 0x82, 0xF0, 0x0B, 0x0C,
                       0xDA, 0xF6, 0x75, 0x82, 0xAC, 0xE0, 0xF5, 0xF0,
                       0x54, 0x04, 0x60, 0x03, 0x02, 0x9E, 0xE6, 0x75,
                       0x82, 0xAD, 0xE0, 0x70, 0x05, 0x74, 0x3C, 0x02,
                       0x12, 0x6F, 0x75, 0x82, 0xA1, 0xE0, 0x70, 0x0D,
                       0x05, 0x82, 0xE0, 0x70, 0x08, 0x05, 0x82, 0xE0,
                       0x70, 0x03, 0x02, 0x9E, 0x22, 0x12, 0x1F, 0x89,
                       0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4, 0xE0, 0x44,
                       0x02, 0xF0, 0xC0, 0xE0, 0x75, 0x82, 0x27, 0xE0,
                       0x54, 0x01, 0x60, 0x06, 0xD0, 0xE0, 0x54, 0xEF,
                       0xC0, 0xE0, 0xD0, 0xE0, 0x78, 0x16, 0xF2, 0xD2,
                       0x0C, 0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75,
                       0xA0, 0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2,
                       0x78, 0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02,
                       0xF2, 0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01,
                       0xF5, 0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2,
                       0x75, 0x82, 0xA9, 0xE0, 0x70, 0x0D, 0x05, 0x82,
                       0xE0, 0x70, 0x08, 0x05, 0x82, 0xE0, 0x70, 0x03,
                       0x02, 0x9C, 0xD7, 0x75, 0x82, 0x27, 0xE0, 0x54,
                       0x01, 0x70, 0x0C, 0x75, 0xA0, 0xC0, 0x75, 0x82,
                       0xAC, 0xE0, 0x44, 0x02, 0x78, 0x1E, 0xF2, 0x02,
                       0x1D, 0x6F, 0x12, 0x20, 0x54, 0x75, 0x82, 0x27,
                       0xE0, 0x54, 0x01, 0x60, 0x05, 0x75, 0x82, 0xA4,
                       0xE4, 0xF0, 0x75, 0xA0, 0xC0, 0x75, 0x82, 0xAC,
                       0xE0, 0x44, 0x02, 0x78, 0x1E, 0xF2, 0xC2, 0x0C,
                       0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75, 0xA0,
                       0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2, 0x78,
                       0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02, 0xF2,
                       0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01, 0xF5,
                       0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2, 0x75,
                       0x82, 0x70, 0x12, 0x1D, 0x83, 0x50, 0x22, 0x75,
                       0x82, 0x27, 0xE0, 0x54, 0x10, 0x60, 0x46, 0x12,
                       0x0E, 0x50, 0x40, 0x41, 0x12, 0x0E, 0x70, 0x40,
                       0x3C, 0x75, 0x82, 0xC4, 0xE0, 0x75, 0x82, 0xCA,
                       0xF0, 0x75, 0x82, 0xC5, 0xE0, 0x75, 0x82, 0xCB,
                       0xF0, 0x78, 0x10, 0x7C, 0xB4, 0x12, 0x1F, 0x28,
                       0x75, 0x82, 0xA4, 0xE0, 0x44, 0x12, 0x75, 0x82,
                       0xA4, 0xF0, 0x75, 0x82, 0x72, 0xE0, 0x70, 0x18,
                       0x78, 0x14, 0x7C, 0xB8, 0x12, 0x1F, 0x3C, 0x12,
                       0x0E, 0x50, 0x75, 0x82, 0xA4, 0xE0, 0x50, 0x02,
                       0x54, 0xEF, 0x78, 0x16, 0xF2, 0x02, 0x1D, 0x6F,
                       0x75, 0x82, 0x72, 0x12, 0x1D, 0x74, 0xE4, 0x75,
                       0x82, 0xB8, 0xF0, 0x05, 0x82, 0xF0, 0x05, 0x82,
                       0x74, 0x01, 0xF0, 0xE4, 0x78, 0x14, 0xF2, 0x08,
                       0xF2, 0x12, 0x21, 0x11, 0x75, 0x82, 0x70, 0x12,
                       0x1D, 0x83, 0x40, 0xCB, 0x80, 0xD4, 0x75, 0x82,
                       0xA9, 0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0, 0x70,
                       0x08, 0x05, 0x82, 0xE0, 0x70, 0x03, 0x02, 0x9C,
                       0x92, 0x12, 0x20, 0x54, 0x75, 0xA0, 0xC0, 0x75,
                       0x82, 0xAC, 0xE0, 0x44, 0x02, 0xF0, 0xC0, 0xE0,
                       0x75, 0x82, 0x27, 0xE0, 0x54, 0x01, 0x60, 0x06,
                       0xD0, 0xE0, 0x54, 0xEF, 0xC0, 0xE0, 0xD0, 0xE0,
                       0x78, 0x1E, 0xF2, 0xC2, 0x0C, 0x54, 0x01, 0xC4,
                       0x23, 0xC0, 0xE0, 0x75, 0xA0, 0xE8, 0x78, 0x03,
                       0x79, 0xDB, 0xE7, 0xF2, 0x78, 0x00, 0xD0, 0xE0,
                       0xC0, 0xE0, 0x44, 0x02, 0xF2, 0xD0, 0xE0, 0xC4,
                       0xB2, 0xE1, 0x44, 0x01, 0xF5, 0x75, 0x78, 0x05,
                       0x75, 0xA0, 0xE0, 0xF2, 0x75, 0x82, 0xAD, 0xE0,
                       0x70, 0x03, 0x02, 0x9E, 0x67, 0x75, 0x82, 0xA1,
                       0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0, 0x70, 0x08,
                       0x05, 0x82, 0xE0, 0x70, 0x03, 0x02, 0x9E, 0x67,
                       0x75, 0x82, 0x27, 0xE0, 0x54, 0x01, 0x70, 0x0C,
                       0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4, 0xE0, 0x44,
                       0x02, 0x78, 0x16, 0xF2, 0x02, 0x1D, 0x6F};

UCHAR Patch17vdata[] = {0xDA, 0x53, 0x43, 0x53, 0x49, 0x5F, 0x4E, 0x43,
                        0x5F, 0x50, 0x41 ,0x54, 0x43, 0x48};

UCHAR Patch19data[] = {0xC0, 0x01, 0xA9, 0x81, 0x19, 0xB7, 0x15, 0x08,
                       0x19, 0xB7, 0x8C, 0x04, 0xD0, 0x01, 0x80, 0x03,
                       0xD0, 0x01, 0x22, 0x15, 0x81, 0x15, 0x81, 0x43,
                       0x6F, 0x08, 0xE5, 0x6F, 0x78, 0x03, 0xF2, 0x7B,
                       0x7C, 0x7C, 0x74, 0x7A, 0x04, 0x8B, 0x82, 0xE0,
                       0x8C, 0x82, 0xF0, 0x0B, 0x0C, 0xDA, 0xF6, 0x75,
                       0x82, 0x74, 0x12, 0x1D, 0xA4, 0x50, 0x03, 0x02,
                       0x1D, 0x90, 0x75, 0x82, 0x78, 0x78, 0x00, 0x7A,
                       0x03, 0xE0, 0xF2, 0x05, 0x82, 0x08, 0xDA, 0xF9,
                       0xE0, 0x60, 0x05, 0x74, 0x1D, 0x02, 0x12, 0x90,
                       0x43, 0x66, 0x01, 0x79, 0xD8, 0xE5, 0xF0, 0xF7,
                       0x75, 0x82, 0xAD, 0xE0, 0x70, 0x0C, 0x75, 0x82,
                       0xAF, 0xE0, 0x70, 0x03, 0x02, 0x18, 0xAE, 0x02,
                       0x9D, 0x56, 0xE0, 0xF5, 0x67, 0x05, 0x82, 0xE0,
                       0xF5, 0x68, 0x43, 0x66, 0x80, 0x75, 0xA0, 0xC0,
                       0x7A, 0x06, 0x78, 0x10, 0x75, 0x82, 0x9D, 0xE0,
                       0xF2, 0x08, 0x05, 0x82, 0xDA, 0xF9, 0x7A, 0x07,
                       0x7B, 0xB4, 0x7C, 0x9D, 0x8C, 0x82, 0xE0, 0x8B,
                       0x82, 0xF0, 0x0B, 0x0C, 0xDA, 0xF6, 0x75, 0x82,
                       0xAF, 0xE0, 0x60, 0x03, 0x02, 0x9D, 0x56, 0x75,
                       0x82, 0xA1, 0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0,
                       0x70, 0x08, 0x05, 0x82, 0xE0, 0x70, 0x03, 0x02,
                       0x1D, 0x90, 0x12, 0x1F, 0xAA, 0x75, 0x82, 0x27,
                       0xE0, 0x54, 0x01, 0x60, 0x05, 0x75, 0x82, 0xAC,
                       0xE4, 0xF0, 0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4,
                       0xE0, 0x44, 0x02, 0x78, 0x16, 0xF2, 0xD2, 0x0C,
                       0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75, 0xA0,
                       0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2, 0x78,
                       0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02, 0xF2,
                       0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01, 0xF5,
                       0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2, 0x75,
                       0x82, 0x70, 0x12, 0x1D, 0xA4, 0x50, 0x22, 0x75,
                       0x82, 0x27, 0xE0, 0x54, 0x10, 0x60, 0x46, 0x12,
                       0x0E, 0x5C, 0x40, 0x41, 0x12, 0x0E, 0x7C, 0x40,
                       0x3C, 0x75, 0x82, 0xC4, 0xE0, 0x75, 0x82, 0xCC,
                       0xF0, 0x75, 0x82, 0xC5, 0xE0, 0x75, 0x82, 0xCD,
                       0xF0, 0x78, 0x18, 0x7C, 0xBB, 0x12, 0x1F, 0x49,
                       0x75, 0x82, 0xAC, 0xE0, 0x44, 0x12, 0x75, 0x82,
                       0xAC, 0xF0, 0x75, 0x82, 0x72, 0xE0, 0x70, 0x18,
                       0x78, 0x1C, 0x7C, 0xBF, 0x12, 0x1F, 0x5D, 0x12,
                       0x0E, 0x5C, 0x75, 0x82, 0xAC, 0xE0, 0x50, 0x02,
                       0x54, 0xEF, 0x78, 0x1E, 0xF2, 0x02, 0x1D, 0x90,
                       0x75, 0x82, 0x72, 0x12, 0x1D, 0x95, 0xE4, 0x75,
                       0x82, 0xBF, 0xF0, 0x05, 0x82, 0xF0, 0x05, 0x82,
                       0x74, 0x01, 0xF0, 0xE4, 0x78, 0x1C, 0xF2, 0x08,
                       0xF2, 0x12, 0x21, 0x32, 0x75, 0x82, 0x70, 0x12,
                       0x1D, 0xA4, 0x40, 0xCB, 0x80, 0xD4, 0xE0, 0xF5,
                       0x67, 0x05, 0x82, 0xE0, 0xF5, 0x68, 0x43, 0x66,
                       0x40, 0x75, 0xA0, 0xC0, 0x7A, 0x06, 0x78, 0x18,
                       0x75, 0x82, 0xA5, 0xE0, 0xF2, 0x08, 0x05, 0x82,
                       0xDA, 0xF9, 0x7A, 0x07, 0x7B, 0xBB, 0x7C, 0xA5,
                       0x8C, 0x82, 0xE0, 0x8B, 0x82, 0xF0, 0x0B, 0x0C,
                       0xDA, 0xF6, 0x75, 0x82, 0xAC, 0xE0, 0xF5, 0xF0,
                       0x54, 0x04, 0x60, 0x03, 0x02, 0x9E, 0xE6, 0x75,
                       0x82, 0xAD, 0xE0, 0x70, 0x05, 0x74, 0x3C, 0x02,
                       0x12, 0x90, 0x75, 0x82, 0xA1, 0xE0, 0x70, 0x0D,
                       0x05, 0x82, 0xE0, 0x70, 0x08, 0x05, 0x82, 0xE0,
                       0x70, 0x03, 0x02, 0x9E, 0x22, 0x12, 0x1F, 0xAA,
                       0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4, 0xE0, 0x44,
                       0x02, 0xF0, 0xC0, 0xE0, 0x75, 0x82, 0x27, 0xE0,
                       0x54, 0x01, 0x60, 0x06, 0xD0, 0xE0, 0x54, 0xEF,
                       0xC0, 0xE0, 0xD0, 0xE0, 0x78, 0x16, 0xF2, 0xD2,
                       0x0C, 0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75,
                       0xA0, 0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2,
                       0x78, 0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02,
                       0xF2, 0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01,
                       0xF5, 0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2,
                       0x75, 0x82, 0xA9, 0xE0, 0x70, 0x0D, 0x05, 0x82,
                       0xE0, 0x70, 0x08, 0x05, 0x82, 0xE0, 0x70, 0x03,
                       0x02, 0x9C, 0xD7, 0x75, 0x82, 0x27, 0xE0, 0x54,
                       0x01, 0x70, 0x0C, 0x75, 0xA0, 0xC0, 0x75, 0x82,
                       0xAC, 0xE0, 0x44, 0x02, 0x78, 0x1E, 0xF2, 0x02,
                       0x1D, 0x90, 0x12, 0x20, 0x75, 0x75, 0x82, 0x27,
                       0xE0, 0x54, 0x01, 0x60, 0x05, 0x75, 0x82, 0xA4,
                       0xE4, 0xF0, 0x75, 0xA0, 0xC0, 0x75, 0x82, 0xAC,
                       0xE0, 0x44, 0x02, 0x78, 0x1E, 0xF2, 0xC2, 0x0C,
                       0x54, 0x01, 0xC4, 0x23, 0xC0, 0xE0, 0x75, 0xA0,
                       0xE8, 0x78, 0x03, 0x79, 0xDB, 0xE7, 0xF2, 0x78,
                       0x00, 0xD0, 0xE0, 0xC0, 0xE0, 0x44, 0x02, 0xF2,
                       0xD0, 0xE0, 0xC4, 0xB2, 0xE1, 0x44, 0x01, 0xF5,
                       0x75, 0x78, 0x05, 0x75, 0xA0, 0xE0, 0xF2, 0x75,
                       0x82, 0x70, 0x12, 0x1D, 0xA4, 0x50, 0x22, 0x75,
                       0x82, 0x27, 0xE0, 0x54, 0x10, 0x60, 0x46, 0x12,
                       0x0E, 0x5C, 0x40, 0x41, 0x12, 0x0E, 0x7C, 0x40,
                       0x3C, 0x75, 0x82, 0xC4, 0xE0, 0x75, 0x82, 0xCA,
                       0xF0, 0x75, 0x82, 0xC5, 0xE0, 0x75, 0x82, 0xCB,
                       0xF0, 0x78, 0x10, 0x7C, 0xB4, 0x12, 0x1F, 0x49,
                       0x75, 0x82, 0xA4, 0xE0, 0x44, 0x12, 0x75, 0x82,
                       0xA4, 0xF0, 0x75, 0x82, 0x72, 0xE0, 0x70, 0x18,
                       0x78, 0x14, 0x7C, 0xB8, 0x12, 0x1F, 0x5D, 0x12,
                       0x0E, 0x5C, 0x75, 0x82, 0xA4, 0xE0, 0x50, 0x02,
                       0x54, 0xEF, 0x78, 0x16, 0xF2, 0x02, 0x1D, 0x90,
                       0x75, 0x82, 0x72, 0x12, 0x1D, 0x95, 0xE4, 0x75,
                       0x82, 0xB8, 0xF0, 0x05, 0x82, 0xF0, 0x05, 0x82,
                       0x74, 0x01, 0xF0, 0xE4, 0x78, 0x14, 0xF2, 0x08,
                       0xF2, 0x12, 0x21, 0x32, 0x75, 0x82, 0x70, 0x12,
                       0x1D, 0xA4, 0x40, 0xCB, 0x80, 0xD4, 0x75, 0x82,
                       0xA9, 0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0, 0x70,
                       0x08, 0x05, 0x82, 0xE0, 0x70, 0x03, 0x02, 0x9C,
                       0x92, 0x12, 0x20, 0x75, 0x75, 0xA0, 0xC0, 0x75,
                       0x82, 0xAC, 0xE0, 0x44, 0x02, 0xF0, 0xC0, 0xE0,
                       0x75, 0x82, 0x27, 0xE0, 0x54, 0x01, 0x60, 0x06,
                       0xD0, 0xE0, 0x54, 0xEF, 0xC0, 0xE0, 0xD0, 0xE0,
                       0x78, 0x1E, 0xF2, 0xC2, 0x0C, 0x54, 0x01, 0xC4,
                       0x23, 0xC0, 0xE0, 0x75, 0xA0, 0xE8, 0x78, 0x03,
                       0x79, 0xDB, 0xE7, 0xF2, 0x78, 0x00, 0xD0, 0xE0,
                       0xC0, 0xE0, 0x44, 0x02, 0xF2, 0xD0, 0xE0, 0xC4,
                       0xB2, 0xE1, 0x44, 0x01, 0xF5, 0x75, 0x78, 0x05,
                       0x75, 0xA0, 0xE0, 0xF2, 0x75, 0x82, 0xAD, 0xE0,
                       0x70, 0x03, 0x02, 0x9E, 0x67, 0x75, 0x82, 0xA1,
                       0xE0, 0x70, 0x0D, 0x05, 0x82, 0xE0, 0x70, 0x08,
                       0x05, 0x82, 0xE0, 0x70, 0x03, 0x02, 0x9E, 0x67,
                       0x75, 0x82, 0x27, 0xE0, 0x54, 0x01, 0x70, 0x0C,
                       0x75, 0xA0, 0xC0, 0x75, 0x82, 0xA4, 0xE0, 0x44,
                       0x02, 0x78, 0x16, 0xF2, 0x02, 0x1D, 0x90};

UCHAR Patch19vdata[] = {0x17, 0x53, 0x43, 0x53, 0x49, 0x5F, 0x4E, 0x43,
                        0x5F, 0x50, 0x41 ,0x54, 0x43, 0x48};
BYTE EndData = {0};
