/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FL2PROTO.H
 *
 * DESCRIPTIVE NAME = IBM2FLPY.ADD - Adapter Driver for ABIOS Diskette
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Function prototypes and segment assignments
 *
 *
 *
*/

/*** Functions which reside in Static Code segment ***/

   /* Functions which reside in fl2entry.c module  */

      VOID   _loadds FAR ADDEntryPoint( PIORBH );
      VOID   FAR  IORBDone( VOID );
      VOID   FAR  ShutDown( VOID );
      VOID   FAR  HookHandler( VOID );
      VOID   NEAR SuspendResume( PIORBH );
      VOID   FAR  Reset( VOID );
      VOID   FAR  ResetComplete( VOID );
      BOOL   FAR  CreateDMABuffer( VOID );

      VOID   NEAR Strategy( VOID );

   /* Functions which reside in fl2intr.c module */

      BOOL   FAR  NextStage( VOID );
      VOID   NEAR IntHandler( VOID );

      VOID   FAR  StartTimer( USHORT, USHORT, PPOSTFN );
      VOID   NEAR CancelTimer( USHORT );
      VOID   NEAR TimerHandler( VOID );

   /* Assign functions to Static Code segment */

      #pragma alloc_text( StaticCode, ADDEntryPoint, IORBDone )
      #pragma alloc_text( StaticCode, ShutDown, HookHandler, SuspendResume )
      #pragma alloc_text( StaticCode, Reset, ResetComplete, CreateDMABuffer )
      #pragma alloc_text( StaticCode, Strategy )
      #pragma alloc_text( StaticCode, NextStage, IntHandler )
      #pragma alloc_text( StaticCode, StartTimer, CancelTimer, TimerHandler )


/*** Functions which reside in Init Code segment ***/

   /* Functions which reside in fl2init.c module */

      VOID   NEAR InitCode( VOID );
      VOID   FAR  InitFloppy( PRPINITIN );
      BOOL   NEAR GetParameters( VOID );
      BOOL   NEAR InitTimer( VOID );
      BOOL   NEAR SetupDMABuffer( VOID );

   /* Assign functions to Init Code segment */

      #pragma alloc_text( InitCode, InitCode, InitFloppy, GetParameters )
      #pragma alloc_text( InitCode, InitTimer, SetupDMABuffer )


/*** Functions which reside in Swap Code segment ***/

   /* Functions which reside in fl2iorb.c module */

      VOID   FAR  NextIORB( VOID );
      VOID   NEAR GetDeviceTable( VOID );
      VOID   NEAR AllocateUnit( VOID );
      VOID   NEAR DeallocateUnit( VOID );
      VOID   NEAR ChangeUnitInfo( VOID );
      VOID   NEAR GetUnitStatus( VOID );
      VOID   FAR  GetUnitStatusComplete( VOID);                      /*@V51531*/
      VOID   NEAR GetUnitLockStatus( VOID);                          /*@V51531*/
      VOID   FAR  GetUnitLockStatusComplete( VOID);                  /*@V51531*/
      VOID   NEAR GetChangelineState( VOID );
      VOID   FAR  GetChangelineStateComplete( VOID );
      VOID   NEAR LkUnlkEjt( VOID);                                  /*@V51531*/
      VOID   FAR  LkUnlkEjtComplete( VOID);                          /*@V51531*/
      VOID   NEAR GetMediaSense( VOID );
      VOID   FAR  GetMediaSenseComplete( VOID );
      VOID   NEAR CompleteInit( VOID );
      VOID   NEAR CmdNotSupported( VOID );

      USHORT NEAR TranslateErrorCode( USHORT );
      VOID   FAR  TurnOffMotor( USHORT );

   /* Functions which reside in fl2geo.c module  */

      VOID   NEAR GetMediaGeometry( VOID );
      VOID   FAR  GetMediaGeometryComplete( VOID );
      VOID   NEAR SetMediaGeometry( VOID );
      VOID   NEAR GetDeviceGeometry( VOID );
      VOID   NEAR SetLogicalGeometry( VOID );

   /* Functions which reside in fl2io.c module   */

      VOID   NEAR IO( VOID );
      VOID   FAR  IOPhase1( VOID );
      VOID   FAR  RWV( VOID );
      VOID   NEAR NextRWV( VOID );
      VOID   NEAR NextRWVStep( VOID );
      VOID   FAR  RWVComplete( VOID );
      USHORT FAR  BlkSizeToN( USHORT BlkSize );

   /* Functions which reside in fl2fmt.c module  */

      VOID   NEAR Format( VOID );
      VOID   FAR  Format2( VOID );
      VOID   FAR  Format3( VOID );
      VOID   NEAR NextFormatStep( VOID );
      VOID   FAR  FormatComplete( VOID );

   /* Functions which reside in fl2media.c module  */
      VOID NEAR DetermineMedia( PCFN DetermineComplete  );
      VOID FAR  DetermineChkChgComplete( VOID );
      VOID FAR  DetermineMedia2( VOID);                                         
      VOID FAR  SetDevParamsForRWV( VOID);                                      
      VOID FAR  EndDetermineMedia1( VOID);                                      
      VOID FAR  EndDetermineMedia2( VOID);                                      
      VOID FAR  DetermineVerifyComplete( VOID );
      VOID FAR  DetermineReadParmsComplete( VOID );

   /* Assign functions to Swap Code segment */

      #pragma alloc_text( SwapCode, NextIORB, GetDeviceTable, GetUnitStatus )
      #pragma alloc_text( SwapCode, AllocateUnit, DeallocateUnit )
      #pragma alloc_text( SwapCode, ChangeUnitInfo )
      #pragma alloc_text( SwapCode, GetChangelineState )
      #pragma alloc_text( SwapCode, GetChangelineStateComplete )
      #pragma alloc_text( SwapCode, LkUnlkEjt )                      /*@V51531*/
      #pragma alloc_text( SwapCode, LkUnlkEjtComplete )              /*@V51531*/
      #pragma alloc_text( SwapCode, GetUnitLockStatus )              /*@V51531*/
      #pragma alloc_text( SwapCode, GetUnitLockStatusComplete )      /*@V51531*/
      #pragma alloc_text( SwapCode, GetUnitStatusComplete )          /*@V51531*/
      #pragma alloc_text( SwapCode, GetMediaSense, GetMediaSenseComplete )
      #pragma alloc_text( SwapCode, CompleteInit )
      #pragma alloc_text( SwapCode, CmdNotSupported, TranslateErrorCode )
      #pragma alloc_text( SwapCode, TurnOffMotor )
      #pragma alloc_text( SwapCode, GetMediaGeometry, GetMediaGeometryComplete )
      #pragma alloc_text( SwapCode, SetMediaGeometry )
      #pragma alloc_text( SwapCode, GetDeviceGeometry, SetLogicalGeometry )
      #pragma alloc_text( SwapCode, IO, IOPhase1 )
      #pragma alloc_text( SwapCode, RWV, NextRWV, NextRWVStep, RWVComplete )
      #pragma alloc_text( SwapCode, Format, Format2, Format3 )
      #pragma alloc_text( SwapCode, NextFormatStep, FormatComplete )
      #pragma alloc_text( SwapCode, BlkSizeToN )
      #pragma alloc_text( SwapCode, DetermineMedia, DetermineChkChgComplete )
      #pragma alloc_text( SwapCode, DetermineMedia2, SetDevParamsForRWV )       
      #pragma alloc_text( SwapCode, EndDetermineMedia1, EndDetermineMedia2 )    
      #pragma alloc_text( SwapCode, DetermineVerifyComplete )
      #pragma alloc_text( SwapCode, DetermineReadParmsComplete )


